/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.en;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.util.Utilities;
import marytts.language.en.WordRelation;

public class NumberExpander {
    private static final String[] digit2num = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
    private static final String[] digit2teen = new String[]{"ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
    private static final String[] digit2enty = new String[]{"zero", "ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
    private static final String[] ord2num = new String[]{"zeroth", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "ninth"};
    private static final String[] ord2teen = new String[]{"tenth", "eleventh", "twelfth", "thirteenth", "fourteenth", "fifteenth", "sixteenth", "seventeenth", "eighteenth", "nineteenth"};
    private static final String[] ord2enty = new String[]{"zeroth", "tenth", "twentieth", "thirtieth", "fortieth", "fiftieth", "sixtieth", "seventieth", "eightieth", "ninetieth"};

    private NumberExpander() {
    }

    public static void expandNumber(String numberString, WordRelation wordRelation, Item tokenItem) {
        int numDigits = numberString.length();
        if (numDigits != 0) {
            if (numDigits == 1) {
                NumberExpander.expandDigits(numberString, wordRelation, tokenItem);
            } else if (numDigits == 2) {
                NumberExpander.expand2DigitNumber(numberString, wordRelation, tokenItem);
            } else if (numDigits == 3) {
                NumberExpander.expand3DigitNumber(numberString, wordRelation, tokenItem);
            } else if (numDigits < 7) {
                NumberExpander.expandBelow7DigitNumber(numberString, wordRelation, tokenItem);
            } else if (numDigits < 10) {
                NumberExpander.expandBelow10DigitNumber(numberString, wordRelation, tokenItem);
            } else if (numDigits < 13) {
                NumberExpander.expandBelow13DigitNumber(numberString, wordRelation, tokenItem);
            } else {
                NumberExpander.expandDigits(numberString, wordRelation, tokenItem);
            }
        }
    }

    private static void expand2DigitNumber(String numberString, WordRelation wordRelation, Item tokenItem) {
        if (numberString.charAt(0) == '0') {
            if (numberString.charAt(1) != '0') {
                String number = digit2num[numberString.charAt(1) - 48];
                wordRelation.addWord(tokenItem, number);
            }
        } else if (numberString.charAt(1) == '0') {
            String number = digit2enty[numberString.charAt(0) - 48];
            wordRelation.addWord(tokenItem, number);
        } else if (numberString.charAt(0) == '1') {
            String number = digit2teen[numberString.charAt(1) - 48];
            wordRelation.addWord(tokenItem, number);
        } else {
            String enty = digit2enty[numberString.charAt(0) - 48];
            wordRelation.addWord(tokenItem, enty);
            NumberExpander.expandDigits(numberString.substring(1, numberString.length()), wordRelation, tokenItem);
        }
    }

    private static void expand3DigitNumber(String numberString, WordRelation wordRelation, Item tokenItem) {
        if (numberString.charAt(0) == '0') {
            NumberExpander.expandNumberAt(numberString, 1, wordRelation, tokenItem);
        } else {
            String hundredDigit = digit2num[numberString.charAt(0) - 48];
            wordRelation.addWord(tokenItem, hundredDigit);
            wordRelation.addWord(tokenItem, "hundred");
            NumberExpander.expandNumberAt(numberString, 1, wordRelation, tokenItem);
        }
    }

    private static void expandBelow7DigitNumber(String numberString, WordRelation wordRelation, Item tokenItem) {
        NumberExpander.expandLargeNumber(numberString, "thousand", 3, wordRelation, tokenItem);
    }

    private static void expandBelow10DigitNumber(String numberString, WordRelation wordRelation, Item tokenItem) {
        NumberExpander.expandLargeNumber(numberString, "million", 6, wordRelation, tokenItem);
    }

    private static void expandBelow13DigitNumber(String numberString, WordRelation wordRelation, Item tokenItem) {
        NumberExpander.expandLargeNumber(numberString, "billion", 9, wordRelation, tokenItem);
    }

    private static void expandLargeNumber(String numberString, String order, int numberZeroes, WordRelation wordRelation, Item tokenItem) {
        int numberDigits = numberString.length();
        int i = numberDigits - numberZeroes;
        String part = numberString.substring(0, i);
        Item oldTail = wordRelation.getTail();
        NumberExpander.expandNumber(part, wordRelation, tokenItem);
        if (wordRelation.getTail() == oldTail) {
            NumberExpander.expandNumberAt(numberString, i, wordRelation, tokenItem);
        } else {
            wordRelation.addWord(tokenItem, order);
            NumberExpander.expandNumberAt(numberString, i, wordRelation, tokenItem);
        }
    }

    private static void expandNumberAt(String numberString, int startIndex, WordRelation wordRelation, Item tokenItem) {
        NumberExpander.expandNumber(numberString.substring(startIndex, numberString.length()), wordRelation, tokenItem);
    }

    public static void expandDigits(String numberString, WordRelation wordRelation, Item tokenItem) {
        int numberDigits = numberString.length();
        for (int i = 0; i < numberDigits; ++i) {
            char digit = numberString.charAt(i);
            if (NumberExpander.isDigit(digit)) {
                wordRelation.addWord(tokenItem, digit2num[numberString.charAt(i) - 48]);
                continue;
            }
            wordRelation.addWord(tokenItem, "umpty");
        }
    }

    public static void expandOrdinal(String rawNumberString, WordRelation wordRelation, Item tokenItem) {
        String numberString = Utilities.deleteChar((String)rawNumberString, (char)',');
        NumberExpander.expandNumber(numberString, wordRelation, tokenItem);
        Item lastItem = wordRelation.getTail();
        if (lastItem != null) {
            FeatureSet featureSet = lastItem.getFeatures();
            String lastNumber = featureSet.getString("name");
            String ordinal = NumberExpander.findMatchInArray(lastNumber, digit2num, ord2num);
            if (ordinal == null) {
                ordinal = NumberExpander.findMatchInArray(lastNumber, digit2teen, ord2teen);
            }
            if (ordinal == null) {
                ordinal = NumberExpander.findMatchInArray(lastNumber, digit2enty, ord2enty);
            }
            if (lastNumber.equals("hundred")) {
                ordinal = "hundredth";
            } else if (lastNumber.equals("thousand")) {
                ordinal = "thousandth";
            } else if (lastNumber.equals("billion")) {
                ordinal = "billionth";
            }
            if (ordinal != null) {
                wordRelation.setLastWord(ordinal);
            }
        }
    }

    private static String findMatchInArray(String strToMatch, String[] matchInArray, String[] returnInArray) {
        for (int i = 0; i < matchInArray.length; ++i) {
            if (!strToMatch.equals(matchInArray[i])) continue;
            if (i < returnInArray.length) {
                return returnInArray[i];
            }
            return null;
        }
        return null;
    }

    public static void expandID(String numberString, WordRelation wordRelation, Item tokenItem) {
        int numberDigits = numberString.length();
        if (numberDigits == 4 && numberString.charAt(2) == '0' && numberString.charAt(3) == '0') {
            if (numberString.charAt(1) == '0') {
                NumberExpander.expandNumber(numberString, wordRelation, tokenItem);
            } else {
                NumberExpander.expandNumber(numberString.substring(0, 2), wordRelation, tokenItem);
                wordRelation.addWord(tokenItem, "hundred");
            }
        } else if (numberDigits == 2 && numberString.charAt(0) == '0') {
            wordRelation.addWord(tokenItem, "oh");
            NumberExpander.expandDigits(numberString.substring(1, 2), wordRelation, tokenItem);
        } else if (numberDigits == 4 && numberString.charAt(1) == '0' || numberDigits < 3) {
            NumberExpander.expandNumber(numberString, wordRelation, tokenItem);
        } else if (numberDigits % 2 == 1) {
            String firstDigit = digit2num[numberString.charAt(0) - 48];
            wordRelation.addWord(tokenItem, firstDigit);
            NumberExpander.expandID(numberString.substring(1, numberDigits), wordRelation, tokenItem);
        } else {
            NumberExpander.expandNumber(numberString.substring(0, 2), wordRelation, tokenItem);
            NumberExpander.expandID(numberString.substring(2, numberDigits), wordRelation, tokenItem);
        }
    }

    public static void expandReal(String numberString, WordRelation wordRelation, Item tokenItem) {
        int stringLength = numberString.length();
        if (numberString.charAt(0) == '-') {
            wordRelation.addWord(tokenItem, "minus");
            NumberExpander.expandReal(numberString.substring(1, stringLength), wordRelation, tokenItem);
        } else if (numberString.charAt(0) == '+') {
            wordRelation.addWord(tokenItem, "plus");
            NumberExpander.expandReal(numberString.substring(1, stringLength), wordRelation, tokenItem);
        } else {
            int position = numberString.indexOf(101);
            if (position != -1 || (position = numberString.indexOf(69)) != -1) {
                NumberExpander.expandReal(numberString.substring(0, position), wordRelation, tokenItem);
                wordRelation.addWord(tokenItem, "e");
                NumberExpander.expandReal(numberString.substring(position + 1), wordRelation, tokenItem);
            } else {
                position = numberString.indexOf(46);
                if (position != -1) {
                    String beforeDot = numberString.substring(0, position);
                    if (beforeDot.length() > 0) {
                        NumberExpander.expandReal(beforeDot, wordRelation, tokenItem);
                    }
                    wordRelation.addWord(tokenItem, "point");
                    String afterDot = numberString.substring(position + 1);
                    if (afterDot.length() > 0) {
                        NumberExpander.expandDigits(afterDot, wordRelation, tokenItem);
                    }
                } else {
                    NumberExpander.expandNumber(numberString, wordRelation, tokenItem);
                }
            }
        }
    }

    public static void expandLetters(String letters, WordRelation wordRelation, Item tokenItem) {
        letters = letters.toLowerCase();
        for (int i = 0; i < letters.length(); ++i) {
            char c = letters.charAt(i);
            if (NumberExpander.isDigit(c)) {
                wordRelation.addWord(tokenItem, digit2num[c - 48]);
                continue;
            }
            if (letters.equals("a")) {
                wordRelation.addWord(tokenItem, "_a");
                continue;
            }
            wordRelation.addWord(tokenItem, String.valueOf(c));
        }
    }

    public static int expandRoman(String roman) {
        int value = 0;
        for (int p = 0; p < roman.length(); ++p) {
            char c = roman.charAt(p);
            if (c == 'X') {
                value += 10;
                continue;
            }
            if (c == 'V') {
                value += 5;
                continue;
            }
            if (c != 'I') continue;
            if (p + 1 < roman.length()) {
                char p1 = roman.charAt(p + 1);
                if (p1 == 'V') {
                    value += 4;
                    ++p;
                    continue;
                }
                if (p1 == 'X') {
                    value += 9;
                    ++p;
                    continue;
                }
                ++value;
                continue;
            }
            ++value;
        }
        return value;
    }

    public static boolean isDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }
}

