/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.en;

import com.sun.speech.freetts.Token;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.en.TokenizerImpl;
import java.util.ArrayList;
import java.util.Locale;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.language.en_US.datatypes.USEnglishDataTypes;
import marytts.modules.InternalModule;
import marytts.modules.synthesis.FreeTTSVoices;
import marytts.modules.synthesis.Voice;

public class FreeTTSTextToTokens
extends InternalModule {
    public FreeTTSTextToTokens() {
        super("TextToTokens", MaryDataType.TEXT, USEnglishDataTypes.FREETTS_TOKENS, Locale.ENGLISH);
    }

    public void startup() throws Exception {
        super.startup();
        FreeTTSVoices.load();
    }

    public MaryData process(MaryData d) throws Exception {
        String text = d.getPlainText();
        TokenizerImpl tokenizer = new TokenizerImpl();
        tokenizer.setWhitespaceSymbols(" \t\n\r");
        tokenizer.setSingleCharSymbols("");
        tokenizer.setPrepunctuationSymbols("\"'`({[");
        tokenizer.setPostpunctuationSymbols("\"'`.,:;!?(){}[]");
        tokenizer.setInputText(text);
        ArrayList<Utterance> utteranceList = new ArrayList<Utterance>();
        Token savedToken = null;
        boolean first = true;
        while (tokenizer.hasMoreTokens()) {
            Voice maryVoice;
            ArrayList<Token> tokenList = new ArrayList<Token>();
            Utterance utterance = null;
            if (savedToken != null) {
                tokenList.add(savedToken);
                savedToken = null;
            }
            while (tokenizer.hasMoreTokens()) {
                Token token = tokenizer.getNextToken();
                if (token.getWord().length() == 0 || tokenList.size() > 500 || tokenizer.isBreak()) {
                    savedToken = token;
                    break;
                }
                tokenList.add(token);
            }
            if ((maryVoice = d.getDefaultVoice()) == null || !maryVoice.getLocale().equals(Locale.US)) {
                maryVoice = Voice.getDefaultVoice((Locale)Locale.US);
            }
            utterance = new Utterance(FreeTTSVoices.getFreeTTSVoice((Voice)maryVoice), tokenList);
            utterance.setFirst(first);
            first = false;
            utterance.setLast(!tokenizer.hasMoreTokens());
            utteranceList.add(utterance);
        }
        MaryData output = new MaryData(this.outputType(), d.getLocale());
        output.setUtterances(utteranceList);
        return output;
    }
}

