/*
 * Decompiled with CFR 0.152.
 */
package topcodes;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import topcodes.TopCode;

public class TopCodePrinter
extends JPanel
implements Printable,
KeyListener {
    static int INCH = 72;
    static final int PAGE_WIDTH = 792;
    static final int PAGE_HEIGHT = 612;
    static final int PAGE_COUNT = 2;
    public static JFrame frame;
    TopCode[] codes;

    public TopCodePrinter() {
        this.addKeyListener(this);
        this.codes = TopCode.generateCodes();
        for (int i = 0; i < this.codes.length; ++i) {
            this.codes[i].setDiameter(this.inches(0.75));
        }
    }

    protected float inches(double d) {
        return (float)INCH * (float)d;
    }

    protected void drawCodes(Graphics2D graphics2D, int n, int n2) {
        float f = (float)n + this.inches(1.4);
        float f2 = this.inches(1.5);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.codes[n2].setLocation(f2, f);
                this.codes[n2].draw(graphics2D);
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawString(String.valueOf(this.codes[n2].getCode()), f2 - this.inches(0.1), f + this.inches(0.55));
                f2 += this.inches(1.0);
                if (++n2 < this.codes.length) continue;
                return;
            }
            f += this.inches(1.0);
            f2 = this.inches(1.5);
        }
    }

    protected void page1(Graphics2D graphics2D, int n) {
        this.drawCodes(graphics2D, n, 0);
    }

    protected void page2(Graphics2D graphics2D, int n) {
        this.drawCodes(graphics2D, n, 54);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(612.0, 0.0);
        affineTransform.rotate(1.5707963267948966);
        graphics2D.transform(affineTransform);
        switch (n) {
            case 0: {
                this.page1(graphics2D, 0);
                return 0;
            }
            case 1: {
                this.page2(graphics2D, 0);
                return 0;
            }
        }
        return 1;
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, 792, 1224);
        for (int i = 0; i < 2; ++i) {
            graphics2D.setColor(Color.black);
            graphics2D.drawLine(0, 612 * (i + 1), 792, 612 * (i + 1));
            graphics2D.setColor(Color.blue);
            graphics2D.drawRect(INCH, INCH + 612 * i, 792 - INCH * 2, 612 - INCH * 2);
        }
        this.page1(graphics2D, 0);
        this.page2(graphics2D, 612);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.isControlDown()) {
            if (keyEvent.getKeyCode() == 80) {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPrintable(this);
                if (printerJob.printDialog()) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException printerException) {
                        System.out.println(printerException);
                    }
                }
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private static void createAndShowGUI() {
        frame = new JFrame("TopCode Printer");
        frame.setDefaultCloseOperation(3);
        TopCodePrinter topCodePrinter = new TopCodePrinter();
        topCodePrinter.setOpaque(true);
        topCodePrinter.setPreferredSize(new Dimension(792, 1224));
        JScrollPane jScrollPane = new JScrollPane(topCodePrinter);
        jScrollPane.setPreferredSize(new Dimension(802, 637));
        frame.setContentPane(jScrollPane);
        frame.pack();
        frame.setVisible(true);
        topCodePrinter.requestFocusInWindow();
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TopCodePrinter.createAndShowGUI();
            }
        });
    }
}

