/*
 * Decompiled with CFR 0.152.
 */
package topcodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import topcodes.Scanner;

public class TopCode {
    protected static int SECTORS = 13;
    protected static int WIDTH = 8;
    protected static float PI = (float)Math.PI;
    protected static float ARC = 2.0f * PI / (float)SECTORS;
    protected int code = -1;
    protected float unit = 72.0f / (float)WIDTH;
    protected float orientation = 0.0f;
    protected float x = 0.0f;
    protected float y = 0.0f;
    protected int[] core = new int[WIDTH];

    public TopCode() {
    }

    public TopCode(int n) {
        this();
        this.code = n;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int n) {
        this.code = n;
    }

    public float getOrientation() {
        return this.orientation;
    }

    public void setOrientation(float f) {
        this.orientation = f;
    }

    public float getDiameter() {
        return this.unit * (float)WIDTH;
    }

    public void setDiameter(float f) {
        this.unit = f / (float)WIDTH;
    }

    public float getCenterX() {
        return this.x;
    }

    public float getCenterY() {
        return this.y;
    }

    public void setLocation(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public boolean isValid() {
        return this.code > 0;
    }

    public int decode(Scanner scanner, int n, int n2) {
        int n3 = scanner.ydist(n, n2, -1) + scanner.ydist(n - 1, n2, -1) + scanner.ydist(n + 1, n2, -1);
        int n4 = scanner.ydist(n, n2, 1) + scanner.ydist(n - 1, n2, 1) + scanner.ydist(n + 1, n2, 1);
        int n5 = scanner.xdist(n, n2, -1) + scanner.xdist(n, n2 - 1, -1) + scanner.xdist(n, n2 + 1, -1);
        int n6 = scanner.xdist(n, n2, 1) + scanner.xdist(n, n2 - 1, 1) + scanner.xdist(n, n2 + 1, 1);
        this.x = n;
        this.y = n2;
        this.x += (float)(n6 - n5) / 6.0f;
        this.y += (float)(n4 - n3) / 6.0f;
        this.unit = this.readUnit(scanner);
        this.code = -1;
        if (this.unit < 0.0f) {
            return -1;
        }
        int n7 = 0;
        int n8 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = -2; i <= 2; ++i) {
            for (int j = 0; j < 10; ++j) {
                float f3 = (float)j * ARC * 0.1f;
                n7 = this.readCode(scanner, this.unit + this.unit * 0.05f * (float)i, f3);
                if (n7 <= n8) continue;
                n8 = n7;
                f = f3;
                f2 = this.unit + this.unit * 0.05f * (float)i;
            }
        }
        if (n8 > 0) {
            this.unit = f2;
            this.readCode(scanner, this.unit, f);
            this.code = this.rotateLowest(this.code, f);
        }
        return this.code;
    }

    protected int readCode(Scanner scanner, float f, float f2) {
        int n = 0;
        int n2 = 0;
        this.code = -1;
        for (int i = SECTORS - 1; i >= 0; --i) {
            float f3 = (float)Math.cos(ARC * (float)i + f2);
            float f4 = (float)Math.sin(ARC * (float)i + f2);
            for (int j = 0; j < WIDTH; ++j) {
                float f5 = ((float)j - 3.5f) * f;
                int n3 = Math.round(this.x + f3 * f5);
                int n4 = Math.round(this.y + f4 * f5);
                this.core[j] = scanner.getSample3x3(n3, n4);
            }
            if (this.core[1] <= 128 || this.core[3] <= 128 || this.core[4] <= 128 || this.core[6] <= 128) {
                return 0;
            }
            if (this.core[2] > 128 || this.core[5] > 128) {
                return 0;
            }
            n += this.core[1] + this.core[3] + this.core[4] + this.core[6] + (255 - this.core[2]) + (255 - this.core[5]);
            n += Math.abs(this.core[7] * 2 - 255);
            n += 255 - Math.abs(this.core[0] * 2 - 255);
            int n5 = this.core[7] > 128 ? 1 : 0;
            n2 <<= 1;
            n2 += n5;
        }
        if (this.checksum(n2)) {
            this.code = n2;
            return n;
        }
        return 0;
    }

    protected int rotateLowest(int n, float f) {
        int n2 = n;
        int n3 = 8191;
        f -= ARC * 0.65f;
        this.orientation = 0.0f;
        for (int i = 1; i <= SECTORS; ++i) {
            if ((n = n << 1 & n3 | n >> SECTORS - 1) >= n2) continue;
            n2 = n;
            this.orientation = (float)i * -ARC;
        }
        this.orientation += f;
        return n2;
    }

    protected boolean checksum(int n) {
        int n2 = 0;
        for (int i = 0; i < SECTORS; ++i) {
            n2 += n & 1;
            n >>= 1;
        }
        return n2 == 5;
    }

    protected boolean inBullsEye(float f, float f2) {
        return (this.x - f) * (this.x - f) + (this.y - f2) * (this.y - f2) <= this.unit * this.unit;
    }

    protected float readUnit(Scanner scanner) {
        int n = Math.round(this.x);
        int n2 = Math.round(this.y);
        int n3 = scanner.getImageWidth();
        int n4 = scanner.getImageHeight();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 1;
        while (n - n9 >= 1 && n + n9 < n3 - 1 && n2 - n9 >= 1 && n2 + n9 < n4 - 1 && n9 <= 100) {
            int n10 = scanner.getBW3x3(n - n9, n2);
            if (n5 <= 0) {
                if (bl && n10 == 0) {
                    bl = false;
                } else if (!bl && n10 == 1) {
                    n5 = n9;
                }
            }
            n10 = scanner.getBW3x3(n + n9, n2);
            if (n6 <= 0) {
                if (bl2 && n10 == 0) {
                    bl2 = false;
                } else if (!bl2 && n10 == 1) {
                    n6 = n9;
                }
            }
            n10 = scanner.getBW3x3(n, n2 - n9);
            if (n7 <= 0) {
                if (bl3 && n10 == 0) {
                    bl3 = false;
                } else if (!bl3 && n10 == 1) {
                    n7 = n9;
                }
            }
            n10 = scanner.getBW3x3(n, n2 + n9);
            if (n8 <= 0) {
                if (bl4 && n10 == 0) {
                    bl4 = false;
                } else if (!bl4 && n10 == 1) {
                    n8 = n9;
                }
            }
            if (n6 > 0 && n5 > 0 && n7 > 0 && n8 > 0) {
                float f = (float)(n6 + n5 + n7 + n8) / 8.0f;
                if ((float)Math.abs(n6 + n5 - n7 - n8) > f) {
                    return -1.0f;
                }
                return f;
            }
            ++n9;
        }
        return -1.0f;
    }

    public void annotate(Graphics2D graphics2D, Scanner scanner) {
        boolean bl = false;
        for (int i = SECTORS - 1; i >= 0; --i) {
            float f = (float)Math.cos(ARC * (float)i + this.orientation);
            float f2 = (float)Math.sin(ARC * (float)i + this.orientation);
            int n = 0;
            for (int j = 3; j < WIDTH; ++j) {
                int n2;
                float f3 = ((float)j - 3.5f) * this.unit;
                int n3 = Math.round(this.x + f * f3);
                n = scanner.getBW3x3(n3, n2 = Math.round(this.y + f2 * f3));
                graphics2D.setColor(n == 0 ? Color.BLACK : Color.WHITE);
                Rectangle2D.Float float_ = new Rectangle2D.Float((float)n3 - 0.6f, (float)n2 - 0.6f, 1.2f, 1.2f);
                graphics2D.fill(float_);
                graphics2D.setColor(Color.RED);
                graphics2D.setStroke(new BasicStroke(0.25f));
                graphics2D.draw(float_);
            }
        }
    }

    public void draw(Graphics2D graphics2D) {
        int n = this.code;
        Arc2D.Float float_ = new Arc2D.Float(2);
        float f = 360.0f / (float)SECTORS;
        float f2 = -this.orientation * 180.0f / PI;
        float f3 = (float)WIDTH * 0.5f * this.unit;
        Ellipse2D.Float float_2 = new Ellipse2D.Float(this.x - f3, this.y - f3, f3 * 2.0f, f3 * 2.0f);
        graphics2D.setColor(Color.white);
        graphics2D.fill(float_2);
        for (int i = SECTORS - 1; i >= 0; --i) {
            ((Arc2D)float_).setArc(this.x - f3, this.y - f3, f3 * 2.0f, f3 * 2.0f, (float)i * f + f2, f, 2);
            graphics2D.setColor((n & 1) > 0 ? Color.white : Color.black);
            graphics2D.fill(float_);
            n >>= 1;
        }
        graphics2D.setColor(Color.white);
        ((RectangularShape)float_2).setFrame(this.x - (f3 -= this.unit), this.y - f3, f3 * 2.0f, f3 * 2.0f);
        graphics2D.fill(float_2);
        graphics2D.setColor(Color.black);
        ((RectangularShape)float_2).setFrame(this.x - (f3 -= this.unit), this.y - f3, f3 * 2.0f, f3 * 2.0f);
        graphics2D.fill(float_2);
        graphics2D.setColor(Color.white);
        ((RectangularShape)float_2).setFrame(this.x - (f3 -= this.unit), this.y - f3, f3 * 2.0f, f3 * 2.0f);
        graphics2D.fill(float_2);
    }

    protected void printBits(int n) {
        for (int i = SECTORS - 1; i >= 0; --i) {
            if ((n >> i & 1) == 1) {
                System.out.print("1");
            } else {
                System.out.print("0");
            }
            if ((44 - i) % 4 != 0) continue;
            System.out.print(" ");
        }
        System.out.println(" = " + n);
    }

    public static TopCode[] generateCodes() {
        int n = 99;
        int n2 = 0;
        TopCode[] topCodeArray = new TopCode[n];
        TopCode topCode = new TopCode();
        int n3 = 0;
        while (n3 < n) {
            int n4 = topCode.rotateLowest(n2, 0.0f);
            if (n4 == n2 && topCode.checksum(n4)) {
                topCode.setCode(n4);
                topCode.setOrientation(0.0f);
                topCodeArray[n3++] = topCode;
                topCode = new TopCode();
            }
            ++n2;
        }
        return topCodeArray;
    }
}

