/*
 * Decompiled with CFR 0.152.
 */
package topcodes;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import topcodes.Scanner;
import topcodes.TopCode;

public class DebugWindow
extends JPanel
implements KeyListener,
WindowListener,
MouseListener,
MouseMotionListener,
FilenameFilter {
    protected JFrame frame;
    protected Scanner scanner;
    protected AffineTransform tform;
    protected boolean binary;
    protected boolean show_spots;
    protected boolean annotate;
    protected List spots;
    protected int test_x;
    protected int test_y;
    protected int file_index;
    protected String[] files;
    int mouseX;
    int mouseY;
    double[] point = new double[2];

    public DebugWindow() {
        super(true);
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(1024, 768));
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.scanner = new Scanner();
        this.scanner.setMaxCodeDiameter(56);
        this.file_index = 0;
        this.files = new File(".").list(this);
        this.clear();
        this.frame = new JFrame("TopCode Debugger");
        this.frame.setDefaultCloseOperation(0);
        this.frame.setContentPane(this);
        this.frame.addWindowListener(this);
        this.frame.pack();
        this.frame.setVisible(true);
        this.requestFocusInWindow();
        this.loadTest();
    }

    public void clear() {
        this.tform = new AffineTransform();
        this.spots = null;
        this.show_spots = true;
        this.binary = false;
        this.annotate = false;
        this.test_x = -1;
        this.test_y = -1;
    }

    protected void paintComponent(Graphics graphics) {
        TopCode topCode;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, n2, n3);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BufferedImage bufferedImage = this.binary ? this.scanner.getPreview() : this.scanner.getImage();
        graphics2D.drawRenderedImage(bufferedImage, this.tform);
        graphics2D.transform(this.tform);
        if (this.show_spots && this.spots != null) {
            for (n = 0; n < this.spots.size(); ++n) {
                topCode = (TopCode)this.spots.get(n);
                topCode.draw(graphics2D);
            }
        }
        if (this.annotate && this.spots != null) {
            for (n = 0; n < this.spots.size(); ++n) {
                topCode = (TopCode)this.spots.get(n);
                topCode.annotate(graphics2D, this.scanner);
            }
        }
        if (this.test_x >= 0 && this.test_y >= 0) {
            TopCode topCode2 = new TopCode();
            topCode2.decode(this.scanner, this.test_x, this.test_y);
            if (topCode2.isValid()) {
                topCode2.draw(graphics2D);
            } else {
                topCode2.annotate(graphics2D, this.scanner);
            }
        }
    }

    public void load(String string) {
        this.clear();
        if (string == null) {
            return;
        }
        if (!new File(string).exists()) {
            return;
        }
        this.frame.setTitle(string);
        try {
            long l = System.currentTimeMillis();
            this.spots = this.scanner.scan(string);
            l = System.currentTimeMillis() - l;
            System.out.println("Found " + this.spots.size() + " codes.");
            System.out.println(this.scanner.getCandidateCount() + " candidates.");
            System.out.println(this.scanner.getTestedCount() + " tested.");
            for (int i = 0; i < this.spots.size(); ++i) {
                TopCode topCode = (TopCode)this.spots.get(i);
                topCode.printBits(topCode.getCode());
            }
            System.out.println(l + "ms elapsed time.");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void loadTest() {
        if (this.files == null || this.file_index >= this.files.length) {
            return;
        }
        System.out.println(this.files[this.file_index]);
        this.load(this.files[this.file_index]);
    }

    public void zoom(double d) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        double d2 = (double)n / 2.0;
        double d3 = (double)n2 / 2.0;
        new AffineTransform();
        this.tform.preConcatenate(AffineTransform.getTranslateInstance(-d2, -d3));
        new AffineTransform();
        this.tform.preConcatenate(AffineTransform.getScaleInstance(d, d));
        new AffineTransform();
        this.tform.preConcatenate(AffineTransform.getTranslateInstance(d2, d3));
        this.repaint();
    }

    public void pan(int n, int n2) {
        double d = this.tform.getScaleX();
        double d2 = this.tform.getScaleY();
        this.tform.translate((double)n / d, (double)n2 / d2);
        this.repaint();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 65: {
                this.annotate = !this.annotate;
                this.repaint();
                break;
            }
            case 66: {
                this.binary = !this.binary;
                this.repaint();
                break;
            }
            case 84: {
                this.show_spots = !this.show_spots;
                this.repaint();
                break;
            }
            case 79: {
                JFileChooser jFileChooser;
                int n2;
                if (keyEvent.isControlDown() && (n2 = (jFileChooser = new JFileChooser(new File("."))).showOpenDialog(null)) == 0) {
                    this.load(jFileChooser.getSelectedFile().getAbsolutePath());
                }
                this.repaint();
                break;
            }
            case 45: {
                this.zoom(0.95);
                this.repaint();
                break;
            }
            case 61: {
                this.zoom(1.0526315789473684);
                this.repaint();
                break;
            }
            case 33: {
                if (this.files != null && this.file_index < this.files.length) {
                    ++this.file_index;
                }
                this.loadTest();
                this.repaint();
                break;
            }
            case 34: {
                if (this.file_index > 0) {
                    --this.file_index;
                }
                this.loadTest();
                this.repaint();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.frame.setVisible(false);
        this.frame.dispose();
        System.exit(0);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        if (mouseEvent.isControlDown()) {
            this.point[0] = this.mouseX;
            this.point[1] = this.mouseY;
            try {
                this.tform.inverseTransform(this.point, 0, this.point, 0, 1);
                this.test_x = (int)Math.round(this.point[0]);
                this.test_y = (int)Math.round(this.point[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.pan(mouseEvent.getX() - this.mouseX, mouseEvent.getY() - this.mouseY);
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
    }

    public boolean accept(File file, String string) {
        return string.toLowerCase().endsWith(".jpg");
    }

    public static void main(String[] stringArray) {
        System.setProperty("sun.java2d.noddraw", "");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new DebugWindow();
            }
        });
    }
}

