/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.gui.util;

import edu.cmu.sphinx.tools.gui.util.AsyncStreamReader;
import edu.cmu.sphinx.tools.gui.util.EnvironmentVar;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SysCommandExecutor {
    private String fWorkingDirectory;
    private List<EnvironmentVar> fEnvironmentVarList;
    private StringBuffer fCmdOutput;
    private StringBuffer fCmdError;
    private AsyncStreamReader fCmdOutputThread;
    private AsyncStreamReader fCmdErrorThread;

    private SysCommandExecutor() {
    }

    public static SysCommandExecutor getInstance() {
        return SysExecutorHolder.instance;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.fWorkingDirectory = workingDirectory;
    }

    public void setEnvironmentVar(String name, String value) {
        if (this.fEnvironmentVarList == null) {
            this.fEnvironmentVarList = new ArrayList<EnvironmentVar>();
        }
        this.fEnvironmentVarList.add(new EnvironmentVar(name, value));
    }

    public String getCommandOutput() {
        return this.fCmdOutput.toString();
    }

    public String getCommandError() {
        return this.fCmdError.toString();
    }

    public int runCommand(String commandLine) throws Exception {
        Process process = this.runCommandHelper(commandLine);
        this.startOutputAndErrorReadThreads(process.getInputStream(), process.getErrorStream());
        int exitStatus = -1;
        try {
            exitStatus = process.waitFor();
        }
        catch (Throwable ex) {
            throw new Exception("SysCommandExecutor :" + ex.getMessage());
        }
        finally {
            this.notifyOutputAndErrorReadThreadsToStopReading();
        }
        return exitStatus;
    }

    private Process runCommandHelper(String commandLine) throws IOException {
        Process process = null;
        process = this.fWorkingDirectory == null ? Runtime.getRuntime().exec(commandLine, this.getEnvTokens()) : Runtime.getRuntime().exec(commandLine, this.getEnvTokens(), new File(this.fWorkingDirectory));
        return process;
    }

    private void startOutputAndErrorReadThreads(InputStream processOut, InputStream processErr) {
        this.fCmdOutput = new StringBuffer();
        this.fCmdOutputThread = new AsyncStreamReader(processOut, this.fCmdOutput, "OUTPUT");
        this.fCmdOutputThread.start();
        this.fCmdError = new StringBuffer();
        this.fCmdErrorThread = new AsyncStreamReader(processErr, this.fCmdError, "ERROR");
        this.fCmdErrorThread.start();
    }

    private void notifyOutputAndErrorReadThreadsToStopReading() {
        this.fCmdOutputThread.stopReading();
        this.fCmdErrorThread.stopReading();
    }

    private String[] getEnvTokens() {
        if (this.fEnvironmentVarList == null) {
            return null;
        }
        String[] envTokenArray = new String[this.fEnvironmentVarList.size()];
        Iterator<EnvironmentVar> envVarIter = this.fEnvironmentVarList.iterator();
        int nEnvVarIndex = 0;
        while (envVarIter.hasNext()) {
            EnvironmentVar envVar = envVarIter.next();
            String envVarToken = envVar.fName + '=' + envVar.fValue;
            envTokenArray[nEnvVarIndex++] = envVarToken;
        }
        return envTokenArray;
    }

    private static class SysExecutorHolder {
        private static final SysCommandExecutor instance = new SysCommandExecutor();

        private SysExecutorHolder() {
        }
    }
}

