/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.gui.util;

import edu.cmu.sphinx.tools.gui.util.ConfigurableProperty;
import edu.cmu.sphinx.util.props.RawPropertyData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigurableComponent {
    private final String _sectionName;
    private final Map<String, ConfigurableProperty> _propList;
    private final Class<?> _component;
    private final String _componentDesc;
    private final String _componentClassName;
    private final Map<String, RawPropertyData> _confProp;

    public ConfigurableComponent(String section, Class<?> component, String name, String desc) {
        this._sectionName = section;
        this._component = component;
        this._componentClassName = name;
        this._componentDesc = desc;
        this._propList = new HashMap<String, ConfigurableProperty>();
        this._confProp = new HashMap<String, RawPropertyData>();
    }

    public String toString() {
        StringBuilder output = new StringBuilder("Section :").append(this._sectionName).append('\n');
        output.append(" Class Name : ").append(this._componentClassName).append('\n');
        if (!this._componentDesc.isEmpty()) {
            output.append(" Desc : ").append(this._componentDesc).append('\n');
        }
        if (!this._propList.isEmpty()) {
            output.append(" Property list : \n");
            for (ConfigurableProperty cp : this._propList.values()) {
                output.append(cp);
            }
        }
        if (!this._confProp.isEmpty()) {
            output.append(" Configuration values : ***** \n");
            for (RawPropertyData rpd : this._confProp.values()) {
                output.append(rpd);
            }
        }
        return output.toString();
    }

    public String getSectionName() {
        return this._sectionName;
    }

    public Map<String, ConfigurableProperty> getPropertyMap() {
        return this._propList;
    }

    public void addProperty(ConfigurableProperty cp) {
        this._propList.put(cp.getName(), cp);
    }

    public boolean containsProperty(String name) {
        return this._propList.containsKey(name);
    }

    public ConfigurableProperty getProperty(String name) {
        return this._propList.get(name);
    }

    public Class<?> getComponentClass() {
        return this._component;
    }

    public String getName() {
        return this._componentClassName;
    }

    public String getDesc() {
        return this._componentDesc;
    }

    public void addConfigurationProp(RawPropertyData rpd) {
        this._confProp.put(rpd.getName(), rpd);
    }

    public void deleteAllConfigurationProp() {
        this._confProp.clear();
    }

    public void deleteConfigurationProp(String rpdname) {
        if (this._confProp.containsKey(rpdname)) {
            this._confProp.remove(rpdname);
        }
    }

    public void deleteOneConfigurationPropFromSet(String rpdname, String propname) {
        RawPropertyData rpd = this._confProp.get(rpdname);
        rpd.remove(propname);
    }

    public void changeConfigurationPropValue(String rpdname, String propname, String newvalue) {
        RawPropertyData rpd = this._confProp.get(rpdname);
        rpd.add(propname, newvalue);
    }

    public void changeConfigurationPropValue(String rpdname, String propname, List<String> newvalue) {
        RawPropertyData rpd = this._confProp.get(rpdname);
        rpd.add(propname, newvalue);
    }

    public Object getConfigurationPropValue(String rpdName, String propname) {
        if (this._confProp.containsKey(rpdName)) {
            RawPropertyData rpd = this._confProp.get(rpdName);
            if (rpd.getProperties().containsKey(propname)) {
                return rpd.getProperties().get(propname);
            }
            return null;
        }
        return null;
    }

    public Map<String, RawPropertyData> getConfigurationPropMap() {
        return this._confProp;
    }

    public boolean containsConfigurationSet(String name) {
        return this._confProp.containsKey(name);
    }

    private void addDefaultProps(RawPropertyData rpd) {
        Map<String, ConfigurableProperty> completePropMap = this.getPropertyMap();
        for (Map.Entry<String, ConfigurableProperty> propentry : completePropMap.entrySet()) {
            String propname = propentry.getKey();
            if (rpd.contains(propname)) continue;
            ConfigurableProperty prop = propentry.getValue();
            String defaultVal = prop.getDefault();
            if (defaultVal != null && !defaultVal.trim().isEmpty()) {
                rpd.add(propname, defaultVal);
                continue;
            }
            rpd.add(propname, (String)null);
            System.out.println("***** add null prop " + propname);
        }
    }

    public void createNewSet(String setname) {
        RawPropertyData newrpd = new RawPropertyData(setname, this._componentClassName);
        this.addDefaultProps(newrpd);
        this.addConfigurationProp(newrpd);
    }
}

