/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.gui.reader;

import edu.cmu.sphinx.tools.gui.ConfigProperties;
import edu.cmu.sphinx.tools.gui.reader.GUIReader;
import edu.cmu.sphinx.tools.gui.reader.GUIReaderException;
import edu.cmu.sphinx.util.props.SaxLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class XMLConfigReader
implements GUIReader {
    private XMLConfigReader() {
    }

    public static XMLConfigReader getInstance() {
        return XMLReaderHolder.instance;
    }

    @Override
    public ConfigProperties read(File fFile) throws GUIReaderException {
        if (fFile == null || fFile.getName().trim().isEmpty()) {
            throw new GUIReaderException("No input filename specified", 3);
        }
        try {
            URL url = fFile.toURI().toURL();
            HashMap<String, String> global = new HashMap<String, String>();
            Map pm = new SaxLoader(url, global).load();
            ConfigProperties cp = new ConfigProperties();
            cp.setGlobal(global);
            cp.setProperty(pm);
            return cp;
        }
        catch (IOException e) {
            throw new GUIReaderException("IO Exception during read", 2);
        }
    }

    private static class XMLReaderHolder {
        private static final XMLConfigReader instance = new XMLConfigReader();

        private XMLReaderHolder() {
        }
    }
}

