/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.gui;

import edu.cmu.sphinx.tools.gui.GUIMediator;
import edu.cmu.sphinx.tools.gui.PanelConfigurable;
import edu.cmu.sphinx.tools.gui.PanelGlobal;
import edu.cmu.sphinx.tools.gui.reader.GUIReaderException;
import edu.cmu.sphinx.tools.gui.util.ConfigurableComponent;
import edu.cmu.sphinx.tools.gui.util.ConfigurableUtilException;
import edu.cmu.sphinx.tools.gui.writer.GUIWriterException;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;

class MainJFrame
extends JFrame {
    private JMenuBar MenuBarFile;
    private JMenu MenuConfig;
    private JMenu MenuFile;
    private JMenuItem MenuItemExit;
    private JMenuItem MenuItemNew;
    private JMenuItem MenuItemOpen;
    private JMenuItem MenuItemRefresh;
    private JMenuItem MenuItemSave;
    private JMenuItem MenuItemShow;
    private JMenu MenuModel;
    private JTabbedPane TabPanel;
    private JDialog jDialogOutput;
    private JScrollPane jScrollPane6;
    private JTextArea jTextAreaOutput;
    private final GUIMediator _gm;
    private PanelGlobal _pGlobal;
    private PanelConfigurable _pConfigurable;

    MainJFrame(GUIMediator gm, Map<String, Set<ConfigurableComponent>> groups) {
        super("Sphinx-4 Configuration");
        this._gm = gm;
        this.initComponents();
        this.addGlobalPanel();
        this.addTextPanels(groups);
    }

    private void initComponents() {
        this.jDialogOutput = new JDialog();
        this.jScrollPane6 = new JScrollPane();
        this.jTextAreaOutput = new JTextArea();
        this.TabPanel = new JTabbedPane();
        this.MenuBarFile = new JMenuBar();
        this.MenuFile = new JMenu();
        this.MenuItemNew = new JMenuItem();
        this.MenuItemOpen = new JMenuItem();
        this.MenuItemSave = new JMenuItem();
        this.MenuItemExit = new JMenuItem();
        this.MenuModel = new JMenu();
        this.MenuItemRefresh = new JMenuItem();
        this.MenuConfig = new JMenu();
        this.MenuItemShow = new JMenuItem();
        this.jDialogOutput.setTitle("Current Configuration");
        this.jDialogOutput.setAlwaysOnTop(true);
        this.jDialogOutput.setModal(true);
        this.jDialogOutput.setName("dialogSource");
        this.jTextAreaOutput.setMargin(new Insets(20, 20, 20, 20));
        this.jScrollPane6.setViewportView(this.jTextAreaOutput);
        this.jDialogOutput.getContentPane().add((Component)this.jScrollPane6, "Center");
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.getContentPane().add(this.TabPanel);
        this.MenuFile.setText("F i l e.....");
        this.MenuItemNew.setText("New");
        this.MenuItemNew.setActionCommand("File-New");
        this.MenuItemNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.MenuItemActionPerformed(evt);
            }
        });
        this.MenuFile.add(this.MenuItemNew);
        this.MenuItemOpen.setText("Open");
        this.MenuItemOpen.setActionCommand("File-Open");
        this.MenuItemOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.MenuItemActionPerformed(evt);
            }
        });
        this.MenuFile.add(this.MenuItemOpen);
        this.MenuItemSave.setText("Save");
        this.MenuItemSave.setActionCommand("File-Save");
        this.MenuItemSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.MenuItemActionPerformed(evt);
            }
        });
        this.MenuFile.add(this.MenuItemSave);
        this.MenuItemExit.setText("Exit");
        this.MenuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.MenuItemActionPerformed(evt);
            }
        });
        this.MenuFile.add(this.MenuItemExit);
        this.MenuBarFile.add(this.MenuFile);
        this.MenuModel.setText("Sphinx Model...");
        this.MenuItemRefresh.setText("Refresh");
        this.MenuItemRefresh.setActionCommand("Model-Refresh");
        this.MenuItemRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.MenuItemActionPerformed(evt);
            }
        });
        this.MenuModel.add(this.MenuItemRefresh);
        this.MenuBarFile.add(this.MenuModel);
        this.MenuConfig.setText("Configuration...");
        this.MenuItemShow.setText("Show Configuration Text");
        this.MenuItemShow.setActionCommand("Show-Configuration");
        this.MenuItemShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.MenuItemActionPerformed(evt);
            }
        });
        this.MenuConfig.add(this.MenuItemShow);
        this.MenuBarFile.add(this.MenuConfig);
        this.setJMenuBar(this.MenuBarFile);
        this.pack();
    }

    private void MenuItemActionPerformed(ActionEvent evt) {
        String NEW = "File-New";
        String OPEN = "File-Open";
        String SAVE = "File-Save";
        String EXIT = "Exit";
        String REFRESH = "Model-Refresh";
        String SHOW_CONFIG = "Show-Configuration";
        String command = evt.getActionCommand();
        ConfigFilter cf = new ConfigFilter();
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File("."));
        fc.setFileFilter(cf);
        boolean status = false;
        try {
            if (command.equals(OPEN)) {
                status = this.openFile(fc);
                if (!status) {
                    this.displayError("File Open Error: Error opening file!");
                }
            } else if (command.equals(SAVE)) {
                status = this.saveFile(fc);
                if (!status) {
                    this.displayError("File Save Error: IO error in saving file!!");
                }
            } else if (command.equals(NEW)) {
                if (this.confirmAction("Discard all configuration set?")) {
                    this._gm.action("new");
                }
            } else if (command.equals(REFRESH)) {
                if (this.confirmAction("Discard all configuration set?")) {
                    this.deleteTabPanels();
                    this._gm.action("refresh_model");
                }
            } else if (command.equals(SHOW_CONFIG)) {
                this._gm.action("show_config", this.jTextAreaOutput);
                this.jDialogOutput.setSize(800, 500);
                this.jDialogOutput.setLocationRelativeTo(null);
                this.jDialogOutput.setVisible(true);
            } else if (command.equals(EXIT)) {
                this.dispose();
            }
        }
        catch (GUIReaderException re) {
            this.displayError("Error occured while reading from file!");
        }
        catch (GUIWriterException we) {
            this.displayError("Error occured while saving file!");
        }
        catch (ConfigurableUtilException cue) {
            this.displayError("Error while refreshing Sphinx model");
        }
    }

    private boolean confirmAction(String message) {
        int response = JOptionPane.showConfirmDialog(this, message, "Confirm Action", 2);
        return response == 0;
    }

    private boolean openFile(JFileChooser fc) throws GUIReaderException, GUIWriterException {
        fc.setFileSelectionMode(2);
        fc.setDialogTitle("Open File");
        int result = fc.showOpenDialog(this);
        if (result == 1) {
            return true;
        }
        if (result != 0) {
            return false;
        }
        File file = fc.getSelectedFile();
        this._gm.action("open", file);
        return true;
    }

    private boolean saveFile(JFileChooser fc) throws GUIReaderException, GUIWriterException {
        File file = null;
        fc.setDialogTitle("Save File");
        int result = fc.showSaveDialog(this);
        if (result == 1) {
            return true;
        }
        if (result == 0) {
            file = fc.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(".config.xml")) {
                file = new File(file.getPath().concat(".config.xml"));
                fc.setSelectedFile(file);
            }
            if (file.exists()) {
                int response = JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Confirm Overwrite", 2, 3);
                if (response == 0) {
                    this._gm.action("save", file);
                    return true;
                }
                return this.saveFile(fc);
            }
            this._gm.action("save", file);
            return true;
        }
        return false;
    }

    private void addTabPanel(String title, Component comp, int tabindex) {
        int c = tabindex + 49;
        this.TabPanel.addTab(title, comp);
        this.TabPanel.setMnemonicAt(tabindex, c);
    }

    private void addGlobalPanel() {
        this._pGlobal = new PanelGlobal("Global settings", this._gm);
        this.addTabPanel("General", this._pGlobal, 0);
    }

    private void deleteTabPanels() {
        System.out.println("*** num of tabs :" + this.TabPanel.getTabCount());
        while (this.TabPanel.getTabCount() > 1) {
            this.TabPanel.remove(this.TabPanel.getTabCount() - 1);
        }
    }

    public void addTextPanels(Map<String, Set<ConfigurableComponent>> groups) {
        int tempi = 1;
        for (Map.Entry<String, Set<ConfigurableComponent>> propentry : groups.entrySet()) {
            String grpname = propentry.getKey();
            Set<ConfigurableComponent> grp = propentry.getValue();
            this._pConfigurable = new PanelConfigurable(this._gm, grpname, grp);
            this.addTabPanel(grpname.substring(1 + grpname.lastIndexOf(46)).toUpperCase(), this._pConfigurable, tempi++);
        }
    }

    private void displayError(String message) {
        JOptionPane.showMessageDialog(this, message, "Sphinx-4", 0);
    }

    class ConfigFilter
    extends FileFilter {
        ConfigFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String fname = f.getName();
            return fname.toLowerCase().endsWith(".config.xml");
        }

        @Override
        public String getDescription() {
            return "Sphinx config file";
        }
    }
}

