/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.gui;

import edu.cmu.sphinx.tools.gui.ConfigProperties;
import edu.cmu.sphinx.tools.gui.GUIFileActionListener;
import edu.cmu.sphinx.tools.gui.GUIOperationException;
import edu.cmu.sphinx.tools.gui.MainJFrame;
import edu.cmu.sphinx.tools.gui.reader.GUIReaderException;
import edu.cmu.sphinx.tools.gui.reader.XMLConfigReader;
import edu.cmu.sphinx.tools.gui.util.ConfigurableUtilException;
import edu.cmu.sphinx.tools.gui.util.ModelBuilder;
import edu.cmu.sphinx.tools.gui.writer.GUIWriterException;
import edu.cmu.sphinx.tools.gui.writer.XMLConfigWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextArea;

public class GUIMediator {
    public static final String OPEN = "open";
    public static final String EXIT = "exit";
    public static final String NEW = "new";
    public static final String SAVE = "save";
    public static final String REFRESH = "refresh_model";
    public static final String SHOW_CONFIG = "show_config";
    private MainJFrame _mainJF;
    private final List<GUIFileActionListener> _panelList = new ArrayList<GUIFileActionListener>();
    private final XMLConfigReader _xmlReader = XMLConfigReader.getInstance();
    private final XMLConfigWriter _xmlWriter = XMLConfigWriter.getInstance();
    private ModelBuilder _mb;

    public GUIMediator() throws ConfigurableUtilException {
        this.loadModel();
        this._mainJF = new MainJFrame(this, this._mb.getGroups());
    }

    private void loadModel() throws ConfigurableUtilException {
        this._mb = ModelBuilder.getInstance();
        this._mb.refresh();
    }

    public ModelBuilder getModelBuilder() {
        return this._mb;
    }

    public void registerPanel(GUIFileActionListener c) {
        this._panelList.add(c);
    }

    public void execute() {
        this._mainJF.setSize(900, 700);
        this._mainJF.setLocationRelativeTo(null);
        this._mainJF.setVisible(true);
    }

    private void updateList(File fFile) throws GUIReaderException, GUIWriterException {
        ConfigProperties cp = this._xmlReader.read(fFile);
        this._mb.update(cp);
        if (this._panelList != null) {
            for (GUIFileActionListener listener : this._panelList) {
                listener.update(cp);
            }
        }
    }

    private void saveToFile(File fFile) throws GUIReaderException, GUIWriterException {
        ConfigProperties cp = new ConfigProperties();
        if (this.readList(cp)) {
            this._xmlWriter.writeOutput(cp, fFile);
        }
    }

    private boolean readList(ConfigProperties cp) throws GUIReaderException, GUIWriterException {
        try {
            this._mb.saveData(cp);
            if (this._panelList != null) {
                for (GUIFileActionListener listener : this._panelList) {
                    listener.saveData(cp);
                }
                return true;
            }
            return true;
        }
        catch (GUIOperationException oe) {
            return false;
        }
    }

    private void clearAll() {
        this._mb.clearAll();
        if (this._panelList != null) {
            for (GUIFileActionListener listener : this._panelList) {
                listener.clearAll();
            }
        }
    }

    private void refreshModel() throws ConfigurableUtilException {
        this._mb.modelRefresh();
        this._mb.printModel();
        this._mainJF.addTextPanels(this._mb.getGroups());
    }

    public void action(String command, File fFile) throws GUIReaderException, GUIWriterException {
        if (command.equalsIgnoreCase(OPEN)) {
            this.updateList(fFile);
        } else if (command.equalsIgnoreCase(SAVE)) {
            this.saveToFile(fFile);
        }
    }

    public void action(String command, JTextArea outputJTextArea) throws GUIWriterException, GUIReaderException {
        ConfigProperties cp = new ConfigProperties();
        if (this.readList(cp)) {
            String output = this._xmlWriter.getOutput(cp);
            outputJTextArea.setText(output);
        }
    }

    public void action(String command) throws ConfigurableUtilException {
        if (command.equalsIgnoreCase(NEW)) {
            this.clearAll();
        } else if (command.equalsIgnoreCase(REFRESH)) {
            this.refreshModel();
        }
    }
}

