/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.gui;

import edu.cmu.sphinx.util.props.RawPropertyData;
import java.util.HashMap;
import java.util.Map;

public class ConfigProperties {
    private Map<String, RawPropertyData> _propertyMap;
    private Map<String, String> _globalProperties;
    private Map<String, Map<String, Object>> _otherPropMap;

    public Map<String, String> getGlobal() {
        return this._globalProperties;
    }

    public Map<String, Map<String, Object>> getOtherProp() {
        return this._otherPropMap;
    }

    public Map<String, RawPropertyData> getProperty() {
        return this._propertyMap;
    }

    public void setGlobal(Map<String, String> global) {
        this._globalProperties = global;
    }

    public void addRPDProperties(Map<String, RawPropertyData> p) {
        if (this._propertyMap == null) {
            this._propertyMap = new HashMap<String, RawPropertyData>();
        }
        if (p != null && !p.isEmpty()) {
            this._propertyMap.putAll(p);
        }
        this.copyPropertiesToOtherMap(p);
    }

    private void copyPropertiesToOtherMap(Map<String, RawPropertyData> from) {
        if (from != null && !from.isEmpty()) {
            if (this._otherPropMap == null) {
                this._otherPropMap = new HashMap<String, Map<String, Object>>();
            }
            for (RawPropertyData rpd : from.values()) {
                Map<Object, Object> classmap;
                String classname = rpd.getClassName();
                if (this._otherPropMap.containsKey(classname)) {
                    classmap = this._otherPropMap.get(classname);
                    if (classmap.containsKey(rpd.getName())) continue;
                    classmap.put(rpd.getName(), rpd);
                    continue;
                }
                classmap = new HashMap<String, RawPropertyData>();
                classmap.put(rpd.getName(), rpd);
                this._otherPropMap.put(classname, classmap);
            }
        }
    }

    public void setProperty(Map<String, RawPropertyData> c) {
        this._propertyMap = c;
        if (this._otherPropMap == null) {
            this._otherPropMap = new HashMap<String, Map<String, Object>>();
        } else {
            this._otherPropMap.clear();
        }
        this.copyPropertiesToOtherMap(this._propertyMap);
    }
}

