/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.audio;

import edu.cmu.sphinx.tools.audio.AudioData;
import edu.cmu.sphinx.tools.audio.RawReader;
import edu.cmu.sphinx.tools.audio.RawWriter;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Utils {
    private static final short[] ulawTable = new short[]{32760, 31608, 30584, 29560, 28536, 27512, 26488, 25464, 24440, 23416, 22392, 21368, 20344, 19320, 18296, 17272, 16248, 15736, 15224, 14712, 14200, 13688, 13176, 12664, 12152, 11640, 11128, 10616, 10104, 9592, 9080, 8568, 8056, 7800, 7544, 7288, 7032, 6776, 6520, 6264, 6008, 5752, 5496, 5240, 4984, 4728, 4472, 4216, 3960, 3832, 3704, 3576, 3448, 3320, 3192, 3064, 2936, 2808, 2680, 2552, 2424, 2296, 2168, 2040, 1912, 1848, 1784, 1720, 1656, 1592, 1528, 1464, 1400, 1336, 1272, 1208, 1144, 1080, 1016, 952, 888, 856, 824, 792, 760, 728, 696, 664, 632, 600, 568, 536, 504, 472, 440, 408, 376, 360, 344, 328, 312, 296, 280, 264, 248, 232, 216, 200, 184, 168, 152, 136, 120, 112, 104, 96, 88, 80, 72, 64, 56, 48, 40, 32, 24, 16, 8, 0, -32760, -31608, -30584, -29560, -28536, -27512, -26488, -25464, -24440, -23416, -22392, -21368, -20344, -19320, -18296, -17272, -16248, -15736, -15224, -14712, -14200, -13688, -13176, -12664, -12152, -11640, -11128, -10616, -10104, -9592, -9080, -8568, -8056, -7800, -7544, -7288, -7032, -6776, -6520, -6264, -6008, -5752, -5496, -5240, -4984, -4728, -4472, -4216, -3960, -3832, -3704, -3576, -3448, -3320, -3192, -3064, -2936, -2808, -2680, -2552, -2424, -2296, -2168, -2040, -1912, -1848, -1784, -1720, -1656, -1592, -1528, -1464, -1400, -1336, -1272, -1208, -1144, -1080, -1016, -952, -888, -856, -824, -792, -760, -728, -696, -664, -632, -600, -568, -536, -504, -472, -440, -408, -376, -360, -344, -328, -312, -296, -280, -264, -248, -232, -216, -200, -184, -168, -152, -136, -120, -112, -104, -96, -88, -80, -72, -64, -56, -48, -40, -32, -24, -16, -8, 0};

    private Utils() {
    }

    public static short toShort(byte[] bytes, boolean bigEndian) {
        if (bytes.length == 1) {
            return bytes[0];
        }
        if (bigEndian) {
            return (short)(bytes[0] << 8 | 0xFF & bytes[1]);
        }
        return (short)(bytes[1] << 8 | 0xFF & bytes[0]);
    }

    public static int toUnsignedShort(byte[] bytes, boolean bigEndian) {
        if (bytes.length == 1) {
            return 0xFF & bytes[0];
        }
        if (bigEndian) {
            return (bytes[0] & 0xFF) << 8 | 0xFF & bytes[1];
        }
        return (bytes[1] & 0xFF) << 8 | 0xFF & bytes[0];
    }

    public static void toBytes(short sVal, byte[] bytes, boolean bigEndian) {
        if (bigEndian) {
            bytes[0] = (byte)(sVal >> 8);
            bytes[1] = (byte)(sVal & 0xFF);
        } else {
            bytes[0] = (byte)(sVal & 0xFF);
            bytes[1] = (byte)(sVal >> 8);
        }
    }

    public static short bytesToShort(AudioFormat format, byte[] byteArray) {
        short result = 0;
        AudioFormat.Encoding encoding = format.getEncoding();
        int frameSize = format.getFrameSize();
        if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
            result = Utils.toShort(byteArray, format.isBigEndian());
            if (frameSize == 1) {
                result = (short)(result << 8);
            }
        } else if (encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
            int tmp = Utils.toUnsignedShort(byteArray, format.isBigEndian());
            if (frameSize == 1) {
                tmp <<= 8;
            }
            result = (short)(tmp - 32768);
        } else if (encoding == AudioFormat.Encoding.ULAW) {
            result = ulawTable[byteArray[0] + 128];
        } else {
            System.out.println("Unknown encoding: " + encoding);
        }
        return result;
    }

    public static short[] toSignedPCM(AudioInputStream ais) throws IOException {
        AudioFormat aisFormat = ais.getFormat();
        short[] shorts = new short[ais.available() / aisFormat.getFrameSize()];
        byte[] frame = new byte[aisFormat.getFrameSize()];
        int pos = 0;
        while (ais.read(frame) != -1) {
            shorts[pos++] = Utils.bytesToShort(aisFormat, frame);
        }
        return shorts;
    }

    public static AudioData readAudioFile(String filename) throws IOException {
        try {
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(filename));
            AudioInputStream ais = AudioSystem.getAudioInputStream(stream);
            AudioData audioData = new AudioData(ais);
            stream.close();
            return audioData;
        }
        catch (UnsupportedAudioFileException e) {
            return null;
        }
    }

    public static AudioData readRawFile(String filename) throws IOException {
        FileInputStream stream = new FileInputStream(filename);
        AudioFormat format = new AudioFormat(16000.0f, 16, 1, true, true);
        short[] audioData = RawReader.readAudioData(stream, format);
        stream.close();
        return new AudioData(audioData, 16000.0f);
    }

    public static void writeRawFile(AudioData audio, String filename) throws IOException {
        short[] samples;
        FileOutputStream outputStream = new FileOutputStream(filename);
        AudioFormat format = new AudioFormat(16000.0f, 16, 1, true, true);
        RawWriter writer = new RawWriter(outputStream, format);
        for (short sample : samples = audio.getAudioData()) {
            writer.writeSample(sample);
        }
        outputStream.flush();
        outputStream.close();
    }
}

