/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.audio;

import edu.cmu.sphinx.frontend.Data;
import edu.cmu.sphinx.frontend.DataEndSignal;
import edu.cmu.sphinx.frontend.DoubleData;
import edu.cmu.sphinx.frontend.FrontEnd;
import edu.cmu.sphinx.frontend.util.StreamDataSource;
import edu.cmu.sphinx.tools.audio.AudioData;
import edu.cmu.sphinx.tools.audio.AudioDataInputStream;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ReplicateScaleFilter;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpectrogramPanel
extends JPanel {
    protected BufferedImage spectrogram;
    protected Image scaledSpectrogram;
    protected float zoom = 1.0f;
    protected double offsetFactor;
    protected AudioData audio;
    protected FrontEnd frontEnd;
    protected StreamDataSource dataSource;

    public SpectrogramPanel() {
    }

    public SpectrogramPanel(FrontEnd frontEnd, StreamDataSource dataSource, AudioData audioData) {
        this.audio = audioData;
        this.frontEnd = frontEnd;
        this.dataSource = dataSource;
        this.audio.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                SpectrogramPanel.this.computeSpectrogram();
            }
        });
    }

    protected void computeSpectrogram() {
        try {
            AudioDataInputStream is = new AudioDataInputStream(this.audio);
            this.dataSource.setInputStream((InputStream)is, "live audio");
            ArrayList<double[]> intensitiesList = new ArrayList<double[]>();
            double maxIntensity = Double.MIN_VALUE;
            Data spectrum = this.frontEnd.getData();
            while (!(spectrum instanceof DataEndSignal)) {
                if (spectrum instanceof DoubleData) {
                    double[] spectrumData = ((DoubleData)spectrum).getValues();
                    double[] intensities = new double[spectrumData.length];
                    for (int i = 0; i < intensities.length; ++i) {
                        intensities[i] = Math.max(Math.log(spectrumData[i]), 0.0);
                        if (!(intensities[i] > maxIntensity)) continue;
                        maxIntensity = intensities[i];
                    }
                    intensitiesList.add(intensities);
                }
                spectrum = this.frontEnd.getData();
            }
            is.close();
            int width = intensitiesList.size();
            int height = ((double[])intensitiesList.get(0)).length;
            int maxYIndex = height - 1;
            Dimension d = new Dimension(width, height);
            this.setMinimumSize(d);
            this.setMaximumSize(d);
            this.setPreferredSize(d);
            this.spectrogram = new BufferedImage(width, height, 1);
            double scaleFactor = (255.0 + this.offsetFactor) / maxIntensity;
            for (int i = 0; i < width; ++i) {
                double[] intensities = (double[])intensitiesList.get(i);
                for (int j = maxYIndex; j >= 0; --j) {
                    int grey = (int)(intensities[j] * scaleFactor - this.offsetFactor);
                    grey = Math.max(grey, 0);
                    grey = 255 - grey;
                    int pixel = grey << 16 & 0xFF0000 | grey << 8 & 0xFF00 | grey & 0xFF;
                    this.spectrogram.setRGB(i, maxYIndex - j, pixel);
                }
            }
            ReplicateScaleFilter scaleFilter = new ReplicateScaleFilter((int)(this.zoom * (float)width), height);
            this.scaledSpectrogram = this.createImage(new FilteredImageSource(this.spectrogram.getSource(), scaleFilter));
            Dimension sz = this.getSize();
            this.repaint(0L, 0, 0, sz.width - 1, sz.height - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOffsetFactor(double offsetFactor) {
        this.offsetFactor = offsetFactor;
        this.computeSpectrogram();
    }

    protected void zoomSet(float zoom) {
        this.zoom = zoom;
        if (this.spectrogram != null) {
            int width = this.spectrogram.getWidth();
            int height = this.spectrogram.getHeight();
            ReplicateScaleFilter scaleFilter = new ReplicateScaleFilter((int)(zoom * (float)width), height);
            this.scaledSpectrogram = this.createImage(new FilteredImageSource(this.spectrogram.getSource(), scaleFilter));
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics g) {
        Dimension sz = this.getSize();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, sz.width - 1, sz.height - 1);
        if (this.spectrogram != null) {
            g.drawImage(this.scaledSpectrogram, 0, 0, null);
        }
    }
}

