/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.synthesis;

import com.sun.speech.engine.EngineMonitor;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Enumeration;
import javax.speech.EngineEvent;
import javax.speech.EngineListener;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.SynthesizerEvent;
import javax.speech.synthesis.SynthesizerListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SynthesizerMonitor
extends EngineMonitor {
    protected JLabel queueEmptyLabel;
    protected JLabel queueNotEmptyLabel;
    protected JLabel queueSizeLabel;

    public SynthesizerMonitor(Synthesizer synth) {
        super(synth);
    }

    @Override
    protected EngineListener getEngineListener() {
        if (this.engineListener == null) {
            this.engineListener = new SynthesizerMonitorEngineListener();
        }
        return this.engineListener;
    }

    @Override
    public Component getStatePanel() {
        if (this.statePanel == null) {
            this.statePanel = (JPanel)super.getStatePanel();
            JPanel queueStatePanel = new JPanel();
            queueStatePanel.setBorder(BorderFactory.createTitledBorder("Synthesizer State:"));
            queueStatePanel.setLayout(new GridLayout(4, 1));
            this.queueEmptyLabel = new JLabel("QUEUE_EMPTY");
            this.queueNotEmptyLabel = new JLabel("QUEUE_NOT_EMPTY");
            this.queueSizeLabel = new JLabel("Queue Size: XXX");
            queueStatePanel.add(this.queueEmptyLabel);
            queueStatePanel.add(this.queueNotEmptyLabel);
            queueStatePanel.add(this.queueSizeLabel);
            this.statePanel.add(queueStatePanel);
        }
        return this.statePanel;
    }

    @Override
    protected void updateGUIComponents() {
        super.updateGUIComponents();
        if (this.statePanel != null) {
            this.queueEmptyLabel.setEnabled(this.engine.testEngineState(65536L));
            this.queueNotEmptyLabel.setEnabled(this.engine.testEngineState(131072L));
            Synthesizer synth = (Synthesizer)this.engine;
            int queueSize = this.countElements(synth.enumerateQueue());
            this.queueSizeLabel.setText("Queue Size: " + queueSize + "  ");
        }
    }

    private int countElements(Enumeration<?> e) {
        int count = 0;
        while (e.hasMoreElements()) {
            e.nextElement();
            ++count;
        }
        return count;
    }

    @Override
    protected String engineStateString(long state) {
        StringBuilder buf = new StringBuilder();
        this.appendBuilder(buf, super.engineStateString(state));
        if ((state & 0x10000L) != 0L) {
            this.appendBuilder(buf, "QUEUE_EMPTY");
        }
        if ((state & 0x20000L) != 0L) {
            this.appendBuilder(buf, "QUEUE_NOT_EMPTY");
        }
        return buf.toString();
    }

    @Override
    protected void handleEvent(EngineEvent e) {
        super.handleEvent(e);
    }

    class SynthesizerMonitorEngineListener
    extends EngineMonitor.EngineMonitorEngineListener
    implements SynthesizerListener {
        @Override
        public void queueEmptied(SynthesizerEvent e) {
            SynthesizerMonitor.this.handleEvent(e);
        }

        @Override
        public void queueUpdated(SynthesizerEvent e) {
            SynthesizerMonitor.this.handleEvent(e);
        }
    }
}

