/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.recognition;

import com.sun.speech.engine.recognition.BaseGrammar;
import com.sun.speech.engine.recognition.BaseRecognizer;
import com.sun.speech.engine.recognition.RuleParser;
import edu.cmu.sphinx.jsgf.JSGFGrammarException;
import edu.cmu.sphinx.jsgf.JSGFRuleGrammar;
import edu.cmu.sphinx.jsgf.parser.JSGFParser;
import edu.cmu.sphinx.jsgf.rule.JSGFRule;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleAlternatives;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleCount;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleName;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleSequence;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleTag;
import edu.cmu.sphinx.jsgf.rule.JSGFRuleToken;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.speech.recognition.FinalRuleResult;
import javax.speech.recognition.GrammarException;
import javax.speech.recognition.Recognizer;
import javax.speech.recognition.ResultToken;
import javax.speech.recognition.Rule;
import javax.speech.recognition.RuleAlternatives;
import javax.speech.recognition.RuleCount;
import javax.speech.recognition.RuleGrammar;
import javax.speech.recognition.RuleName;
import javax.speech.recognition.RuleParse;
import javax.speech.recognition.RuleSequence;
import javax.speech.recognition.RuleTag;
import javax.speech.recognition.RuleToken;

public class BaseRuleGrammar
extends BaseGrammar
implements RuleGrammar,
Serializable {
    private JSGFRuleGrammar jsgfGrammar;

    public BaseRuleGrammar(BaseRecognizer rec, JSGFRuleGrammar grammar) {
        super(rec, grammar.getName());
        assert (grammar != null);
        this.jsgfGrammar = grammar;
    }

    public BaseRuleGrammar(BaseRecognizer recognizer, String name) {
        super(recognizer, name);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.jsgfGrammar.setEnabled(enabled);
    }

    @Override
    public Rule ruleForJSGF(String text) {
        return this.convert(JSGFParser.ruleForJSGF((String)text));
    }

    public JSGFRule convert(Rule rule) {
        if (rule == null) {
            return null;
        }
        if (rule instanceof RuleName) {
            if (rule == RuleName.NULL) {
                return JSGFRuleName.NULL;
            }
            if (rule == RuleName.VOID) {
                return JSGFRuleName.NULL;
            }
            return new JSGFRuleName(((RuleName)rule).getRuleName());
        }
        if (rule instanceof RuleAlternatives) {
            RuleAlternatives ruleAlternatives = (RuleAlternatives)rule;
            ArrayList<JSGFRule> subrules = new ArrayList<JSGFRule>();
            for (Rule r : ruleAlternatives.getRules()) {
                subrules.add(this.convert(r));
            }
            ArrayList<Float> weights = null;
            if (ruleAlternatives.getWeights() != null) {
                weights = new ArrayList<Float>();
                for (float f : ruleAlternatives.getWeights()) {
                    weights.add(Float.valueOf(f));
                }
            }
            return new JSGFRuleAlternatives(subrules, weights);
        }
        if (rule instanceof RuleSequence) {
            RuleSequence ruleSequence = (RuleSequence)rule;
            ArrayList<JSGFRule> subrules = new ArrayList<JSGFRule>();
            for (Rule r : ruleSequence.getRules()) {
                subrules.add(this.convert(r));
            }
            return new JSGFRuleSequence(subrules);
        }
        if (rule instanceof RuleCount) {
            RuleCount ruleCount = (RuleCount)rule;
            return new JSGFRuleCount(this.convert(ruleCount.getRule()), ruleCount.getCount());
        }
        if (rule instanceof RuleTag) {
            RuleTag ruleTag = (RuleTag)rule;
            return new JSGFRuleTag(this.convert(ruleTag.getRule()), ruleTag.getTag());
        }
        if (rule instanceof RuleToken) {
            RuleToken ruleToken = (RuleToken)rule;
            return new JSGFRuleToken(ruleToken.getText());
        }
        System.out.println("Can't convert rule " + rule.getClass());
        return null;
    }

    private Rule convert(JSGFRule rule) {
        if (rule == null) {
            return null;
        }
        if (rule instanceof JSGFRuleName) {
            if (rule == JSGFRuleName.NULL) {
                return RuleName.NULL;
            }
            if (rule == JSGFRuleName.VOID) {
                return RuleName.NULL;
            }
            JSGFRuleName ruleName = (JSGFRuleName)rule;
            return new RuleName(ruleName.getRuleName());
        }
        if (rule instanceof JSGFRuleAlternatives) {
            JSGFRuleAlternatives ruleAlternatives = (JSGFRuleAlternatives)rule;
            Rule[] subrules = new Rule[ruleAlternatives.getRules().size()];
            int i = 0;
            for (JSGFRule subrule : ruleAlternatives.getRules()) {
                subrules[i] = this.convert(subrule);
                ++i;
            }
            float[] weights = null;
            if (ruleAlternatives.getWeights() != null) {
                weights = new float[ruleAlternatives.getWeights().size()];
                i = 0;
                for (Float f : ruleAlternatives.getWeights()) {
                    weights[i] = f.floatValue();
                    ++i;
                }
            }
            return new RuleAlternatives(subrules, weights);
        }
        if (rule instanceof JSGFRuleSequence) {
            JSGFRuleSequence ruleSequence = (JSGFRuleSequence)rule;
            Rule[] subrules = new Rule[ruleSequence.getRules().size()];
            int i = 0;
            for (JSGFRule subrule : ruleSequence.getRules()) {
                subrules[i] = this.convert(subrule);
                ++i;
            }
            return new RuleSequence(subrules);
        }
        if (rule instanceof JSGFRuleCount) {
            JSGFRuleCount ruleCount = (JSGFRuleCount)rule;
            return new RuleCount(this.convert(ruleCount.getRule()), ruleCount.getCount());
        }
        if (rule instanceof JSGFRuleTag) {
            JSGFRuleTag ruleTag = (JSGFRuleTag)rule;
            return new RuleTag(this.convert(ruleTag.getRule()), ruleTag.getTag());
        }
        if (rule instanceof JSGFRuleToken) {
            JSGFRuleToken ruleToken = (JSGFRuleToken)rule;
            return new RuleToken(ruleToken.getText());
        }
        System.out.println("Unknown rule type " + rule.getClass());
        return null;
    }

    @Override
    public void setRule(String ruleName, Rule rule, boolean isPublic) throws NullPointerException, IllegalArgumentException {
        this.jsgfGrammar.setRule(ruleName, this.convert(rule), isPublic);
        this.grammarChanged = true;
    }

    @Override
    public Rule getRule(String ruleName) {
        return this.convert(this.jsgfGrammar.getRule(ruleName));
    }

    @Override
    public Rule getRuleInternal(String ruleName) {
        return this.convert(this.jsgfGrammar.getRule(ruleName));
    }

    @Override
    public boolean isRulePublic(String ruleName) throws IllegalArgumentException {
        return this.jsgfGrammar.isRulePublic(ruleName);
    }

    @Override
    public String[] listRuleNames() {
        Set names = this.jsgfGrammar.getRuleNames();
        return names.toArray(new String[names.size()]);
    }

    @Override
    public void deleteRule(String ruleName) throws IllegalArgumentException {
        this.jsgfGrammar.deleteRule(ruleName);
        this.grammarChanged = true;
    }

    @Override
    public void setEnabled(String ruleName, boolean enabled) throws IllegalArgumentException {
        this.jsgfGrammar.setEnabled(enabled);
    }

    @Override
    public void setEnabled(String[] ruleNames, boolean enabled) throws IllegalArgumentException {
        for (String ruleName : ruleNames) {
            this.setEnabled(ruleName, enabled);
        }
    }

    @Override
    public boolean isEnabled(String ruleName) throws IllegalArgumentException {
        return this.jsgfGrammar.isEnabled(ruleName);
    }

    @Override
    public RuleName resolve(RuleName ruleName) throws GrammarException {
        JSGFRuleName jsgfRuleName = (JSGFRuleName)this.convert(ruleName);
        try {
            return (RuleName)this.convert((JSGFRule)this.jsgfGrammar.resolve(jsgfRuleName));
        }
        catch (JSGFGrammarException e) {
            throw new GrammarException(e.getMessage());
        }
    }

    @Override
    public void addImport(RuleName importName) {
        this.jsgfGrammar.addImport((JSGFRuleName)this.convert(importName));
        this.grammarChanged = true;
    }

    @Override
    public void removeImport(RuleName importName) throws IllegalArgumentException {
        this.jsgfGrammar.addImport((JSGFRuleName)this.convert(importName));
        this.grammarChanged = true;
    }

    @Override
    public RuleName[] listImports() {
        assert (this.jsgfGrammar != null);
        List imports = this.jsgfGrammar.getImports();
        RuleName[] result = new RuleName[imports.size()];
        for (int i = 0; i < imports.size(); ++i) {
            result[i] = (RuleName)this.convert((JSGFRule)imports.get(i));
        }
        return result;
    }

    @Override
    public RuleParse parse(String text, String ruleName) throws GrammarException {
        return RuleParser.parse(text, (Recognizer)this.recognizer, (RuleGrammar)this, ruleName == null ? ruleName : JSGFRuleName.stripRuleName((String)ruleName));
    }

    @Override
    public RuleParse parse(String[] tokens, String ruleName) throws GrammarException {
        return RuleParser.parse(tokens, (Recognizer)this.recognizer, (RuleGrammar)this, ruleName == null ? ruleName : JSGFRuleName.stripRuleName((String)ruleName));
    }

    @Override
    public RuleParse parse(FinalRuleResult r, int nBest, String ruleName) throws GrammarException {
        ResultToken[] rt = r.getAlternativeTokens(nBest);
        if (rt != null || (rt = r.getBestTokens()) != null) {
            String[] tokens = new String[rt.length];
            for (int i = 0; i < rt.length; ++i) {
                tokens[i] = rt[i].getSpokenText();
            }
            return this.parse(tokens, ruleName);
        }
        return this.parse(r.toString(), ruleName);
    }

    @Override
    public String toString() {
        return this.jsgfGrammar.toString();
    }

    public void addRuleDocComment(String rname, String comment) {
        this.jsgfGrammar.addRuleDocComment(rname, comment);
    }

    public String getRuleDocComment(String rname) {
        return this.jsgfGrammar.getRuleDocComment(rname);
    }

    public void addImportDocComment(RuleName imp, String comment) {
        this.jsgfGrammar.addImportDocComment((JSGFRuleName)this.convert(imp), comment);
    }

    public String getImportDocComment(RuleName imp) {
        return this.jsgfGrammar.getImportDocComment((JSGFRuleName)this.convert(imp));
    }

    public void addGrammarDocComment(String comment) {
        this.jsgfGrammar.addGrammarDocComment(comment);
    }

    public String getGrammarDocComment() {
        return this.jsgfGrammar.getGrammarDocComment();
    }

    public boolean isRuleChanged(String ruleName) {
        return this.jsgfGrammar.isRuleChanged(ruleName);
    }

    public void setRuleChanged(String ruleName, boolean changed) {
        this.jsgfGrammar.setRuleChanged(ruleName, changed);
    }
}

