/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine.recognition;

import com.sun.speech.engine.SpeechEventDispatcher;
import com.sun.speech.engine.SpeechEventUtilities;
import java.applet.AudioClip;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.speech.EngineStateError;
import javax.speech.SpeechEvent;
import javax.speech.recognition.DictationGrammar;
import javax.speech.recognition.FinalDictationResult;
import javax.speech.recognition.FinalResult;
import javax.speech.recognition.FinalRuleResult;
import javax.speech.recognition.Grammar;
import javax.speech.recognition.GrammarException;
import javax.speech.recognition.Result;
import javax.speech.recognition.ResultEvent;
import javax.speech.recognition.ResultListener;
import javax.speech.recognition.ResultStateError;
import javax.speech.recognition.ResultToken;
import javax.speech.recognition.RuleGrammar;
import javax.speech.recognition.RuleParse;

public class BaseResult
implements Result,
FinalResult,
FinalRuleResult,
FinalDictationResult,
Serializable,
Cloneable,
SpeechEventDispatcher {
    private final List<ResultListener> resultListeners = new ArrayList<ResultListener>();
    String[] theText;
    int nTokens;
    transient Grammar grammar;
    int state = 300;
    String[] tags;
    String ruleName;

    public BaseResult() {
        this(null);
    }

    public BaseResult(Grammar g) {
        this(g, null);
    }

    public BaseResult(Grammar gram, String str) {
        this.grammar = gram;
        this.tryTokens(gram, str);
    }

    static BaseResult copyResult(Result result) {
        BaseResult copy = null;
        if (result instanceof BaseResult) {
            try {
                copy = (BaseResult)((BaseResult)result).clone();
            }
            catch (CloneNotSupportedException e) {
                System.out.println("ERROR: " + e);
            }
            return copy;
        }
        copy = new BaseResult(result.getGrammar());
        copy.nTokens = result.numTokens();
        copy.theText = new String[copy.nTokens];
        for (int i = 0; i < result.numTokens(); ++i) {
            copy.theText[i] = result.getBestToken(i).getSpokenText();
        }
        return copy;
    }

    @Override
    public int getResultState() {
        return this.state;
    }

    @Override
    public Grammar getGrammar() {
        return this.grammar;
    }

    @Override
    public int numTokens() {
        return this.nTokens;
    }

    @Override
    public ResultToken getBestToken(int nth) throws IllegalArgumentException {
        if (nth < 0 || nth > this.nTokens - 1) {
            throw new IllegalArgumentException("Token index out of range.");
        }
        return new BaseResultToken(this.theText[nth]);
    }

    @Override
    public ResultToken[] getBestTokens() {
        ResultToken[] bt = new ResultToken[this.nTokens];
        for (int i = 0; i < this.nTokens; ++i) {
            bt[i] = this.getBestToken(i);
        }
        return bt;
    }

    @Override
    public ResultToken[] getUnfinalizedTokens() {
        return new ResultToken[0];
    }

    @Override
    public void addResultListener(ResultListener listener) {
        if (!this.resultListeners.contains(listener)) {
            this.resultListeners.add(listener);
        }
    }

    @Override
    public void removeResultListener(ResultListener listener) {
        this.resultListeners.remove(listener);
    }

    @Override
    public boolean isTrainingInfoAvailable() throws ResultStateError {
        this.checkResultState(300);
        return false;
    }

    @Override
    public void releaseTrainingInfo() throws ResultStateError {
        this.checkResultState(300);
    }

    @Override
    public void tokenCorrection(String[] correctTokens, ResultToken fromToken, ResultToken toToken, int correctionType) throws ResultStateError, IllegalArgumentException {
        this.checkResultState(300);
    }

    @Override
    public boolean isAudioAvailable() throws ResultStateError {
        this.checkResultState(300);
        return false;
    }

    @Override
    public void releaseAudio() throws ResultStateError {
        this.checkResultState(300);
    }

    @Override
    public AudioClip getAudio() throws ResultStateError {
        this.checkResultState(300);
        return null;
    }

    @Override
    public AudioClip getAudio(ResultToken from, ResultToken to) throws ResultStateError {
        this.checkResultState(300);
        return null;
    }

    @Override
    public int getNumberGuesses() throws ResultStateError {
        this.checkResultState(300);
        if (!(this.grammar instanceof RuleGrammar)) {
            throw new ResultStateError("Result is not a FinalRuleResult");
        }
        return 1;
    }

    @Override
    public ResultToken[] getAlternativeTokens(int nBest) throws ResultStateError {
        this.checkResultState(300);
        if (!(this.grammar instanceof RuleGrammar)) {
            throw new ResultStateError("Result is not a FinalRuleResult");
        }
        if (nBest == 0) {
            return this.getBestTokens();
        }
        return null;
    }

    @Override
    public RuleGrammar getRuleGrammar(int nBest) throws ResultStateError {
        this.checkResultState(300);
        if (!(this.grammar instanceof RuleGrammar)) {
            throw new ResultStateError("Result is not a FinalRuleResult");
        }
        if (nBest == 0) {
            return (RuleGrammar)this.grammar;
        }
        return null;
    }

    @Override
    public String getRuleName(int nBest) throws ResultStateError {
        this.checkResultState(300);
        if (!(this.grammar instanceof RuleGrammar)) {
            throw new ResultStateError("Result is not a FinalRuleResult");
        }
        if (nBest == 0) {
            return this.ruleName;
        }
        return null;
    }

    @Override
    public String[] getTags() throws ResultStateError {
        this.checkResultState(300);
        if (!(this.grammar instanceof RuleGrammar)) {
            throw new ResultStateError("Result is not a FinalRuleResult");
        }
        return this.tags;
    }

    @Override
    public ResultToken[][] getAlternativeTokens(ResultToken from, ResultToken to, int max) throws ResultStateError, IllegalArgumentException {
        this.checkResultState(300);
        if (!(this.grammar instanceof DictationGrammar)) {
            throw new ResultStateError("Result is not a FinalDicationResult");
        }
        return null;
    }

    public void postAudioReleased() {
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(this, 806));
    }

    public void fireAudioReleased(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.audioReleased(event);
        }
    }

    public void postGrammarFinalized() {
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(this, 803));
    }

    public void fireGrammarFinalized(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.grammarFinalized(event);
        }
    }

    public void postResultAccepted() {
        this.setResultState(301);
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(this, 804));
    }

    public void fireResultAccepted(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.resultAccepted(event);
        }
    }

    public void postResultCreated() {
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(this, 801));
    }

    public void fireResultCreated(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.resultCreated(event);
        }
    }

    public void postResultRejected() {
        this.setResultState(302);
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(this, 805));
    }

    public void fireResultRejected(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.resultRejected(event);
        }
    }

    public void postResultUpdated() {
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(this, 802));
    }

    public void fireResultUpdated(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.resultUpdated(event);
        }
    }

    public void postTrainingInfoReleased() {
        SpeechEventUtilities.postSpeechEvent(this, new ResultEvent(this, 807));
    }

    public void fireTrainingInfoReleased(ResultEvent event) {
        for (ResultListener rl : this.resultListeners) {
            rl.trainingInfoReleased(event);
        }
    }

    public String toString() {
        if (this.numTokens() == 0) {
            return "<nothing>";
        }
        StringBuilder sb = new StringBuilder(this.getBestToken(0).getWrittenText());
        for (int i = 1; i < this.numTokens(); ++i) {
            sb.append(' ').append(this.getBestToken(i).getWrittenText());
        }
        return sb.toString();
    }

    public void setResultState(int state) {
        this.state = state;
    }

    protected void checkResultState(int state) throws ResultStateError {
        if (this.getResultState() == state) {
            throw new EngineStateError("Invalid ResultState: " + this.getResultState());
        }
    }

    @Override
    public void dispatchSpeechEvent(SpeechEvent event) {
        switch (event.getId()) {
            case 806: {
                this.fireAudioReleased((ResultEvent)event);
                break;
            }
            case 803: {
                this.fireGrammarFinalized((ResultEvent)event);
                break;
            }
            case 804: {
                this.fireResultAccepted((ResultEvent)event);
                break;
            }
            case 801: {
                this.fireResultCreated((ResultEvent)event);
                break;
            }
            case 805: {
                this.fireResultRejected((ResultEvent)event);
                break;
            }
            case 802: {
                this.fireResultUpdated((ResultEvent)event);
                break;
            }
            case 807: {
                this.fireTrainingInfoReleased((ResultEvent)event);
            }
        }
    }

    public void setGrammar(Grammar g) {
        this.grammar = g;
    }

    public boolean tryTokens(Grammar g, String str) {
        if (str == null || g == null) {
            return false;
        }
        if (g instanceof RuleGrammar) {
            try {
                RuleParse rp = ((RuleGrammar)g).parse(str, null);
                if (rp != null) {
                    this.grammar = g;
                    this.tags = rp.getTags();
                    this.ruleName = rp.getRuleName().getSimpleRuleName();
                    StringTokenizer st = new StringTokenizer(str);
                    this.nTokens = st.countTokens();
                    int i = 0;
                    this.theText = new String[this.nTokens];
                    while (st.hasMoreTokens()) {
                        this.theText[i++] = st.nextToken();
                    }
                    return true;
                }
            }
            catch (GrammarException grammarException) {
                // empty catch block
            }
        }
        return false;
    }

    protected class BaseResultToken
    implements ResultToken {
        String token;

        BaseResultToken(String t) {
            this.token = t;
        }

        @Override
        public Result getResult() {
            return null;
        }

        public int getAttachmentHint() {
            return 0;
        }

        @Override
        public int getCapitalizationHint() {
            return 0;
        }

        @Override
        public String getWrittenText() {
            return this.token;
        }

        @Override
        public String getSpokenText() {
            return this.token;
        }

        @Override
        public long getStartTime() {
            return 0L;
        }

        @Override
        public long getEndTime() {
            return 0L;
        }

        @Override
        public int getSpacingHint() {
            return 0;
        }
    }
}

