/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.engine;

import com.sun.speech.engine.EngineEventPanel;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Date;
import javax.speech.Engine;
import javax.speech.EngineErrorEvent;
import javax.speech.EngineEvent;
import javax.speech.EngineListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EngineMonitor {
    protected Engine engine;
    protected EngineListener engineListener;
    protected EngineEventPanel eventPanel;
    protected JPanel statePanel;
    protected JLabel deallocatedLabel;
    protected JLabel allocatingResourcesLabel;
    protected JLabel allocatedLabel;
    protected JLabel deallocatingResourcesLabel;
    protected JLabel pausedLabel;
    protected JLabel resumedLabel;

    public EngineMonitor(Engine eng) {
        this.engine = eng;
        this.engine.addEngineListener(this.getEngineListener());
    }

    protected EngineListener getEngineListener() {
        if (this.engineListener == null) {
            this.engineListener = new EngineMonitorEngineListener();
        }
        return this.engineListener;
    }

    public Component getEventPanel() {
        if (this.eventPanel == null) {
            this.eventPanel = new EngineEventPanel();
        }
        return this.eventPanel;
    }

    public Component getStatePanel() {
        if (this.statePanel == null) {
            JPanel newStatePanel = new JPanel();
            newStatePanel.setLayout(new GridLayout(1, 2));
            JPanel engineStatePanel = new JPanel();
            engineStatePanel.setLayout(new GridLayout(4, 2));
            engineStatePanel.setBorder(BorderFactory.createTitledBorder("Engine State:"));
            this.deallocatedLabel = new JLabel("DEALLOCATED");
            this.allocatingResourcesLabel = new JLabel("ALLOCATING_RESOURCES");
            this.allocatedLabel = new JLabel("ALLOCATED");
            this.deallocatingResourcesLabel = new JLabel("DEALLOCATING_RESOURCES");
            this.pausedLabel = new JLabel("PAUSED");
            this.resumedLabel = new JLabel("RESUMED");
            engineStatePanel.add(this.deallocatedLabel);
            engineStatePanel.add(this.pausedLabel);
            engineStatePanel.add(this.allocatedLabel);
            engineStatePanel.add(this.resumedLabel);
            engineStatePanel.add(this.deallocatingResourcesLabel);
            engineStatePanel.add(new JLabel(""));
            engineStatePanel.add(this.allocatingResourcesLabel);
            newStatePanel.add(engineStatePanel);
            this.statePanel = newStatePanel;
        }
        return this.statePanel;
    }

    protected void handleEvent(EngineEvent e) {
        if (this.eventPanel != null) {
            this.eventPanel.addText(new Date() + ": " + e + '\n');
            this.eventPanel.addText("   Old state: " + this.engineStateString(e.getOldEngineState()) + '\n');
            this.eventPanel.addText("   New state: " + this.engineStateString(e.getNewEngineState()) + '\n');
        }
        this.updateGUIComponents();
    }

    protected void updateGUIComponents() {
        this.updateEngineStateComponents();
    }

    protected void updateEngineStateComponents() {
        if (this.statePanel != null) {
            this.deallocatedLabel.setEnabled(this.engine.testEngineState(1L));
            this.allocatingResourcesLabel.setEnabled(this.engine.testEngineState(2L));
            this.allocatedLabel.setEnabled(this.engine.testEngineState(4L));
            this.deallocatingResourcesLabel.setEnabled(this.engine.testEngineState(8L));
            this.pausedLabel.setEnabled(this.engine.testEngineState(256L));
            this.resumedLabel.setEnabled(this.engine.testEngineState(512L));
        }
    }

    protected String engineStateString(long state) {
        StringBuilder sb = new StringBuilder();
        if ((state & 1L) != 0L) {
            this.appendBuilder(sb, "DEALLOCATED");
        }
        if ((state & 2L) != 0L) {
            this.appendBuilder(sb, "ALLOCATING_RESOURCES");
        }
        if ((state & 4L) != 0L) {
            this.appendBuilder(sb, "ALLOCATED");
        }
        if ((state & 8L) != 0L) {
            this.appendBuilder(sb, "DEALLOCATING_RESOURCES");
        }
        if ((state & 0x100L) != 0L) {
            this.appendBuilder(sb, "PAUSED");
        }
        if ((state & 0x200L) != 0L) {
            this.appendBuilder(sb, "RESUMED");
        }
        return sb.toString();
    }

    protected void appendBuilder(StringBuilder b, String s) {
        if (b.length() > 0) {
            b.append(':');
        }
        b.append(s);
    }

    protected class EngineMonitorEngineListener
    implements EngineListener {
        @Override
        public void enginePaused(EngineEvent e) {
            EngineMonitor.this.handleEvent(e);
        }

        @Override
        public void engineResumed(EngineEvent e) {
            EngineMonitor.this.handleEvent(e);
        }

        @Override
        public void engineAllocated(EngineEvent e) {
            EngineMonitor.this.handleEvent(e);
        }

        @Override
        public void engineDeallocated(EngineEvent e) {
            EngineMonitor.this.handleEvent(e);
        }

        @Override
        public void engineAllocatingResources(EngineEvent e) {
            EngineMonitor.this.handleEvent(e);
        }

        @Override
        public void engineDeallocatingResources(EngineEvent e) {
            EngineMonitor.this.handleEvent(e);
        }

        @Override
        public void engineError(EngineErrorEvent e) {
            EngineMonitor.this.handleEvent(e);
        }
    }
}

