/*
 * Decompiled with CFR 0.152.
 */
package webcam;

import java.awt.image.BufferedImage;
import webcam.WebCamException;

public class WebCam {
    protected int width;
    protected int height;
    protected int[] rgba;

    public native void initialize() throws WebCamException;

    public native void uninitialize();

    public void openCamera(int n, int n2) throws WebCamException {
        this.width = n;
        this.height = n2;
        this.rgba = new int[n * n2];
        this.NopenCamera(n, n2);
    }

    private native void NopenCamera(int var1, int var2) throws WebCamException;

    public native void closeCamera();

    public native void capture(String var1) throws WebCamException;

    public native void captureFrame() throws WebCamException;

    public native boolean isCameraOpen();

    public int getFrameWidth() {
        return this.width;
    }

    public int getFrameHeight() {
        return this.height;
    }

    public BufferedImage getFrameImage() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        bufferedImage.setRGB(0, 0, this.width, this.height, this.rgba, 0, this.width);
        return bufferedImage;
    }

    public int[] getFrameData() {
        return this.rgba;
    }

    private void callback(byte[] byArray) {
        int n = 0;
        if (byArray.length != this.rgba.length * 3) {
            return;
        }
        for (int i = 0; i < this.height; ++i) {
            int n2 = (this.height - i - 1) * this.width;
            for (int j = 0; j < this.width; ++j) {
                int n3;
                this.rgba[n2] = n3 = 0xFF000000 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
                ++n2;
                n += 3;
            }
        }
    }

    static {
        System.loadLibrary("JavaWebCam");
    }
}

