/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import topcodes.Scanner;
import topcodes.TopCode;
import webcam.WebCam;
import webcam.WebCamException;

public class WebCamSample
extends JPanel
implements ActionListener,
WindowListener {
    protected JFrame frame = new JFrame("TopCodes Webcam Sample");
    protected WebCam webcam = new WebCam();
    protected Scanner scanner = new Scanner();
    protected Timer animator = new Timer(100, this);

    public WebCamSample() {
        super(true);
        this.setOpaque(true);
        this.setPreferredSize(new Dimension(640, 480));
        this.frame.setDefaultCloseOperation(0);
        this.frame.setContentPane(this);
        this.frame.addWindowListener(this);
        this.frame.pack();
        this.frame.setVisible(true);
        try {
            this.webcam.initialize();
            this.webcam.openCamera(640, 480);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.requestFocusInWindow();
        this.animator.start();
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        List<TopCode> list = null;
        try {
            if (this.webcam.isCameraOpen()) {
                this.webcam.captureFrame();
                list = this.scanner.scan(this.webcam.getFrameData(), this.webcam.getFrameWidth(), this.webcam.getFrameHeight());
            }
        }
        catch (WebCamException webCamException) {
            System.err.println(webCamException);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setFont(new Font(null, 0, 12));
        BufferedImage bufferedImage = this.scanner.getImage();
        if (bufferedImage != null) {
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        }
        if (list != null) {
            for (TopCode topCode : list) {
                topCode.draw(graphics2D);
                String string = String.valueOf(topCode.getCode());
                int n = (int)topCode.getDiameter();
                int n2 = (int)topCode.getCenterX();
                int n3 = (int)topCode.getCenterY();
                int n4 = graphics2D.getFontMetrics().stringWidth(string);
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillRect(n2 - n4 / 2 - 3, n3 + n / 2 + 6, n4 + 6, 12);
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawString(string, n2 - n4 / 2, n3 + n / 2 + 16);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.animator) {
            this.repaint();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.webcam.closeCamera();
        this.webcam.uninitialize();
        this.frame.setVisible(false);
        this.frame.dispose();
        System.exit(0);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public static void main(String[] stringArray) {
        System.setProperty("sun.java2d.noddraw", "");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new WebCamSample();
            }
        });
    }
}

