/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.chatterbotapi;

import com.google.code.chatterbotapi.ChatterBot;
import com.google.code.chatterbotapi.ChatterBotSession;
import com.google.code.chatterbotapi.ChatterBotThought;
import com.google.code.chatterbotapi.Utils;
import java.rmi.server.UID;
import java.util.LinkedHashMap;
import java.util.Map;

class Pandorabots
implements ChatterBot {
    private final String botid;

    public Pandorabots(String botid) {
        this.botid = botid;
    }

    @Override
    public ChatterBotSession createSession() {
        return new Session();
    }

    private class Session
    implements ChatterBotSession {
        private final Map<String, String> vars = new LinkedHashMap<String, String>();

        public Session() {
            this.vars.put("botid", Pandorabots.this.botid);
            this.vars.put("custid", new UID().toString());
        }

        @Override
        public ChatterBotThought think(ChatterBotThought thought) throws Exception {
            this.vars.put("input", thought.getText());
            String response = Utils.post("http://www.pandorabots.com/pandora/talk-xml", this.vars);
            ChatterBotThought responseThought = new ChatterBotThought();
            responseThought.setText(Utils.xPathSearch(response, "//result/that/text()"));
            return responseThought;
        }

        @Override
        public String think(String text) throws Exception {
            ChatterBotThought thought = new ChatterBotThought();
            thought.setText(text);
            return this.think(thought).getText();
        }
    }
}

