/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.resources;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.saintandreas.resources.Resource;
import org.saintandreas.resources.ResourceProvider;

public abstract class InputStreamResourceProvider
implements ResourceProvider {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getAsString(Resource r) {
        try (InputStream is = this.getAsInputStream(r);){
            String string = new String(ByteStreams.toByteArray((InputStream)is), Charsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ByteBuffer getAsByteBuffer(Resource r) {
        try (InputStream is = this.getAsInputStream(r);){
            ByteBuffer byteBuffer = ByteBuffer.wrap(ByteStreams.toByteArray((InputStream)is));
            return byteBuffer;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

