/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.resources;

import com.google.common.io.Resources;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.saintandreas.resources.Resource;
import org.saintandreas.resources.ResourceManager;

public class Images {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage load(Resource r) {
        try (InputStream is = ResourceManager.getAsInputStream(r);){
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load resource as texture: " + r.getPath(), e);
        }
    }

    public static BufferedImage load(String resource) {
        return Images.load(Resources.getResource((String)resource));
    }

    public static BufferedImage load(URL url) {
        try {
            return ImageIO.read(url);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load resource as texture: " + url.toString(), e);
        }
    }
}

