/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.math;

import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import marytts.util.math.ArrayUtils;
import marytts.util.math.ComplexArray;
import marytts.util.math.ComplexNumber;
import marytts.util.string.StringUtils;

public class MathUtils {
    public static final double TINY_PROBABILITY = 1.0E-50;
    public static final double TINY_PROBABILITY_LOG = Math.log(1.0E-50);
    public static final double TINY = 1.0E-50;
    public static final double TINY_LOG = Math.log(1.0E-50);
    protected static final double PASCAL = 2.0E-5;
    protected static final double PASCALSQUARE = 4.0E-10;
    protected static final double LOG10 = Math.log(10.0);
    public static final double TWOPI = Math.PI * 2;
    public static final int EQUALS = 0;
    public static final int GREATER_THAN = 1;
    public static final int GREATER_THAN_OR_EQUALS = 2;
    public static final int LESS_THAN = 3;
    public static final int LESS_THAN_OR_EQUALS = 4;
    public static final int NOT_EQUALS = 5;

    public static boolean isPowerOfTwo(int N) {
        int maxBits = 32;
        int n = 2;
        for (int i = 2; i <= 32; ++i) {
            if (n == N) {
                return true;
            }
            n <<= 1;
        }
        return false;
    }

    public static int closestPowerOfTwoAbove(int N) {
        return 1 << (int)Math.ceil(Math.log(N) / Math.log(2.0));
    }

    public static int findNextValleyLocation(double[] data, int startIndex) {
        for (int i = startIndex + 1; i < data.length; ++i) {
            if (!(data[i - 1] < data[i])) continue;
            return i - 1;
        }
        return data.length - 1;
    }

    public static int findNextPeakLocation(double[] data, int startIndex) {
        for (int i = startIndex + 1; i < data.length; ++i) {
            if (!(data[i - 1] > data[i])) continue;
            return i - 1;
        }
        return data.length - 1;
    }

    public static int findGlobalPeakLocation(double[] data) {
        double max = Double.NaN;
        int imax = -1;
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i]) || !Double.isNaN(max) && !(data[i] > max)) continue;
            max = data[i];
            imax = i;
        }
        return imax;
    }

    public static int findGlobalPeakLocation(float[] data) {
        float max = Float.NaN;
        int imax = -1;
        for (int i = 0; i < data.length; ++i) {
            if (Float.isNaN(data[i]) || !Float.isNaN(max) && !(data[i] > max)) continue;
            max = data[i];
            imax = i;
        }
        return imax;
    }

    public static int findGlobalValleyLocation(double[] data) {
        double min = Double.NaN;
        int imin = -1;
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i]) || !Double.isNaN(min) && !(data[i] < min)) continue;
            min = data[i];
            imin = i;
        }
        return imin;
    }

    public static int findGlobalValleyLocation(float[] data) {
        float min = Float.NaN;
        int imin = -1;
        for (int i = 0; i < data.length; ++i) {
            if (Float.isNaN(data[i]) || !Float.isNaN(min) && !(data[i] < min)) continue;
            min = data[i];
            imin = i;
        }
        return imin;
    }

    public static double sum(double[] data) {
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i])) continue;
            sum += data[i];
        }
        return sum;
    }

    public static float sum(float[] data) {
        float sum = 0.0f;
        for (int i = 0; i < data.length; ++i) {
            if (Float.isNaN(data[i])) continue;
            sum += data[i];
        }
        return sum;
    }

    public static int sum(int[] data) {
        int sum = 0;
        for (int i = 0; i < data.length; ++i) {
            sum += data[i];
        }
        return sum;
    }

    public static double sumSquared(double[] data) {
        return MathUtils.sumSquared(data, 0.0);
    }

    public static double sumSquared(double[] data, double term) {
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i])) continue;
            sum += (data[i] + term) * (data[i] + term);
        }
        return sum;
    }

    public static double sumSquared(double[] data, int startInd, int endInd) {
        return MathUtils.sumSquared(data, startInd, endInd, 0.0);
    }

    public static double sumSquared(double[] data, int startInd, int endInd, double term) {
        double sum = 0.0;
        for (int i = startInd; i <= endInd; ++i) {
            sum += (data[i] + term) * (data[i] + term);
        }
        return sum;
    }

    public static double max(double[] data) {
        double max = Double.NaN;
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i]) || !Double.isNaN(max) && !(data[i] > max)) continue;
            max = data[i];
        }
        return max;
    }

    public static int max(int[] data) {
        int max = data[0];
        for (int i = 1; i < data.length; ++i) {
            if (data[i] <= max) continue;
            max = data[i];
        }
        return max;
    }

    public static double absMax(double[] data) {
        return MathUtils.absMax(data, 0, data.length);
    }

    public static double absMax(double[] data, int off, int len) {
        double max = Double.NaN;
        for (int i = off; i < off + len; ++i) {
            if (Double.isNaN(data[i])) continue;
            double abs = Math.abs(data[i]);
            if (!Double.isNaN(max) && !(abs > max)) continue;
            max = abs;
        }
        return max;
    }

    public static double min(double[] data) {
        double min = Double.NaN;
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i]) || !Double.isNaN(min) && !(data[i] < min)) continue;
            min = data[i];
        }
        return min;
    }

    public static int min(int[] data) {
        int min = data[0];
        for (int i = 1; i < data.length; ++i) {
            if (data[i] >= min) continue;
            min = data[i];
        }
        return min;
    }

    public static double mean(double[] data) {
        return MathUtils.mean(data, 0, data.length - 1);
    }

    public static double mean(double[] data, int startIndex, int endIndex) {
        double mean = 0.0;
        int total = 0;
        startIndex = Math.max(startIndex, 0);
        startIndex = Math.min(startIndex, data.length - 1);
        endIndex = Math.max(endIndex, 0);
        if (startIndex > (endIndex = Math.min(endIndex, data.length - 1))) {
            startIndex = endIndex;
        }
        for (int i = startIndex; i <= endIndex; ++i) {
            if (Double.isNaN(data[i])) {
                throw new IllegalArgumentException("NaN not allowed in mean calculation");
            }
            mean += data[i];
            ++total;
        }
        return mean /= (double)total;
    }

    public static double mean(double[] data, int[] inds) {
        double mean = 0.0;
        for (int i = 0; i < inds.length; ++i) {
            if (Double.isNaN(data[inds[i]])) {
                throw new IllegalArgumentException("NaN not allowed in mean calculation");
            }
            mean += data[inds[i]];
        }
        return mean /= (double)inds.length;
    }

    public static float mean(float[] data, int startIndex, int endIndex) {
        float mean = 0.0f;
        int total = 0;
        startIndex = Math.max(startIndex, 0);
        startIndex = Math.min(startIndex, data.length - 1);
        endIndex = Math.max(endIndex, 0);
        if (startIndex > (endIndex = Math.min(endIndex, data.length - 1))) {
            startIndex = endIndex;
        }
        for (int i = startIndex; i <= endIndex; ++i) {
            if (Float.isNaN(data[i])) {
                throw new IllegalArgumentException("NaN not allowed in mean calculation");
            }
            mean += data[i];
            ++total;
        }
        return mean /= (float)total;
    }

    public static float mean(float[] data) {
        return MathUtils.mean(data, 0, data.length - 1);
    }

    public static float mean(float[] data, int[] inds) {
        float mean = 0.0f;
        for (int i = 0; i < inds.length; ++i) {
            if (Float.isNaN(data[inds[i]])) {
                throw new IllegalArgumentException("NaN not allowed in mean calculation");
            }
            mean += data[inds[i]];
        }
        return mean /= (float)inds.length;
    }

    public static double mean(double[] data, int opt) {
        if (opt == 0) {
            int numData = 0;
            double mean = 0.0;
            for (int i = 0; i < data.length; ++i) {
                if (Double.isNaN(data[i])) continue;
                mean += data[i];
                ++numData;
            }
            return mean /= (double)numData;
        }
        int numData = 0;
        double mean = 0.0;
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i])) continue;
            mean += Math.log(data[i]);
            ++numData;
        }
        return Math.exp(mean /= (double)numData);
    }

    public static double standardDeviation(double[] data) {
        return MathUtils.standardDeviation(data, MathUtils.mean(data));
    }

    public static double standardDeviation(double[] data, double meanVal) {
        return MathUtils.standardDeviation(data, meanVal, 0, data.length - 1);
    }

    public static double standardDeviation(double[] data, double meanVal, int startIndex, int endIndex) {
        return Math.sqrt(MathUtils.variance(data, meanVal, startIndex, endIndex));
    }

    public static double standardDeviation(double[] data, int opt) {
        if (opt == 0) {
            return Math.sqrt(MathUtils.variance(data, opt));
        }
        return Math.sqrt(MathUtils.variance(data, opt));
    }

    public static double variance(double[] data, int opt) {
        double mean = 0.0;
        double S = 0.0;
        double numData = 0.0;
        for (int i = 0; i < data.length; ++i) {
            if (Double.isNaN(data[i])) continue;
            double delta = data[i] - mean;
            S += delta * (data[i] - (mean += delta / (numData + 1.0)));
            numData += 1.0;
        }
        if (opt == 0) {
            return S / (numData - 1.0);
        }
        return S / numData;
    }

    public static double variance(double[] data) {
        return MathUtils.variance(data, MathUtils.mean(data));
    }

    public static float variance(float[] data) {
        return MathUtils.variance(data, MathUtils.mean(data));
    }

    public static double variance(double[] data, double meanVal) {
        return MathUtils.variance(data, meanVal, 0, data.length - 1);
    }

    public static float variance(float[] data, float meanVal) {
        return MathUtils.variance(data, meanVal, 0, data.length - 1);
    }

    public static float variance(float[] data, float meanVal, int startIndex, int endIndex) {
        double[] ddata = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            ddata[i] = data[i];
        }
        return (float)MathUtils.variance(ddata, (double)meanVal, startIndex, endIndex);
    }

    public static double variance(double[] data, double meanVal, int startIndex, int endIndex) {
        double var = 0.0;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (startIndex > data.length - 1) {
            startIndex = data.length - 1;
        }
        if (endIndex < startIndex) {
            endIndex = startIndex;
        }
        if (endIndex > data.length - 1) {
            endIndex = data.length - 1;
        }
        for (int i = startIndex; i <= endIndex; ++i) {
            var += (data[i] - meanVal) * (data[i] - meanVal);
        }
        if (endIndex - startIndex > 1) {
            var /= (double)(endIndex - startIndex);
        }
        return var;
    }

    public static double[] variance(double[][] x, double[] meanVector) {
        return MathUtils.variance(x, meanVector, true);
    }

    public static double[] variance(double[][] x, double[] meanVector, boolean isAlongRows) {
        double[] var;
        block5: {
            var = null;
            if (x == null || x[0] == null || x[0].length <= 0 || meanVector == null) break block5;
            if (isAlongRows) {
                var = new double[x[0].length];
                int j = 0;
                while (j < x[0].length) {
                    for (int i = 0; i < x.length; ++i) {
                        int n = j;
                        var[n] = var[n] + (x[i][j] - meanVector[j]) * (x[i][j] - meanVector[j]);
                    }
                    int n = j++;
                    var[n] = var[n] / (double)(x.length - 1);
                }
            } else {
                var = new double[x.length];
                for (int i = 0; i < x.length; ++i) {
                    var[i] = MathUtils.variance(x[i], meanVector[i]);
                }
            }
        }
        return var;
    }

    public static double[] mean(double[][] x) {
        return MathUtils.mean(x, true);
    }

    public static double[] mean(double[][] x, boolean isAlongRows) {
        int[] indices = null;
        if (isAlongRows) {
            indices = new int[x.length];
            for (int i = 0; i < x.length; ++i) {
                indices[i] = i;
            }
        } else {
            indices = new int[x[0].length];
            for (int i = 0; i < x[0].length; ++i) {
                indices[i] = i;
            }
        }
        return MathUtils.mean(x, isAlongRows, indices);
    }

    public static double[] mean(double[][] x, boolean isAlongRows, int[] indicesOfX) {
        double[] meanVector = null;
        if (isAlongRows) {
            int j;
            meanVector = new double[x[indicesOfX[0]].length];
            Arrays.fill(meanVector, 0.0);
            for (int i = 0; i < indicesOfX.length; ++i) {
                for (j = 0; j < x[indicesOfX[0]].length; ++j) {
                    int n = j;
                    meanVector[n] = meanVector[n] + x[indicesOfX[i]][j];
                }
            }
            j = 0;
            while (j < meanVector.length) {
                int n = j++;
                meanVector[n] = meanVector[n] / (double)indicesOfX.length;
            }
        } else {
            int j;
            meanVector = new double[x.length];
            Arrays.fill(meanVector, 0.0);
            for (int i = 0; i < indicesOfX.length; ++i) {
                for (j = 0; j < x.length; ++j) {
                    int n = j;
                    meanVector[n] = meanVector[n] + x[j][indicesOfX[i]];
                }
            }
            j = 0;
            while (j < meanVector.length) {
                int n = j++;
                meanVector[n] = meanVector[n] / (double)indicesOfX.length;
            }
        }
        return meanVector;
    }

    public static double[][] covariance(double[][] x) {
        return MathUtils.covariance(x, true);
    }

    public static double[][] covariance(double[][] x, double[] meanVector) {
        return MathUtils.covariance(x, meanVector, true);
    }

    public static double[][] covariance(double[][] x, boolean isAlongRows) {
        double[] meanVector = MathUtils.mean(x, isAlongRows);
        return MathUtils.covariance(x, meanVector, isAlongRows);
    }

    public static double[][] covariance(double[][] x, double[] meanVector, boolean isAlongRows) {
        int[] indices = null;
        if (isAlongRows) {
            indices = new int[x.length];
            for (int i = 0; i < x.length; ++i) {
                indices[i] = i;
            }
        } else {
            indices = new int[x[0].length];
            for (int i = 0; i < x[0].length; ++i) {
                indices[i] = i;
            }
        }
        return MathUtils.covariance(x, meanVector, isAlongRows, indices);
    }

    public static double[][] covariance(double[][] x, double[] meanVector, boolean isAlongRows, int[] indicesOfX) {
        double[][] cov = null;
        double[][] tmpMatrix = null;
        double[][] zeroMean = null;
        double[][] zeroMeanTranspoze = null;
        if (x != null && meanVector != null) {
            if (isAlongRows) {
                int i;
                for (i = 0; i < indicesOfX.length; ++i) {
                    assert (meanVector.length == x[indicesOfX[i]].length);
                }
                int numObservations = indicesOfX.length;
                int dimension = x[indicesOfX[0]].length;
                cov = new double[dimension][dimension];
                tmpMatrix = new double[dimension][dimension];
                zeroMean = new double[dimension][1];
                for (i = 0; i < dimension; ++i) {
                    Arrays.fill(cov[i], 0.0);
                }
                for (i = 0; i < numObservations; ++i) {
                    double[] tmpVector = MathUtils.subtract(x[indicesOfX[i]], meanVector);
                    zeroMean = MathUtils.transpoze(tmpVector);
                    zeroMeanTranspoze = MathUtils.transpoze(zeroMean);
                    tmpMatrix = MathUtils.matrixProduct(zeroMean, zeroMeanTranspoze);
                    cov = MathUtils.add(cov, tmpMatrix);
                }
                cov = MathUtils.divide(cov, (double)(numObservations - 1));
            } else {
                assert (meanVector.length == x.length);
                int numObservations = indicesOfX.length;
                for (int i = 1; i < indicesOfX.length; ++i) {
                    assert (x[indicesOfX[i]].length == x[indicesOfX[0]].length);
                }
                int dimension = x.length;
                cov = MathUtils.transpoze(MathUtils.covariance(MathUtils.transpoze(x), meanVector, true, indicesOfX));
            }
        }
        return cov;
    }

    public static double correlation(double[] x, double[] y) {
        if (x.length == y.length) {
            double mx = MathUtils.mean(x);
            double my = MathUtils.mean(y);
            double sx = Math.sqrt(MathUtils.variance(x));
            double sy = Math.sqrt(MathUtils.variance(y));
            int n = x.length;
            double nval = 0.0;
            for (int i = 0; i < n; ++i) {
                nval += (x[i] - mx) * (y[i] - my);
            }
            double r = nval / ((double)(n - 1) * sx * sy);
            return r;
        }
        throw new IllegalArgumentException("vectors of different size");
    }

    public static double[] diagonal(double[][] x) {
        int i;
        double[] d = null;
        int dim = x.length;
        for (i = 1; i < dim; ++i) {
            assert (x[i].length == dim);
        }
        if (x != null) {
            d = new double[dim];
            for (i = 0; i < x.length; ++i) {
                d[i] = x[i][i];
            }
        }
        return d;
    }

    public static double[][] toDiagonalMatrix(double[] x) {
        double[][] m = null;
        if (x != null && x.length > 0) {
            int i;
            m = new double[x.length][x.length];
            for (i = 0; i < x.length; ++i) {
                Arrays.fill(m[i], 0.0);
            }
            for (i = 0; i < x.length; ++i) {
                m[i][i] = x[i];
            }
        }
        return m;
    }

    public static double[][] transpoze(double[] x) {
        double[][] y = new double[x.length][1];
        for (int i = 0; i < x.length; ++i) {
            y[i][0] = x[i];
        }
        return y;
    }

    public static double[][] transpoze(double[][] x) {
        double[][] y = null;
        if (x != null) {
            int i;
            int rowSizex = x.length;
            int colSizex = x[0].length;
            for (i = 1; i < rowSizex; ++i) {
                assert (x[i].length == colSizex);
            }
            y = new double[colSizex][rowSizex];
            for (i = 0; i < rowSizex; ++i) {
                for (int j = 0; j < colSizex; ++j) {
                    y[j][i] = x[i][j];
                }
            }
        }
        return y;
    }

    public static ComplexNumber[][] transpoze(ComplexNumber[][] x) {
        ComplexNumber[][] y = null;
        if (x != null) {
            int i;
            int rowSizex = x.length;
            int colSizex = x[0].length;
            for (i = 1; i < rowSizex; ++i) {
                assert (x[i].length == colSizex);
            }
            y = new ComplexNumber[colSizex][rowSizex];
            for (i = 0; i < rowSizex; ++i) {
                for (int j = 0; j < colSizex; ++j) {
                    y[j][i] = new ComplexNumber(x[i][j]);
                }
            }
        }
        return y;
    }

    public static ComplexNumber[][] hermitianTranspoze(ComplexNumber[][] x) {
        ComplexNumber[][] y = null;
        if (x != null) {
            int i;
            int rowSizex = x.length;
            int colSizex = x[0].length;
            for (i = 1; i < rowSizex; ++i) {
                assert (x[i].length == colSizex);
            }
            y = new ComplexNumber[colSizex][rowSizex];
            for (i = 0; i < rowSizex; ++i) {
                for (int j = 0; j < colSizex; ++j) {
                    y[j][i] = new ComplexNumber((double)x[i][j].real, -1.0 * (double)x[i][j].imag);
                }
            }
        }
        return y;
    }

    public static ComplexNumber[][] diagonalComplexMatrix(double[] diag) {
        ComplexNumber[][] x = null;
        int N = diag.length;
        if (N > 0) {
            x = new ComplexNumber[N][N];
            for (int i = 0; i < N; ++i) {
                for (int j = 0; j < N; ++j) {
                    x[i][j] = i == j ? new ComplexNumber(diag[i], 0.0) : new ComplexNumber(0.0, 0.0);
                }
            }
        }
        return x;
    }

    public static double[][] diagonalMatrix(double[] diag) {
        double[][] x = null;
        int N = diag.length;
        if (N > 0) {
            x = new double[N][N];
            for (int i = 0; i < N; ++i) {
                for (int j = 0; j < N; ++j) {
                    x[i][j] = i == j ? diag[i] : 0.0;
                }
            }
        }
        return x;
    }

    public static ComplexNumber ampPhase2ComplexNumber(double amp, double phaseInRadians) {
        return new ComplexNumber(amp * Math.cos(phaseInRadians), amp * Math.sin(phaseInRadians));
    }

    public static ComplexNumber[] polar2complex(double[] amps, float[] phasesInRadian) {
        if (amps.length != phasesInRadian.length) {
            throw new IllegalArgumentException("Arrays must have same length, but are " + amps.length + " vs. " + phasesInRadian.length);
        }
        ComplexNumber[] comps = new ComplexNumber[amps.length];
        for (int i = 0; i < amps.length; ++i) {
            comps[i] = MathUtils.ampPhase2ComplexNumber(amps[i], phasesInRadian[i]);
        }
        return comps;
    }

    public static ComplexNumber[] polar2complex(double[] amps, double[] phasesInRadian) {
        if (amps.length != phasesInRadian.length) {
            throw new IllegalArgumentException("Arrays must have same length, but are " + amps.length + " vs. " + phasesInRadian.length);
        }
        ComplexNumber[] comps = new ComplexNumber[amps.length];
        for (int i = 0; i < amps.length; ++i) {
            comps[i] = MathUtils.ampPhase2ComplexNumber(amps[i], phasesInRadian[i]);
        }
        return comps;
    }

    public static double[] add(double[] x, double[] y) {
        assert (x.length == y.length);
        double[] z = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            z[i] = x[i] + y[i];
        }
        return z;
    }

    public static double[] add(double[] a, double b) {
        double[] c = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] + b;
        }
        return c;
    }

    public static double[] subtract(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Arrays must be equal length");
        }
        double[] c = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] - b[i];
        }
        return c;
    }

    public static double[] subtract(double[] a, double b) {
        double[] c = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] - b;
        }
        return c;
    }

    public static double[] multiply(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Arrays must be equal length");
        }
        double[] c = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] * b[i];
        }
        return c;
    }

    public static float[] multiply(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Arrays must be equal length");
        }
        float[] c = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] * b[i];
        }
        return c;
    }

    public static double[] multiply(double[] a, double b) {
        double[] c = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] * b;
        }
        return c;
    }

    public static float[] multiply(float[] a, float b) {
        float[] c = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] * b;
        }
        return c;
    }

    public static double[] invert(double[] a) throws IllegalArgumentException {
        if (a == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        double[] c = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = 1.0 / a[i];
        }
        return c;
    }

    public static float[] invert(float[] a) {
        if (a == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        float[] c = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = 1.0f / a[i];
        }
        return c;
    }

    public static ComplexNumber[] multiplyComplex(ComplexNumber[] a, double b) {
        ComplexNumber[] c = new ComplexNumber[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = MathUtils.multiply(b, a[i]);
        }
        return c;
    }

    public static ComplexNumber complexConjugate(ComplexNumber x) {
        return new ComplexNumber((double)x.real, -1.0 * (double)x.imag);
    }

    public static ComplexNumber complexConjugate(double xReal, double xImag) {
        return new ComplexNumber(xReal, -1.0 * xImag);
    }

    public static ComplexNumber addComplex(ComplexNumber x1, ComplexNumber x2) {
        return new ComplexNumber(x1.real + x2.real, x1.imag + x2.imag);
    }

    public static ComplexNumber addComplex(ComplexNumber x, double yReal, double yImag) {
        return new ComplexNumber((double)x.real + yReal, (double)x.imag + yImag);
    }

    public static ComplexNumber addComplex(double yReal, double yImag, ComplexNumber x) {
        return new ComplexNumber((double)x.real + yReal, (double)x.imag + yImag);
    }

    public static ComplexNumber addComplex(double xReal, double xImag, double yReal, double yImag) {
        return new ComplexNumber(xReal + yReal, xImag + yImag);
    }

    public static ComplexNumber subtractComplex(ComplexNumber x1, ComplexNumber x2) {
        return new ComplexNumber(x1.real - x2.real, x1.imag - x2.imag);
    }

    public static ComplexNumber subtractComplex(ComplexNumber x, double yReal, double yImag) {
        return new ComplexNumber((double)x.real - yReal, (double)x.imag - yImag);
    }

    public static ComplexNumber subtractComplex(double yReal, double yImag, ComplexNumber x) {
        return new ComplexNumber(yReal - (double)x.real, yImag - (double)x.imag);
    }

    public static ComplexNumber subtractComplex(double xReal, double xImag, double yReal, double yImag) {
        return new ComplexNumber(xReal - yReal, xImag - yImag);
    }

    public static ComplexNumber multiplyComplex(ComplexNumber x1, ComplexNumber x2) {
        return new ComplexNumber(x1.real * x2.real - x1.imag * x2.imag, x1.real * x2.imag + x1.imag * x2.real);
    }

    public static ComplexNumber multiplyComplex(ComplexNumber x, double yReal, double yImag) {
        return new ComplexNumber((double)x.real * yReal - (double)x.imag * yImag, (double)x.real * yImag + (double)x.imag * yReal);
    }

    public static ComplexNumber multiplyComplex(double yReal, double yImag, ComplexNumber x) {
        return new ComplexNumber((double)x.real * yReal - (double)x.imag * yImag, (double)x.real * yImag + (double)x.imag * yReal);
    }

    public static ComplexNumber multiplyComplex(double xReal, double xImag, double yReal, double yImag) {
        return new ComplexNumber(xReal * yReal - xImag * yImag, xReal * yImag + xImag * yReal);
    }

    public static ComplexNumber multiply(double x1, ComplexNumber x2) {
        return new ComplexNumber(x1 * (double)x2.real, x1 * (double)x2.imag);
    }

    public static ComplexNumber divideComplex(ComplexNumber x, double yReal, double yImag) {
        double denum = MathUtils.magnitudeComplexSquared(yReal, yImag);
        return new ComplexNumber(((double)x.real * yReal + (double)x.imag * yImag) / denum, ((double)x.imag * yReal - (double)x.real * yImag) / denum);
    }

    public static ComplexNumber divideComplex(double yReal, double yImag, ComplexNumber x) {
        double denum = MathUtils.magnitudeComplexSquared(x.real, x.imag);
        return new ComplexNumber((yReal * (double)x.real + yImag * (double)x.imag) / denum, (yImag * (double)x.real - yReal * (double)x.imag) / denum);
    }

    public static ComplexNumber divideComplex(ComplexNumber x1, ComplexNumber x2) {
        double denum = MathUtils.magnitudeComplexSquared(x2.real, x2.imag);
        return new ComplexNumber((double)(x1.real * x2.real + x1.imag * x2.imag) / denum, (double)(x1.imag * x2.real - x1.real * x2.imag) / denum);
    }

    public static ComplexNumber divideComplex(double xReal, double xImag, double yReal, double yImag) {
        double denum = MathUtils.magnitudeComplexSquared(yReal, yImag);
        return new ComplexNumber((xReal * yReal + xImag * yImag) / denum, (xImag * yReal - xReal * yImag) / denum);
    }

    public static ComplexNumber divide(ComplexNumber x1, double x2) {
        return new ComplexNumber((double)x1.real / x2, (double)x1.imag / x2);
    }

    public static ComplexNumber divide(double x1, ComplexNumber x2) {
        return MathUtils.divideComplex(x1, 0.0, x2);
    }

    public static double magnitudeComplexSquared(ComplexNumber x) {
        return x.real * x.real + x.imag * x.imag;
    }

    public static double magnitudeComplexSquared(double xReal, double xImag) {
        return xReal * xReal + xImag * xImag;
    }

    public static double magnitudeComplex(ComplexNumber x) {
        return Math.sqrt(MathUtils.magnitudeComplexSquared(x));
    }

    public static double[] magnitudeComplex(ComplexNumber[] xs) {
        double[] mags = new double[xs.length];
        for (int i = 0; i < xs.length; ++i) {
            mags[i] = MathUtils.magnitudeComplex(xs[i]);
        }
        return mags;
    }

    public static double[] magnitudeComplex(ComplexArray x) {
        assert (x.real.length == x.imag.length);
        double[] mags = new double[x.real.length];
        for (int i = 0; i < x.real.length; ++i) {
            mags[i] = MathUtils.magnitudeComplex(new ComplexNumber(x.real[i], x.imag[i]));
        }
        return mags;
    }

    public static double magnitudeComplex(double xReal, double xImag) {
        return Math.sqrt(MathUtils.magnitudeComplexSquared(xReal, xImag));
    }

    public static double phaseInRadians(ComplexNumber x) {
        return Math.atan2(x.imag, x.real);
    }

    public static float phaseInRadiansFloat(ComplexNumber x) {
        return (float)MathUtils.phaseInRadians(x);
    }

    public static double phaseInRadians(double xReal, double xImag) {
        return MathUtils.phaseInRadians(new ComplexNumber(xReal, xImag));
    }

    public static double[] phaseInRadians(ComplexNumber[] xs) {
        double[] phases = new double[xs.length];
        for (int i = 0; i < xs.length; ++i) {
            phases[i] = MathUtils.phaseInRadians(xs[i]);
        }
        return phases;
    }

    public static float[] phaseInRadiansFloat(ComplexNumber[] xs) {
        float[] phases = new float[xs.length];
        for (int i = 0; i < xs.length; ++i) {
            phases[i] = MathUtils.phaseInRadiansFloat(xs[i]);
        }
        return phases;
    }

    public static double[] phaseInRadians(ComplexArray x) {
        assert (x.real.length == x.imag.length);
        double[] phases = new double[x.real.length];
        for (int i = 0; i < x.real.length; ++i) {
            phases[i] = MathUtils.phaseInRadians(x.real[i], x.imag[i]);
        }
        return phases;
    }

    public static ComplexNumber complexNumber(double r, double theta) {
        return new ComplexNumber(r * Math.cos(theta), r * Math.sin(theta));
    }

    public static double[] divide(double[] a, double[] b) {
        if (a == null || b == null || a.length != b.length) {
            throw new IllegalArgumentException("Arrays must be equal length");
        }
        double[] c = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] / b[i];
        }
        return c;
    }

    public static double[] divide(double[] a, double b) {
        double[] c = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] / b;
        }
        return c;
    }

    public static double[][] add(double[][] x, double[][] y) {
        double[][] z = null;
        if (x != null && y != null) {
            int i;
            assert (x.length == y.length);
            for (i = 0; i < x.length; ++i) {
                assert (x[i].length == x[0].length);
                assert (x[i].length == y[i].length);
            }
            z = new double[x.length][x[0].length];
            for (i = 0; i < x.length; ++i) {
                for (int j = 0; j < x[i].length; ++j) {
                    z[i][j] = x[i][j] + y[i][j];
                }
            }
        }
        return z;
    }

    public static double[][] subtract(double[][] x, double[][] y) {
        double[][] z = null;
        if (x != null && y != null) {
            int i;
            assert (x.length == y.length);
            for (i = 0; i < x.length; ++i) {
                assert (x[i].length == x[0].length);
                assert (x[i].length == y[i].length);
            }
            z = new double[x.length][x[0].length];
            for (i = 0; i < x.length; ++i) {
                for (int j = 0; j < x[i].length; ++j) {
                    z[i][j] = x[i][j] - y[i][j];
                }
            }
        }
        return z;
    }

    public static double[][] multiply(double a, double[][] x) {
        double[][] z = null;
        if (x != null) {
            int i;
            for (i = 1; i < x.length; ++i) {
                assert (x[i].length == x[0].length);
            }
            z = new double[x.length][x[0].length];
            for (i = 0; i < x.length; ++i) {
                for (int j = 0; j < x[i].length; ++j) {
                    z[i][j] = a * x[i][j];
                }
            }
        }
        return z;
    }

    public static double[][] divide(double[][] x, double a) {
        return MathUtils.multiply(1.0 / a, x);
    }

    public static double[] matrixProduct(double[][] x, double[] y) {
        int i;
        double[][] y2 = new double[y.length][1];
        for (i = 0; i < y.length; ++i) {
            y2[i][0] = y[i];
        }
        y2 = MathUtils.matrixProduct(x, y2);
        double[] y3 = new double[y2.length];
        for (i = 0; i < y2.length; ++i) {
            y3[i] = y2[i][0];
        }
        return y3;
    }

    public static double[] matrixProduct(double[][] x, float[] y) {
        int i;
        double[][] y2 = new double[y.length][1];
        for (i = 0; i < y.length; ++i) {
            y2[i][0] = y[i];
        }
        y2 = MathUtils.matrixProduct(x, y2);
        double[] y3 = new double[y2.length];
        for (i = 0; i < y2.length; ++i) {
            y3[i] = y2[i][0];
        }
        return y3;
    }

    public static ComplexNumber[] matrixProduct(ComplexNumber[][] x, ComplexNumber[] y) {
        int i;
        ComplexNumber[][] y2 = new ComplexNumber[y.length][1];
        for (i = 0; i < y.length; ++i) {
            y2[i][0] = new ComplexNumber(y[i]);
        }
        y2 = MathUtils.matrixProduct(x, y2);
        ComplexNumber[] y3 = new ComplexNumber[y2.length];
        for (i = 0; i < y2.length; ++i) {
            y3[i] = new ComplexNumber(y2[i][0]);
        }
        return y3;
    }

    public static ComplexNumber[] matrixProduct(ComplexNumber[][] x, double[] y) {
        int i;
        ComplexNumber[][] y2 = new ComplexNumber[y.length][1];
        for (i = 0; i < y.length; ++i) {
            y2[i][0] = new ComplexNumber(y[i], 0.0);
        }
        y2 = MathUtils.matrixProduct(x, y2);
        ComplexNumber[] y3 = new ComplexNumber[y2.length];
        for (i = 0; i < y2.length; ++i) {
            y3[i] = new ComplexNumber(y2[i][0]);
        }
        return y3;
    }

    public static double[][] matrixProduct(double[] x, double[][] y) {
        double[][] x2 = new double[x.length][1];
        for (int i = 0; i < x.length; ++i) {
            x2[i][0] = x[i];
        }
        return MathUtils.matrixProduct(x2, y);
    }

    public static ComplexNumber[][] matrixProduct(ComplexNumber[] x, ComplexNumber[][] y) {
        ComplexNumber[][] x2 = new ComplexNumber[x.length][1];
        for (int i = 0; i < x.length; ++i) {
            x2[i][0] = new ComplexNumber(x[i]);
        }
        return MathUtils.matrixProduct(x2, y);
    }

    public static double[][] matrixProduct(double[][] x, double[][] y) {
        double[][] z;
        block12: {
            z = null;
            if (x == null || y == null) break block12;
            if (x.length == 1 && y.length == 1) {
                assert (x[0].length == y[0].length);
                z = new double[1][x[0].length];
                for (int i = 0; i < x[0].length; ++i) {
                    z[0][i] = x[0][i] * y[0][i];
                }
            } else {
                int i;
                int rowSizex = x.length;
                int colSizex = x[0].length;
                int rowSizey = y.length;
                int colSizey = y[0].length;
                for (i = 1; i < x.length; ++i) {
                    assert (x[i].length == colSizex);
                }
                for (i = 1; i < y.length; ++i) {
                    assert (y[i].length == colSizey);
                }
                assert (colSizex == rowSizey);
                z = new double[rowSizex][colSizey];
                for (i = 0; i < rowSizex; ++i) {
                    for (int j = 0; j < colSizey; ++j) {
                        double tmpSum = 0.0;
                        for (int m = 0; m < x[i].length; ++m) {
                            tmpSum += x[i][m] * y[m][j];
                        }
                        z[i][j] = tmpSum;
                    }
                }
            }
        }
        return z;
    }

    public static ComplexNumber[][] matrixProduct(ComplexNumber[][] x, ComplexNumber[][] y) {
        ComplexNumber[][] z;
        block12: {
            z = null;
            if (x == null || y == null) break block12;
            if (x.length == 1 && y.length == 1) {
                assert (x[0].length == y[0].length);
                z = new ComplexNumber[1][x[0].length];
                for (int i = 0; i < x[0].length; ++i) {
                    z[0][i] = MathUtils.multiplyComplex(x[0][i], y[0][i]);
                }
            } else {
                int i;
                int rowSizex = x.length;
                int colSizex = x[0].length;
                int rowSizey = y.length;
                int colSizey = y[0].length;
                for (i = 1; i < x.length; ++i) {
                    assert (x[i].length == colSizex);
                }
                for (i = 1; i < y.length; ++i) {
                    assert (y[i].length == colSizey);
                }
                assert (colSizex == rowSizey);
                z = new ComplexNumber[rowSizex][colSizey];
                for (i = 0; i < rowSizex; ++i) {
                    for (int j = 0; j < colSizey; ++j) {
                        float real = 0.0f;
                        float imag = 0.0f;
                        for (int m = 0; m < x[i].length; ++m) {
                            ComplexNumber x1 = x[i][m];
                            ComplexNumber x2 = y[m][j];
                            real += x1.real * x2.real - x1.imag * x2.imag;
                            imag += x1.real * x2.imag + x1.imag * x2.real;
                        }
                        z[i][j] = new ComplexNumber(real, imag);
                    }
                }
            }
        }
        return z;
    }

    public static double[][] vectorProduct(double[] x, boolean isColumnVectorX, double[] y, boolean isColumnVectorY) {
        int i;
        double[][] xx = null;
        double[][] yy = null;
        if (isColumnVectorX) {
            xx = new double[x.length][1];
            for (i = 0; i < x.length; ++i) {
                xx[i][0] = x[i];
            }
        } else {
            xx = new double[1][x.length];
            System.arraycopy(x, 0, xx[0], 0, x.length);
        }
        if (isColumnVectorY) {
            yy = new double[y.length][1];
            for (i = 0; i < y.length; ++i) {
                yy[i][0] = y[i];
            }
        } else {
            yy = new double[1][y.length];
            System.arraycopy(y, 0, yy[0], 0, y.length);
        }
        return MathUtils.matrixProduct(xx, yy);
    }

    public static double dotProduct(double[] x, double[] y) {
        assert (x.length == y.length);
        double tmpSum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            tmpSum += x[i] * y[i];
        }
        return tmpSum;
    }

    public static double[][] dotProduct(double[][] x, double[][] y) {
        int i;
        double[][] z = null;
        assert (x.length == y.length);
        int numRows = x.length;
        int numCols = x[0].length;
        for (i = 1; i < numRows; ++i) {
            assert (numCols == x[i].length);
            assert (numCols == y[i].length);
        }
        if (x != null) {
            z = new double[numRows][numCols];
            for (i = 0; i < numRows; ++i) {
                for (int j = 0; j < numCols; ++j) {
                    z[i][j] = x[i][j] * y[i][j];
                }
            }
        }
        return z;
    }

    public static double dbSPL(double energy) {
        if (energy <= 0.0) {
            return Double.NaN;
        }
        return 10.0 * MathUtils.log10(energy / 4.0E-10);
    }

    public static double[] dbSPL(double[] energies) {
        return MathUtils.multiply(MathUtils.log10(MathUtils.divide(energies, 4.0E-10)), 10.0);
    }

    public static double db(double energy) {
        if (energy <= 1.0E-80) {
            return -200.0;
        }
        return 10.0 * MathUtils.log10(energy);
    }

    public static double amp2db(double amp) {
        if (amp <= 1.0E-80) {
            return -200.0;
        }
        return 20.0 * MathUtils.log10(amp);
    }

    public static double amp2neper(double amp) {
        if (amp <= 1.0E-80) {
            return -200.0;
        }
        return Math.log(amp);
    }

    public static double[] db(double[] energies) {
        return MathUtils.multiply(MathUtils.log10(energies), 10.0);
    }

    public static double[] abs(ComplexArray c) {
        int len = Math.min(c.real.length, c.imag.length);
        return MathUtils.abs(c, 0, len - 1);
    }

    public static double[] abs(ComplexNumber[] x) {
        double[] absMags = null;
        if (x.length > 0) {
            absMags = new double[x.length];
            for (int i = 0; i < x.length; ++i) {
                absMags[i] = MathUtils.magnitudeComplex(x[i]);
            }
        }
        return absMags;
    }

    public static double[] abs(ComplexArray c, int startInd, int endInd) {
        if (startInd < 0) {
            startInd = 0;
        }
        if (startInd > Math.min(c.real.length - 1, c.imag.length - 1)) {
            startInd = Math.min(c.real.length - 1, c.imag.length - 1);
        }
        if (endInd < startInd) {
            endInd = startInd;
        }
        if (endInd > Math.min(c.real.length - 1, c.imag.length - 1)) {
            endInd = Math.min(c.real.length - 1, c.imag.length - 1);
        }
        double[] absVals = new double[endInd - startInd + 1];
        for (int i = startInd; i <= endInd; ++i) {
            absVals[i - startInd] = Math.sqrt(c.real[i] * c.real[i] + c.imag[i] * c.imag[i]);
        }
        return absVals;
    }

    public static double[] amp2db(double[] amps) {
        return MathUtils.multiply(MathUtils.log10(amps), 20.0);
    }

    public static double[] amp2neper(double[] amps) {
        double[] newAmps = new double[amps.length];
        for (int i = 0; i < amps.length; ++i) {
            newAmps[i] = MathUtils.amp2neper(amps[i]);
        }
        return newAmps;
    }

    public static double[] dft2ampdb(ComplexArray c) {
        return MathUtils.dft2ampdb(c, 0, c.real.length - 1);
    }

    public static double[] dft2ampdb(ComplexArray c, int startInd, int endInd) {
        if (startInd < 0) {
            startInd = 0;
        }
        if (startInd > Math.min(c.real.length - 1, c.imag.length - 1)) {
            startInd = Math.min(c.real.length - 1, c.imag.length - 1);
        }
        if (endInd < startInd) {
            endInd = startInd;
        }
        if (endInd > Math.min(c.real.length - 1, c.imag.length - 1)) {
            endInd = Math.min(c.real.length - 1, c.imag.length - 1);
        }
        double[] dbs = new double[endInd - startInd + 1];
        for (int i = startInd; i <= endInd; ++i) {
            dbs[i - startInd] = MathUtils.amp2db(Math.sqrt(c.real[i] * c.real[i] + c.imag[i] * c.imag[i]));
        }
        return dbs;
    }

    public static double db2linear(double dbEnergy) {
        if (Double.isNaN(dbEnergy)) {
            return 0.0;
        }
        return MathUtils.exp10(dbEnergy / 10.0);
    }

    public static double[] db2linear(double[] dbEnergies) {
        return MathUtils.exp10(MathUtils.divide(dbEnergies, 10.0));
    }

    public static double[] linear2db(double[] linears) {
        return MathUtils.multiply(MathUtils.log10(linears), 10.0);
    }

    public static float db2amp(float dbAmplitude) {
        if (Float.isNaN(dbAmplitude)) {
            return 0.0f;
        }
        return (float)Math.pow(10.0, dbAmplitude / 20.0f);
    }

    public static double db2amp(double dbAmplitude) {
        if (Double.isNaN(dbAmplitude)) {
            return 0.0;
        }
        return Math.pow(10.0, dbAmplitude / 20.0);
    }

    public static float[] db2amp(float[] dbAmplitudes) {
        float[] amps = new float[dbAmplitudes.length];
        for (int i = 0; i < dbAmplitudes.length; ++i) {
            amps[i] = MathUtils.db2amp(dbAmplitudes[i]);
        }
        return amps;
    }

    public static double[] db2amp(double[] dbAmplitudes) {
        double[] amps = new double[dbAmplitudes.length];
        for (int i = 0; i < dbAmplitudes.length; ++i) {
            amps[i] = MathUtils.db2amp(dbAmplitudes[i]);
        }
        return amps;
    }

    public static float radian2degrees(float rad) {
        return (float)((double)rad / (Math.PI * 2) * 360.0);
    }

    public static double radian2degrees(double rad) {
        return rad / (Math.PI * 2) * 360.0;
    }

    public static float degrees2radian(float deg) {
        return (float)((double)deg / 360.0 * (Math.PI * 2));
    }

    public static double degrees2radian(double deg) {
        return deg / 360.0 * (Math.PI * 2);
    }

    public static double sumSquaredError(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Arrays must be equal length");
        }
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double delta = a[i] - b[i];
            if (Double.isNaN(delta)) continue;
            sum += delta * delta;
        }
        return sum;
    }

    public static double log10(double x) {
        return Math.log(x) / LOG10;
    }

    public static double[] log(double[] a) {
        double[] c = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = Math.log(a[i]);
        }
        return c;
    }

    public static double[] log(double[] a, double minimumValue, double fixedValue) {
        double[] c = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] > minimumValue ? Math.log(a[i]) : fixedValue;
        }
        return c;
    }

    public static double[] log10(double[] a) {
        double[] c = null;
        if (a != null) {
            c = new double[a.length];
            for (int i = 0; i < a.length; ++i) {
                c[i] = MathUtils.log10(a[i]);
            }
        }
        return c;
    }

    public static double exp10(double x) {
        return Math.exp(LOG10 * x);
    }

    public static double[] exp(double[] a) {
        double[] c = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = Math.exp(a[i]);
        }
        return c;
    }

    public static double[] exp10(double[] a) {
        double[] c = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = MathUtils.exp10(a[i]);
        }
        return c;
    }

    public static float[] add(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Arrays must be equal length");
        }
        float[] c = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] + b[i];
        }
        return c;
    }

    public static float[] add(float[] a, float b) {
        float[] c = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] + b;
        }
        return c;
    }

    public static float[] subtract(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Arrays must be equal length");
        }
        float[] c = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] - b[i];
        }
        return c;
    }

    public static float[] subtract(float[] a, float b) {
        float[] c = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] - b;
        }
        return c;
    }

    public static double euclidianLength(float[] a) {
        double len = 0.0;
        for (int i = 0; i < a.length; ++i) {
            len += (double)(a[i] * a[i]);
        }
        return Math.sqrt(len);
    }

    public static double euclidianLength(double[] a) {
        double len = 0.0;
        for (int i = 0; i < a.length; ++i) {
            len += a[i] * a[i];
        }
        return Math.sqrt(len);
    }

    public static void toPolarCoordinates(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays must be equal length");
        }
        for (int i = 0; i < x.length; ++i) {
            double r = Math.sqrt(x[i] * x[i] + y[i] * y[i]);
            double phi = Math.atan2(y[i], x[i]);
            x[i] = r;
            y[i] = phi;
        }
    }

    public static void toCartesianCoordinates(double[] r, double[] phi) {
        if (r.length != phi.length) {
            throw new IllegalArgumentException("Arrays must be equal length");
        }
        for (int i = 0; i < r.length; ++i) {
            double x = r[i] * Math.cos(phi[i]);
            double y = r[i] * Math.sin(phi[i]);
            r[i] = x;
            phi[i] = y;
        }
    }

    public static double angleToDefaultAngle(double angle) {
        return (angle + Math.PI) % (Math.PI * -2) + Math.PI;
    }

    public static void angleToDefaultAngle(double[] angle) {
        for (int i = 0; i < angle.length; ++i) {
            angle[i] = MathUtils.angleToDefaultAngle(angle[i]);
        }
    }

    public static double[] levinson(double[] r, int m) {
        int i;
        double[] e = new double[m + 1];
        double[][] l = new double[m + 1][m + 1];
        double[] coeffs = new double[m + 1];
        for (i = 0; i <= m; ++i) {
            for (int j = i + 1; j <= m; ++j) {
                l[i][j] = 0.0;
            }
        }
        l[0][0] = 1.0;
        l[1][1] = 1.0;
        l[1][0] = -r[1] / r[0];
        e[0] = r[0];
        e[1] = e[0] * (1.0 - l[1][0] * l[1][0]);
        for (i = 2; i <= m; ++i) {
            int k;
            double gap = 0.0;
            for (k = 0; k <= i - 1; ++k) {
                gap += r[k + 1] * l[i - 1][k];
            }
            double gamma = gap / e[i - 1];
            l[i][0] = -gamma;
            for (k = 1; k <= i - 1; ++k) {
                l[i][k] = l[i - 1][k - 1] - gamma * l[i - 1][i - 1 - k];
            }
            l[i][i] = 1.0;
            e[i] = e[i - 1] * (1.0 - gamma * gamma);
        }
        coeffs[0] = 1.0;
        for (i = 1; i <= m; ++i) {
            coeffs[i] = l[m][m - i];
        }
        return coeffs;
    }

    public static ComplexNumber[] levinson(ComplexNumber[] r, ComplexNumber[] c) {
        assert (r.length == c.length);
        int M = r.length;
        ComplexNumber[] a = new ComplexNumber[M];
        ComplexNumber[] b = new ComplexNumber[M];
        ComplexNumber[] h = new ComplexNumber[M];
        if ((double)r[0].real == 0.0 && (double)r[0].imag == 0.0) {
            for (int i = 1; i <= M; ++i) {
                h[i - 1] = new ComplexNumber(0.0, 0.0);
            }
            return h;
        }
        a[0] = new ComplexNumber(1.0, 0.0);
        ComplexNumber beta = new ComplexNumber(r[1]);
        ComplexNumber alpha = new ComplexNumber(r[0]);
        h[0] = MathUtils.divideComplex(c[0], r[0]);
        if (M == 1) {
            return h;
        }
        ComplexNumber gamma = MathUtils.multiplyComplex(h[0], r[1]);
        ComplexNumber xk = MathUtils.divideComplex(MathUtils.multiply(-1.0, beta), alpha);
        a[1] = new ComplexNumber(xk);
        alpha = MathUtils.addComplex(alpha, MathUtils.multiplyComplex(xk, MathUtils.complexConjugate(beta)));
        ComplexNumber q = MathUtils.divideComplex(MathUtils.subtractComplex(c[1], gamma), MathUtils.complexConjugate(alpha));
        h[0] = MathUtils.addComplex(h[0], MathUtils.multiplyComplex(q, MathUtils.complexConjugate(a[1])));
        h[1] = new ComplexNumber(q);
        if (M == 2) {
            return h;
        }
        beta = MathUtils.addComplex(r[2], MathUtils.multiplyComplex(a[1], r[1]));
        gamma = MathUtils.addComplex(MathUtils.multiplyComplex(h[0], r[2]), MathUtils.multiplyComplex(h[1], r[1]));
        int M1 = M - 1;
        for (int N = 2; N <= M1; ++N) {
            int i;
            xk = MathUtils.divideComplex(MathUtils.multiply(-1.0, beta), MathUtils.complexConjugate(alpha));
            for (i = 2; i <= N; ++i) {
                b[i - 1] = MathUtils.addComplex(a[i - 1], MathUtils.multiplyComplex(xk, MathUtils.complexConjugate(a[N + 1 - i])));
            }
            for (i = 2; i <= N; ++i) {
                a[i - 1] = new ComplexNumber(b[i - 1]);
            }
            a[N] = new ComplexNumber(xk);
            alpha = MathUtils.addComplex(alpha, MathUtils.multiplyComplex(xk, MathUtils.complexConjugate(beta)));
            q = MathUtils.divideComplex(MathUtils.subtractComplex(c[N], gamma), MathUtils.complexConjugate(alpha));
            h[0] = MathUtils.addComplex(h[0], MathUtils.multiplyComplex(q, MathUtils.complexConjugate(a[N])));
            for (i = 2; i <= N; ++i) {
                h[i - 1] = MathUtils.addComplex(h[i - 1], MathUtils.multiplyComplex(q, MathUtils.complexConjugate(a[N + 1 - i])));
            }
            h[N] = new ComplexNumber(q);
            if (N == M1) {
                return h;
            }
            gamma = new ComplexNumber(0.0, 0.0);
            beta = new ComplexNumber(0.0, 0.0);
            for (i = 1; i <= N + 1; ++i) {
                beta = MathUtils.addComplex(beta, MathUtils.multiplyComplex(a[i - 1], r[N - i + 2]));
                gamma = MathUtils.addComplex(gamma, MathUtils.multiplyComplex(h[i - 1], r[N - i + 2]));
            }
        }
        return h;
    }

    public static float[] interpolate(float[] x, int newLength) {
        if (x != null) {
            int i;
            double[] xDouble = new double[x.length];
            for (i = 0; i < x.length; ++i) {
                xDouble[i] = x[i];
            }
            double[] yDouble = MathUtils.interpolate(xDouble, newLength);
            float[] y = new float[yDouble.length];
            for (i = 0; i < yDouble.length; ++i) {
                y[i] = (float)yDouble[i];
            }
            return y;
        }
        return null;
    }

    public static double[] interpolate(double[] x, int newLength) {
        double[] y = null;
        if (newLength > 0) {
            int N = x.length;
            if (N == 1) {
                y = new double[]{x[0]};
                return y;
            }
            if (newLength == 1) {
                y = new double[1];
                int ind = (int)Math.floor((double)N * 0.5 + 0.5);
                ind = Math.max(1, ind);
                ind = Math.min(ind, N);
                y[0] = x[ind - 1];
                return y;
            }
            y = new double[newLength];
            double ratio = (double)x.length / (double)newLength;
            for (int i = 0; i < newLength; ++i) {
                int leftInd = (int)Math.floor((double)i * ratio);
                y[i] = leftInd < x.length - 1 ? MathUtils.interpolatedSample(leftInd, (double)i * ratio, leftInd + 1, x[leftInd], x[leftInd + 1]) : (leftInd > 0 ? MathUtils.interpolatedSample(leftInd, (double)i * ratio, leftInd + 1, x[leftInd], 2.0 * x[leftInd] - x[leftInd - 1]) : x[leftInd]);
            }
        }
        return y;
    }

    public static ComplexNumber[] interpolate(ComplexNumber[] x, int newLength) {
        ComplexNumber[] y = null;
        if (newLength > 0) {
            int N = x.length;
            if (N == 1) {
                y = new ComplexNumber[]{new ComplexNumber(x[0])};
                return y;
            }
            if (newLength == 1) {
                y = new ComplexNumber[1];
                int ind = (int)Math.floor((double)N * 0.5 + 0.5);
                ind = Math.max(1, ind);
                ind = Math.min(ind, N);
                y[0] = new ComplexNumber(x[ind - 1]);
                return y;
            }
            y = new ComplexNumber[newLength];
            double ratio = (double)x.length / (double)newLength;
            for (int i = 0; i < newLength; ++i) {
                double yImag;
                double yReal;
                int leftInd = (int)Math.floor((double)i * ratio);
                if (leftInd < x.length - 1) {
                    yReal = MathUtils.interpolatedSample(leftInd, (double)i * ratio, leftInd + 1, x[leftInd].real, x[leftInd + 1].real);
                    yImag = MathUtils.interpolatedSample(leftInd, (double)i * ratio, leftInd + 1, x[leftInd].imag, x[leftInd + 1].imag);
                    y[i] = new ComplexNumber(yReal, yImag);
                    continue;
                }
                if (leftInd > 0) {
                    yReal = MathUtils.interpolatedSample(leftInd, (double)i * ratio, leftInd + 1, x[leftInd].real, 2.0f * x[leftInd].real - x[leftInd - 1].real);
                    yImag = MathUtils.interpolatedSample(leftInd, (double)i * ratio, leftInd + 1, x[leftInd].imag, 2.0f * x[leftInd].imag - x[leftInd - 1].imag);
                    y[i] = new ComplexNumber(yReal, yImag);
                    continue;
                }
                y[i] = new ComplexNumber(x[leftInd]);
            }
        }
        return y;
    }

    public static double[] interpolate(int[] xInds, double[] xVals, int[] xInds2) {
        double[] xVals2 = new double[xInds2.length];
        assert (xInds.length == xVals.length);
        for (int i = 0; i < xInds2.length; ++i) {
            int closestInd = MathUtils.findClosest(xInds, xInds2[i]);
            if (closestInd == xInds2[i]) {
                xVals2[i] = xVals[closestInd];
                continue;
            }
            if (closestInd > xInds2[i]) {
                if (closestInd > 0) {
                    xVals2[i] = MathUtils.interpolatedSample(xInds[closestInd - 1], xInds2[i], xInds[closestInd], xVals[closestInd - 1], xVals[closestInd]);
                    continue;
                }
                if (closestInd + 1 < xVals.length) {
                    xVals2[i] = MathUtils.interpolatedSample(xInds[closestInd] - 1, xInds2[i], xInds[closestInd], 2.0 * xVals[closestInd] - xVals[closestInd + 1], xVals[closestInd]);
                    continue;
                }
                xVals2[i] = xVals[closestInd];
                continue;
            }
            xVals2[i] = closestInd + 1 < xVals.length ? MathUtils.interpolatedSample(xInds[closestInd], xInds2[i], xInds[closestInd + 1], xVals[closestInd], xVals[closestInd + 1]) : (closestInd - 1 >= 0 ? MathUtils.interpolatedSample(xInds[closestInd], xInds2[i], xInds[closestInd] + 1, xVals[closestInd], 2.0 * xVals[closestInd] - xVals[closestInd - 1]) : xVals[closestInd]);
        }
        return xVals2;
    }

    public static double interpolatedSample(double xStart, double xVal, double xEnd, double yStart, double yEnd) {
        return (xVal - xStart) * (yEnd - yStart) / (xEnd - xStart) + yStart;
    }

    public static int getMax(int[] x) {
        int maxx = x[0];
        for (int i = 1; i < x.length; ++i) {
            if (x[i] <= maxx) continue;
            maxx = x[i];
        }
        return maxx;
    }

    public static int getMinIndex(int[] x) {
        return MathUtils.getMinIndex(x, 0);
    }

    public static int getMinIndex(int[] x, int startInd) {
        return MathUtils.getMinIndex(x, startInd, x.length - 1);
    }

    public static int getMinIndex(int[] x, int startInd, int endInd) {
        return MathUtils.getExtremaIndex(x, false, startInd, endInd);
    }

    public static int getMaxIndex(int[] x) {
        return MathUtils.getMaxIndex(x, 0);
    }

    public static int getMaxIndex(int[] x, int startInd) {
        return MathUtils.getMaxIndex(x, startInd, x.length - 1);
    }

    public static int getMaxIndex(int[] x, int startInd, int endInd) {
        return MathUtils.getExtremaIndex(x, true, startInd, endInd);
    }

    public static int getExtremaIndex(int[] x, boolean isMax) {
        return MathUtils.getExtremaIndex(x, isMax, 0);
    }

    public static int getExtremaIndex(int[] x, boolean isMax, int startInd) {
        return MathUtils.getExtremaIndex(x, isMax, startInd, x.length - 1);
    }

    public static int getExtremaIndex(int[] x, boolean isMax, int startInd, int endInd) {
        int extrema = x[0];
        int extremaInd = 0;
        if (startInd < 0) {
            startInd = 0;
        }
        if (endInd > x.length - 1) {
            endInd = x.length - 1;
        }
        if (startInd > endInd) {
            startInd = endInd;
        }
        if (isMax) {
            for (int i = startInd; i <= endInd; ++i) {
                if (x[i] <= extrema) continue;
                extrema = x[i];
                extremaInd = i;
            }
        } else {
            for (int i = startInd; i <= endInd; ++i) {
                if (x[i] >= extrema) continue;
                extrema = x[i];
                extremaInd = i;
            }
        }
        return extremaInd;
    }

    public static int getMinIndex(float[] x) {
        return MathUtils.getMinIndex(x, 0);
    }

    public static int getMinIndex(float[] x, int startInd) {
        return MathUtils.getMinIndex(x, startInd, x.length - 1);
    }

    public static int getMinIndex(float[] x, int startInd, int endInd) {
        return MathUtils.getExtremaIndex(x, false, startInd, endInd);
    }

    public static int getMaxIndex(float[] x) {
        return MathUtils.getMaxIndex(x, 0);
    }

    public static int getMaxIndex(float[] x, int startInd) {
        return MathUtils.getMaxIndex(x, startInd, x.length - 1);
    }

    public static int getMaxIndex(float[] x, int startInd, int endInd) {
        return MathUtils.getExtremaIndex(x, true, startInd, endInd);
    }

    public static int getExtremaIndex(float[] x, boolean isMax) {
        return MathUtils.getExtremaIndex(x, isMax, 0);
    }

    public static int getExtremaIndex(float[] x, boolean isMax, int startInd) {
        return MathUtils.getExtremaIndex(x, isMax, startInd, x.length - 1);
    }

    public static int getExtremaIndex(float[] x, boolean isMax, int startInd, int endInd) {
        float extrema = x[0];
        int extremaInd = 0;
        if (startInd < 0) {
            startInd = 0;
        }
        if (endInd > x.length - 1) {
            endInd = x.length - 1;
        }
        if (startInd > endInd) {
            startInd = endInd;
        }
        if (isMax) {
            for (int i = startInd; i <= endInd; ++i) {
                if (!(x[i] > extrema)) continue;
                extrema = x[i];
                extremaInd = i;
            }
        } else {
            for (int i = startInd; i <= endInd; ++i) {
                if (!(x[i] < extrema)) continue;
                extrema = x[i];
                extremaInd = i;
            }
        }
        return extremaInd;
    }

    public static int getMinIndex(double[] x) {
        return MathUtils.getMinIndex(x, 0);
    }

    public static int getMinIndex(double[] x, int startInd) {
        return MathUtils.getMinIndex(x, startInd, x.length - 1);
    }

    public static int getMinIndex(double[] x, int startInd, int endInd) {
        return MathUtils.getExtremaIndex(x, false, startInd, endInd);
    }

    public static int getMaxIndex(double[] x) {
        return MathUtils.getMaxIndex(x, 0);
    }

    public static int getMaxIndex(double[] x, int[] inds) {
        double[] tmp = new double[inds.length];
        for (int i = 0; i < inds.length; ++i) {
            tmp[i] = x[inds[i]];
        }
        int maxIndInd = MathUtils.getMaxIndex(tmp);
        return inds[maxIndInd];
    }

    public static int getMaxIndex(double[] x, int startInd) {
        return MathUtils.getMaxIndex(x, startInd, x.length - 1);
    }

    public static int getMaxIndex(double[] x, int startInd, int endInd) {
        return MathUtils.getExtremaIndex(x, true, startInd, endInd);
    }

    public static int getExtremaIndex(double[] x, boolean isMax) {
        return MathUtils.getExtremaIndex(x, isMax, 0);
    }

    public static int getExtremaIndex(double[] x, boolean isMax, int startInd) {
        return MathUtils.getExtremaIndex(x, isMax, startInd, x.length - 1);
    }

    public static int getExtremaIndex(double[] x, boolean isMax, int startInd, int endInd) {
        double extrema = x[0];
        int extremaInd = startInd;
        if (startInd < 0) {
            startInd = 0;
        }
        if (endInd > x.length - 1) {
            endInd = x.length - 1;
        }
        if (startInd > endInd) {
            startInd = endInd;
        }
        if (isMax) {
            for (int i = startInd; i <= endInd; ++i) {
                if (!(x[i] > extrema)) continue;
                extrema = x[i];
                extremaInd = i;
            }
        } else {
            for (int i = startInd; i <= endInd; ++i) {
                if (!(x[i] < extrema)) continue;
                extrema = x[i];
                extremaInd = i;
            }
        }
        return extremaInd;
    }

    public static double getMax(double[] x) {
        double maxx = x[0];
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] > maxx)) continue;
            maxx = x[i];
        }
        return maxx;
    }

    public static float getMax(float[] x) {
        float maxx = x[0];
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] > maxx)) continue;
            maxx = x[i];
        }
        return maxx;
    }

    public static int getMin(int[] x) {
        int minn = x[0];
        for (int i = 1; i < x.length; ++i) {
            if (x[i] >= minn) continue;
            minn = x[i];
        }
        return minn;
    }

    public static double getMin(double[] x) {
        double minn = x[0];
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] < minn)) continue;
            minn = x[i];
        }
        return minn;
    }

    public static float getMin(float[] x) {
        float maxx = x[0];
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] < maxx)) continue;
            maxx = x[i];
        }
        return maxx;
    }

    public static double getAbsMax(double[] x) {
        return MathUtils.getAbsMax(x, 0, x.length - 1);
    }

    public static double getAbsMax(double[] x, int startInd, int endInd) {
        double maxx = Math.abs(x[startInd]);
        for (int i = startInd + 1; i <= endInd; ++i) {
            if (!(Math.abs(x[i]) > maxx)) continue;
            maxx = Math.abs(x[i]);
        }
        return maxx;
    }

    public static int getAbsMaxInd(double[] x, int startInd, int endInd) {
        int index = -1;
        startInd = Math.max(startInd, 0);
        endInd = Math.min(endInd, x.length - 1);
        double max = x[startInd];
        for (int i = startInd + 1; i < endInd - 1; ++i) {
            if (!(x[i] > max) || !(x[i] > x[i - 1]) || !(x[i] > x[i + 1])) continue;
            max = x[i];
            index = i;
        }
        return index;
    }

    public static double[] filledArray(double val, int len) {
        double[] x = null;
        if (len > 0) {
            x = new double[len];
            for (int i = 0; i < len; ++i) {
                x[i] = val;
            }
        }
        return x;
    }

    public static float[] filledArray(float val, int len) {
        float[] x = null;
        if (len > 0) {
            x = new float[len];
            for (int i = 0; i < len; ++i) {
                x[i] = val;
            }
        }
        return x;
    }

    public static int[] filledArray(int val, int len) {
        int[] x = null;
        if (len > 0) {
            x = new int[len];
            for (int i = 0; i < len; ++i) {
                x[i] = val;
            }
        }
        return x;
    }

    public static double[] zeros(int len) {
        return MathUtils.filledArray(0.0, len);
    }

    public static double[] ones(int len) {
        return MathUtils.filledArray(1.0, len);
    }

    public static int[] zerosInt(int len) {
        return MathUtils.filledArray(0, len);
    }

    public static int[] onesInt(int len) {
        return MathUtils.filledArray(1, len);
    }

    public static float[] zerosFloat(int len) {
        return MathUtils.filledArray(0.0f, len);
    }

    public static float[] onesFloat(int len) {
        return MathUtils.filledArray(1.0f, len);
    }

    public static int[] find(int[] x, int comparator, int val) {
        double[] xd = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            xd[i] = x[i];
        }
        return MathUtils.find(xd, comparator, (double)val);
    }

    public static int[] findAnd(int[] x, int comparator1, int val1, int comparator2, int val2) {
        double[] xd = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            xd[i] = x[i];
        }
        return MathUtils.findAnd(xd, comparator1, (double)val1, comparator2, (double)val2);
    }

    public static int[] findOr(int[] x, int comparator1, int val1, int comparator2, int val2) {
        double[] xd = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            xd[i] = x[i];
        }
        return MathUtils.findOr(xd, comparator1, (double)val1, comparator2, (double)val2);
    }

    public static int[] findAnd(double[] x, int comparator1, double val1, int comparator2, double val2) {
        int[] indices = null;
        int[] indices1 = MathUtils.find(x, comparator1, val1);
        int[] indices2 = MathUtils.find(x, comparator2, val2);
        if (indices1 != null && indices2 != null) {
            int j;
            int i;
            int total = 0;
            block0: for (i = 0; i < indices1.length; ++i) {
                for (j = 0; j < indices2.length; ++j) {
                    if (indices1[i] != indices2[j]) continue;
                    ++total;
                    continue block0;
                }
            }
            if (total > 0) {
                indices = new int[total];
                int count = 0;
                for (i = 0; i < indices1.length; ++i) {
                    for (j = 0; j < indices2.length; ++j) {
                        if (indices1[i] != indices2[j]) continue;
                        indices[count++] = indices1[i];
                        break;
                    }
                    if (count >= total) break;
                }
            }
        }
        return indices;
    }

    public static int[] findOr(double[] x, int comparator1, double val1, int comparator2, double val2) {
        int[] indices = null;
        int[] indices1 = MathUtils.find(x, comparator1, val1);
        int[] indices2 = MathUtils.find(x, comparator2, val2);
        if (indices1 != null || indices2 != null) {
            int total = 0;
            if (indices1 != null) {
                total += indices1.length;
            }
            if (indices2 != null) {
                total += indices2.length;
            }
            int[] tmpIndices = new int[total];
            int currentPos = 0;
            if (indices1 != null) {
                System.arraycopy(indices1, 0, tmpIndices, 0, indices1.length);
                currentPos = indices1.length;
            }
            if (indices2 != null) {
                System.arraycopy(indices2, 0, tmpIndices, currentPos, indices2.length);
            }
            indices = StringUtils.getDifferentItemsList((int[])tmpIndices);
        }
        return indices;
    }

    public static double[] findValues(double[] x, int comparator, double val) {
        int[] inds = MathUtils.find(x, comparator, val);
        double[] vals = null;
        if (inds != null) {
            vals = new double[inds.length];
            for (int i = 0; i < inds.length; ++i) {
                vals[i] = x[inds[i]];
            }
        }
        return vals;
    }

    public static int[] find(double[] x, int comparator, double val) {
        int[] inds = null;
        int totalFound = 0;
        switch (comparator) {
            case 0: {
                int i;
                for (i = 0; i < x.length; ++i) {
                    if (x[i] != val) continue;
                    ++totalFound;
                }
                break;
            }
            case 1: {
                int i;
                for (i = 0; i < x.length; ++i) {
                    if (!(x[i] > val)) continue;
                    ++totalFound;
                }
                break;
            }
            case 2: {
                int i;
                for (i = 0; i < x.length; ++i) {
                    if (!(x[i] >= val)) continue;
                    ++totalFound;
                }
                break;
            }
            case 3: {
                int i;
                for (i = 0; i < x.length; ++i) {
                    if (!(x[i] < val)) continue;
                    ++totalFound;
                }
                break;
            }
            case 4: {
                int i;
                for (i = 0; i < x.length; ++i) {
                    if (!(x[i] <= val)) continue;
                    ++totalFound;
                }
                break;
            }
            case 5: {
                int i;
                for (i = 0; i < x.length; ++i) {
                    if (x[i] == val) continue;
                    ++totalFound;
                }
                break;
            }
        }
        if (totalFound > 0) {
            int currentInd = 0;
            inds = new int[totalFound];
            switch (comparator) {
                case 0: {
                    for (int i = 0; i < x.length; ++i) {
                        if (x[i] != val) continue;
                        inds[currentInd++] = i;
                        ++totalFound;
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < x.length; ++i) {
                        if (!(x[i] > val)) continue;
                        inds[currentInd++] = i;
                        ++totalFound;
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < x.length; ++i) {
                        if (!(x[i] >= val)) continue;
                        inds[currentInd++] = i;
                        ++totalFound;
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < x.length; ++i) {
                        if (!(x[i] < val)) continue;
                        inds[currentInd++] = i;
                        ++totalFound;
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < x.length; ++i) {
                        if (!(x[i] <= val)) continue;
                        inds[currentInd++] = i;
                        ++totalFound;
                    }
                    break;
                }
                case 5: {
                    for (int i = 0; i < x.length; ++i) {
                        if (x[i] == val) continue;
                        inds[currentInd++] = i;
                        ++totalFound;
                    }
                    break;
                }
            }
        }
        return inds;
    }

    public static double[] interpolate_linear(int[] x, double[] y, int[] xi) {
        assert (x.length == y.length);
        double[] yi = new double[xi.length];
        for (int i = 0; i < xi.length; ++i) {
            int j;
            boolean bFound = false;
            for (j = 0; j < x.length - 1; ++j) {
                if (xi[i] < x[j] || xi[i] >= x[j + 1]) continue;
                bFound = true;
                break;
            }
            if (!bFound) continue;
            double alpha = ((double)xi[i] - (double)x[j]) / (double)(x[j + 1] - x[j]);
            yi[i] = (1.0 - alpha) * y[j] + alpha * y[j + 1];
        }
        if (xi[xi.length - 1] == x[x.length - 1]) {
            yi[xi.length - 1] = y[x.length - 1];
        }
        return yi;
    }

    public static int CheckLimits(int val, int minVal, int maxVal) {
        int ret = val;
        if (ret < minVal) {
            ret = minVal;
        }
        if (ret > maxVal) {
            ret = maxVal;
        }
        return ret;
    }

    public static double CheckLimits(double val, double minVal, double maxVal) {
        double ret = val;
        if (ret < minVal) {
            ret = minVal;
        }
        if (ret > maxVal) {
            ret = maxVal;
        }
        return ret;
    }

    public static float CheckLimits(float val, float minVal, float maxVal) {
        float ret = val;
        if (ret < minVal) {
            ret = minVal;
        }
        if (ret > maxVal) {
            ret = maxVal;
        }
        return ret;
    }

    public static int[] getExtrema(double[] x, int numLeftN, int numRightN, boolean isMaxima) {
        return MathUtils.getExtrema(x, numLeftN, numRightN, isMaxima, 0);
    }

    public static int[] getExtrema(double[] x, int numLeftN, int numRightN, boolean isMaxima, int startInd) {
        return MathUtils.getExtrema(x, numLeftN, numRightN, isMaxima, startInd, x.length - 1);
    }

    public static int[] getExtrema(double[] x, int numLeftN, int numRightN, boolean isMaxima, int startInd, int endInd) {
        double th = isMaxima ? MathUtils.getMin(x) - 1.0 : MathUtils.getMax(x) + 1.0;
        return MathUtils.getExtrema(x, numLeftN, numRightN, isMaxima, startInd, endInd, th);
    }

    public static int[] getExtrema(double[] x, int numLeftN, int numRightN, boolean isMaxima, int startInd, int endInd, double th) {
        int[] numLeftNs = new int[x.length];
        int[] numRightNs = new int[x.length];
        Arrays.fill(numLeftNs, numLeftN);
        Arrays.fill(numRightNs, numRightN);
        return MathUtils.getExtrema(x, numLeftNs, numRightNs, isMaxima, startInd, endInd, th);
    }

    public static int[] getExtrema(double[] x, int[] numLeftNs, int[] numRightNs, boolean isMaxima) {
        return MathUtils.getExtrema(x, numLeftNs, numRightNs, isMaxima, 0);
    }

    public static int[] getExtrema(double[] x, int[] numLeftNs, int[] numRightNs, boolean isMaxima, int startInd) {
        return MathUtils.getExtrema(x, numLeftNs, numRightNs, isMaxima, startInd, x.length - 1);
    }

    public static int[] getExtrema(double[] x, int[] numLeftNs, int[] numRightNs, boolean isMaxima, int startInd, int endInd) {
        double th = isMaxima ? MathUtils.getMin(x) - 1.0 : MathUtils.getMax(x) + 1.0;
        return MathUtils.getExtrema(x, numLeftNs, numRightNs, isMaxima, startInd, endInd, th);
    }

    public static int[] getExtrema(double[] x, int[] numLeftNs, int[] numRightNs, boolean isMaxima, int startInd, int endInd, double th) {
        int[] tmpInds = new int[x.length];
        int[] inds = null;
        int total = 0;
        if (startInd < 0) {
            startInd = 0;
        }
        if (endInd > x.length - 1) {
            endInd = x.length - 1;
        }
        if (startInd > endInd) {
            startInd = endInd;
        }
        if (isMaxima) {
            for (int i = startInd; i <= endInd; ++i) {
                boolean bExtremum;
                if (x[i] > th) {
                    bExtremum = true;
                    if (numLeftNs == null || i - numLeftNs[i] >= 0) {
                        int j;
                        if (numLeftNs != null) {
                            for (j = i - numLeftNs[i]; j < i; ++j) {
                                if (!(x[i] < x[j])) continue;
                                bExtremum = false;
                                break;
                            }
                        }
                        if (bExtremum && numRightNs != null) {
                            if (i + numRightNs[i] < x.length) {
                                for (j = i + 1; j <= i + numRightNs[i]; ++j) {
                                    if (!(x[i] < x[j])) continue;
                                    bExtremum = false;
                                    break;
                                }
                            } else {
                                bExtremum = false;
                            }
                        }
                    } else {
                        bExtremum = false;
                    }
                } else {
                    bExtremum = false;
                }
                if (!bExtremum) continue;
                tmpInds[total++] = i;
            }
        } else {
            for (int i = startInd; i <= endInd; ++i) {
                boolean bExtremum;
                if (x[i] < th) {
                    bExtremum = true;
                    if (numLeftNs == null || i - numLeftNs[i] >= 0) {
                        int j;
                        if (numLeftNs != null) {
                            for (j = i - numLeftNs[i]; j < i; ++j) {
                                if (!(x[i] > x[j])) continue;
                                bExtremum = false;
                                break;
                            }
                        }
                        if (bExtremum && numRightNs != null) {
                            if (i + numRightNs[i] < x.length) {
                                for (j = i + 1; j <= i + numRightNs[i]; ++j) {
                                    if (!(x[i] > x[j])) continue;
                                    bExtremum = false;
                                    break;
                                }
                            } else {
                                bExtremum = false;
                            }
                        }
                    } else {
                        bExtremum = false;
                    }
                } else {
                    bExtremum = false;
                }
                if (!bExtremum) continue;
                tmpInds[total++] = i;
            }
        }
        if (total > 0) {
            inds = new int[total];
            System.arraycopy(tmpInds, 0, inds, 0, total);
        }
        return inds;
    }

    public static double[] getRandoms(int len) {
        return MathUtils.getRandoms(len, 0.0, 1.0);
    }

    public static double[] getRandoms(int len, double minVal, double maxVal) {
        double[] x = null;
        if (len > 0) {
            x = new double[len];
            if (minVal > maxVal) {
                double tmp = minVal;
                minVal = maxVal;
                maxVal = tmp;
            }
            for (int i = 0; i < len; ++i) {
                x[i] = Math.random() * (maxVal - minVal) + minVal;
            }
        }
        return x;
    }

    public static int findClosest(float[] x, float val) {
        int ind = -1;
        if (x != null && x.length > 0) {
            float minDiff = Math.abs(x[0] - val);
            ind = 0;
            for (int i = 1; i < x.length; ++i) {
                float tmpDiff = Math.abs(x[i] - val);
                if (!(tmpDiff < minDiff)) continue;
                minDiff = tmpDiff;
                ind = i;
            }
        }
        return ind;
    }

    public static int findClosest(int[] x, int val) {
        int ind = -1;
        if (x != null && x.length > 0) {
            int minDiff = Math.abs(x[0] - val);
            ind = 0;
            for (int i = 1; i < x.length; ++i) {
                int tmpDiff = Math.abs(x[i] - val);
                if (tmpDiff >= minDiff) continue;
                minDiff = tmpDiff;
                ind = i;
            }
        }
        return ind;
    }

    public static float unwrap(float phaseInRadians, float prevPhaseInRadians) {
        float unwrappedPhaseInRadians = phaseInRadians;
        while ((double)Math.abs(unwrappedPhaseInRadians - prevPhaseInRadians) > Math.PI) {
            if (unwrappedPhaseInRadians > prevPhaseInRadians) {
                unwrappedPhaseInRadians = (float)((double)unwrappedPhaseInRadians - Math.PI * 2);
                continue;
            }
            unwrappedPhaseInRadians = (float)((double)unwrappedPhaseInRadians + Math.PI * 2);
        }
        return unwrappedPhaseInRadians;
    }

    public static float unwrapToRange(float phaseInDegrees, float lowestDegree) {
        float retVal;
        block3: {
            block2: {
                retVal = phaseInDegrees;
                if (!(retVal < lowestDegree)) break block2;
                while (retVal < lowestDegree) {
                    retVal += 360.0f;
                }
                break block3;
            }
            if (!(retVal >= lowestDegree + 360.0f)) break block3;
            while (retVal >= lowestDegree + 360.0f) {
                retVal -= 360.0f;
            }
        }
        return retVal;
    }

    public static double db2neper(double db) {
        return 20.0 * db / Math.log(10.0);
    }

    public static double[] db2neper(double[] dbs) {
        double[] nepers = null;
        if (dbs != null && dbs.length > 0) {
            nepers = new double[dbs.length];
            for (int i = 0; i < nepers.length; ++i) {
                nepers[i] = MathUtils.db2neper(dbs[i]);
            }
        }
        return nepers;
    }

    public static double neper2db(double neper) {
        return neper * Math.log(10.0) / 20.0;
    }

    public static double[] neper2db(double[] nepers) {
        double[] dbs = null;
        if (nepers != null && nepers.length > 0) {
            dbs = new double[nepers.length];
            for (int i = 0; i < dbs.length; ++i) {
                dbs[i] = MathUtils.neper2db(nepers[i]);
            }
        }
        return dbs;
    }

    public static double neper2linear(double neper) {
        return Math.exp(neper);
    }

    public static double[] neper2linear(double[] nepers) {
        double[] lins = null;
        if (nepers != null && nepers.length > 0) {
            lins = new double[nepers.length];
            for (int i = 0; i < lins.length; ++i) {
                lins[i] = MathUtils.neper2linear(nepers[i]);
            }
        }
        return lins;
    }

    public static float[] sinc(float[] x, float N) {
        float[] y = null;
        if (x.length > 0) {
            y = new float[x.length];
            for (int i = 0; i < y.length; ++i) {
                y[i] = MathUtils.sinc(x[i], N);
            }
        }
        return y;
    }

    public static float sinc(float x, float N) {
        return (float)(Math.sin((double)N * 0.5 * (double)x) / ((double)N * Math.sin(0.5 * (double)x)));
    }

    public static double sinc(double x, double N) {
        return Math.sin(N * 0.5 * x) / (N * Math.sin(0.5 * x));
    }

    public static float[] sinc(float[] x) {
        float[] y = null;
        if (x.length > 0) {
            y = new float[x.length];
            for (int i = 0; i < y.length; ++i) {
                y[i] = MathUtils.sinc(2.0f * x[i], (float)Math.PI);
            }
        }
        return y;
    }

    public static double[] sinc(double[] x) {
        double[] y = null;
        if (x.length > 0) {
            y = new double[x.length];
            for (int i = 0; i < y.length; ++i) {
                y[i] = MathUtils.sinc(2.0 * x[i], Math.PI);
            }
        }
        return y;
    }

    public static float sinc(float x) {
        return MathUtils.sinc(2.0f * x, (float)Math.PI);
    }

    public static double sinc(double x) {
        return MathUtils.sinc(2.0 * x, Math.PI);
    }

    public static double getSortedValue(double[] x, double percentSmallerThan) {
        int retInd = -1;
        Vector<Double> v = new Vector<Double>();
        for (int i = 0; i < x.length; ++i) {
            v.add(x[i]);
        }
        Collections.sort(v);
        int index = (int)Math.floor(percentSmallerThan / 100.0 * (double)(x.length - 1) + 0.5);
        index = Math.max(0, index);
        index = Math.min(index, x.length - 1);
        return (Double)v.get(index);
    }

    public static int[][] factorialDesign(int[] totalItemsInNodes) {
        int i;
        int totalPaths = 1;
        for (i = 0; i < totalItemsInNodes.length; ++i) {
            if (totalItemsInNodes[i] <= 0) continue;
            totalPaths *= totalItemsInNodes[i];
        }
        int[][] pathInds = new int[totalPaths][totalItemsInNodes.length];
        int[] currentPath = new int[totalItemsInNodes.length];
        int count = 0;
        Arrays.fill(currentPath, 0);
        System.arraycopy(currentPath, 0, pathInds[count++], 0, currentPath.length);
        while (count < totalPaths) {
            for (i = currentPath.length - 1; i >= 0; --i) {
                if (currentPath[i] + 1 < Math.max(1, totalItemsInNodes[i])) {
                    int n = i;
                    currentPath[n] = currentPath[n] + 1;
                    break;
                }
                currentPath[i] = 0;
            }
            System.arraycopy(currentPath, 0, pathInds[count], 0, currentPath.length);
            ++count;
        }
        return pathInds;
    }

    public static float linearMap(float x, float xStart, float xEnd, float yStart, float yEnd) {
        return (x - xStart) / (xEnd - xStart) * (yEnd - yStart) + yStart;
    }

    public static double linearMap(double x, double xStart, double xEnd, double yStart, double yEnd) {
        return (x - xStart) / (xEnd - xStart) * (yEnd - yStart) + yStart;
    }

    public static int linearMap(int x, int xStart, int xEnd, int yStart, int yEnd) {
        return (int)Math.floor(((double)x - (double)xStart) / ((double)xEnd - (double)xStart) * (double)(yEnd - yStart) + (double)yStart + 0.5);
    }

    public static int[] quickSort(int[] x) {
        int i;
        double[] x2 = new double[x.length];
        for (i = 0; i < x.length; ++i) {
            x2[i] = x[i];
        }
        int[] inds = MathUtils.quickSort(x2);
        for (i = 0; i < x.length; ++i) {
            x[i] = (int)x2[i];
        }
        return inds;
    }

    public static int[] quickSort(double[] x) {
        int[] indices = new int[x.length];
        for (int i = 0; i < x.length; ++i) {
            indices[i] = i;
        }
        MathUtils.quickSort(x, indices);
        return indices;
    }

    public static int[] quickSort(float[] x) {
        int[] indices = new int[x.length];
        for (int i = 0; i < x.length; ++i) {
            indices[i] = i;
        }
        MathUtils.quickSort(x, indices);
        return indices;
    }

    public static int[] quickSort(double[] x, int startIndex, int endIndex) {
        int i;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (startIndex > x.length - 1) {
            startIndex = x.length - 1;
        }
        if (endIndex < startIndex) {
            endIndex = startIndex;
        }
        if (endIndex > x.length - 1) {
            endIndex = x.length - 1;
        }
        int[] indices = new int[endIndex - startIndex + 1];
        double[] x2 = new double[endIndex - startIndex + 1];
        for (i = startIndex; i <= endIndex; ++i) {
            indices[i - startIndex] = i;
            x2[i - startIndex] = x[i];
        }
        MathUtils.quickSort(x2, indices);
        for (i = startIndex; i <= endIndex; ++i) {
            x[i] = x2[i - startIndex];
        }
        return indices;
    }

    public static int[] quickSort(float[] x, int startIndex, int endIndex) {
        int i;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (startIndex > x.length - 1) {
            startIndex = x.length - 1;
        }
        if (endIndex < startIndex) {
            endIndex = startIndex;
        }
        if (endIndex > x.length - 1) {
            endIndex = x.length - 1;
        }
        int[] indices = new int[endIndex - startIndex + 1];
        float[] x2 = new float[endIndex - startIndex + 1];
        for (i = startIndex; i <= endIndex; ++i) {
            indices[i - startIndex] = i;
            x2[i - startIndex] = x[i];
        }
        MathUtils.quickSort(x2, indices);
        for (i = startIndex; i <= endIndex; ++i) {
            x[i] = x2[i - startIndex];
        }
        return indices;
    }

    public static void quickSort(double[] x, int[] y) {
        assert (x.length == y.length);
        MathUtils.quickSort(x, y, 0, x.length - 1);
    }

    public static void quickSort(float[] x, int[] y) {
        assert (x.length == y.length);
        MathUtils.quickSort(x, y, 0, x.length - 1);
    }

    public static void quickSort(double[] x, int[] y, int startIndex, int endIndex) {
        if (startIndex < endIndex) {
            int j = MathUtils.partition(x, y, startIndex, endIndex);
            MathUtils.quickSort(x, y, startIndex, j - 1);
            MathUtils.quickSort(x, y, j + 1, endIndex);
        }
    }

    public static void quickSort(float[] x, int[] y, int startIndex, int endIndex) {
        if (startIndex < endIndex) {
            int j = MathUtils.partition(x, y, startIndex, endIndex);
            MathUtils.quickSort(x, y, startIndex, j - 1);
            MathUtils.quickSort(x, y, j + 1, endIndex);
        }
    }

    private static int partition(double[] x, int[] y, int startIndex, int endIndex) {
        int ty;
        double t;
        int i = startIndex;
        int j = endIndex + 1;
        double pivot = x[startIndex];
        while (true) {
            if (++i <= endIndex && x[i] <= pivot) {
                continue;
            }
            while (x[--j] > pivot) {
            }
            if (i >= j) break;
            t = x[i];
            ty = y[i];
            x[i] = x[j];
            y[i] = y[j];
            x[j] = t;
            y[j] = ty;
        }
        t = x[startIndex];
        ty = y[startIndex];
        x[startIndex] = x[j];
        y[startIndex] = y[j];
        x[j] = t;
        y[j] = ty;
        return j;
    }

    private static int partition(float[] x, int[] y, int startIndex, int endIndex) {
        int ty;
        float t;
        int i = startIndex;
        int j = endIndex + 1;
        float pivot = x[startIndex];
        while (true) {
            if (++i <= endIndex && x[i] <= pivot) {
                continue;
            }
            while (x[--j] > pivot) {
            }
            if (i >= j) break;
            t = x[i];
            ty = y[i];
            x[i] = x[j];
            y[i] = y[j];
            x[j] = t;
            y[j] = ty;
        }
        t = x[startIndex];
        ty = y[startIndex];
        x[startIndex] = x[j];
        y[startIndex] = y[j];
        x[j] = t;
        y[j] = ty;
        return j;
    }

    public static double[] sortAs(double[] x, int[] sortedIndices) {
        if (x == null) {
            return null;
        }
        if (sortedIndices == null) {
            return ArrayUtils.copy(x);
        }
        assert (x.length == sortedIndices.length);
        double[] y = new double[x.length];
        for (int i = 0; i < sortedIndices.length; ++i) {
            y[i] = x[sortedIndices[i]];
        }
        return y;
    }

    public static float[] sortAs(float[] x, int[] sortedIndices) {
        if (x == null) {
            return null;
        }
        if (sortedIndices == null) {
            return ArrayUtils.copy(x);
        }
        assert (x.length == sortedIndices.length);
        float[] y = new float[x.length];
        for (int i = 0; i < sortedIndices.length; ++i) {
            y[i] = x[sortedIndices[i]];
        }
        return y;
    }

    public static double[] normalizeZscore(double[] x) {
        double mn = MathUtils.mean(x, 0);
        double sd = MathUtils.standardDeviation(x, 0);
        for (int i = 0; i < x.length; ++i) {
            if (Double.isNaN(x[i])) continue;
            x[i] = (x[i] - mn) / sd;
        }
        return x;
    }

    public static double[] normalizeToSumUpTo(double[] x, double sumUp) {
        return MathUtils.normalizeToSumUpTo(x, x.length, sumUp);
    }

    public static double[] normalizeToSumUpTo(double[] x, int len, double sumUp) {
        int i;
        if (len > x.length) {
            len = x.length;
        }
        double[] y = new double[len];
        double total = 0.0;
        for (i = 0; i < len; ++i) {
            total += x[i];
        }
        if (total > 0.0) {
            for (i = 0; i < len; ++i) {
                y[i] = sumUp * (x[i] / total);
            }
        } else {
            for (i = 0; i < len; ++i) {
                y[i] = 1.0 / (double)len;
            }
        }
        return y;
    }

    public static double[] normalizeToRange(double[] x, int len, double minVal, double maxVal) {
        if (len > x.length) {
            len = x.length;
        }
        double[] y = new double[len];
        double xmin = MathUtils.min(x);
        double xmax = MathUtils.max(x);
        if (xmax > xmin) {
            for (int i = 0; i < len; ++i) {
                y[i] = (x[i] - xmin) / (xmax - xmin) * (maxVal - minVal) + minVal;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                y[i] = x[i] - xmin + 0.5 * (minVal + maxVal);
            }
        }
        return y;
    }

    public static double[] normalizeToAbsMax(double[] x, double absMax) {
        double[] y = new double[x.length];
        double currentAbsMax = MathUtils.getAbsMax(x);
        for (int i = 0; i < x.length; ++i) {
            y[i] = x[i] * absMax / currentAbsMax;
        }
        return y;
    }

    public static void adjustMean(double[] x, double newMean) {
        double currentMean = MathUtils.mean(x);
        for (int i = 0; i < x.length; ++i) {
            x[i] = x[i] - currentMean + newMean;
        }
    }

    public static void adjustVariance(double[] x, double newVariance) {
        MathUtils.adjustStandardDeviation(x, Math.sqrt(newVariance));
    }

    public static void adjustMeanVariance(double[] x, double newMean, double newVariance) {
        MathUtils.adjustMeanStandardDeviation(x, newMean, Math.sqrt(newVariance));
    }

    public static void adjustVariance(double[] x, double newVariance, double currentMean) {
        MathUtils.adjustStandardDeviation(x, Math.sqrt(newVariance), currentMean);
    }

    public static void adjustMeanStandardDeviation(double[] x, double newMean, double newStandardDeviation) {
        MathUtils.adjustMeanStandardDeviation(x, MathUtils.mean(x), newMean, newStandardDeviation);
    }

    public static void adjustStandardDeviation(double[] x, double newStandardDeviation) {
        double currentMean = MathUtils.mean(x);
        MathUtils.adjustStandardDeviation(x, newStandardDeviation, currentMean);
    }

    public static void adjustStandardDeviation(double[] x, double newStandardDeviation, double currentMean) {
        double currentStdDev = MathUtils.standardDeviation(x, currentMean);
        for (int i = 0; i < x.length; ++i) {
            x[i] = (x[i] - currentMean) * newStandardDeviation / currentStdDev + currentMean;
        }
    }

    public static void adjustMeanStandardDeviation(double[] x, double currentMean, double newMean, double newStandardDeviation) {
        double currentStdDev = MathUtils.standardDeviation(x, currentMean);
        for (int i = 0; i < x.length; ++i) {
            x[i] = (x[i] - currentMean) * newStandardDeviation / currentStdDev + newMean;
        }
    }

    public static void adjustRange(double[] x, double minVal, double maxVal) {
        double minOrig = MathUtils.min(x);
        double maxOrig = MathUtils.max(x);
        double diffOrig = maxOrig - minOrig;
        if (diffOrig > 0.0) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = (x[i] - minOrig) / diffOrig * (maxVal - minVal) + minVal;
            }
        } else {
            for (int i = 0; i < x.length; ++i) {
                x[i] = 0.5 * (maxVal + minVal);
            }
        }
    }

    public static boolean clipRange(double[] x, double minVal, double maxVal) {
        boolean modified = false;
        if (x == null) {
            return modified;
        }
        for (int i = 0; i < x.length; ++i) {
            if (x[i] < minVal) {
                x[i] = minVal;
                modified = true;
                continue;
            }
            if (!(x[i] > maxVal)) continue;
            x[i] = maxVal;
            modified = true;
        }
        return modified;
    }

    public static double median(double[] x) {
        if (x != null && x.length > 0) {
            return MathUtils.median(x, 0, x.length - 1);
        }
        return 0.0;
    }

    public static double median(double[] xin, int firstIndex, int lastIndex) {
        if (firstIndex < 0) {
            firstIndex = 0;
        }
        if (lastIndex > xin.length - 1) {
            lastIndex = xin.length - 1;
        }
        if (lastIndex < firstIndex) {
            lastIndex = firstIndex;
        }
        double[] x = new double[lastIndex - firstIndex + 1];
        System.arraycopy(xin, firstIndex, x, 0, x.length);
        MathUtils.quickSort(x);
        int index = (int)Math.floor(0.5 * (double)x.length + 0.5);
        if (index < 0) {
            index = 0;
        }
        if (index > x.length - 1) {
            index = x.length - 1;
        }
        return x[index];
    }

    public static double absMean(double[] x) {
        double m = 0.0;
        for (int i = 0; i < x.length; ++i) {
            m += Math.abs(x[i]);
        }
        return m /= (double)x.length;
    }

    public static double[] getVarianceRows(double[][] x) {
        double[] variances = null;
        if (x != null) {
            variances = new double[x.length];
            for (int i = 0; i < x.length; ++i) {
                variances[i] = MathUtils.variance(x[i]);
            }
        }
        return variances;
    }

    public static double[] getVarianceCols(double[][] x) {
        double[] variances = null;
        if (x != null) {
            variances = new double[x[0].length];
            double[] tmp = new double[x.length];
            for (int j = 0; j < x[0].length; ++j) {
                for (int i = 0; i < x.length; ++i) {
                    tmp[i] = x[i][j];
                }
                variances[j] = MathUtils.variance(tmp);
            }
        }
        return variances;
    }

    public static double getGaussianPdfValueConstantTerm(int featureDimension, double detCovarianceMatrix) {
        double constantTerm = Math.pow(Math.PI * 2, 0.5 * (double)featureDimension);
        constantTerm *= Math.sqrt(detCovarianceMatrix);
        constantTerm = 1.0 / constantTerm;
        return constantTerm;
    }

    public static double getGaussianPdfValueConstantTermLog(int featureDimension, double detCovarianceMatrix) {
        double constantTermLog = 0.5 * (double)featureDimension * Math.log(Math.PI * 2);
        constantTermLog += Math.log(Math.sqrt(detCovarianceMatrix));
        constantTermLog = -constantTermLog;
        return constantTermLog;
    }

    public static double getGaussianPdfValue(double[] x, double[] meanVector, double[] covarianceMatrix) {
        double constantTerm = MathUtils.getGaussianPdfValueConstantTerm(x.length, MathUtils.determinant(covarianceMatrix));
        return MathUtils.getGaussianPdfValue(x, meanVector, covarianceMatrix, constantTerm);
    }

    public static double getGaussianPdfValue(double[] x, double[] meanVector, double[] covarianceMatrix, double constantTerm) {
        double P = 0.0;
        for (int i = 0; i < x.length; ++i) {
            P += (x[i] - meanVector[i]) * (x[i] - meanVector[i]) / covarianceMatrix[i];
        }
        P *= -0.5;
        P = constantTerm * Math.exp(P);
        return P;
    }

    public static double getGaussianPdfValueLog(double[] x, double[] meanVector, double[] covarianceMatrix, double constantTermLog) {
        double P = Double.MIN_VALUE;
        for (int i = 0; i < x.length; ++i) {
            double z = (x[i] - meanVector[i]) * (x[i] - meanVector[i]);
            P = MathUtils.logAdd(P, Math.log(z) - Math.log(covarianceMatrix[i]));
        }
        P *= -0.5;
        P = constantTermLog + P;
        return P;
    }

    public static double getGaussianPdfValue(double[] x, double[] meanVector, double detCovarianceMatrix, double[][] inverseCovarianceMatrix) {
        double constantTerm = Math.pow(Math.PI * 2, 0.5 * (double)x.length);
        constantTerm *= Math.sqrt(detCovarianceMatrix);
        constantTerm = 1.0 / constantTerm;
        return MathUtils.getGaussianPdfValue(x, meanVector, inverseCovarianceMatrix, constantTerm);
    }

    public static double getGaussianPdfValue(double[] x, double[] meanVector, double[][] inverseCovarianceMatrix, double constantTerm) {
        double[][] z = new double[1][x.length];
        z[0] = MathUtils.subtract(x, meanVector);
        double[][] zT = MathUtils.transpoze(z);
        double[][] prod = MathUtils.matrixProduct(MathUtils.matrixProduct(z, inverseCovarianceMatrix), zT);
        double P = -0.5 * prod[0][0];
        P = constantTerm * Math.exp(P);
        return P;
    }

    public static double determinant(double[] diagonal) {
        double det = 1.0;
        for (int i = 0; i < diagonal.length; ++i) {
            det *= diagonal[i];
        }
        return det;
    }

    public static double determinant(double[][] matrix) {
        double result = 0.0;
        if (matrix.length == 1) {
            return MathUtils.determinant(matrix[0]);
        }
        if (matrix.length == 1 && matrix[0].length == 1) {
            return matrix[0][0];
        }
        if (matrix.length == 2) {
            result = matrix[0][0] * matrix[1][1] - matrix[0][1] * matrix[1][0];
            return result;
        }
        for (int i = 0; i < matrix[0].length; ++i) {
            double[][] temp = new double[matrix.length - 1][matrix[0].length - 1];
            for (int j = 1; j < matrix.length; ++j) {
                for (int k = 0; k < matrix[0].length; ++k) {
                    if (k < i) {
                        temp[j - 1][k] = matrix[j][k];
                        continue;
                    }
                    if (k <= i) continue;
                    temp[j - 1][k - 1] = matrix[j][k];
                }
            }
            result += matrix[0][i] * Math.pow(-1.0, i) * MathUtils.determinant(temp);
        }
        return result;
    }

    public static double[] random(int numSamples) {
        double[] x = null;
        if (numSamples > 0) {
            x = new double[numSamples];
            for (int i = 0; i < numSamples; ++i) {
                x[i] = Math.random();
            }
        }
        return x;
    }

    public static double[] random(int numSamples, double minVal, double maxVal) {
        double[] x = MathUtils.random(numSamples);
        MathUtils.adjustRange(x, minVal, maxVal);
        return x;
    }

    public static double[] inverse(double[] x) {
        double[] invx = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            invx[i] = 1.0 / ((double)x.length * x[i]);
        }
        return invx;
    }

    public static ComplexNumber[] inverse(ComplexNumber[] x) {
        ComplexNumber[] invx = new ComplexNumber[x.length];
        for (int i = 0; i < x.length; ++i) {
            invx[i] = MathUtils.divide(1.0, MathUtils.multiply((double)x.length, x[i]));
        }
        return invx;
    }

    public static double[][] inverse(double[][] matrix) {
        double[][] invMatrix = null;
        if (matrix.length == 1) {
            invMatrix = new double[1][matrix[0].length];
            invMatrix[0] = MathUtils.inverse(matrix[0]);
        } else {
            invMatrix = new double[matrix.length][matrix.length];
            for (int i = 0; i < matrix.length; ++i) {
                System.arraycopy(matrix[i], 0, invMatrix[i], 0, matrix[i].length);
            }
            MathUtils.inverseInPlace(invMatrix);
        }
        return invMatrix;
    }

    public static ComplexNumber[][] inverse(ComplexNumber[][] matrix) {
        ComplexNumber[][] invMatrix = null;
        if (matrix.length == 1) {
            invMatrix = new ComplexNumber[1][matrix[0].length];
            invMatrix[0] = MathUtils.inverse(matrix[0]);
        } else {
            invMatrix = new ComplexNumber[matrix.length][matrix.length];
            for (int i = 0; i < matrix.length; ++i) {
                for (int j = 0; j < matrix[i].length; ++j) {
                    invMatrix[i][j] = new ComplexNumber(matrix[i][j]);
                }
            }
            MathUtils.inverseInPlace(invMatrix);
        }
        return invMatrix;
    }

    public static void inverseInPlace(double[][] matrix) {
        int i;
        int dim = matrix.length;
        double[] d = new double[1];
        double[][] y = new double[dim][dim];
        int[] indices = new int[dim];
        double[] col = new double[dim];
        MathUtils.luDecompose(matrix, dim, indices, d);
        for (int j = 0; j < dim; ++j) {
            for (i = 0; i < dim; ++i) {
                col[i] = 0.0;
            }
            col[j] = 1.0;
            MathUtils.luSubstitute(matrix, indices, col);
            for (i = 0; i < dim; ++i) {
                y[i][j] = col[i];
            }
        }
        for (i = 0; i < dim; ++i) {
            System.arraycopy(y[i], 0, matrix[i], 0, dim);
        }
    }

    public static void inverseInPlace(ComplexNumber[][] matrix) {
        int i;
        int j;
        int dim = matrix.length;
        ComplexNumber[] d = new ComplexNumber[1];
        ComplexNumber[][] y = new ComplexNumber[dim][dim];
        int[] indices = new int[dim];
        ComplexNumber[] col = new ComplexNumber[dim];
        MathUtils.luDecompose(matrix, dim, indices, d);
        for (j = 0; j < dim; ++j) {
            for (i = 0; i < dim; ++i) {
                col[i] = new ComplexNumber(0.0, 0.0);
            }
            col[j] = new ComplexNumber(1.0, 0.0);
            MathUtils.luSubstitute(matrix, indices, col);
            for (i = 0; i < dim; ++i) {
                y[i][j] = new ComplexNumber(col[i]);
            }
        }
        for (i = 0; i < dim; ++i) {
            for (j = 0; j < dim; ++j) {
                matrix[i][j] = new ComplexNumber(y[i][j]);
            }
        }
    }

    public static void luDecompose(double[][] a, int n, int[] indx, double[] d) {
        int j;
        double big;
        int i;
        double TINYVAL = 1.0E-20;
        int imax = 0;
        double[] vv = new double[n];
        d[0] = 1.0;
        for (i = 1; i <= n; ++i) {
            big = 0.0;
            for (j = 1; j <= n; ++j) {
                double d2;
                double temp = Math.abs(a[i - 1][j - 1]);
                if (!(d2 > big)) continue;
                big = temp;
            }
            if (big == 0.0) {
                System.out.println("Singular matrix in routine ludcmp");
            }
            vv[i - 1] = 1.0 / big;
        }
        for (j = 1; j <= n; ++j) {
            double dum;
            int k;
            double sum;
            for (i = 1; i < j; ++i) {
                sum = a[i - 1][j - 1];
                for (k = 1; k < i; ++k) {
                    sum -= a[i - 1][k - 1] * a[k - 1][j - 1];
                }
                a[i - 1][j - 1] = sum;
            }
            big = 0.0;
            for (i = j; i <= n; ++i) {
                double d3;
                sum = a[i - 1][j - 1];
                for (k = 1; k < j; ++k) {
                    sum -= a[i - 1][k - 1] * a[k - 1][j - 1];
                }
                a[i - 1][j - 1] = sum;
                dum = vv[i - 1] * Math.abs(sum);
                if (!(d3 >= big)) continue;
                big = dum;
                imax = i;
            }
            if (j != imax) {
                for (k = 1; k <= n; ++k) {
                    dum = a[imax - 1][k - 1];
                    a[imax - 1][k - 1] = a[j - 1][k - 1];
                    a[j - 1][k - 1] = dum;
                }
                d[0] = -d[0];
                vv[imax - 1] = vv[j - 1];
            }
            indx[j - 1] = imax;
            if (a[j - 1][j - 1] == 0.0) {
                a[j - 1][j - 1] = TINYVAL;
            }
            if (j == n) continue;
            dum = 1.0 / a[j - 1][j - 1];
            for (i = j + 1; i <= n; ++i) {
                double[] dArray = a[i - 1];
                int n2 = j - 1;
                dArray[n2] = dArray[n2] * dum;
            }
        }
    }

    public static void luDecompose(ComplexNumber[][] a, int n, int[] indx, ComplexNumber[] d) {
        int j;
        int i;
        double TINYVAL = 1.0E-20;
        ComplexNumber big = new ComplexNumber(0.0, 0.0);
        ComplexNumber dum = new ComplexNumber(0.0, 0.0);
        ComplexNumber sum = new ComplexNumber(0.0, 0.0);
        ComplexNumber temp = new ComplexNumber(0.0, 0.0);
        int imax = 0;
        ComplexNumber[] vv = new ComplexNumber[n];
        d[0] = new ComplexNumber(1.0, 0.0);
        for (i = 1; i <= n; ++i) {
            big = new ComplexNumber(0.0, 0.0);
            for (j = 1; j <= n; ++j) {
                if (!(MathUtils.magnitudeComplex(a[i - 1][j - 1]) > MathUtils.magnitudeComplex(big))) continue;
                big = new ComplexNumber(a[i - 1][j - 1]);
            }
            if (MathUtils.magnitudeComplex(big) == 0.0) {
                System.out.println("Singular matrix in routine ludcmp");
            }
            vv[i - 1] = MathUtils.divide(1.0, big);
        }
        for (j = 1; j <= n; ++j) {
            int k;
            for (i = 1; i < j; ++i) {
                sum = new ComplexNumber(a[i - 1][j - 1]);
                for (k = 1; k < i; ++k) {
                    sum = MathUtils.subtractComplex(sum, MathUtils.multiplyComplex(a[i - 1][k - 1], a[k - 1][j - 1]));
                }
                a[i - 1][j - 1] = new ComplexNumber(sum);
            }
            big = new ComplexNumber(0.0, 0.0);
            for (i = j; i <= n; ++i) {
                sum = new ComplexNumber(a[i - 1][j - 1]);
                for (k = 1; k < j; ++k) {
                    sum = MathUtils.subtractComplex(sum, MathUtils.multiplyComplex(a[i - 1][k - 1], a[k - 1][j - 1]));
                }
                a[i - 1][j - 1] = new ComplexNumber(sum);
                dum = MathUtils.multiply(MathUtils.magnitudeComplex(sum), vv[i - 1]);
                if (!(MathUtils.magnitudeComplex(dum) >= MathUtils.magnitudeComplex(big))) continue;
                big = new ComplexNumber(dum);
                imax = i;
            }
            if (j != imax) {
                for (k = 1; k <= n; ++k) {
                    dum = new ComplexNumber(a[imax - 1][k - 1]);
                    a[imax - 1][k - 1] = new ComplexNumber(a[j - 1][k - 1]);
                    a[j - 1][k - 1] = new ComplexNumber(dum);
                }
                d[0] = MathUtils.multiply(-1.0, d[0]);
                vv[imax - 1] = new ComplexNumber(vv[j - 1]);
            }
            indx[j - 1] = imax;
            if (MathUtils.magnitudeComplex(a[j - 1][j - 1]) == 0.0) {
                a[j - 1][j - 1] = new ComplexNumber(TINYVAL, TINYVAL);
            }
            if (j == n) continue;
            dum = MathUtils.divide(1.0, a[j - 1][j - 1]);
            for (i = j + 1; i <= n; ++i) {
                a[i - 1][j - 1] = MathUtils.multiplyComplex(dum, a[i - 1][j - 1]);
            }
        }
    }

    public static void luSubstitute(double[][] a, int[] indx, double[] b) {
        int j;
        double sum;
        int n = a.length;
        int i = 0;
        int ii = 0;
        for (i = 1; i <= n; ++i) {
            int ip = indx[i - 1];
            sum = b[ip - 1];
            b[ip - 1] = b[i - 1];
            if (ii != 0) {
                for (j = ii; j <= i - 1; ++j) {
                    sum -= a[i - 1][j - 1] * b[j - 1];
                }
            } else if (sum != 0.0) {
                ii = i;
            }
            b[i - 1] = sum;
        }
        for (i = n; i >= 1; --i) {
            sum = b[i - 1];
            for (j = i + 1; j <= n; ++j) {
                sum -= a[i - 1][j - 1] * b[j - 1];
            }
            b[i - 1] = sum / a[i - 1][i - 1];
        }
    }

    public static void luSubstitute(ComplexNumber[][] a, int[] indx, ComplexNumber[] b) {
        int j;
        int n = a.length;
        int i = 0;
        int ii = 0;
        ComplexNumber sum = new ComplexNumber(0.0, 0.0);
        for (i = 1; i <= n; ++i) {
            int ip = indx[i - 1];
            sum = new ComplexNumber(b[ip - 1]);
            b[ip - 1] = new ComplexNumber(b[i - 1]);
            if (ii != 0) {
                for (j = ii; j <= i - 1; ++j) {
                    sum = MathUtils.subtractComplex(sum, MathUtils.multiplyComplex(a[i - 1][j - 1], b[j - 1]));
                }
            } else if (MathUtils.magnitudeComplex(sum) != 0.0) {
                ii = i;
            }
            b[i - 1] = new ComplexNumber(sum);
        }
        for (i = n; i >= 1; --i) {
            sum = new ComplexNumber(b[i - 1]);
            for (j = i + 1; j <= n; ++j) {
                sum = MathUtils.subtractComplex(sum, MathUtils.multiplyComplex(a[i - 1][j - 1], b[j - 1]));
            }
            b[i - 1] = MathUtils.divideComplex(sum, a[i - 1][i - 1]);
        }
    }

    public static double logAdd(double x, double y) {
        if (y > x) {
            double temp = x;
            x = y;
            y = temp;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return x;
        }
        double negDiff = y - x;
        if (negDiff < -20.0) {
            return x;
        }
        return x + Math.log(1.0 + Math.exp(negDiff));
    }

    public static int getLargestIndexSmallerThan(double[] x, double val) {
        int index = -1;
        if (x != null) {
            int i = 0;
            while (i < x.length && x[i] < val) {
                index = i++;
            }
        }
        return index;
    }

    public static int[] randomSort(int[] x) {
        int[] tmpx = new int[x.length];
        int[] y = new int[x.length];
        System.arraycopy(x, 0, tmpx, 0, x.length);
        for (int i = 1; i < x.length; ++i) {
            int ind = (int)(Math.random() * (double)tmpx.length);
            if (ind > tmpx.length - 1) {
                ind = tmpx.length - 1;
            }
            y[i - 1] = tmpx[ind];
            int[] tmpx2 = new int[tmpx.length - 1];
            System.arraycopy(tmpx, 0, tmpx2, 0, ind);
            System.arraycopy(tmpx, ind + 1, tmpx2, ind, tmpx.length - ind - 1);
            tmpx = new int[tmpx2.length];
            System.arraycopy(tmpx2, 0, tmpx, 0, tmpx2.length);
        }
        y[x.length - 1] = tmpx[0];
        return y;
    }

    public static double[][] randomSort(double[][] x) {
        Object y = null;
        if (x != null) {
            int i;
            int[] indsRnd = new int[x.length];
            for (i = 0; i < x.length; ++i) {
                indsRnd[i] = i;
            }
            indsRnd = MathUtils.randomSort(indsRnd);
            y = new double[x.length][];
            for (i = 0; i < x.length; ++i) {
                y[i] = new double[x[indsRnd[i]].length];
                System.arraycopy(x[indsRnd[i]], 0, y[i], 0, x[indsRnd[i]].length);
            }
        }
        return y;
    }

    public static int[] addIndex(int[] X, int x) {
        int[] newX = new int[X.length + 1];
        for (int i = 0; i < X.length; ++i) {
            newX[i] = X[i];
        }
        newX[X.length] = x;
        return newX;
    }

    public static int[] removeIndex(int[] X, int x) {
        int[] newX = new int[X.length - 1];
        int j = 0;
        for (int i = 0; i < X.length; ++i) {
            if (X[i] == x) continue;
            newX[j++] = X[i];
        }
        return newX;
    }

    public static double[] modifySize(double[] x, int newLen) {
        double[] y = null;
        if (newLen < 1) {
            return y;
        }
        if (x.length == newLen || newLen == 1) {
            y = new double[x.length];
            System.arraycopy(x, 0, y, 0, x.length);
            return y;
        }
        y = new double[newLen];
        for (int i = 1; i <= newLen; ++i) {
            int mappedInd = (int)Math.floor(((double)i - 1.0) / ((double)newLen - 1.0) * ((double)x.length - 1.0) + 1.5);
            if (mappedInd < 1) {
                mappedInd = 1;
            } else if (mappedInd > x.length) {
                mappedInd = x.length;
            }
            y[i - 1] = x[mappedInd - 1];
        }
        return y;
    }

    public static double getConfidenceInterval95(double standardDeviation) {
        return 1.96 * standardDeviation;
    }

    public static double getConfidenceInterval99(double standardDeviation) {
        return 2.58 * standardDeviation;
    }

    public static double[] autocorr(double[] x, int P) {
        double[] R = new double[P + 1];
        int N = x.length;
        for (int m = 0; m <= P; ++m) {
            R[m] = 0.0;
            for (int n = 0; n <= N - m - 1; ++n) {
                int n2 = m;
                R[n2] = R[n2] + x[n] * x[n + m];
            }
        }
        return R;
    }

    public static boolean isAnyNaN(double[] x) {
        for (int i = 0; i < x.length; ++i) {
            if (!Double.isNaN(x[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyInfinity(double[] x) {
        for (double value : x) {
            if (!Double.isInfinite(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean allZeros(double[] x) {
        boolean bRet = true;
        for (int i = 0; i < x.length; ++i) {
            if (!(Math.abs(x[i]) > 1.0E-100)) continue;
            bRet = false;
            break;
        }
        return bRet;
    }

    public static double[] doubleRange2ByteRange(double[] x) {
        return MathUtils.doubleRange2ByteRange(x, -32768.0, 32767.0);
    }

    public static double[] doubleRange2ByteRange(double[] x, double doubleMin, double doubleMax) {
        return MathUtils.multiply(x, 256.0 / (doubleMax - doubleMin));
    }

    public static double[] byteRange2DoubleRange(double[] x) {
        return MathUtils.byteRange2DoubleRange(x, -32768.0, 32767.0);
    }

    public static double[] byteRange2DoubleRange(double[] x, double doubleMin, double doubleMax) {
        return MathUtils.multiply(x, (doubleMax - doubleMin) / 256.0);
    }

    public static float[] floatRange2ByteRange(float[] x) {
        return MathUtils.floatRange2ByteRange(x, -32768.0f, 32767.0f);
    }

    public static float[] floatRange2ByteRange(float[] x, float floatMin, float floatMax) {
        return MathUtils.multiply(x, 256.0f / (floatMax - floatMin));
    }

    public static float[] byteRange2FloatRange(float[] x) {
        return MathUtils.byteRange2FloatRange(x, -32768.0f, 32767.0f);
    }

    public static float[] byteRange2FloatRange(float[] x, float floatMin, float floatMax) {
        return MathUtils.multiply(x, (floatMax - floatMin) / 256.0f);
    }

    public static double trimToRange(double untrimmedValue, double min, double max) {
        return Math.max(min, Math.min(max, untrimmedValue));
    }

    public static double[] interpolateNonZeroValues(double[] contour) {
        for (int i = 0; i < contour.length; ++i) {
            int j;
            if (contour[i] != 0.0) continue;
            int index = MathUtils.findNextIndexNonZero(contour, i);
            if (index == -1) {
                int n = j = i == 0 ? 1 : i;
                while (j < contour.length) {
                    contour[j] = contour[j - 1];
                    ++j;
                }
                break;
            }
            for (j = i; j < index; ++j) {
                contour[j] = i == 0 ? contour[index] : contour[j - 1] + (contour[index] - contour[i - 1]) / (double)(index - i);
            }
            i = index - 1;
        }
        return contour;
    }

    public static int findNextIndexNonZero(double[] contour, int current) {
        for (int i = current + 1; i < contour.length; ++i) {
            if (contour[i] == 0.0) continue;
            return i;
        }
        return -1;
    }

    public static double[] arrayResize(double[] source, int targetSize) {
        if (source.length == targetSize) {
            return source;
        }
        int sourceSize = source.length;
        double fraction = (double)source.length / (double)targetSize;
        double[] newSignal = new double[targetSize];
        for (int i = 0; i < targetSize; ++i) {
            double fVal;
            double posIdx = fraction * (double)i;
            int nVal = (int)Math.floor(posIdx);
            double diffVal = posIdx - (double)nVal;
            newSignal[i] = nVal >= sourceSize - 1 ? source[sourceSize - 1] : (fVal = diffVal * source[nVal + 1] + (1.0 - diffVal) * source[nVal]);
        }
        return newSignal;
    }

    public static double[] diff(double[] a) {
        if (a == null) {
            return null;
        }
        if (a.length < 2) {
            return new double[0];
        }
        double[] b = new double[a.length - 1];
        for (int i = 0; i < a.length - 1; ++i) {
            b[i] = a[i + 1] - a[i];
        }
        return b;
    }

    public static void main(String[] args) {
        ComplexNumber[][] x1 = new ComplexNumber[2][2];
        x1[0][0] = new ComplexNumber(1.0, 2.0);
        x1[0][1] = new ComplexNumber(2.0, 1.0);
        x1[1][0] = new ComplexNumber(1.0, 2.0);
        x1[1][1] = new ComplexNumber(3.0, 1.0);
        ComplexNumber[][] x2 = new ComplexNumber[2][2];
        x2[0][0] = new ComplexNumber(1.0, 2.0);
        x2[0][1] = new ComplexNumber(2.0, 1.0);
        x2[1][0] = new ComplexNumber(1.0, 2.0);
        x2[1][1] = new ComplexNumber(3.0, 1.0);
        ComplexNumber[][] y = MathUtils.matrixProduct(x1, x2);
        System.out.print(MathUtils.toString(y));
        System.out.println("Test completed...");
    }

    public static String[] toStringLines(ComplexNumber[] x) {
        String[] y = null;
        if (x != null && x.length > 0) {
            y = new String[x.length];
            for (int i = 0; i < x.length; ++i) {
                y[i] = x[i].imag >= 0.0f ? String.valueOf(x[i].real) + "+i*" + String.valueOf(x[i].imag) : String.valueOf(x[i].real) + "-i*" + String.valueOf(Math.abs(x[i].imag));
            }
        }
        return y;
    }

    public static String[] toStringLines(ComplexArray x) {
        String[] y = null;
        if (x != null && x.real.length > 0 && x.imag.length > 0) {
            assert (x.real.length == x.imag.length);
            y = new String[x.real.length];
            for (int i = 0; i < x.real.length; ++i) {
                y[i] = x.imag[i] >= 0.0 ? String.valueOf(x.real[i]) + "+i*" + String.valueOf(x.imag[i]) : String.valueOf(x.real[i]) + "-i*" + String.valueOf(Math.abs(x.imag[i]));
            }
        }
        return y;
    }

    public static String toString(ComplexNumber[][] array) {
        String str = "";
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                str = str + array[i][j].toString();
                if (j >= array[i].length - 1) continue;
                str = str + " ";
            }
            str = str + System.getProperty("line.separator");
        }
        str = str + System.getProperty("line.separator");
        return str;
    }
}

