/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import marytts.util.io.General;

public class ESTTrackWriter {
    private float[] times = null;
    private float[][] frames = null;
    private String feaType = "";

    public ESTTrackWriter(float[] setTimes, float[][] setFrames, String setFeaType) {
        this.times = setTimes;
        this.frames = setFrames;
        this.feaType = setFeaType;
    }

    public void doWriteAndClose(String fName, boolean isBinary, boolean isBigEndian) throws IOException {
        int i;
        DataOutputStream dos = null;
        try {
            dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fName)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Can't open file [" + fName + "] for writing.", e);
        }
        dos.writeBytes("EST_File Track\n");
        if (isBinary) {
            dos.writeBytes("DataType binary\n");
            if (isBigEndian) {
                dos.writeBytes("ByteOrder 10\n");
            } else {
                dos.writeBytes("ByteOrder 01\n");
            }
        } else {
            dos.writeBytes("DataType ascii\n");
        }
        int numChannels = this.frames != null && this.frames.length > 0 && this.frames[0] != null ? this.frames[0].length : 0;
        dos.writeBytes("NumFrames " + this.times.length + "\n" + "NumChannels " + numChannels + "\n" + "NumAuxChannels 0\n" + "EqualSpace 0\n" + "BreaksPresent true\n" + "CommentChar ;\n");
        for (int k = 0; k < numChannels; ++k) {
            String K = Integer.toString(k);
            dos.writeBytes("Channel_" + K + " " + this.feaType + "_" + K + "\n");
        }
        dos.writeBytes("EST_Header_End\n");
        if (isBinary) {
            for (i = 0; i < this.times.length; ++i) {
                General.writeFloat((DataOutputStream)dos, (boolean)isBigEndian, (float)this.times[i]);
                General.writeFloat((DataOutputStream)dos, (boolean)isBigEndian, (float)1.0f);
                for (int k = 0; k < numChannels; ++k) {
                    General.writeFloat((DataOutputStream)dos, (boolean)isBigEndian, (float)this.frames[i][k]);
                }
            }
        } else {
            for (i = 0; i < this.times.length; ++i) {
                dos.writeBytes(Float.toString(this.times[i]));
                dos.writeBytes("\t1\t");
                if (numChannels > 0) {
                    dos.writeBytes(Float.toString(this.frames[i][0]));
                    for (int k = 1; k < this.frames[0].length; ++k) {
                        dos.writeBytes(" " + Float.toString(this.frames[i][k]));
                    }
                }
                dos.writeBytes("\n");
            }
        }
        dos.flush();
        dos.close();
    }
}

