/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.synthesis;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.analysis.RegularizedPostWarpedCepstrumEstimator;
import marytts.signalproc.analysis.RegularizedPreWarpedCepstrumEstimator;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameNoisePartPseudoHarmonic;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignal;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizerParams;
import marytts.signalproc.window.Window;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.io.FileUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;
import marytts.util.string.StringUtils;

public class NoisePartPseudoHarmonicSynthesizer {
    public static double[] synthesize(HntmSpeechSignal hnmSignal, HntmAnalyzerParams analysisParams, HntmSynthesizerParams synthesisParams, String referenceFile) {
        int n;
        int k;
        int numHarmonicsCurrentFrame;
        int i;
        double[] noisePart = null;
        boolean trackNoToExamine = true;
        double tsik = 0.0;
        double tsikPlusOne = 0.0;
        int maxNumHarmonics = 0;
        for (i = 0; i < hnmSignal.frames.length; ++i) {
            if (!(hnmSignal.frames[i].maximumFrequencyOfVoicingInHz > 0.0f) || hnmSignal.frames[i].n == null) continue;
            numHarmonicsCurrentFrame = (int)Math.floor((double)((float)hnmSignal.samplingRateInHz / analysisParams.noiseF0InHz) + 0.5);
            if ((numHarmonicsCurrentFrame = Math.max(0, numHarmonicsCurrentFrame)) <= maxNumHarmonics) continue;
            maxNumHarmonics = numHarmonicsCurrentFrame;
        }
        float[] phasekis = null;
        float phasekt = 0.0f;
        float phasekiEstimate = 0.0f;
        float phasekiPlusOneEstimate = 0.0f;
        int outputLen = SignalProcUtils.time2sample(hnmSignal.originalDurationInSeconds, hnmSignal.samplingRateInHz);
        noisePart = new double[outputLen];
        Arrays.fill(noisePart, 0.0);
        Object noiseTracks = null;
        if (maxNumHarmonics > 0) {
            noiseTracks = new double[maxNumHarmonics][];
            for (k = 0; k < maxNumHarmonics; ++k) {
                noiseTracks[k] = new double[outputLen];
                Arrays.fill(noiseTracks[k], 0.0);
            }
            phasekis = new float[maxNumHarmonics];
            for (k = 0; k < maxNumHarmonics; ++k) {
                phasekis[k] = (float)(Math.PI * 2 * (Math.random() - 0.5));
            }
        }
        int transitionLen = SignalProcUtils.time2sample(synthesisParams.unvoicedVoicedTrackTransitionInSeconds, hnmSignal.samplingRateInHz);
        Window transitionWin = Window.get(1, transitionLen * 2);
        transitionWin.normalizePeakValue(1.0f);
        double[] halfTransitionWinLeft = transitionWin.getCoeffsLeftHalf();
        float halfFs = hnmSignal.samplingRateInHz;
        for (i = 0; i < hnmSignal.frames.length; ++i) {
            boolean isPrevNoised = false;
            boolean isNoised = false;
            boolean isNextNoised = false;
            if (i > 0 && hnmSignal.frames[i - 1].n != null && hnmSignal.frames[i - 1].maximumFrequencyOfVoicingInHz < halfFs && ((FrameNoisePartPseudoHarmonic)hnmSignal.frames[i - 1].n).ceps != null) {
                isPrevNoised = true;
            }
            if (i > 0 && hnmSignal.frames[i].n != null && hnmSignal.frames[i].maximumFrequencyOfVoicingInHz < halfFs && ((FrameNoisePartPseudoHarmonic)hnmSignal.frames[i].n).ceps != null) {
                isNoised = true;
            }
            if (i < hnmSignal.frames.length - 1 && hnmSignal.frames[i + 1].maximumFrequencyOfVoicingInHz < halfFs && hnmSignal.frames[i + 1].n != null && ((FrameNoisePartPseudoHarmonic)hnmSignal.frames[i + 1].n).ceps != null) {
                isNextNoised = true;
            }
            int numHarmonicsPrevFrame = 0;
            numHarmonicsCurrentFrame = 0;
            int numHarmonicsNextFrame = 0;
            int harmonicIndexShiftPrev = 0;
            int harmonicIndexShiftCurrent = 0;
            int harmonicIndexShiftNext = 0;
            if (isPrevNoised) {
                numHarmonicsPrevFrame = (int)Math.floor((double)(((float)hnmSignal.samplingRateInHz - hnmSignal.frames[i - 1].maximumFrequencyOfVoicingInHz) / analysisParams.noiseF0InHz) + 0.5);
                numHarmonicsPrevFrame = Math.max(0, numHarmonicsPrevFrame);
                harmonicIndexShiftPrev = (int)Math.floor((double)(hnmSignal.frames[i - 1].maximumFrequencyOfVoicingInHz / analysisParams.noiseF0InHz) + 0.5);
                harmonicIndexShiftPrev = Math.max(1, harmonicIndexShiftPrev);
            }
            if (isNoised) {
                numHarmonicsCurrentFrame = (int)Math.floor((double)(((float)hnmSignal.samplingRateInHz - hnmSignal.frames[i].maximumFrequencyOfVoicingInHz) / analysisParams.noiseF0InHz) + 0.5);
                numHarmonicsCurrentFrame = Math.max(0, numHarmonicsCurrentFrame);
                harmonicIndexShiftCurrent = (int)Math.floor((double)(hnmSignal.frames[i].maximumFrequencyOfVoicingInHz / analysisParams.noiseF0InHz) + 0.5);
                harmonicIndexShiftCurrent = Math.max(1, harmonicIndexShiftCurrent);
            } else if (!isNoised && isNextNoised) {
                numHarmonicsCurrentFrame = (int)Math.floor((double)(((float)hnmSignal.samplingRateInHz - hnmSignal.frames[i + 1].maximumFrequencyOfVoicingInHz) / analysisParams.noiseF0InHz) + 0.5);
                numHarmonicsCurrentFrame = Math.max(0, numHarmonicsCurrentFrame);
                harmonicIndexShiftCurrent = (int)Math.floor((double)(hnmSignal.frames[i + 1].maximumFrequencyOfVoicingInHz / analysisParams.noiseF0InHz) + 0.5);
                harmonicIndexShiftCurrent = Math.max(1, harmonicIndexShiftCurrent);
            }
            if (isNextNoised) {
                numHarmonicsNextFrame = (int)Math.floor((double)(((float)hnmSignal.samplingRateInHz - hnmSignal.frames[i + 1].maximumFrequencyOfVoicingInHz) / analysisParams.noiseF0InHz) + 0.5);
                numHarmonicsNextFrame = Math.max(0, numHarmonicsNextFrame);
                harmonicIndexShiftNext = (int)Math.floor((double)(hnmSignal.frames[i + 1].maximumFrequencyOfVoicingInHz / analysisParams.noiseF0InHz) + 0.5);
                harmonicIndexShiftNext = Math.max(1, harmonicIndexShiftNext);
            }
            for (k = 0; k < numHarmonicsCurrentFrame; ++k) {
                double aksi = 0.0;
                double aksiPlusOne = 0.0;
                float phasekiPlusOne = 0.0f;
                boolean isPrevTrackNoised = false;
                boolean isTrackNoised = false;
                boolean isNextTrackNoised = false;
                if (i > 0 && hnmSignal.frames[i - 1].n != null && numHarmonicsPrevFrame > k) {
                    isPrevTrackNoised = true;
                }
                if (hnmSignal.frames[i].n != null && numHarmonicsCurrentFrame > k) {
                    isTrackNoised = true;
                }
                if (i < hnmSignal.frames.length - 1 && hnmSignal.frames[i + 1].n != null && numHarmonicsNextFrame > k) {
                    isNextTrackNoised = true;
                }
                tsik = hnmSignal.frames[i].tAnalysisInSeconds;
                double trackStartInSeconds = i == 0 ? 0.0 : tsik;
                tsikPlusOne = i == hnmSignal.frames.length - 1 ? (double)hnmSignal.originalDurationInSeconds : (double)hnmSignal.frames[i + 1].tAnalysisInSeconds;
                double trackEndInSeconds = tsikPlusOne;
                int trackStartIndex = SignalProcUtils.time2sample(trackStartInSeconds, hnmSignal.samplingRateInHz);
                int trackEndIndex = SignalProcUtils.time2sample(trackEndInSeconds, hnmSignal.samplingRateInHz);
                if (!isTrackNoised || trackEndIndex - trackStartIndex + 1 <= 0) continue;
                if (isTrackNoised) {
                    if (!analysisParams.useNoiseAmplitudesDirectly) {
                        if (analysisParams.regularizedCepstrumWarpingMethod == 1) {
                            aksi = RegularizedPreWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(((FrameNoisePartPseudoHarmonic)hnmSignal.frames[i].n).ceps, (float)(k + harmonicIndexShiftCurrent) * analysisParams.noiseF0InHz, hnmSignal.samplingRateInHz);
                        } else if (analysisParams.regularizedCepstrumWarpingMethod == 2) {
                            aksi = RegularizedPostWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(((FrameNoisePartPseudoHarmonic)hnmSignal.frames[i].n).ceps, (float)(k + harmonicIndexShiftCurrent) * analysisParams.noiseF0InHz, hnmSignal.samplingRateInHz);
                        }
                    } else {
                        aksi = k < ((FrameNoisePartPseudoHarmonic)hnmSignal.frames[i].n).ceps.length ? (double)((FrameNoisePartPseudoHarmonic)hnmSignal.frames[i].n).ceps[k] : 0.0;
                    }
                } else {
                    aksi = 0.0;
                }
                if (isNextTrackNoised) {
                    if (!analysisParams.useNoiseAmplitudesDirectly) {
                        if (analysisParams.regularizedCepstrumWarpingMethod == 1) {
                            aksiPlusOne = RegularizedPreWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(((FrameNoisePartPseudoHarmonic)hnmSignal.frames[i + 1].n).ceps, (float)(k + harmonicIndexShiftNext) * analysisParams.noiseF0InHz, hnmSignal.samplingRateInHz);
                        } else if (analysisParams.regularizedCepstrumWarpingMethod == 2) {
                            aksiPlusOne = RegularizedPostWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(((FrameNoisePartPseudoHarmonic)hnmSignal.frames[i + 1].n).ceps, (float)(k + harmonicIndexShiftNext) * analysisParams.noiseF0InHz, hnmSignal.samplingRateInHz);
                        }
                    } else {
                        aksiPlusOne = k < ((FrameNoisePartPseudoHarmonic)hnmSignal.frames[i + 1].n).ceps.length ? (double)((FrameNoisePartPseudoHarmonic)hnmSignal.frames[i + 1].n).ceps[k] : 0.0;
                    }
                } else {
                    aksiPlusOne = 0.0;
                }
                phasekis[k] = (float)(Math.PI * 2 * (Math.random() - 0.5));
                phasekiPlusOne = (float)((double)phasekis[k] + (double)(k + harmonicIndexShiftCurrent) * (Math.PI * 2) * (double)analysisParams.noiseF0InHz * (tsikPlusOne - tsik));
                if (!isPrevTrackNoised) {
                    trackStartIndex = Math.max(0, trackStartIndex - transitionLen);
                }
                for (n = trackStartIndex; n <= Math.min(trackEndIndex, outputLen - 1); ++n) {
                    double t = SignalProcUtils.sample2time(n, hnmSignal.samplingRateInHz);
                    double akt = MathUtils.interpolatedSample(tsik, t, tsikPlusOne, aksi, aksiPlusOne);
                    phasekt = (float)((double)phasekiPlusOne * (t - tsik) / (tsikPlusOne - tsik));
                    noiseTracks[k][n] = !isPrevTrackNoised && n - trackStartIndex < transitionLen ? halfTransitionWinLeft[n - trackStartIndex] * akt * Math.cos(phasekt) : akt * Math.cos(phasekt);
                }
                phasekis[k] = phasekiPlusOne;
            }
        }
        for (k = 0; k < ((double[][])noiseTracks).length; ++k) {
            for (n = 0; n < noisePart.length; ++n) {
                int n2 = n;
                noisePart[n2] = noisePart[n2] + noiseTracks[k][n];
            }
        }
        if (noiseTracks != null) {
            for (k = 0; k < ((double[][])noiseTracks).length; ++k) {
                for (n = 0; n < noisePart.length; ++n) {
                    int n3 = n;
                    noisePart[n3] = noisePart[n3] + noiseTracks[k][n];
                }
            }
            if (referenceFile != null && FileUtils.exists((String)referenceFile) && synthesisParams.writeSeparateHarmonicTracksToOutputs) {
                AudioInputStream inputAudio = null;
                try {
                    inputAudio = AudioSystem.getAudioInputStream(new File(referenceFile));
                }
                catch (UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (inputAudio != null) {
                    for (k = 0; k < ((double[][])noiseTracks).length; ++k) {
                        noiseTracks[k] = MathUtils.divide(noiseTracks[k], 32767.0);
                        DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(noiseTracks[k]), inputAudio.getFormat());
                        String outFileName = StringUtils.getFolderName((String)referenceFile) + "noiseTrack" + String.valueOf(k + 1) + ".wav";
                        try {
                            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        return noisePart;
    }
}

