/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Arrays;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.analysis.F0TrackerAutocorrelationHeuristic;
import marytts.signalproc.analysis.PitchMarks;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.signalproc.process.PsolaFrameProvider;
import marytts.signalproc.process.VocalTractModifier;
import marytts.signalproc.process.VoiceModificationParametersPreprocessor;
import marytts.signalproc.window.DynamicWindow;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.Datagram;
import marytts.util.data.DatagramDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.io.FileUtils;
import marytts.util.io.LEDataInputStream;
import marytts.util.io.LEDataOutputStream;
import marytts.util.math.ComplexArray;
import marytts.util.math.FFTMixedRadix;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class FDPSOLAProcessor
extends VocalTractModifier {
    public static int WAVEFORM_MODIFICATION = 1;
    public static int TTS_MODIFICATION = 2;
    protected DoubleDataSource input;
    protected AudioInputStream inputAudio;
    protected DDSAudioInputStream outputAudio;
    protected VoiceModificationParametersPreprocessor modParams;
    protected int numfrm;
    protected int numfrmFixed;
    protected int lpOrder;
    protected String outputFile;
    protected String tempOutBinaryFile;
    protected int origLen;
    protected PitchMarks pm;
    protected double[] f0s;
    protected PsolaFrameProvider psFrm;
    protected double wsFixedInSeconds;
    protected double ssFixedInSeconds;
    protected int numPeriods;
    protected static int NUM_PITCH_SYNC_PERIODS = 3;
    protected static int FROM_CODE = 0;
    protected static int FROM_FILE = 1;
    protected static int FROM_TARGET = 2;
    public boolean bSilent = true;
    protected LEDataOutputStream dout;
    protected LEDataInputStream din;
    protected DynamicWindow windowIn;
    protected DynamicWindow windowOut;
    protected double[] wgt;
    protected double[] wgty;
    protected int frmSize;
    protected int newFrmSize;
    protected int newPeriod;
    protected int synthFrmInd;
    protected double localDurDiff;
    protected int repeatSkipCount;
    protected double localDurDiffSaved;
    protected double sumLocalDurDiffs;
    protected double nextAdd;
    protected int synthSt;
    protected int synthTotal;
    protected int maxFrmSize;
    protected int maxNewFrmSize;
    protected int synthFrameInd;
    protected boolean bLastFrame;
    protected boolean bBroke;
    protected int newFftSize;
    protected int newMaxFreq;
    protected int outBuffLen;
    protected double[] outBuff;
    protected int outBuffStart;
    protected int totalWrittenToFile;
    protected double[] ySynthBuff;
    protected double[] wSynthBuff;
    protected int ySynthInd;
    protected double[] frm;
    protected boolean bWarp;
    protected double[] inputVT;
    protected double[] py2;
    protected ComplexArray hy;
    protected double[] frmy;
    protected double frmEn;
    protected double frmyEn;
    protected double gain;
    protected int newSkipSize;
    protected int halfWin;
    protected double[] newVScales;
    protected double[] tmpvsc;
    protected boolean isWavFileOutput;
    protected int inputFrameIndex;
    protected static double MIN_PSCALE = 0.1;
    protected static double MAX_PSCALE = 5.0;
    protected static double MIN_TSCALE = 0.1;
    protected static double MAX_TSCALE = 5.0;
    protected double tscaleSingle;

    public FDPSOLAProcessor(String strInputFile, String strPitchFile, String strOutputFile, double[] pscales, double[] tscales, double[] escales, double[] vscales) throws UnsupportedAudioFileException, IOException {
        this(strInputFile, strPitchFile, strOutputFile, pscales, tscales, escales, vscales, false);
    }

    public FDPSOLAProcessor(String strInputFile, String strPitchFile, String strOutputFile, double[] pscales, double[] tscales, double[] escales, double[] vscales, boolean isFixedRate) throws UnsupportedAudioFileException, IOException {
        this.init(WAVEFORM_MODIFICATION, strInputFile, strPitchFile, strOutputFile, pscales, tscales, escales, vscales, isFixedRate);
    }

    public FDPSOLAProcessor() {
        this.init(TTS_MODIFICATION);
    }

    protected void init(int initialisationType) {
        this.init(initialisationType, null, null, null, null, null, null, null, false);
    }

    protected void init(int initialisationType, String strInputFile, String strPitchFile, String strOutputFile, double[] pscales, double[] tscales, double[] escales, double[] vscales, boolean isFixedRate) {
        this.isWavFileOutput = false;
        this.inputAudio = null;
        this.input = null;
        this.pm = null;
        this.f0s = null;
        this.wsFixedInSeconds = 0.02;
        this.ssFixedInSeconds = 0.01;
        this.numPeriods = NUM_PITCH_SYNC_PERIODS;
        this.origLen = 0;
        this.fs = 16000;
        this.numfrm = 0;
        this.numfrmFixed = 0;
        this.modParams = null;
        this.outputFile = null;
        this.tscaleSingle = 1.0;
        boolean bContinue = true;
        if (initialisationType == WAVEFORM_MODIFICATION) {
            this.isWavFileOutput = true;
            if (!FileUtils.exists((String)strInputFile)) {
                System.out.println("Error! Pitch file " + strInputFile + " not found.");
                bContinue = false;
            }
            if (strOutputFile == null || strOutputFile == "") {
                System.out.println("Invalid output file...");
                bContinue = false;
            }
            if (bContinue) {
                try {
                    this.inputAudio = AudioSystem.getAudioInputStream(new File(strInputFile));
                }
                catch (UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.input = new AudioDoubleDataSource(this.inputAudio);
                this.origLen = (int)this.input.getDataLength();
                this.fs = (int)this.inputAudio.getFormat().getSampleRate();
                if (!FileUtils.exists((String)strPitchFile)) {
                    System.out.println("Pitch file cannot be found, computing... " + strPitchFile);
                    try {
                        F0TrackerAutocorrelationHeuristic f0Tracker = new F0TrackerAutocorrelationHeuristic(strInputFile, strPitchFile);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                PitchReaderWriter f0 = new PitchReaderWriter(strPitchFile);
                this.pm = SignalProcUtils.pitchContour2pitchMarks(f0.contour, this.fs, this.origLen, f0.header.windowSizeInSeconds, f0.header.skipSizeInSeconds, true, 0);
                this.numfrmFixed = (int)(Math.floor(((double)(this.origLen + this.pm.totalZerosToPadd) / (double)this.fs - 0.5 * this.wsFixedInSeconds) / this.ssFixedInSeconds + 0.5) + 2.0);
                this.numfrm = !isFixedRate ? this.pm.pitchMarks.length - this.numPeriods : this.numfrmFixed;
                this.f0s = SignalProcUtils.fixedRateF0Values(this.pm, this.wsFixedInSeconds, this.ssFixedInSeconds, this.numfrmFixed, this.fs);
                this.lpOrder = SignalProcUtils.getLPOrder(this.fs);
                this.modParams = new VoiceModificationParametersPreprocessor(this.fs, this.lpOrder, pscales, tscales, escales, vscales, this.pm.pitchMarks, this.wsFixedInSeconds, this.ssFixedInSeconds, this.numfrm, this.numfrmFixed, this.numPeriods, isFixedRate);
                this.tscaleSingle = this.modParams.tscaleSingle;
                this.outputFile = strOutputFile;
            }
        } else if (initialisationType == TTS_MODIFICATION) {
            this.lpOrder = SignalProcUtils.getLPOrder(this.fs);
        }
        if (bContinue) {
            this.tmpvsc = new double[1];
            if (this.outputFile != null) {
                this.tempOutBinaryFile = this.outputFile + ".bin";
            }
            if (this.isWavFileOutput) {
                this.psFrm = !isFixedRate ? new PsolaFrameProvider(this.input, this.pm, this.modParams.fs, this.modParams.numPeriods) : new PsolaFrameProvider(this.input, this.wsFixedInSeconds, this.ssFixedInSeconds, this.modParams.fs, this.numfrm);
                try {
                    this.dout = new LEDataOutputStream(this.tempOutBinaryFile);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                this.psFrm = null;
                this.dout = null;
            }
            this.windowIn = new DynamicWindow(3);
            this.windowOut = new DynamicWindow(3);
            this.frmSize = 0;
            this.newFrmSize = 0;
            this.newPeriod = 0;
            this.synthFrmInd = 0;
            this.localDurDiff = 0.0;
            this.repeatSkipCount = 0;
            this.localDurDiffSaved = 0.0;
            this.sumLocalDurDiffs = 0.0;
            this.nextAdd = 0.0;
            this.synthSt = this.isWavFileOutput ? this.pm.pitchMarks[0] : 0;
            this.synthTotal = 0;
            this.maxFrmSize = (int)((double)(this.numPeriods * this.fs) / 40.0);
            if (this.maxFrmSize % 2 != 0) {
                ++this.maxFrmSize;
            }
            this.maxNewFrmSize = (int)Math.floor((double)this.maxFrmSize / MIN_PSCALE + 0.5);
            if (this.maxNewFrmSize % 2 != 0) {
                ++this.maxNewFrmSize;
            }
            this.synthFrameInd = 0;
            this.bLastFrame = false;
            this.bBroke = false;
            this.fftSize = (int)Math.pow(2.0, Math.ceil(Math.log(this.maxFrmSize) / Math.log(2.0)));
            this.maxFreq = this.fftSize / 2 + 1;
            this.outBuffLen = 500000;
            this.outBuff = MathUtils.zeros(this.outBuffLen);
            this.outBuffStart = 1;
            this.totalWrittenToFile = 0;
            this.ySynthBuff = MathUtils.zeros(this.maxNewFrmSize);
            this.wSynthBuff = MathUtils.zeros(this.maxNewFrmSize);
            this.ySynthInd = 1;
        }
    }

    public DDSAudioInputStream processDecrufted(Datagram[][] datagrams, Datagram[] rightContexts, AudioFormat audioformat, boolean[][] voicings, double[][] pitchScales, double[][] timeScales) throws IOException {
        int j;
        int i;
        this.tscaleSingle = -1.0;
        this.origLen = 0;
        this.numfrm = 0;
        for (i = 0; i < datagrams.length; ++i) {
            for (j = 0; j < datagrams[i].length; ++j) {
                this.origLen = (int)((long)this.origLen + datagrams[i][j].getDuration());
                if (j != datagrams[i].length - 1 || rightContexts == null || rightContexts[i] == null) continue;
                this.origLen = (int)((long)this.origLen + rightContexts[i].getDuration());
            }
            this.numfrm += datagrams[i].length;
        }
        for (i = 0; i < datagrams.length; ++i) {
            for (j = 0; j < datagrams[i].length; ++j) {
                int length = datagrams[i][j].getLength();
                Datagram nextDatagram = new Datagram(length, new byte[2 * length]);
                if (j < datagrams[i].length - 1) {
                    nextDatagram = datagrams[i][j + 1];
                } else if (rightContexts[i] != null) {
                    nextDatagram = rightContexts[i];
                } else if (i < datagrams.length - 1) {
                    nextDatagram = datagrams[i + 1][0];
                }
                assert (nextDatagram.getDuration() > 0L);
                Datagram[] sourceDatagrams = new Datagram[]{datagrams[i][j], nextDatagram};
                DatagramDoubleDataSource dataSource = new DatagramDoubleDataSource(sourceDatagrams);
                double[] frmIn = dataSource.getAllData();
                boolean symbolicVoicing = voicings[i][j];
                boolean acousticVoicing = SignalProcUtils.getVoicing(frmIn, (int)audioformat.getSampleRate());
                boolean isVoiced = symbolicVoicing;
                double escale = 1.0;
                double vscale = 1.0;
                boolean bLastInputFrame = i == datagrams.length - 1 && j == datagrams[i].length - 1;
                int currentPeriod = (int)datagrams[i][j].getDuration();
                int inputFrameSize = currentPeriod + (int)nextDatagram.getDuration();
                try {
                    int bufferStartIndex = this.outBuffStart;
                    this.processFrame(frmIn, isVoiced, pitchScales[i][j], timeScales[i][j], escale, vscale, bLastInputFrame, currentPeriod, inputFrameSize);
                    int bufferEndIndex = this.outBuffStart;
                    int bufferLength = bufferEndIndex - bufferStartIndex;
                    double[] samples = new double[bufferLength];
                    System.arraycopy(this.outBuff, bufferStartIndex - 1, samples, 0, bufferLength);
                    datagrams[i][j].setDuration(samples.length);
                    continue;
                }
                catch (IOException e) {
                    throw new IOException("Frames could not be processed!", e);
                }
            }
        }
        int bufferStartIndex = this.outBuffStart - 1;
        double[] output = null;
        try {
            output = this.writeFinal();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int bufferEndIndex = this.outBuffLen;
        int bufferLength = bufferEndIndex - bufferStartIndex;
        double[] samples = new double[bufferLength];
        System.arraycopy(this.outBuff, bufferStartIndex, samples, 0, bufferLength);
        Datagram finalDatagram = datagrams[datagrams.length - 1][datagrams[datagrams.length - 1].length - 1];
        finalDatagram.setDuration(finalDatagram.getDuration() + (long)samples.length);
        BufferedDoubleDataSource buffer = new BufferedDoubleDataSource(output);
        DDSAudioInputStream stream = new DDSAudioInputStream(buffer, audioformat);
        return stream;
    }

    public DDSAudioInputStream process(Datagram[][] datagrams, Datagram[] rightContexts, AudioFormat audioformat, boolean[][] voicings, double[][] pitchScales, double[][] timeScales) {
        double absMax;
        double firstTScale;
        int j;
        int i;
        int pitchSpecs = FROM_TARGET;
        int durationSpecs = FROM_TARGET;
        double[] output = null;
        boolean isVoiced = true;
        double pscale = 1.0;
        double tscale = 1.0;
        double escale = 1.0;
        double vscale = 1.0;
        if (pitchSpecs == FROM_FILE || durationSpecs == FROM_FILE) {
            double[] scales = this.getScalesFromTextFile("d:/psolaParam.txt");
            if (pitchSpecs == FROM_FILE) {
                pscale = scales[0];
            }
            if (durationSpecs == FROM_FILE) {
                tscale = scales[1];
            }
            escale = scales[2];
            vscale = scales[3];
        }
        if (pitchSpecs == FROM_FILE || pitchSpecs == FROM_CODE || durationSpecs == FROM_FILE || durationSpecs == FROM_CODE) {
            for (i = 0; i < timeScales.length; ++i) {
                if (pitchSpecs == FROM_FILE || pitchSpecs == FROM_CODE) {
                    for (j = 0; j < pitchScales[i].length; ++j) {
                        pitchScales[i][j] = pscale;
                    }
                }
                if (durationSpecs != FROM_FILE && durationSpecs != FROM_CODE) continue;
                for (j = 0; j < timeScales[i].length; ++j) {
                    timeScales[i][j] = tscale;
                }
            }
        }
        this.tscaleSingle = firstTScale = timeScales[0][0];
        block7: for (i = 0; i < timeScales.length; ++i) {
            for (j = 0; j < timeScales[i].length; ++j) {
                if (i == 0 || j == 0 || timeScales[i][j] == firstTScale) continue;
                this.tscaleSingle = -1.0;
                continue block7;
            }
        }
        boolean bLastInputFrame = false;
        double[] frmIn = null;
        double[] frmTmp = null;
        double[] yOut = null;
        double[] yOutTmp = null;
        Datagram[] tmpDatagram = new Datagram[1];
        this.origLen = 0;
        this.numfrm = 0;
        for (i = 0; i < datagrams.length; ++i) {
            for (j = 0; j < datagrams[i].length; ++j) {
                this.origLen = j == datagrams[i].length - 1 ? (rightContexts != null && rightContexts[i] != null ? (int)((long)this.origLen + (datagrams[i][j].getDuration() + rightContexts[i].getDuration())) : (int)((long)this.origLen + datagrams[i][j].getDuration())) : (int)((long)this.origLen + datagrams[i][j].getDuration());
                ++this.numfrm;
            }
        }
        int yCounter = -1;
        block11: for (i = 0; i < datagrams.length; ++i) {
            for (j = 0; j < datagrams[i].length; ++j) {
                int tmpLen;
                bLastInputFrame = i == datagrams.length - 1 && j == datagrams[i].length - 1;
                frmIn = null;
                int inputFrameSize = 0;
                int currentPeriod = (int)datagrams[i][j].getDuration();
                if (j < datagrams[i].length - 1) {
                    inputFrameSize = (int)datagrams[i][j].getDuration() + (int)datagrams[i][j + 1].getDuration();
                    frmIn = new double[inputFrameSize];
                    tmpDatagram[0] = datagrams[i][j];
                    frmTmp = new DatagramDoubleDataSource(tmpDatagram).getAllData();
                    tmpLen = frmTmp.length;
                    System.arraycopy(frmTmp, 0, frmIn, 0, tmpLen);
                    tmpDatagram[0] = datagrams[i][j + 1];
                    frmTmp = new DatagramDoubleDataSource(tmpDatagram).getAllData();
                    System.arraycopy(frmTmp, 0, frmIn, tmpLen, frmTmp.length);
                } else if (rightContexts[i] != null) {
                    inputFrameSize = (int)datagrams[i][j].getDuration() + (int)rightContexts[i].getDuration();
                    frmIn = new double[inputFrameSize];
                    tmpDatagram[0] = datagrams[i][j];
                    frmTmp = new DatagramDoubleDataSource(tmpDatagram).getAllData();
                    tmpLen = frmTmp.length;
                    System.arraycopy(frmTmp, 0, frmIn, 0, tmpLen);
                    tmpDatagram[0] = rightContexts[i];
                    frmTmp = new DatagramDoubleDataSource(tmpDatagram).getAllData();
                    System.arraycopy(frmTmp, 0, frmIn, tmpLen, frmTmp.length);
                } else if (i < datagrams.length - 1) {
                    inputFrameSize = (int)datagrams[i][j].getDuration() + (int)datagrams[i + 1][0].getDuration();
                    frmIn = new double[inputFrameSize];
                    tmpDatagram[0] = datagrams[i][j];
                    frmTmp = new DatagramDoubleDataSource(tmpDatagram).getAllData();
                    tmpLen = frmTmp.length;
                    System.arraycopy(frmTmp, 0, frmIn, 0, tmpLen);
                    tmpDatagram[0] = datagrams[i + 1][0];
                    frmTmp = new DatagramDoubleDataSource(tmpDatagram).getAllData();
                    System.arraycopy(frmTmp, 0, frmIn, tmpLen, frmTmp.length);
                } else {
                    inputFrameSize = 2 * (int)datagrams[i][j].getDuration();
                    frmIn = MathUtils.zeros(inputFrameSize);
                    tmpDatagram[0] = datagrams[i][j];
                    frmTmp = new DatagramDoubleDataSource(tmpDatagram).getAllData();
                    tmpLen = frmTmp.length;
                    System.arraycopy(frmTmp, 0, frmIn, 0, tmpLen);
                }
                if (frmIn == null) continue;
                isVoiced = SignalProcUtils.getVoicing(frmIn, (int)audioformat.getSampleRate(), 0.35f);
                try {
                    output = this.processFrame(frmIn, isVoiced, pitchScales[i][j], timeScales[i][j], escale, vscale, bLastInputFrame, currentPeriod, inputFrameSize);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                boolean bBroken = false;
                if (output != null) {
                    if (yOut == null) {
                        yOut = new double[output.length];
                        System.arraycopy(output, 0, yOut, 0, output.length);
                    } else {
                        yOutTmp = new double[yOut.length];
                        System.arraycopy(yOut, 0, yOutTmp, 0, yOut.length);
                        yOut = new double[yOutTmp.length + output.length];
                        System.arraycopy(yOutTmp, 0, yOut, 0, yOutTmp.length);
                        System.arraycopy(output, 0, yOut, yOutTmp.length, output.length);
                    }
                }
                if (bBroken) continue block11;
            }
        }
        try {
            output = this.writeFinal();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (output != null) {
            if (yOut == null) {
                yOut = new double[output.length];
                System.arraycopy(output, 0, yOut, 0, output.length);
            } else {
                yOutTmp = new double[yOut.length];
                System.arraycopy(yOut, 0, yOutTmp, 0, yOut.length);
                yOut = new double[yOutTmp.length + output.length];
                System.arraycopy(yOutTmp, 0, yOut, 0, yOutTmp.length);
                System.arraycopy(output, 0, yOut, yOutTmp.length, output.length);
            }
        }
        if ((absMax = MathUtils.absMax(yOut)) > 32700.0) {
            for (i = 0; i < yOut.length; ++i) {
                yOut[i] = yOut[i] / absMax * 32700.0;
            }
        }
        return new DDSAudioInputStream(new BufferedDoubleDataSource(yOut), audioformat);
    }

    public DDSAudioInputStream process(double[] x, int[] pitchMarks, AudioFormat audioformat, boolean[] voicings, double[] pitchScales, double[] timeScales) {
        double absMax;
        double firstTScale;
        int i;
        int pitchSpecs = FROM_TARGET;
        int durationSpecs = FROM_TARGET;
        double[] output = null;
        boolean isVoiced = true;
        double pscale = 1.0;
        double tscale = 1.0;
        double escale = 1.0;
        double vscale = 1.0;
        if (pitchSpecs == FROM_FILE || durationSpecs == FROM_FILE) {
            double[] scales = this.getScalesFromTextFile("d:/psolaParam.txt");
            if (pitchSpecs == FROM_FILE) {
                pscale = scales[0];
            }
            if (durationSpecs == FROM_FILE) {
                tscale = scales[1];
            }
            escale = scales[2];
            vscale = scales[3];
        }
        if (pitchSpecs == FROM_FILE || pitchSpecs == FROM_CODE || durationSpecs == FROM_FILE || durationSpecs == FROM_CODE) {
            if (pitchSpecs == FROM_FILE || pitchSpecs == FROM_CODE) {
                for (i = 0; i < pitchScales.length; ++i) {
                    pitchScales[i] = pscale;
                }
            }
            if (durationSpecs == FROM_FILE || durationSpecs == FROM_CODE) {
                for (i = 0; i < timeScales.length; ++i) {
                    timeScales[i] = tscale;
                }
            }
        }
        this.tscaleSingle = firstTScale = timeScales[0];
        for (i = 0; i < timeScales.length; ++i) {
            if (i == 0 || timeScales[i] == firstTScale) continue;
            this.tscaleSingle = -1.0;
            break;
        }
        boolean bLastInputFrame = false;
        double[] frmIn = null;
        Object frmTmp = null;
        double[] yOut = null;
        double[] yOutTmp = null;
        this.origLen = x.length;
        this.numfrm = pitchMarks.length - this.numPeriods;
        int yCounter = -1;
        for (i = 0; i < pitchMarks.length - this.numPeriods; ++i) {
            bLastInputFrame = i == pitchMarks.length - this.numPeriods - 1;
            int inputFrameSize = pitchMarks[i + this.numPeriods] - pitchMarks[i] + 1;
            frmIn = new double[inputFrameSize];
            System.arraycopy(x, pitchMarks[i], frmIn, 0, inputFrameSize);
            int currentPeriod = pitchMarks[i + 1] - pitchMarks[i] + 1;
            if (frmIn == null) continue;
            isVoiced = SignalProcUtils.getVoicing(frmIn, (int)audioformat.getSampleRate(), 0.35f);
            try {
                output = this.processFrame(frmIn, isVoiced, pitchScales[i], timeScales[i], escale, vscale, bLastInputFrame, currentPeriod, inputFrameSize);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            boolean bBroken = false;
            if (output != null) {
                if (yOut == null) {
                    yOut = new double[output.length];
                    System.arraycopy(output, 0, yOut, 0, output.length);
                } else {
                    yOutTmp = new double[yOut.length];
                    System.arraycopy(yOut, 0, yOutTmp, 0, yOut.length);
                    yOut = new double[yOutTmp.length + output.length];
                    System.arraycopy(yOutTmp, 0, yOut, 0, yOutTmp.length);
                    System.arraycopy(output, 0, yOut, yOutTmp.length, output.length);
                }
            }
            if (bBroken) break;
        }
        try {
            output = this.writeFinal();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (output != null) {
            if (yOut == null) {
                yOut = new double[output.length];
                System.arraycopy(output, 0, yOut, 0, output.length);
            } else {
                yOutTmp = new double[yOut.length];
                System.arraycopy(yOut, 0, yOutTmp, 0, yOut.length);
                yOut = new double[yOutTmp.length + output.length];
                System.arraycopy(yOutTmp, 0, yOut, 0, yOutTmp.length);
                System.arraycopy(output, 0, yOut, yOutTmp.length, output.length);
            }
        }
        if ((absMax = MathUtils.absMax(yOut)) > 32700.0) {
            for (i = 0; i < yOut.length; ++i) {
                yOut[i] = yOut[i] / absMax * 32700.0;
            }
        }
        return new DDSAudioInputStream(new BufferedDoubleDataSource(yOut), audioformat);
    }

    public double[] processDatagram(Datagram[] datagrams, Datagram rightContext, AudioFormat audioformat, boolean[] voicings, double[] pitchScales, double[] timeScales, boolean bLastDatagram) {
        double firstTScale;
        int j;
        int pitchSpecs = FROM_TARGET;
        int durationSpecs = FROM_TARGET;
        double[] output = null;
        boolean isVoiced = true;
        double pscale = 1.0;
        double tscale = 1.0;
        double escale = 1.0;
        double vscale = 1.0;
        if (pitchSpecs == FROM_FILE || durationSpecs == FROM_FILE) {
            double[] scales = this.getScalesFromTextFile("d:/psolaParam.txt");
            if (pitchSpecs == FROM_FILE) {
                pscale = scales[0];
            }
            if (durationSpecs == FROM_FILE) {
                tscale = scales[1];
            }
            escale = scales[2];
            vscale = scales[3];
        }
        if (pitchSpecs == FROM_FILE || pitchSpecs == FROM_CODE || durationSpecs == FROM_FILE || durationSpecs == FROM_CODE) {
            if (pitchSpecs == FROM_FILE || pitchSpecs == FROM_CODE) {
                for (j = 0; j < pitchScales.length; ++j) {
                    pitchScales[j] = pscale;
                }
            }
            if (durationSpecs == FROM_FILE || durationSpecs == FROM_CODE) {
                for (j = 0; j < timeScales.length; ++j) {
                    timeScales[j] = tscale;
                }
            }
        }
        this.tscaleSingle = firstTScale = timeScales[0];
        for (j = 0; j < timeScales.length; ++j) {
            if (j == 0 || timeScales[j] == firstTScale) continue;
            this.tscaleSingle = -1.0;
            break;
        }
        boolean bLastInputFrame = false;
        double[] frmIn = null;
        double[] frmTmp = null;
        double[] yOut = null;
        double[] yOutTmp = null;
        Datagram[] tmpDatagram = new Datagram[1];
        this.origLen = 0;
        this.numfrm = 0;
        for (j = 0; j < datagrams.length; ++j) {
            this.origLen = j == datagrams.length - 1 ? (rightContext != null ? (int)((long)this.origLen + (datagrams[j].getDuration() + rightContext.getDuration())) : (int)((long)this.origLen + datagrams[j].getDuration())) : (int)((long)this.origLen + datagrams[j].getDuration());
            ++this.numfrm;
        }
        int yCounter = -1;
        for (j = 0; j < datagrams.length; ++j) {
            int tmpLen;
            frmIn = null;
            int inputFrameSize = 0;
            if (bLastDatagram && j == datagrams.length - 1) {
                bLastInputFrame = true;
            }
            int currentPeriod = (int)datagrams[j].getDuration();
            if (j < datagrams.length - 1) {
                inputFrameSize = (int)datagrams[j].getDuration() + (int)datagrams[j + 1].getDuration();
                frmIn = new double[inputFrameSize];
                tmpDatagram[0] = datagrams[j];
                frmTmp = new DatagramDoubleDataSource(tmpDatagram).getAllData();
                tmpLen = frmTmp.length;
                System.arraycopy(frmTmp, 0, frmIn, 0, tmpLen);
                tmpDatagram[0] = datagrams[j + 1];
                frmTmp = new DatagramDoubleDataSource(tmpDatagram).getAllData();
                System.arraycopy(frmTmp, 0, frmIn, tmpLen, frmTmp.length);
            } else if (rightContext != null) {
                inputFrameSize = (int)datagrams[j].getDuration() + (int)rightContext.getDuration();
                frmIn = new double[inputFrameSize];
                tmpDatagram[0] = datagrams[j];
                frmTmp = new DatagramDoubleDataSource(tmpDatagram).getAllData();
                tmpLen = frmTmp.length;
                System.arraycopy(frmTmp, 0, frmIn, 0, tmpLen);
                tmpDatagram[0] = rightContext;
                frmTmp = new DatagramDoubleDataSource(tmpDatagram).getAllData();
                System.arraycopy(frmTmp, 0, frmIn, tmpLen, frmTmp.length);
            } else {
                inputFrameSize = 2 * (int)datagrams[j].getDuration();
                frmIn = new double[inputFrameSize];
                Arrays.fill(frmIn, 0.0);
                tmpDatagram[0] = datagrams[j];
                frmTmp = new DatagramDoubleDataSource(tmpDatagram).getAllData();
                tmpLen = frmTmp.length;
                System.arraycopy(frmTmp, 0, frmIn, 0, tmpLen);
            }
            if (frmIn == null) continue;
            isVoiced = SignalProcUtils.getVoicing(frmIn, (int)audioformat.getSampleRate(), 0.35f);
            try {
                output = this.processFrame(frmIn, isVoiced, pitchScales[j], timeScales[j], escale, vscale, bLastInputFrame, currentPeriod, inputFrameSize);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            boolean bBroken = false;
            if (output != null) {
                if (yOut == null) {
                    yOut = new double[output.length];
                    System.arraycopy(output, 0, yOut, 0, output.length);
                } else {
                    yOutTmp = new double[yOut.length];
                    System.arraycopy(yOut, 0, yOutTmp, 0, yOut.length);
                    yOut = new double[yOutTmp.length + output.length];
                    System.arraycopy(yOutTmp, 0, yOut, 0, yOutTmp.length);
                    System.arraycopy(output, 0, yOut, yOutTmp.length, output.length);
                }
            }
            if (bBroken) break;
        }
        try {
            output = this.writeFinal();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (output != null) {
            if (yOut == null) {
                yOut = new double[output.length];
                System.arraycopy(output, 0, yOut, 0, output.length);
            } else {
                yOutTmp = new double[yOut.length];
                System.arraycopy(yOut, 0, yOutTmp, 0, yOut.length);
                yOut = new double[yOutTmp.length + output.length];
                System.arraycopy(yOutTmp, 0, yOut, 0, yOutTmp.length);
                System.arraycopy(output, 0, yOut, yOutTmp.length, output.length);
            }
        }
        return yOut;
    }

    public double[] getScalesFromTextFile(String strScaleFile) {
        double[] scales = new double[4];
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(strScaleFile));
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        StreamTokenizer stok = new StreamTokenizer(r);
        stok.parseNumbers();
        try {
            stok.nextToken();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        for (int i = 0; i < scales.length; ++i) {
            if (stok.ttype == -2) {
                scales[i] = stok.nval;
            }
            try {
                stok.nextToken();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            ((Reader)r).close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return scales;
    }

    public void fdpsolaOnline() throws IOException {
        this.inputFrameIndex = 0;
        for (int i = 0; i < this.numfrm; ++i) {
            double[] frmIn = this.psFrm.getNextFrame();
            if (this.bBroke) break;
            boolean isLastInputFrame = i == this.numfrm - 1;
            int currentPeriod = this.pm.pitchMarks[i + 1] - this.pm.pitchMarks[i];
            int inputFrameSize = this.pm.pitchMarks[i + this.modParams.numPeriods] - this.pm.pitchMarks[i] + 1;
            boolean isVoiced = (double)this.pm.f0s[i] > 10.0;
            this.processFrame(frmIn, isVoiced, this.modParams.pscalesVar[i], this.modParams.tscalesVar[i], this.modParams.escalesVar[i], this.modParams.vscalesVar[i], isLastInputFrame, currentPeriod, inputFrameSize);
        }
        this.writeFinal();
        this.convertToWav(this.inputAudio.getFormat());
        this.inputAudio.close();
    }

    public double[] processFrame(double[] frmIn, boolean isVoiced, double pscale, double tscale, double escale, double vscale, boolean isLastInputFrame, int currentPeriod, int inputFrameSize) throws IOException {
        if (pscale < MIN_PSCALE) {
            pscale = MIN_PSCALE;
        }
        if (pscale > MAX_PSCALE) {
            pscale = MAX_PSCALE;
        }
        if (tscale < MIN_TSCALE) {
            tscale = MIN_TSCALE;
        }
        if (tscale > MAX_TSCALE) {
            tscale = MAX_TSCALE;
        }
        double[] output = null;
        double[] outputTmp = null;
        this.repeatSkipCount = 0;
        this.frmSize = inputFrameSize;
        if (this.frmSize % 2 != 0) {
            ++this.frmSize;
        }
        if (this.frmSize < 4) {
            this.frmSize = 4;
        }
        if (isVoiced) {
            this.newFrmSize = (int)Math.floor((double)this.frmSize / pscale + 0.5);
            if (this.newFrmSize % 2 != 0) {
                ++this.newFrmSize;
            }
            if (this.newFrmSize < 4) {
                this.newFrmSize = 4;
            }
        } else {
            this.newFrmSize = this.frmSize;
        }
        this.newPeriod = (int)Math.floor((double)this.newFrmSize / (double)NUM_PITCH_SYNC_PERIODS + 0.5);
        this.localDurDiff = this.nextAdd + ((double)this.frmSize * tscale - (double)this.newFrmSize) / (double)NUM_PITCH_SYNC_PERIODS;
        this.nextAdd = 0.0;
        if (this.localDurDiff < -0.1 * (double)this.newPeriod) {
            --this.repeatSkipCount;
            if (!isLastInputFrame) {
                this.nextAdd = this.localDurDiff + (double)this.newPeriod;
                this.localDurDiff = 0.0;
            }
        } else if (this.localDurDiff > 0.1 * (double)this.newPeriod) {
            while (this.localDurDiff > 0.1 * (double)this.newPeriod) {
                ++this.repeatSkipCount;
                this.localDurDiff -= (double)this.newPeriod;
            }
            if (!isLastInputFrame) {
                this.nextAdd = this.localDurDiff;
                this.localDurDiff = 0.0;
            }
        }
        this.sumLocalDurDiffs += this.localDurDiff;
        if (isLastInputFrame) {
            this.localDurDiff = this.sumLocalDurDiffs;
            while (this.localDurDiff > 0.0) {
                ++this.repeatSkipCount;
                this.localDurDiff -= (double)this.newPeriod;
            }
        }
        if (isLastInputFrame) {
            ++this.repeatSkipCount;
            this.bLastFrame = true;
        }
        if (this.repeatSkipCount > -1) {
            int j;
            int k;
            this.frm = MathUtils.zeros(this.frmSize);
            System.arraycopy(frmIn, 0, this.frm, 0, Math.min(frmIn.length, this.frmSize));
            this.wgt = this.windowIn.values(this.frmSize);
            this.bWarp = vscale != 1.0;
            if (isVoiced && pscale != 1.0 || this.bWarp) {
                if (this.fftSize < this.frmSize) {
                    this.fftSize = (int)Math.pow(2.0, Math.ceil(Math.log(this.frmSize) / Math.log(2.0)));
                    this.maxFreq = this.fftSize / 2 + 1;
                }
                this.newMaxFreq = (int)Math.floor((double)this.maxFreq / pscale + 0.5);
                if (this.newMaxFreq < 3) {
                    this.newMaxFreq = 3;
                }
                if (this.newMaxFreq % 2 != 1) {
                    ++this.newMaxFreq;
                }
                this.newFftSize = 2 * (this.newMaxFreq - 1);
                this.frmEn = SignalProcUtils.getEnergy(this.frm);
                super.initialise(this.lpOrder, this.fs, this.fftSize, true);
                this.windowIn.applyInline(this.frm, 0, this.frmSize);
                this.applyInline(this.frm, 0, this.frmSize);
                this.inputVT = MathUtils.interpolate(this.vtSpectrum, this.newMaxFreq);
                if (this.bWarp) {
                    this.tmpvsc[0] = vscale;
                    this.newVScales = MathUtils.modifySize(this.tmpvsc, this.newMaxFreq);
                    for (k = 0; k < this.newVScales.length; ++k) {
                        if (!(this.newVScales[k] < 0.05)) continue;
                        this.newVScales[k] = 0.05;
                    }
                    this.py2 = new double[this.newMaxFreq];
                    for (k = 0; k < this.newMaxFreq; ++k) {
                        int wInd = (int)Math.floor((double)(k + 1) / this.newVScales[k] + 0.5);
                        if (wInd < 1) {
                            wInd = 1;
                        }
                        if (wInd > this.newMaxFreq) {
                            wInd = this.newMaxFreq;
                        }
                        this.py2[k] = this.inputVT[wInd - 1];
                    }
                    System.arraycopy(this.py2, 0, this.inputVT, 0, this.newMaxFreq);
                }
                this.hy = new ComplexArray(this.newFftSize);
                this.hy.real = MathUtils.zeros(this.newFftSize);
                this.hy.imag = MathUtils.zeros(this.newFftSize);
                System.arraycopy(this.h.real, 0, this.hy.real, 0, Math.min(this.maxFreq, this.newFftSize));
                System.arraycopy(this.h.imag, 0, this.hy.imag, 0, Math.min(this.maxFreq, this.newFftSize));
                int kMax = 1;
                while (this.newMaxFreq > (kMax + 1) * (this.maxFreq - 2)) {
                    ++kMax;
                }
                for (k = 1; k <= kMax; ++k) {
                    int tmpMul;
                    int tmpAdd;
                    int tmpFix = (this.maxFreq - 2) * k;
                    if (k % 2 == 1) {
                        tmpAdd = this.maxFreq + 2;
                        tmpMul = 1;
                    } else {
                        tmpAdd = -1;
                        tmpMul = -1;
                    }
                    for (j = tmpFix + 3; j <= Math.min(this.newMaxFreq, this.maxFreq + tmpFix); ++j) {
                        this.hy.real[j - 1] = this.h.real[tmpMul * (tmpFix - j) + tmpAdd - 1];
                        this.hy.imag[j - 1] = this.h.imag[tmpMul * (tmpFix - j) + tmpAdd - 1];
                    }
                }
                this.hy.real[this.newMaxFreq - 1] = Math.sqrt(this.hy.real[this.newMaxFreq - 1] * this.hy.real[this.newMaxFreq - 1] + this.hy.imag[this.newMaxFreq - 1] * this.hy.imag[this.newMaxFreq - 1]);
                this.hy.imag[this.newMaxFreq - 1] = 0.0;
                for (k = 1; k <= this.newMaxFreq; ++k) {
                    int n = k - 1;
                    this.hy.real[n] = this.hy.real[n] * this.inputVT[k - 1];
                    int n2 = k - 1;
                    this.hy.imag[n2] = this.hy.imag[n2] * this.inputVT[k - 1];
                }
                for (k = this.newMaxFreq + 1; k <= this.newFftSize; ++k) {
                    this.hy.real[k - 1] = this.hy.real[2 * this.newMaxFreq - 1 - k];
                    this.hy.imag[k - 1] = -this.hy.imag[2 * this.newMaxFreq - 1 - k];
                }
                this.hy = FFTMixedRadix.ifft(this.hy);
                this.frmy = new double[this.newFrmSize];
                System.arraycopy(this.hy.real, 0, this.frmy, 0, this.newFrmSize);
                this.frmyEn = SignalProcUtils.getEnergy(this.frmy);
                this.gain = this.frmEn / Math.sqrt(this.frmSize) / (this.frmyEn / Math.sqrt(this.newFrmSize)) * escale;
            } else {
                if (this.frmSize < this.newFrmSize) {
                    this.newFrmSize = this.frmSize;
                }
                this.frmy = new double[this.newFrmSize];
                for (k = 0; k < this.frmSize; ++k) {
                    this.frmy[k] = this.frm[k] * this.wgt[k];
                }
                this.gain = escale;
            }
            k = 0;
            while (k < this.newFrmSize) {
                int n = k++;
                this.frmy[n] = this.frmy[n] * this.gain;
            }
            for (j = 1; j <= this.repeatSkipCount + 1; ++j) {
                this.newSkipSize = isVoiced ? (int)Math.floor((double)currentPeriod / pscale + 0.5) : (int)Math.floor((double)currentPeriod + 0.5);
                this.bLastFrame = isLastInputFrame && j == this.repeatSkipCount + 1;
                ++this.synthFrameInd;
                this.wgty = this.windowOut.values(this.newFrmSize);
                if (this.synthFrameInd == 1) {
                    this.halfWin = (int)Math.floor((double)this.newFrmSize / 2.0 + 0.5);
                    this.synthTotal = this.synthSt + this.newFrmSize;
                    if (this.ySynthInd + this.newFrmSize - 1 <= this.maxNewFrmSize) {
                        for (k = this.ySynthInd; k <= this.ySynthInd + this.halfWin - 1; ++k) {
                            this.ySynthBuff[k - 1] = this.frmy[k - this.ySynthInd];
                            this.wSynthBuff[k - 1] = 1.0;
                        }
                        for (k = this.ySynthInd + this.halfWin; k <= this.ySynthInd + this.newFrmSize - 1; ++k) {
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                            int n3 = k - 1;
                            this.wSynthBuff[n3] = this.wSynthBuff[n3] + this.wgty[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                        }
                    } else {
                        for (k = this.ySynthInd; k <= this.maxNewFrmSize; ++k) {
                            if (k - this.ySynthInd < this.halfWin) {
                                this.ySynthBuff[k - 1] = this.frmy[k - this.ySynthInd];
                                this.wSynthBuff[k - 1] = 1.0;
                                continue;
                            }
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                            int n4 = k - 1;
                            this.wSynthBuff[n4] = this.wSynthBuff[n4] + this.wgty[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                        }
                        for (k = 1; k <= this.newFrmSize - 1 - this.maxNewFrmSize + this.ySynthInd; ++k) {
                            if (this.maxNewFrmSize - this.ySynthInd + k < this.halfWin) {
                                this.ySynthBuff[k - 1] = this.frmy[this.maxNewFrmSize - this.ySynthInd + k];
                                this.wSynthBuff[k - 1] = 1.0;
                                continue;
                            }
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[this.maxNewFrmSize - this.ySynthInd + k] * this.wgty[this.maxNewFrmSize - this.ySynthInd + k];
                            int n5 = k - 1;
                            this.wSynthBuff[n5] = this.wSynthBuff[n5] + this.wgty[this.maxNewFrmSize - this.ySynthInd + k] * this.wgty[this.maxNewFrmSize - this.ySynthInd + k];
                        }
                    }
                    if (!this.bSilent) {
                        System.out.println("Synthesized using frame " + String.valueOf(this.inputFrameIndex + 1));
                    }
                } else if (this.bLastFrame) {
                    this.halfWin = (int)Math.floor((double)this.newFrmSize / 2.0 + 0.5);
                    int remain = this.newFrmSize - this.halfWin;
                    this.synthTotal = this.synthSt + this.halfWin + remain - 1;
                    if (this.ySynthInd + this.newFrmSize - 1 <= this.maxNewFrmSize) {
                        for (k = this.ySynthInd; k <= this.ySynthInd + this.halfWin - 1; ++k) {
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                            int n6 = k - 1;
                            this.wSynthBuff[n6] = this.wSynthBuff[n6] + this.wgty[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                        }
                        for (k = this.ySynthInd + this.halfWin; k <= this.ySynthInd + this.newFrmSize - 1; ++k) {
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd];
                            this.wSynthBuff[k - 1] = 1.0;
                        }
                    } else {
                        for (k = this.ySynthInd; k <= this.maxNewFrmSize; ++k) {
                            if (k - this.ySynthInd < this.halfWin) {
                                int n = k - 1;
                                this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                                int n7 = k - 1;
                                this.wSynthBuff[n7] = this.wSynthBuff[n7] + this.wgty[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                                continue;
                            }
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd];
                            this.wSynthBuff[k - 1] = 1.0;
                        }
                        for (k = 1; k <= this.newFrmSize - 1 - this.maxNewFrmSize + this.ySynthInd; ++k) {
                            if (this.maxNewFrmSize - this.ySynthInd + k < this.halfWin) {
                                int n = k - 1;
                                this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[this.maxNewFrmSize - this.ySynthInd + k] * this.wgty[this.maxNewFrmSize - this.ySynthInd + k];
                                int n8 = k - 1;
                                this.wSynthBuff[n8] = this.wSynthBuff[n8] + this.wgty[this.maxNewFrmSize - this.ySynthInd + k] * this.wgty[this.maxNewFrmSize - this.ySynthInd + k];
                                continue;
                            }
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[this.maxNewFrmSize - this.ySynthInd + k];
                            this.wSynthBuff[k - 1] = 1.0;
                        }
                    }
                    if (!this.bSilent) {
                        System.out.println("Synthesized using frame " + String.valueOf(this.inputFrameIndex + 1));
                    }
                } else {
                    if (!isVoiced && this.repeatSkipCount % 2 == 1) {
                        this.frmy = SignalProcUtils.reverse(this.frmy);
                    }
                    this.synthTotal = this.synthSt + this.newFrmSize;
                    if (this.ySynthInd + this.newFrmSize - 1 <= this.maxNewFrmSize) {
                        for (k = this.ySynthInd; k <= this.ySynthInd + this.newFrmSize - 1; ++k) {
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                            int n9 = k - 1;
                            this.wSynthBuff[n9] = this.wSynthBuff[n9] + this.wgty[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                        }
                    } else {
                        for (k = this.ySynthInd; k <= this.maxNewFrmSize; ++k) {
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                            int n10 = k - 1;
                            this.wSynthBuff[n10] = this.wSynthBuff[n10] + this.wgty[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                        }
                        for (k = 1; k <= this.newFrmSize - 1 - this.maxNewFrmSize + this.ySynthInd; ++k) {
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k + this.maxNewFrmSize - this.ySynthInd] * this.wgty[k + this.maxNewFrmSize - this.ySynthInd];
                            int n11 = k - 1;
                            this.wSynthBuff[n11] = this.wSynthBuff[n11] + this.wgty[k + this.maxNewFrmSize - this.ySynthInd] * this.wgty[k + this.maxNewFrmSize - this.ySynthInd];
                        }
                    }
                    if (!this.bSilent) {
                        if (j == 1) {
                            System.out.println("Synthesized using frame " + String.valueOf(this.inputFrameIndex + 1));
                        } else {
                            System.out.println("Repeated using frame " + String.valueOf(this.inputFrameIndex + 1));
                        }
                    }
                }
                for (k = 0; k <= this.newSkipSize - 1; ++k) {
                    int kInd = (k + this.ySynthInd) % this.maxNewFrmSize;
                    if (kInd == 0) {
                        kInd = this.maxNewFrmSize;
                    }
                    this.outBuff[this.outBuffStart - 1] = this.wSynthBuff[kInd - 1] > 0.0 ? this.ySynthBuff[kInd - 1] / this.wSynthBuff[kInd - 1] : this.ySynthBuff[kInd - 1];
                    this.ySynthBuff[kInd - 1] = 0.0;
                    this.wSynthBuff[kInd - 1] = 0.0;
                    ++this.outBuffStart;
                    if (this.outBuffStart <= this.outBuffLen) continue;
                    if (this.tscaleSingle != 1.0 || this.totalWrittenToFile + this.outBuffLen <= this.origLen) {
                        if (this.isWavFileOutput) {
                            this.dout.writeDouble(this.outBuff, 0, this.outBuffLen);
                        } else if (output == null) {
                            output = new double[this.outBuffLen];
                            System.arraycopy(this.outBuff, 0, output, 0, this.outBuffLen);
                        } else {
                            outputTmp = new double[output.length];
                            System.arraycopy(output, 0, outputTmp, 0, output.length);
                            output = new double[outputTmp.length + this.outBuffLen];
                            System.arraycopy(outputTmp, 0, output, 0, outputTmp.length);
                            System.arraycopy(this.outBuff, 0, output, outputTmp.length, this.outBuffLen);
                        }
                        this.totalWrittenToFile += this.outBuffLen;
                    } else {
                        if (this.isWavFileOutput) {
                            this.dout.writeDouble(this.outBuff, 0, this.origLen - this.totalWrittenToFile);
                        } else if (output == null) {
                            output = new double[this.origLen - this.totalWrittenToFile];
                            System.arraycopy(this.outBuff, 0, output, 0, this.origLen - this.totalWrittenToFile);
                        } else {
                            outputTmp = new double[output.length];
                            System.arraycopy(output, 0, outputTmp, 0, output.length);
                            output = new double[outputTmp.length + this.origLen - this.totalWrittenToFile];
                            System.arraycopy(outputTmp, 0, output, 0, outputTmp.length);
                            System.arraycopy(this.outBuff, 0, output, outputTmp.length, this.origLen - this.totalWrittenToFile);
                        }
                        this.totalWrittenToFile = this.origLen;
                    }
                    this.outBuffStart = 1;
                }
                this.synthSt += this.newSkipSize;
                this.ySynthInd = this.ySynthInd + this.newSkipSize <= this.maxNewFrmSize ? (this.ySynthInd += this.newSkipSize) : (this.ySynthInd += this.newSkipSize - this.maxNewFrmSize);
                if (!this.bLastFrame) continue;
                this.bBroke = true;
                break;
            }
        } else if (!this.bSilent) {
            System.out.println("Skipped frame " + String.valueOf(this.inputFrameIndex + 1));
        }
        ++this.inputFrameIndex;
        return output;
    }

    public double[] writeFinal() throws IOException {
        double[] output = null;
        double[] outputTmp = null;
        if (this.tscaleSingle == 1.0) {
            this.synthTotal = this.origLen;
        }
        if (this.outBuffLen > this.synthTotal) {
            this.outBuffLen = this.synthTotal;
        }
        for (int k = this.synthSt; k <= this.synthTotal; ++k) {
            int kInd = (k - this.synthSt + this.ySynthInd) % this.maxNewFrmSize;
            if (kInd == 0) {
                kInd = this.maxNewFrmSize;
            }
            this.outBuff[this.outBuffStart - 1] = this.wSynthBuff[kInd - 1] > 0.0 ? this.ySynthBuff[kInd - 1] / this.wSynthBuff[kInd - 1] : this.ySynthBuff[kInd - 1];
            this.ySynthBuff[kInd - 1] = 0.0;
            this.wSynthBuff[kInd - 1] = 0.0;
            ++this.outBuffStart;
            if (this.outBuffStart <= this.outBuffLen) continue;
            if (this.tscaleSingle != 1.0 || this.totalWrittenToFile + this.outBuffLen <= this.origLen) {
                if (this.isWavFileOutput) {
                    this.dout.writeDouble(this.outBuff, 0, this.outBuffLen);
                } else if (output == null) {
                    output = new double[this.outBuffLen];
                    System.arraycopy(this.outBuff, 0, output, 0, this.outBuffLen);
                } else {
                    outputTmp = new double[output.length];
                    System.arraycopy(output, 0, outputTmp, 0, output.length);
                    output = new double[outputTmp.length + this.outBuffLen];
                    System.arraycopy(outputTmp, 0, output, 0, outputTmp.length);
                    System.arraycopy(this.outBuff, 0, output, outputTmp.length, this.outBuffLen);
                }
                this.totalWrittenToFile += this.outBuffLen;
            } else {
                if (this.isWavFileOutput) {
                    this.dout.writeDouble(this.outBuff, 0, this.origLen - this.totalWrittenToFile);
                } else if (output == null) {
                    output = new double[this.origLen - this.totalWrittenToFile];
                    System.arraycopy(this.outBuff, 0, output, 0, this.origLen - this.totalWrittenToFile);
                } else {
                    outputTmp = new double[output.length];
                    System.arraycopy(output, 0, outputTmp, 0, output.length);
                    output = new double[outputTmp.length + this.origLen - this.totalWrittenToFile];
                    System.arraycopy(outputTmp, 0, output, 0, outputTmp.length);
                    System.arraycopy(this.outBuff, 0, output, outputTmp.length, this.origLen - this.totalWrittenToFile);
                }
                this.totalWrittenToFile = this.origLen;
            }
            this.outBuffStart = 1;
        }
        if (this.outBuffStart > 1) {
            if (this.tscaleSingle != 1.0 || this.totalWrittenToFile + this.outBuffStart - 1 <= this.origLen) {
                if (this.isWavFileOutput) {
                    this.dout.writeDouble(this.outBuff, 0, this.outBuffStart - 1);
                } else if (output == null) {
                    output = new double[this.outBuffStart - 1];
                    System.arraycopy(this.outBuff, 0, output, 0, this.outBuffStart - 1);
                } else {
                    outputTmp = new double[output.length];
                    System.arraycopy(output, 0, outputTmp, 0, output.length);
                    output = new double[outputTmp.length + this.outBuffStart - 1];
                    System.arraycopy(outputTmp, 0, output, 0, outputTmp.length);
                    System.arraycopy(this.outBuff, 0, output, outputTmp.length, this.outBuffStart - 1);
                }
                this.totalWrittenToFile += this.outBuffStart - 1;
            } else {
                if (this.isWavFileOutput) {
                    this.dout.writeDouble(this.outBuff, 0, this.origLen - this.totalWrittenToFile);
                } else if (output == null) {
                    output = new double[this.origLen - this.totalWrittenToFile];
                    System.arraycopy(this.outBuff, 0, output, 0, this.origLen - this.totalWrittenToFile);
                } else {
                    outputTmp = new double[output.length];
                    System.arraycopy(output, 0, outputTmp, 0, output.length);
                    output = new double[outputTmp.length + this.origLen - this.totalWrittenToFile];
                    System.arraycopy(outputTmp, 0, output, 0, outputTmp.length);
                    System.arraycopy(this.outBuff, 0, output, outputTmp.length, this.origLen - this.totalWrittenToFile);
                }
                this.totalWrittenToFile = this.origLen;
            }
        }
        if (this.dout != null) {
            this.dout.close();
        }
        return output;
    }

    public void convertToWav(AudioFormat audioformat) throws IOException {
        if (this.tempOutBinaryFile != null) {
            double[] yOut = null;
            this.din = new LEDataInputStream(this.tempOutBinaryFile);
            yOut = this.din.readDouble(this.totalWrittenToFile);
            this.din.close();
            double tmpMax = MathUtils.getAbsMax(yOut);
            if (tmpMax > 1.0) {
                int n = 0;
                while (n < yOut.length) {
                    int n2 = n++;
                    yOut[n2] = yOut[n2] / tmpMax;
                }
            }
            this.outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(yOut), audioformat);
            AudioSystem.write((AudioInputStream)this.outputAudio, AudioFileFormat.Type.WAVE, new File(this.outputFile));
            File tmpFile = new File(this.tempOutBinaryFile);
            tmpFile.delete();
        }
    }

    public static void mainParametric(String inputWavFile, double[] pscales, double[] tscales, double[] escales, double[] vscales) throws UnsupportedAudioFileException, IOException {
        String strExt = "";
        if (pscales.length == 1 && tscales.length == 1) {
            String strTmp;
            if (pscales[0] != 1.0) {
                strTmp = String.valueOf(pscales[0]);
                while (strTmp.length() < 4) {
                    strTmp = strTmp + "0";
                }
                strTmp = strTmp.substring(0, 1) + strTmp.substring(2, 3) + strTmp.substring(3, 4);
                strExt = strExt + "_p" + strTmp;
            }
            if (tscales[0] != 1.0) {
                strTmp = String.valueOf(tscales[0]);
                while (strTmp.length() < 4) {
                    strTmp = strTmp + "0";
                }
                strTmp = strTmp.substring(0, 1) + strTmp.substring(2, 3) + strTmp.substring(3, 4);
                strExt = strExt + "_d" + strTmp;
            }
            if (pscales[0] == 1.0 && tscales[0] == 1.0) {
                strExt = "_none";
            }
        } else {
            strExt = "_pvar_dvar";
        }
        String strOutputFile = inputWavFile.substring(0, inputWavFile.length() - 4) + "_fd" + strExt + ".wav";
        String strPitchFile = inputWavFile.substring(0, inputWavFile.length() - 4) + ".ptc";
        FDPSOLAProcessor fd = new FDPSOLAProcessor(inputWavFile, strPitchFile, strOutputFile, pscales, tscales, escales, vscales);
        fd.fdpsolaOnline();
    }

    public static void main(String[] args) throws Exception {
        double[] pscales = new double[]{1.0};
        double[] tscales = new double[]{1.2};
        double[] escales = new double[]{1.0};
        double[] vscales = new double[]{1.0};
        FDPSOLAProcessor.mainParametric(args[0], pscales, tscales, escales, vscales);
        System.out.println("FDPSOLA test completed...");
    }
}

