/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import marytts.signalproc.analysis.PitchFileHeader;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.util.io.FileUtils;
import marytts.util.io.LEDataInputStream;
import marytts.util.io.LEDataOutputStream;

public class SPTKPitchReaderWriter {
    private PitchFileHeader header;
    private double[] contour;
    private final float NEGATIVE_MAXIMUM = -1.0E10f;

    public SPTKPitchReaderWriter(String lf0SPTKFile) {
        this(lf0SPTKFile, 0.005f, 0.005f, 16000);
    }

    public SPTKPitchReaderWriter(String lf0SPTKFile, float windowSizeInSeconds, float skipSizeInSeconds, int samplingRate) {
        this.contour = null;
        this.header = new PitchFileHeader();
        this.header.windowSizeInSeconds = windowSizeInSeconds;
        this.header.skipSizeInSeconds = skipSizeInSeconds;
        this.header.fs = samplingRate;
        try {
            this.contour = this.readSPTKF0Data(lf0SPTKFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SPTKPitchReaderWriter(double[] contour, PitchFileHeader header) {
        this.contour = contour;
        this.header = header;
    }

    public double[] getF0Contour() {
        return this.contour;
    }

    public PitchFileHeader getPitchFileHeader() {
        return this.header;
    }

    private int getNumberOfFrames(String lf0SPTKFile) throws IOException {
        LEDataInputStream lf0Data = new LEDataInputStream((InputStream)new BufferedInputStream(new FileInputStream(lf0SPTKFile)));
        int totalFrame = 0;
        try {
            while (true) {
                float fval = lf0Data.readFloat();
                ++totalFrame;
            }
        }
        catch (EOFException e) {
            lf0Data.close();
            return totalFrame;
        }
    }

    private double[] readSPTKF0Data(String lf0SPTKFile) throws IOException {
        if (!FileUtils.exists((String)lf0SPTKFile)) {
            System.out.println("SPTK Pitch file not found: " + lf0SPTKFile);
            return null;
        }
        int numberOfFrames = this.getNumberOfFrames(lf0SPTKFile);
        LEDataInputStream lf0Data = new LEDataInputStream((InputStream)new BufferedInputStream(new FileInputStream(lf0SPTKFile)));
        double[] f0Data = new double[numberOfFrames];
        for (int i = 0; i < numberOfFrames; ++i) {
            float f0Value = lf0Data.readFloat();
            f0Data[i] = f0Value < 0.0f ? 0.0 : new Double(Math.exp(f0Value));
        }
        return f0Data;
    }

    public void writeIntoSPTKLF0File(String sptkFileName) throws IOException {
        LEDataOutputStream lf0Data = new LEDataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(sptkFileName)));
        for (int i = 0; i < this.contour.length; ++i) {
            double f0Val = this.contour[i];
            if (this.contour[i] == 0.0) {
                lf0Data.writeFloat(-1.0E10f);
                continue;
            }
            lf0Data.writeFloat((float)Math.log(this.contour[i]));
        }
        lf0Data.flush();
        lf0Data.close();
    }

    public void writeIntoMARYPTCfile(String ptcFileName) throws IOException {
        PitchReaderWriter.write_pitch_file(ptcFileName, this.contour, (float)this.header.windowSizeInSeconds, (float)this.header.skipSizeInSeconds, this.header.fs);
    }

    public static void main(String[] args) throws IOException {
        String lf0File = "/home/sathish/Desktop/test/Poppy2_091.lf0";
        SPTKPitchReaderWriter sprw = new SPTKPitchReaderWriter(lf0File);
        double[] f0contour = sprw.getF0Contour();
        PitchFileHeader hdr = sprw.getPitchFileHeader();
        SPTKPitchReaderWriter sprw1 = new SPTKPitchReaderWriter(f0contour, hdr);
        sprw1.writeIntoSPTKLF0File("/home/sathish/Desktop/test/Dummy.lf0");
        SPTKPitchReaderWriter sprw2 = new SPTKPitchReaderWriter("/home/sathish/Desktop/test/Dummy.lf0");
        f0contour = sprw2.getF0Contour();
        hdr = sprw2.getPitchFileHeader();
        for (int i = 0; i < f0contour.length; ++i) {
            System.out.println((float)Math.log(f0contour[i]));
        }
        System.out.println("No. of frames: " + f0contour.length);
    }
}

