/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import marytts.signalproc.analysis.PitchFileHeader;
import marytts.util.io.FileUtils;
import marytts.util.io.LEDataInputStream;
import marytts.util.io.LEDataOutputStream;
import marytts.util.math.ArrayUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class PitchReaderWriter {
    public PitchFileHeader header = new PitchFileHeader();
    public double[] contour = null;

    public PitchReaderWriter(String file) {
        this.header.windowSizeInSeconds = 0.0;
        this.header.skipSizeInSeconds = 0.0;
        this.header.fs = 0;
        try {
            this.read_pitch_file(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PitchReaderWriter() {
        this.header.windowSizeInSeconds = 0.0;
        this.header.skipSizeInSeconds = 0.0;
        this.header.fs = 0;
    }

    public PitchReaderWriter(int[] pitchMarks, int samplingRate, float windowSizeInSeconds, float skipSizeInSeconds) {
        int numfrm;
        this.header.windowSizeInSeconds = windowSizeInSeconds;
        this.header.skipSizeInSeconds = skipSizeInSeconds;
        this.header.fs = samplingRate;
        if (pitchMarks != null && pitchMarks.length > 1 && (numfrm = (int)Math.floor((double)((float)pitchMarks[pitchMarks.length - 2] / (float)this.header.fs) / this.header.skipSizeInSeconds + 0.5)) > 0) {
            float[] onsets = SignalProcUtils.samples2times(pitchMarks, this.header.fs);
            this.contour = new double[numfrm];
            for (int i = 0; i < numfrm; ++i) {
                float currentTime = (float)((double)i * this.header.skipSizeInSeconds + 0.5 * this.header.windowSizeInSeconds);
                int currentInd = MathUtils.findClosest(onsets, currentTime);
                this.contour[i] = currentInd < onsets.length - 1 ? (double)(this.header.fs / (pitchMarks[currentInd + 1] - pitchMarks[currentInd])) : (double)(this.header.fs / (pitchMarks[currentInd] - pitchMarks[currentInd - 1]));
            }
        }
    }

    public double[] getVoiceds() {
        return SignalProcUtils.getVoiceds(this.contour);
    }

    public void read_pitch_file(String ptcFile) throws IOException {
        if (FileUtils.exists((String)ptcFile)) {
            LEDataInputStream lr = new LEDataInputStream((InputStream)new DataInputStream(new FileInputStream(ptcFile)));
            if (lr != null) {
                int winsize = (int)lr.readFloat();
                int skipsize = (int)lr.readFloat();
                this.header.fs = (int)lr.readFloat();
                this.header.numfrm = (int)lr.readFloat();
                this.header.windowSizeInSeconds = (double)winsize / (double)this.header.fs;
                this.header.skipSizeInSeconds = (double)skipsize / (double)this.header.fs;
                this.contour = new double[this.header.numfrm];
                for (int i = 0; i < this.header.numfrm; ++i) {
                    this.contour[i] = lr.readFloat();
                }
                lr.close();
            }
        } else {
            System.out.println("Pitch file not found: " + ptcFile);
        }
    }

    public static void write_pitch_file(String ptcFile, double[] f0s, float windowSizeInSeconds, float skipSizeInSeconds, int samplingRate) throws IOException {
        float[] f0sFloat = new float[f0s.length];
        for (int i = 0; i < f0s.length; ++i) {
            f0sFloat[i] = (float)f0s[i];
        }
        PitchReaderWriter.write_pitch_file(ptcFile, f0sFloat, windowSizeInSeconds, skipSizeInSeconds, samplingRate);
    }

    public static void write_pitch_file(String ptcFile, float[] f0s, float windowSizeInSeconds, float skipSizeInSeconds, int samplingRate) throws IOException {
        LEDataOutputStream lw = new LEDataOutputStream((OutputStream)new DataOutputStream(new FileOutputStream(ptcFile)));
        if (lw != null) {
            int winsize = (int)Math.floor((double)(windowSizeInSeconds * (float)samplingRate) + 0.5);
            lw.writeFloat((float)winsize);
            int skipsize = (int)Math.floor((double)(skipSizeInSeconds * (float)samplingRate) + 0.5);
            lw.writeFloat((float)skipsize);
            lw.writeFloat((float)samplingRate);
            lw.writeFloat((float)f0s.length);
            lw.writeFloat(f0s);
            lw.close();
        }
    }

    public void setContour(double[] newContour) {
        this.contour = null;
        this.header.numfrm = 0;
        if (newContour != null && newContour.length > 0) {
            this.contour = ArrayUtils.copy(newContour);
            this.header.numfrm = this.contour.length;
        }
    }
}

