/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.analysis.PitchFileHeader;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.signalproc.display.FunctionGraph;
import marytts.signalproc.filter.BandPassFilter;
import marytts.signalproc.filter.FIRFilter;
import marytts.signalproc.filter.LowPassFilter;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.io.FileUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;
import marytts.util.string.StringUtils;

public class F0TrackerAutocorrelationHeuristic {
    public double[] f0s;
    protected PitchFileHeader params;
    protected int totalVoicedFrames;
    protected double[] voicingProbabilities;
    protected int minT0Index;
    protected int maxT0Index;
    protected double[] prevF0s;
    protected double[] voicedF0s;
    protected double longTermAverageF0;
    protected double shortTermAverageF0;
    public static double MAX_SAMPLE = 32767.0;
    public static double MINIMUM_SPEECH_ENERGY = 50.0;
    protected double averageSampleEnergy;
    private double[] pitchFrm;
    private int frameIndex;
    private int ws;
    private int ss;

    public F0TrackerAutocorrelationHeuristic(String wavFile) throws Exception {
        if (FileUtils.exists((String)wavFile)) {
            String ptcFile = StringUtils.modifyExtension((String)wavFile, (String)"ptc");
            this.params = new PitchFileHeader();
            this.init();
            PitchReaderWriter f0 = null;
            try {
                f0 = this.pitchAnalyzeWavFile(wavFile, ptcFile);
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            throw new Exception("Wav file not found!");
        }
    }

    public F0TrackerAutocorrelationHeuristic(String wavFile, String ptcFile) throws Exception {
        if (FileUtils.exists((String)wavFile)) {
            this.params = new PitchFileHeader();
            this.init();
            PitchReaderWriter f0 = null;
            try {
                f0 = this.pitchAnalyzeWavFile(wavFile, ptcFile);
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            throw new Exception("Wav file not found!");
        }
    }

    public F0TrackerAutocorrelationHeuristic(PitchFileHeader paramsIn) {
        this.params = new PitchFileHeader(paramsIn);
        this.init();
    }

    public void init() {
        int i;
        this.voicingProbabilities = new double[2];
        for (i = 0; i < this.voicingProbabilities.length; ++i) {
            this.voicingProbabilities[i] = 0.0;
        }
        this.prevF0s = new double[5];
        for (i = 0; i < this.prevF0s.length; ++i) {
            this.prevF0s[i] = 0.0;
        }
        this.voicedF0s = new double[20];
        for (i = 0; i < this.voicedF0s.length; ++i) {
            this.voicedF0s[i] = 0.0;
        }
        this.shortTermAverageF0 = this.longTermAverageF0 = 0.5 * (this.params.maximumF0 + this.params.minimumF0);
        this.frameIndex = 0;
        this.ws = (int)Math.floor(this.params.windowSizeInSeconds * (double)this.params.fs + 0.5);
        this.ss = (int)Math.floor(this.params.skipSizeInSeconds * (double)this.params.fs + 0.5);
        this.pitchFrm = new double[this.ws];
        this.minT0Index = (int)Math.floor((double)this.params.fs / this.params.maximumF0 + 0.5);
        this.maxT0Index = (int)Math.floor((double)this.params.fs / this.params.minimumF0 + 0.5);
        if (this.minT0Index < 0) {
            this.minT0Index = 0;
        }
        if (this.minT0Index > this.ws - 1) {
            this.minT0Index = this.ws - 1;
        }
        if (this.maxT0Index < this.minT0Index) {
            this.maxT0Index = this.minT0Index;
        }
        if (this.maxT0Index > this.ws - 1) {
            this.maxT0Index = this.ws - 1;
        }
    }

    public PitchReaderWriter pitchAnalyzeWavFile(String wavFileIn) throws UnsupportedAudioFileException, IOException {
        return this.pitchAnalyzeWavFile(wavFileIn, null);
    }

    public PitchReaderWriter pitchAnalyzeWavFile(String wavFileIn, String ptcFileOut) throws UnsupportedAudioFileException, IOException {
        PitchReaderWriter f0 = new PitchReaderWriter();
        this.pitchAnalyzeWav(wavFileIn);
        if (this.f0s != null) {
            this.params.numfrm = this.f0s.length;
            if (ptcFileOut != null) {
                PitchReaderWriter.write_pitch_file(ptcFileOut, this.f0s, (float)this.params.windowSizeInSeconds, (float)this.params.skipSizeInSeconds, this.params.fs);
            }
        } else {
            this.params.numfrm = 0;
        }
        f0.header = new PitchFileHeader(this.params);
        f0.setContour(this.f0s);
        return f0;
    }

    public void pitchAnalyzeWav(String wavFile) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(wavFile));
        this.params.fs = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        this.pitchAnalyze(signal);
    }

    public void pitchAnalyze(DoubleDataSource signal) {
        this.pitchAnalyze(signal.getAllData());
        this.params.numfrm = this.f0s != null ? this.f0s.length : 0;
    }

    private void pitchAnalyze(double[] x) {
        this.init();
        if (this.params.cutOff1 > 0.0 || this.params.cutOff2 > 0.0) {
            FIRFilter f = null;
            f = this.params.cutOff2 <= 0.0 ? new LowPassFilter(this.params.cutOff1 / (double)this.params.fs) : new BandPassFilter(this.params.cutOff1 / (double)this.params.fs, this.params.cutOff2 / (double)this.params.fs);
            if (f != null) {
                f.apply(x);
            }
        }
        this.f0s = null;
        int numfrm = (int)Math.floor(((double)x.length - (double)this.ws) / (double)this.ss + 0.5);
        if (numfrm <= 0) {
            return;
        }
        double maxSample = MathUtils.getAbsMax(x);
        this.f0s = new double[numfrm];
        this.frameIndex = 0;
        Arrays.fill(this.f0s, 0.0);
        Random random = new Random();
        for (int i = 0; i < numfrm; ++i) {
            System.arraycopy(x, i * this.ss, this.pitchFrm, 0, Math.min(this.ws, x.length - i * this.ss));
            for (int j = 0; j < this.ws; ++j) {
                this.pitchFrm[j] = this.pitchFrm[j] / maxSample * MAX_SAMPLE + 1.0E-50 * random.nextDouble();
            }
            this.f0s[i] = this.pitchFrameAutocorrelation(this.pitchFrm);
            ++this.frameIndex;
        }
    }

    private double pitchFrameAutocorrelation(double[] frmIn) {
        double tmp;
        int i;
        assert (this.pitchFrm.length == frmIn.length);
        System.arraycopy(this.pitchFrm, 0, frmIn, 0, frmIn.length);
        this.averageSampleEnergy = SignalProcUtils.getAverageSampleEnergy(this.pitchFrm);
        double f0 = 0.0;
        if (this.params.centerClippingRatio > 0.0) {
            SignalProcUtils.centerClip(this.pitchFrm, this.params.centerClippingRatio);
        }
        double r0 = 0.0;
        for (i = 0; i < this.pitchFrm.length; ++i) {
            r0 += this.pitchFrm[i] * this.pitchFrm[i];
        }
        int maxIndex = 0;
        double maxR = -1.0E10;
        for (i = this.minT0Index; i <= this.maxT0Index; ++i) {
            tmp = 0.0;
            for (int j = 0; j < this.pitchFrm.length - i; ++j) {
                tmp += this.pitchFrm[j] * this.pitchFrm[j + i];
            }
            if (!(tmp > maxR)) continue;
            maxIndex = i;
            maxR = tmp;
        }
        double probabilityOfVoicing = maxIndex == this.minT0Index || maxIndex == this.maxT0Index ? 0.0 : maxR / r0;
        f0 = (double)this.params.fs / (double)maxIndex;
        if (probabilityOfVoicing > this.params.voicingThreshold) {
            if (this.voicingProbabilities[0] < this.params.voicingThreshold && this.voicingProbabilities[1] > this.params.voicingThreshold) {
                this.voicingProbabilities[0] = this.params.voicingThreshold + 0.01;
            }
        } else if (probabilityOfVoicing > this.params.voicingThreshold - 0.1 && this.voicingProbabilities[0] > this.params.voicingThreshold && this.voicingProbabilities[1] > this.params.voicingThreshold) {
            probabilityOfVoicing = this.params.voicingThreshold + 0.01;
        }
        if (probabilityOfVoicing < this.params.voicingThreshold) {
            f0 = 0.0;
        }
        if (this.averageSampleEnergy < MINIMUM_SPEECH_ENERGY) {
            f0 = 0.0;
        }
        for (i = this.voicingProbabilities.length - 1; i > 0; --i) {
            this.voicingProbabilities[i] = this.voicingProbabilities[i - 1];
        }
        this.voicingProbabilities[0] = probabilityOfVoicing;
        if (f0 > 10.0) {
            ++this.totalVoicedFrames;
        }
        if ((this.params.isDoublingCheck || this.params.isHalvingCheck) && f0 > 10.0) {
            ++this.totalVoicedFrames;
            if (this.totalVoicedFrames > this.voicedF0s.length) {
                boolean bNeighVoiced = true;
                for (i = 0; i < this.voicingProbabilities.length; ++i) {
                    if (!(this.voicingProbabilities[i] < this.params.voicingThreshold)) continue;
                    bNeighVoiced = false;
                    break;
                }
                if (bNeighVoiced) {
                    if (this.params.isDoublingCheck && f0 > 1.25 * this.longTermAverageF0 && f0 > 1.33 * this.shortTermAverageF0) {
                        f0 *= 0.5;
                    }
                    if (this.params.isHalvingCheck && f0 < 0.8 * this.longTermAverageF0 && f0 < 0.66 * this.shortTermAverageF0) {
                        f0 *= 2.0;
                    }
                }
            }
        }
        if (f0 > 10.0) {
            this.longTermAverageF0 = 0.99 * this.longTermAverageF0 + 0.01 * f0;
            this.shortTermAverageF0 = 0.9 * this.shortTermAverageF0 + 0.1 * f0;
        }
        this.prevF0s[2] = f0;
        boolean bAllVoiced = true;
        for (i = 0; i < this.prevF0s.length; ++i) {
            if (!(this.prevF0s[i] < 10.0)) continue;
            bAllVoiced = false;
            break;
        }
        if (bAllVoiced) {
            tmp = 0.5 * this.prevF0s[2] + 0.25 * this.prevF0s[1] + 0.25 * this.prevF0s[0];
            f0 = MathUtils.median(this.prevF0s);
            if (Math.abs(tmp - f0) < 10.0) {
                f0 = tmp;
            }
            this.prevF0s[0] = this.prevF0s[1];
            this.prevF0s[1] = this.prevF0s[2];
            if (this.totalVoicedFrames == this.voicedF0s.length) {
                this.shortTermAverageF0 = this.longTermAverageF0 = MathUtils.median(this.voicedF0s);
            }
        }
        return f0;
    }

    public double getSkipSizeInSeconds() {
        return this.params.skipSizeInSeconds;
    }

    public double getWindowSizeInSeconds() {
        return this.params.windowSizeInSeconds;
    }

    public double[] getF0Contour() {
        return this.f0s;
    }

    public static void main(String[] args) throws Exception {
        F0TrackerAutocorrelationHeuristic tracker = new F0TrackerAutocorrelationHeuristic(new PitchFileHeader());
        tracker.pitchAnalyzeWavFile(args[0]);
        FunctionGraph f0Graph = new FunctionGraph(0.0, tracker.params.skipSizeInSeconds, tracker.f0s);
        f0Graph.showInJFrame("F0 curve for " + args[0], false, true);
    }
}

