/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.codebook;

import java.io.IOException;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.adaptation.BaselineAdaptationItem;
import marytts.signalproc.adaptation.BaselineAdaptationSet;
import marytts.signalproc.adaptation.BaselineFeatureExtractor;
import marytts.signalproc.adaptation.BaselinePostprocessor;
import marytts.signalproc.adaptation.BaselinePreprocessor;
import marytts.signalproc.adaptation.FdpsolaAdapter;
import marytts.signalproc.adaptation.TargetLsfCopyMapper;
import marytts.signalproc.adaptation.codebook.WeightedCodebook;
import marytts.signalproc.adaptation.codebook.WeightedCodebookFile;
import marytts.signalproc.adaptation.codebook.WeightedCodebookMapper;
import marytts.signalproc.adaptation.codebook.WeightedCodebookMapperParams;
import marytts.signalproc.adaptation.codebook.WeightedCodebookTransformer;
import marytts.signalproc.adaptation.codebook.WeightedCodebookTransformerParams;
import marytts.signalproc.adaptation.prosody.PitchMapping;
import marytts.signalproc.adaptation.prosody.PitchMappingFile;
import marytts.signalproc.adaptation.prosody.PitchStatistics;
import marytts.signalproc.adaptation.prosody.PitchTransformationData;
import marytts.signalproc.analysis.LsfFileHeader;
import marytts.util.io.FileUtils;
import marytts.util.string.StringUtils;

public class WeightedCodebookParallelTransformer
extends WeightedCodebookTransformer {
    public WeightedCodebookTransformerParams pa;
    public WeightedCodebookMapper mapper = null;
    private WeightedCodebookFile codebookFile;
    public WeightedCodebook codebook = null;
    private PitchMappingFile pitchMappingFile;
    public PitchMapping pitchMapping;

    public WeightedCodebookParallelTransformer(BaselinePreprocessor pp, BaselineFeatureExtractor fe, BaselinePostprocessor po, WeightedCodebookTransformerParams pa) {
        super(pp, fe, po, pa);
    }

    @Override
    public boolean checkParams() throws IOException {
        super.checkParams();
        this.params.inputFolder = StringUtils.checkLastSlash((String)this.params.inputFolder);
        this.params.outputBaseFolder = StringUtils.checkLastSlash((String)this.params.outputBaseFolder);
        this.codebookFile = null;
        if (!FileUtils.exists((String)this.params.codebookFile)) {
            System.out.println("Error: Codebook file " + this.params.codebookFile + " not found!");
            return false;
        }
        this.codebookFile = new WeightedCodebookFile(this.params.codebookFile, WeightedCodebookFile.OPEN_FOR_READ);
        this.codebook = new WeightedCodebook();
        this.codebook.header = this.codebookFile.readCodebookHeader();
        this.params.lsfParams = new LsfFileHeader(this.codebook.header.lsfParams);
        this.params.mapperParams.lpOrder = this.params.lsfParams.dimension;
        if (!FileUtils.exists((String)this.params.pitchMappingFile)) {
            System.out.println("Error: Pitch mapping file " + this.params.pitchMappingFile + " not found!");
            return false;
        }
        this.pitchMappingFile = new PitchMappingFile(this.params.pitchMappingFile, PitchMappingFile.OPEN_FOR_READ);
        this.pitchMapping = new PitchMapping();
        this.pitchMapping.header = this.pitchMappingFile.readPitchMappingHeader();
        if (!FileUtils.exists((String)this.params.inputFolder) || !FileUtils.isDirectory((String)this.params.inputFolder)) {
            System.out.println("Error: Input folder " + this.params.inputFolder + " not found!");
            return false;
        }
        if (!FileUtils.isDirectory((String)this.params.outputBaseFolder)) {
            System.out.println("Creating output base folder " + this.params.outputBaseFolder + "...");
            FileUtils.createDirectory((String)this.params.outputBaseFolder);
        }
        this.params.outputFolder = this.params.outputFolderInfoString != "" ? this.params.outputBaseFolder + this.params.outputFolderInfoString + "_prosody" + String.valueOf(this.params.prosodyParams.pitchStatisticsType) + "x" + String.valueOf(this.params.prosodyParams.pitchTransformationMethod) + "x" + String.valueOf(this.params.prosodyParams.durationTransformationMethod) : this.params.outputBaseFolder + "_prosody" + String.valueOf(this.params.prosodyParams.pitchStatisticsType) + "x" + String.valueOf(this.params.prosodyParams.pitchTransformationMethod) + "x" + String.valueOf(this.params.prosodyParams.durationTransformationMethod);
        if (!FileUtils.isDirectory((String)this.params.outputFolder)) {
            System.out.println("Creating output folder " + this.params.outputFolder + "...");
            FileUtils.createDirectory((String)this.params.outputFolder);
        }
        if (!this.params.isSeparateProsody) {
            this.params.isSaveVocalTractOnlyVersion = false;
        }
        return true;
    }

    @Override
    public void transform(BaselineAdaptationSet inputSet, BaselineAdaptationSet outputSet) throws UnsupportedAudioFileException {
        System.out.println("Transformation started...");
        if (inputSet.items != null && outputSet.items != null) {
            int numItems = Math.min(inputSet.items.length, outputSet.items.length);
            if (numItems > 0) {
                this.preprocessor.run(inputSet);
                int desiredFeatures = BaselineFeatureExtractor.F0_FEATURES + BaselineFeatureExtractor.ENERGY_FEATURES;
                try {
                    this.featureExtractor.run(inputSet, this.params, desiredFeatures);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.codebookFile.readCodebookFileExcludingHeader(this.codebook);
            this.pitchMappingFile.readPitchMappingFileExcludingHeader(this.pitchMapping);
            this.mapper = new WeightedCodebookMapper(this.params.mapperParams);
            for (int i = 0; i < numItems; ++i) {
                try {
                    WeightedCodebookParallelTransformer.transformOneItem(inputSet.items[i], outputSet.items[i], this.params, this.mapper, this.codebook, (PitchTransformationData)this.pitchMapping);
                }
                catch (UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println("Transformed file " + String.valueOf(i + 1) + " of " + String.valueOf(numItems));
            }
        }
        System.out.println("Transformation completed...");
    }

    public static void transformOneItem(BaselineAdaptationItem inputItem, BaselineAdaptationItem outputItem, WeightedCodebookTransformerParams wctParams, WeightedCodebookMapper wcMapper, WeightedCodebook wCodebook, PitchTransformationData pMap) throws UnsupportedAudioFileException, IOException {
        TargetLsfCopyMapper tcMapper = new TargetLsfCopyMapper();
        if (wctParams.isFixedRateVocalTractConversion && (wctParams.prosodyParams.pitchTransformationMethod != 0 || wctParams.prosodyParams.durationTransformationMethod != 0)) {
            wctParams.isSeparateProsody = true;
        }
        double[] pscales = new double[]{1.0};
        double[] tscales = new double[]{1.0};
        double[] escales = new double[]{1.0};
        double[] vscales = new double[]{1.0};
        double[] pscalesNone = new double[]{1.0};
        double[] tscalesNone = new double[]{1.0};
        double[] escalesNone = new double[]{1.0};
        double[] vscalesNone = new double[]{1.0};
        boolean noPscaleFromFestivalUttFile = false;
        boolean noTscaleFromFestivalUttFile = false;
        boolean noEscaleFromTargetWavFile = false;
        FdpsolaAdapter adapter = null;
        WeightedCodebookTransformerParams currentWctParams = new WeightedCodebookTransformerParams(wctParams);
        String firstPassOutputWavFile = "";
        String smoothedVocalTractFile = "";
        if (currentWctParams.isTemporalSmoothing) {
            currentWctParams.isSeparateProsody = true;
        }
        if (currentWctParams.isSeparateProsody) {
            firstPassOutputWavFile = StringUtils.getFolderName((String)outputItem.audioFile) + StringUtils.getFileName((String)outputItem.audioFile) + "_vt.wav";
            smoothedVocalTractFile = StringUtils.getFolderName((String)outputItem.audioFile) + StringUtils.getFileName((String)outputItem.audioFile) + "_vt.vtf";
            int tmpPitchTransformationMethod = currentWctParams.prosodyParams.pitchTransformationMethod;
            int tmpDurationTransformationMethod = currentWctParams.prosodyParams.durationTransformationMethod;
            currentWctParams.prosodyParams.pitchTransformationMethod = 0;
            currentWctParams.prosodyParams.durationTransformationMethod = 0;
            boolean tmpPitchFromTargetFile = currentWctParams.isPitchFromTargetFile;
            boolean tmpDurationFromTargetFile = currentWctParams.isDurationFromTargetFile;
            boolean tmpEnergyFromTargetFile = currentWctParams.isEnergyFromTargetFile;
            currentWctParams.isPitchFromTargetFile = noPscaleFromFestivalUttFile;
            currentWctParams.isDurationFromTargetFile = noTscaleFromFestivalUttFile;
            currentWctParams.isEnergyFromTargetFile = noEscaleFromTargetWavFile;
            if (currentWctParams.isTemporalSmoothing) {
                currentWctParams.smoothingState = 1;
                currentWctParams.smoothedVocalTractFile = smoothedVocalTractFile;
                adapter = new FdpsolaAdapter(inputItem, firstPassOutputWavFile, currentWctParams, pscalesNone, tscalesNone, escalesNone, vscalesNone);
                boolean bl = adapter.bSilent = !currentWctParams.isDisplayProcessingFrameCount;
                if (!currentWctParams.isLsfsFromTargetFile) {
                    adapter.fdpsolaOnline(wcMapper, wCodebook, pMap);
                } else {
                    adapter.fdpsolaOnline(tcMapper, wCodebook, pMap);
                }
                currentWctParams.smoothingState = 2;
                currentWctParams.smoothedVocalTractFile = smoothedVocalTractFile;
                adapter = new FdpsolaAdapter(inputItem, firstPassOutputWavFile, currentWctParams, pscalesNone, tscalesNone, escalesNone, vscalesNone);
            } else {
                currentWctParams.smoothingMethod = 0;
                currentWctParams.smoothingState = 0;
                currentWctParams.smoothedVocalTractFile = "";
                adapter = new FdpsolaAdapter(inputItem, firstPassOutputWavFile, currentWctParams, pscalesNone, tscalesNone, escalesNone, vscalesNone);
            }
            currentWctParams.isPitchFromTargetFile = tmpPitchFromTargetFile;
            currentWctParams.isDurationFromTargetFile = tmpDurationFromTargetFile;
            currentWctParams.isEnergyFromTargetFile = tmpEnergyFromTargetFile;
            if (adapter != null) {
                boolean bl = adapter.bSilent = !currentWctParams.isDisplayProcessingFrameCount;
                if (!currentWctParams.isLsfsFromTargetFile) {
                    adapter.fdpsolaOnline(wcMapper, wCodebook, pMap);
                } else {
                    adapter.fdpsolaOnline(tcMapper, wCodebook, pMap);
                }
                if (WeightedCodebookParallelTransformer.isScalingsRequired(pscales, tscales, escales, vscales) || tmpPitchTransformationMethod != 0 || tmpDurationTransformationMethod != 0) {
                    System.out.println("Performing prosody modifications...");
                    currentWctParams.isVocalTractTransformation = false;
                    currentWctParams.isFixedRateVocalTractConversion = false;
                    currentWctParams.isResynthesizeVocalTractFromSourceModel = false;
                    currentWctParams.isVocalTractMatchUsingTargetModel = false;
                    currentWctParams.prosodyParams.pitchTransformationMethod = tmpPitchTransformationMethod;
                    currentWctParams.prosodyParams.durationTransformationMethod = tmpDurationTransformationMethod;
                    currentWctParams.smoothingMethod = 0;
                    currentWctParams.smoothingState = 0;
                    currentWctParams.smoothedVocalTractFile = "";
                    currentWctParams.isContextBasedPreselection = false;
                    String tmpInputWavFile = inputItem.audioFile;
                    inputItem.audioFile = firstPassOutputWavFile;
                    adapter = new FdpsolaAdapter(inputItem, outputItem.audioFile, currentWctParams, pscales, tscales, escales, vscales);
                    inputItem.audioFile = tmpInputWavFile;
                    adapter.bSilent = true;
                    adapter.fdpsolaOnline(null, wCodebook, pMap);
                } else {
                    FileUtils.copy((String)firstPassOutputWavFile, (String)outputItem.audioFile);
                }
                if (!currentWctParams.isSaveVocalTractOnlyVersion) {
                    FileUtils.delete((String)firstPassOutputWavFile);
                }
                System.out.println("Done...");
            }
        } else {
            currentWctParams.smoothingMethod = 0;
            currentWctParams.smoothingState = 0;
            currentWctParams.smoothedVocalTractFile = "";
            adapter = new FdpsolaAdapter(inputItem, outputItem.audioFile, currentWctParams, pscales, tscales, escales, vscales);
            boolean bl = adapter.bSilent = !wctParams.isDisplayProcessingFrameCount;
            if (!currentWctParams.isLsfsFromTargetFile) {
                adapter.fdpsolaOnline(wcMapper, wCodebook, pMap);
            } else {
                adapter.fdpsolaOnline(tcMapper, wCodebook, pMap);
            }
        }
    }

    public static void main(String[] args) throws IOException, UnsupportedAudioFileException {
        WeightedCodebookParallelTransformer.mainQuickTest2();
    }

    public static void mainNeutralSad() throws IOException, UnsupportedAudioFileException {
        String emotion = "sad";
        String method = "F";
        String inputFolder = "D:/Oytun/DFKI/voices/Interspeech08/neutral/test_tts_" + emotion;
        String outputBaseFolder = "D:/Oytun/DFKI/voices/Interspeech08_out/neutral2" + emotion + "/neutral2" + emotion + "Out_codebook" + method + "3";
        String baseFile = "D:/Oytun/DFKI/voices/Interspeech08_out/neutral2" + emotion + "/neutral" + method + "_X_" + emotion + method + "_200";
        boolean isSourceVocalTractSpectrumFromModel = true;
        int numBestMatches = 15;
        boolean isTemporalSmoothing = true;
        int smoothingNumNeighbours = 1;
        boolean isContextBasedPreselection = true;
        int totalContextNeighbours = 5;
        boolean isPitchFromTargetFile = true;
        int pitchFromTargetMethod = 30;
        boolean isDurationFromTargetFile = true;
        int durationFromTargetMethod = 1;
        boolean isEnergyFromTargetFile = false;
        boolean isLsfsFromTargetFile = false;
        int targetAlignmentFileType = 2;
        String outputFolderInfoString = "isSrc" + String.valueOf(isSourceVocalTractSpectrumFromModel ? 1 : 0) + "_nBest" + String.valueOf(numBestMatches) + "_smooth" + String.valueOf(isTemporalSmoothing ? 1 : 0) + "_" + String.valueOf(smoothingNumNeighbours) + "_context" + String.valueOf(isContextBasedPreselection ? 1 : 0) + "_" + String.valueOf(totalContextNeighbours) + "_psUtt" + String.valueOf(isPitchFromTargetFile ? 1 : 0) + "_tsUtt" + String.valueOf(isDurationFromTargetFile ? 1 : 0);
        WeightedCodebookParallelTransformer.mainParametric(inputFolder, outputBaseFolder, baseFile, outputFolderInfoString, isSourceVocalTractSpectrumFromModel, numBestMatches, isTemporalSmoothing, smoothingNumNeighbours, isContextBasedPreselection, totalContextNeighbours, isPitchFromTargetFile, pitchFromTargetMethod, isDurationFromTargetFile, durationFromTargetMethod, isEnergyFromTargetFile, isLsfsFromTargetFile, targetAlignmentFileType);
    }

    public static void mainQuickTest2() throws IOException, UnsupportedAudioFileException {
        String emotion = "angry";
        String method = "F";
        String inputFolder = "/project/mary/marcela/VoiceConversion/Neutral-Spike-Conversion/codebook/neutral/train_99";
        String outputBaseFolder = "/project/mary/marcela/VoiceConversion/Neutral-Spike-Conversion/codebook/neutral2" + emotion + "/neutral2" + emotion + "Out_codebook" + method + "3";
        String baseFile = "/project/mary/marcela/VoiceConversion/Neutral-Spike-Conversion/codebook/neutral2" + emotion + "/neutral" + method + "_X_" + emotion + method + "_99";
        boolean isSourceVocalTractSpectrumFromModel = true;
        int numBestMatches = 15;
        boolean isTemporalSmoothing = true;
        int smoothingNumNeighbours = 1;
        boolean isContextBasedPreselection = true;
        int totalContextNeighbours = 5;
        boolean isPitchFromTargetFile = true;
        int pitchFromTargetMethod = 30;
        boolean isDurationFromTargetFile = true;
        int durationFromTargetMethod = 1;
        boolean isEnergyFromTargetFile = false;
        boolean isLsfsFromTargetFile = false;
        int targetAlignmentFileType = 2;
        String outputFolderInfoString = "isSrc" + String.valueOf(isSourceVocalTractSpectrumFromModel ? 1 : 0) + "_nBest" + String.valueOf(numBestMatches) + "_smooth" + String.valueOf(isTemporalSmoothing ? 1 : 0) + "_" + String.valueOf(smoothingNumNeighbours) + "_context" + String.valueOf(isContextBasedPreselection ? 1 : 0) + "_" + String.valueOf(totalContextNeighbours) + "_psUtt" + String.valueOf(isPitchFromTargetFile ? 1 : 0) + "_tsUtt" + String.valueOf(isDurationFromTargetFile ? 1 : 0);
        WeightedCodebookParallelTransformer.mainParametric(inputFolder, outputBaseFolder, baseFile, outputFolderInfoString, isSourceVocalTractSpectrumFromModel, numBestMatches, isTemporalSmoothing, smoothingNumNeighbours, isContextBasedPreselection, totalContextNeighbours, isPitchFromTargetFile, pitchFromTargetMethod, isDurationFromTargetFile, durationFromTargetMethod, isEnergyFromTargetFile, isLsfsFromTargetFile, targetAlignmentFileType);
    }

    public static void mainParametric(String inputFolder, String outputBaseFolder, String baseFile, String outputFolderInfoString, boolean isSourceVocalTractSpectrumFromModel, int numBestMatches, boolean isTemporalSmoothing, int smoothingNumNeighbours, boolean isContextBasedPreselection, int totalContextNeighbours, boolean isPitchFromTargetFile, int pitchFromTargetMethod, boolean isDurationFromTargetFile, int durationFromTargetMethod, boolean isEnergyFromTargetFile, boolean isLsfsFromTargetFile, int targetAlignmentFileType) throws IOException, UnsupportedAudioFileException {
        BaselinePreprocessor pp = new BaselinePreprocessor();
        BaselineFeatureExtractor fe = new BaselineFeatureExtractor();
        BaselinePostprocessor po = new BaselinePostprocessor();
        WeightedCodebookTransformerParams pa = new WeightedCodebookTransformerParams();
        pa.isDisplayProcessingFrameCount = true;
        pa.inputFolder = inputFolder;
        pa.outputBaseFolder = outputBaseFolder;
        pa.codebookFile = baseFile + ".wcf";
        pa.pitchMappingFile = baseFile + PitchMappingFile.DEFAULT_EXTENSION;
        pa.outputFolderInfoString = outputFolderInfoString;
        pa.mapperParams.numBestMatches = numBestMatches;
        pa.mapperParams.weightingSteepness = 1.0;
        pa.mapperParams.freqRange = 8000.0;
        pa.mapperParams.distanceMeasure = WeightedCodebookMapperParams.LSF_INVERSE_HARMONIC_DISTANCE_SYMMETRIC;
        pa.mapperParams.alphaForSymmetric = 0.5;
        pa.mapperParams.weightingMethod = WeightedCodebookMapperParams.EXPONENTIAL_HALF_WINDOW;
        pa.mapperParams.distanceMean = 0.0;
        pa.mapperParams.distanceVariance = 1.0;
        pa.isForcedAnalysis = false;
        pa.isSourceVocalTractSpectrumFromModel = isSourceVocalTractSpectrumFromModel;
        pa.isVocalTractTransformation = true;
        pa.isResynthesizeVocalTractFromSourceModel = false;
        pa.isVocalTractMatchUsingTargetModel = false;
        pa.isSeparateProsody = true;
        pa.isSaveVocalTractOnlyVersion = true;
        pa.isFixedRateVocalTractConversion = true;
        pa.isContextBasedPreselection = isContextBasedPreselection;
        pa.totalContextNeighbours = totalContextNeighbours;
        pa.prosodyParams.pitchStatisticsType = PitchStatistics.STATISTICS_IN_HERTZ;
        pa.prosodyParams.durationTransformationMethod = 0;
        pa.prosodyParams.pitchTransformationMethod = 0;
        pa.prosodyParams.isUseInputMeanPitch = false;
        pa.prosodyParams.isUseInputStdDevPitch = false;
        pa.prosodyParams.isUseInputRangePitch = false;
        pa.prosodyParams.isUseInputInterceptPitch = false;
        pa.prosodyParams.isUseInputSlopePitch = false;
        pa.isTemporalSmoothing = isTemporalSmoothing;
        pa.smoothingNumNeighbours = smoothingNumNeighbours;
        pa.smoothingMethod = 1;
        pa.isPitchFromTargetFile = isPitchFromTargetFile;
        pa.pitchFromTargetMethod = pitchFromTargetMethod;
        pa.isDurationFromTargetFile = isDurationFromTargetFile;
        pa.durationFromTargetMethod = durationFromTargetMethod;
        pa.isEnergyFromTargetFile = isEnergyFromTargetFile;
        pa.isLsfsFromTargetFile = isLsfsFromTargetFile;
        pa.targetAlignmentFileType = targetAlignmentFileType;
        WeightedCodebookParallelTransformer t = new WeightedCodebookParallelTransformer(pp, fe, po, pa);
        t.run();
    }
}

