/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.codebook;

import java.io.FileNotFoundException;
import java.io.IOException;
import marytts.signalproc.adaptation.codebook.WeightedCodebook;
import marytts.signalproc.adaptation.codebook.WeightedCodebookEntry;
import marytts.signalproc.adaptation.codebook.WeightedCodebookFileHeader;
import marytts.util.io.FileUtils;
import marytts.util.io.MaryRandomAccessFile;

public class WeightedCodebookFile {
    int status;
    public static int NOT_OPENED = -1;
    public static int OPEN_FOR_READ = 0;
    public static int OPEN_FOR_WRITE = 1;
    public MaryRandomAccessFile stream;
    public String currentFile;
    public static final String DEFAULT_EXTENSION = ".wcf";

    public WeightedCodebookFile() {
        this("");
    }

    public WeightedCodebookFile(String codebookFile) {
        this(codebookFile, NOT_OPENED);
    }

    public WeightedCodebookFile(String codebookFile, int desiredStatus) {
        this.init(codebookFile, desiredStatus);
    }

    private void init(String codebookFile, int desiredStatus) {
        this.status = NOT_OPENED;
        this.stream = null;
        this.currentFile = "";
        if (desiredStatus == OPEN_FOR_READ) {
            this.status = desiredStatus;
            try {
                this.stream = new MaryRandomAccessFile(codebookFile, "r");
                this.currentFile = codebookFile;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else if (desiredStatus == OPEN_FOR_WRITE) {
            FileUtils.delete((String)codebookFile);
            this.status = desiredStatus;
            try {
                this.stream = new MaryRandomAccessFile(codebookFile, "rw");
                this.currentFile = codebookFile;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void close() {
        if (this.status != NOT_OPENED) {
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.stream = null;
            this.status = NOT_OPENED;
        }
    }

    public WeightedCodebookFileHeader readCodebookHeader(String codebookFile, boolean bCloseAfterReading) {
        this.init(codebookFile, OPEN_FOR_READ);
        return this.readCodebookHeader();
    }

    public WeightedCodebookFileHeader readCodebookHeader() {
        try {
            return WeightedCodebookFile.readCodebookHeader(this.stream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static WeightedCodebookFileHeader readCodebookHeader(MaryRandomAccessFile ler) throws IOException {
        WeightedCodebookFileHeader header = new WeightedCodebookFileHeader();
        header.read(ler);
        return header;
    }

    public MaryRandomAccessFile writeCodebookHeader(String codebookFile, WeightedCodebookFileHeader header) {
        this.init(codebookFile, OPEN_FOR_WRITE);
        return this.writeCodebookHeader(header);
    }

    public MaryRandomAccessFile writeCodebookHeader(WeightedCodebookFileHeader header) {
        try {
            this.writeCodebookHeader(this.stream, header);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.stream;
    }

    public void writeCodebookHeader(MaryRandomAccessFile ler, WeightedCodebookFileHeader header) throws IOException {
        header.write(ler);
    }

    public WeightedCodebook readCodebookFile() throws IOException {
        return this.readCodebookFile(this.currentFile);
    }

    public WeightedCodebook readCodebookFile(String codebookFile) throws IOException {
        WeightedCodebook codebook = null;
        if (FileUtils.exists((String)codebookFile)) {
            if (this.status != OPEN_FOR_READ) {
                if (this.status != NOT_OPENED) {
                    this.close();
                }
                this.init(codebookFile, OPEN_FOR_READ);
            }
            if (this.status == OPEN_FOR_READ) {
                codebook = new WeightedCodebook();
                codebook.header = this.readCodebookHeader();
                this.readCodebookFileExcludingHeader(codebook);
            }
        }
        return codebook;
    }

    public void readCodebookFileExcludingHeader(WeightedCodebook codebook) {
        codebook.allocate();
        System.out.println("Reading codebook file: " + this.currentFile + "...");
        for (int i = 0; i < codebook.header.totalEntries; ++i) {
            codebook.entries[i] = this.readEntry(codebook.header.lsfParams.dimension, codebook.header.mfccParams.dimension);
        }
        this.close();
        System.out.println("Reading completed...");
    }

    public void WriteCodebookFile(String codebookFile, WeightedCodebook codebook) {
        if (this.status != OPEN_FOR_WRITE) {
            if (this.status != NOT_OPENED) {
                this.close();
            }
            this.init(codebookFile, OPEN_FOR_WRITE);
        }
        codebook.header.totalEntries = codebook.entries.length;
        this.writeCodebookHeader(codebookFile, codebook.header);
        for (int i = 0; i < codebook.header.totalEntries; ++i) {
            this.writeEntry(codebook.entries[i]);
        }
        this.close();
    }

    public void writeEntry(WeightedCodebookEntry w) {
        if (this.status != OPEN_FOR_WRITE) {
            if (this.status != NOT_OPENED) {
                this.close();
            }
            this.init(this.currentFile, OPEN_FOR_WRITE);
        }
        if (this.status == OPEN_FOR_WRITE) {
            w.write(this.stream);
            this.incrementTotalEntries();
        }
    }

    public WeightedCodebookEntry readEntry(int lpOrder, int mfccDimension) {
        WeightedCodebookEntry w = new WeightedCodebookEntry();
        if (this.status != OPEN_FOR_READ) {
            if (this.status != NOT_OPENED) {
                this.close();
            }
            this.init(this.currentFile, OPEN_FOR_READ);
        }
        if (this.status == OPEN_FOR_READ) {
            w.read(this.stream, lpOrder, mfccDimension);
        }
        return w;
    }

    public void incrementTotalEntries() {
        if (this.status == OPEN_FOR_WRITE) {
            try {
                long currentPos = this.stream.getFilePointer();
                this.stream.seek(0L);
                int totalEntries = this.stream.readInt();
                this.stream.seek(0L);
                this.stream.writeInt(++totalEntries);
                System.out.println("Wrote codebook entry " + String.valueOf(totalEntries));
                this.stream.seek(currentPos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

