/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation;

import java.io.IOException;
import java.util.Arrays;
import marytts.signalproc.adaptation.BaselineAdaptationItem;
import marytts.signalproc.adaptation.BaselineTransformerParams;
import marytts.signalproc.adaptation.VocalTractTransformationData;
import marytts.signalproc.adaptation.VocalTractTransformationFunction;
import marytts.signalproc.adaptation.gmm.GMMMatch;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMMMapper;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMMMatch;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMMSet;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMMTransformerParams;
import marytts.signalproc.analysis.Mfccs;
import marytts.util.io.FileUtils;

public class MfccAdapter {
    protected Mfccs inputMfccs;
    public boolean bSilent;
    private BaselineTransformerParams baseParams;
    protected String outputFile;
    protected int numfrm;

    public MfccAdapter(BaselineAdaptationItem inputItem, String strOutputFile, JointGMMTransformerParams jgmmParamsIn) {
        this.baseParams = new JointGMMTransformerParams(jgmmParamsIn);
        this.init(inputItem, strOutputFile);
    }

    public void init(BaselineAdaptationItem inputItem, String strOutputFile) {
        this.outputFile = null;
        boolean bContinue = true;
        if (!FileUtils.exists((String)inputItem.mfccFile)) {
            System.out.println("Error! MFCC file " + inputItem.mfccFile + " not found.");
            bContinue = false;
        }
        if (strOutputFile == null || strOutputFile == "") {
            System.out.println("Invalid output file...");
            bContinue = false;
        }
        this.numfrm = 0;
        if (bContinue) {
            this.inputMfccs = new Mfccs(inputItem.mfccFile);
            this.numfrm = this.inputMfccs.mfccs.length;
            this.outputFile = strOutputFile;
        }
    }

    public void transformOnline(VocalTractTransformationFunction vtMapper, VocalTractTransformationData vtData) {
        for (int i = 0; i < this.numfrm; ++i) {
            this.inputMfccs.mfccs[i] = this.processFrame(this.inputMfccs.mfccs[i], vtMapper, vtData);
        }
        try {
            Mfccs.writeRawMfccFile(this.inputMfccs.mfccs, this.outputFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double[] processFrame(double[] frameMfccs, VocalTractTransformationFunction mapper, VocalTractTransformationData data) {
        GMMMatch gmmMatch = null;
        if (this.baseParams.isVocalTractTransformation && mapper instanceof JointGMMMapper) {
            double[] gmmWeights = new double[1];
            Arrays.fill(gmmWeights, 1.0);
            gmmMatch = ((JointGMMMapper)mapper).transform(frameMfccs, (JointGMMSet)data, gmmWeights, this.baseParams.isVocalTractMatchUsingTargetModel);
        }
        if (!this.baseParams.isResynthesizeVocalTractFromSourceModel) {
            return ((JointGMMMatch)gmmMatch).outputFeatures;
        }
        return ((JointGMMMatch)gmmMatch).mappedSourceFeatures;
    }
}

