/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.adaptation.BaselineAdaptationItem;
import marytts.signalproc.adaptation.BaselineTransformerParams;
import marytts.signalproc.adaptation.Context;
import marytts.signalproc.adaptation.LsfMatch;
import marytts.signalproc.adaptation.TargetLsfCopyMapper;
import marytts.signalproc.adaptation.VocalTractMatch;
import marytts.signalproc.adaptation.VocalTractTransformationData;
import marytts.signalproc.adaptation.VocalTractTransformationFunction;
import marytts.signalproc.adaptation.codebook.WeightedCodebook;
import marytts.signalproc.adaptation.codebook.WeightedCodebookLsfMatch;
import marytts.signalproc.adaptation.codebook.WeightedCodebookMapper;
import marytts.signalproc.adaptation.codebook.WeightedCodebookTransformerParams;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMMMapper;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMMMatch;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMMSet;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMMTransformerParams;
import marytts.signalproc.adaptation.prosody.PitchMapping;
import marytts.signalproc.adaptation.prosody.PitchStatistics;
import marytts.signalproc.adaptation.prosody.PitchTransformationData;
import marytts.signalproc.adaptation.prosody.PitchTransformer;
import marytts.signalproc.adaptation.smoothing.SmoothingFile;
import marytts.signalproc.adaptation.smoothing.TemporalSmoother;
import marytts.signalproc.analysis.F0ReaderWriter;
import marytts.signalproc.analysis.Labels;
import marytts.signalproc.analysis.LpcAnalyser;
import marytts.signalproc.analysis.LsfAnalyser;
import marytts.signalproc.analysis.PitchMarks;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.signalproc.process.PsolaFrameProvider;
import marytts.signalproc.process.VoiceModificationParametersPreprocessor;
import marytts.signalproc.window.DynamicWindow;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.display.DisplayUtils;
import marytts.util.io.FileUtils;
import marytts.util.io.LEDataInputStream;
import marytts.util.io.LEDataOutputStream;
import marytts.util.math.ArrayUtils;
import marytts.util.math.ComplexArray;
import marytts.util.math.FFTMixedRadix;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class FdpsolaAdapter {
    protected DoubleDataSource input;
    protected AudioInputStream inputAudio;
    protected DDSAudioInputStream outputAudio;
    protected VoiceModificationParametersPreprocessor modParams;
    protected int numfrm;
    protected int numfrmFixed;
    protected int lpOrder;
    protected String outputFile;
    protected String tempOutBinaryFile;
    protected int origLen;
    protected PitchMarks pm;
    protected double[] f0s;
    protected PsolaFrameProvider psFrm;
    protected double wsFixedInSeconds;
    protected double ssFixedInSeconds;
    protected int numPeriods;
    protected static int NUM_PITCH_SYNC_PERIODS = 3;
    public boolean bSilent;
    protected LEDataOutputStream dout;
    protected LEDataInputStream din;
    protected DynamicWindow windowIn;
    protected DynamicWindow windowOut;
    protected double[] wgt;
    protected double[] wgty;
    protected int frmSize;
    protected int newFrmSize;
    protected int newPeriod;
    protected int synthFrmInd;
    protected double localDurDiff;
    protected int repeatSkipCount;
    protected double localDurDiffSaved;
    protected double sumLocalDurDiffs;
    protected double nextAdd;
    protected int synthSt;
    protected int synthTotal;
    protected int maxFrmSize;
    protected int maxNewFrmSize;
    protected int synthFrameInd;
    protected boolean bLastFrame;
    protected boolean bBroke;
    protected int outBuffLen;
    protected double[] outBuff;
    protected int outBuffStart;
    protected int totalWrittenToFile;
    protected double[] ySynthBuff;
    protected double[] wSynthBuff;
    protected int ySynthInd;
    protected double[] frm;
    protected boolean bWarp;
    protected double[] inputVT;
    protected double[] py2;
    protected ComplexArray hy;
    protected double[] frmy;
    protected double frmEn;
    protected double frmyEn;
    protected double gain;
    protected int newSkipSize;
    protected int halfWin;
    protected double[] newVScales;
    protected double[] tmpvsc;
    protected int inputFrameIndex;
    protected static double MIN_PSCALE = 0.1;
    protected static double MAX_PSCALE = 5.0;
    protected static double MIN_TSCALE = 0.1;
    protected static double MAX_TSCALE = 5.0;
    protected int fs;
    protected double tscaleSingle;
    private double desiredFrameTime;
    private boolean bShowSpectralPlots;
    private PitchTransformer pitchTransformer;
    private SmoothingFile smoothingFile;
    private double[][] smoothedVocalTract;
    private int smoothedInd;
    private int[] preselectedIndices;
    private int[] allIndices;
    private Labels labels;
    private Labels targetLabels;
    private int currentLabelIndex;
    private double[][] targetLsfs;
    private BaselineTransformerParams baseParams;

    public FdpsolaAdapter(BaselineAdaptationItem inputItem, String strOutputFile, WeightedCodebookTransformerParams wctParamsIn, double[] pscales, double[] tscales, double[] escales, double[] vscales) throws UnsupportedAudioFileException, IOException {
        this.baseParams = new WeightedCodebookTransformerParams(wctParamsIn);
        this.init(inputItem, strOutputFile, pscales, tscales, escales, vscales);
    }

    public FdpsolaAdapter(BaselineAdaptationItem inputItem, String strOutputFile, JointGMMTransformerParams jgmmParamsIn, double[] pscales, double[] tscales, double[] escales, double[] vscales) throws UnsupportedAudioFileException, IOException {
        this.baseParams = new JointGMMTransformerParams(jgmmParamsIn);
        this.init(inputItem, strOutputFile, pscales, tscales, escales, vscales);
    }

    public void init(BaselineAdaptationItem inputItem, String strOutputFile, double[] pscales, double[] tscales, double[] escales, double[] vscales) throws IOException {
        this.smoothingFile = null;
        if (this.baseParams.smoothingState == 0) {
            this.baseParams.smoothedVocalTractFile = "";
        }
        if (this.baseParams.smoothingState == 1) {
            if (this.baseParams.smoothedVocalTractFile == "") {
                throw new IllegalArgumentException("smoothedVocalTractFile not valid");
            }
            this.smoothingFile = new SmoothingFile(this.baseParams.smoothedVocalTractFile, 1);
            this.smoothingFile.smoothingMethod = this.baseParams.smoothingMethod;
            this.smoothingFile.writeHeader();
        }
        if (this.baseParams.smoothingState == 2 && this.baseParams.smoothingMethod != 0) {
            if (!FileUtils.exists((String)this.baseParams.smoothedVocalTractFile)) {
                throw new IllegalArgumentException("smoothedVocalTractFile not found");
            }
            this.smoothingFile = new SmoothingFile(this.baseParams.smoothedVocalTractFile, 2);
            this.smoothedVocalTract = this.smoothingFile.readAll();
            this.smoothedInd = 0;
        }
        this.pitchTransformer = new PitchTransformer();
        this.inputAudio = null;
        this.input = null;
        this.pm = null;
        this.f0s = null;
        this.wsFixedInSeconds = 0.02;
        this.ssFixedInSeconds = 0.01;
        this.numPeriods = NUM_PITCH_SYNC_PERIODS;
        this.origLen = 0;
        this.fs = 16000;
        this.numfrm = 0;
        this.numfrmFixed = 0;
        this.modParams = null;
        this.outputFile = null;
        this.tscaleSingle = 1.0;
        boolean bContinue = true;
        if (!FileUtils.exists((String)inputItem.audioFile)) {
            System.out.println("Error! Audio file " + inputItem.audioFile + " not found.");
            bContinue = false;
        }
        if (!FileUtils.exists((String)inputItem.f0File) && !FileUtils.exists((String)inputItem.pitchFile)) {
            System.out.println("Error! No F0 or pitch file found: " + inputItem.f0File + " " + inputItem.pitchFile);
            bContinue = false;
        }
        if (strOutputFile == null || strOutputFile == "") {
            System.out.println("Invalid output file...");
            bContinue = false;
        }
        if (bContinue) {
            boolean isF0File = false;
            if (FileUtils.exists((String)inputItem.f0File)) {
                isF0File = true;
            }
            try {
                this.inputAudio = AudioSystem.getAudioInputStream(new File(inputItem.audioFile));
            }
            catch (UnsupportedAudioFileException e) {
                throw new IOException("Cannot open audio", e);
            }
            this.input = new AudioDoubleDataSource(this.inputAudio);
            this.origLen = (int)this.input.getDataLength();
            this.fs = (int)this.inputAudio.getFormat().getSampleRate();
            PitchReaderWriter f0 = null;
            f0 = FileUtils.exists((String)inputItem.f0File) ? new F0ReaderWriter(inputItem.f0File) : new PitchReaderWriter(inputItem.pitchFile);
            this.pm = SignalProcUtils.pitchContour2pitchMarks(f0.contour, this.fs, this.origLen, f0.header.windowSizeInSeconds, f0.header.skipSizeInSeconds, true, 0);
            this.numfrmFixed = (int)(Math.floor(((double)(this.origLen + this.pm.totalZerosToPadd) / (double)this.fs - 0.5 * this.wsFixedInSeconds) / this.ssFixedInSeconds + 0.5) + 2.0);
            this.numfrm = !this.baseParams.isFixedRateVocalTractConversion ? this.pm.pitchMarks.length - this.numPeriods : this.numfrmFixed;
            this.f0s = SignalProcUtils.fixedRateF0Values(this.pm, this.wsFixedInSeconds, this.ssFixedInSeconds, this.numfrmFixed, this.fs);
            this.lpOrder = SignalProcUtils.getLPOrder(this.fs);
            if (!(this.baseParams.isPitchFromTargetFile || this.baseParams.isDurationFromTargetFile || this.baseParams.isEnergyFromTargetFile)) {
                this.modParams = new VoiceModificationParametersPreprocessor(this.fs, this.lpOrder, pscales, tscales, escales, vscales, this.pm.pitchMarks, this.wsFixedInSeconds, this.ssFixedInSeconds, this.numfrm, this.numfrmFixed, this.numPeriods, this.baseParams.isFixedRateVocalTractConversion);
                this.tscaleSingle = this.modParams.tscaleSingle;
            } else {
                String targetAlignmentFile = null;
                if (this.baseParams.targetAlignmentFileType == 1) {
                    targetAlignmentFile = inputItem.targetLabelFile;
                } else if (this.baseParams.targetAlignmentFileType == 2) {
                    targetAlignmentFile = inputItem.targetFestivalUttFile;
                }
                String sourcePitchContourFile = isF0File ? inputItem.f0File : inputItem.pitchFile;
                String targetPitchContourFile = isF0File ? inputItem.targetF0File : inputItem.targetPitchFile;
                this.modParams = new VoiceModificationParametersPreprocessor(sourcePitchContourFile, isF0File, inputItem.labelFile, inputItem.audioFile, targetPitchContourFile, inputItem.targetWavFile, this.baseParams.isPitchFromTargetFile, this.baseParams.pitchFromTargetMethod, this.baseParams.isDurationFromTargetFile, this.baseParams.durationFromTargetMethod, this.baseParams.isEnergyFromTargetFile, this.baseParams.targetAlignmentFileType, targetAlignmentFile, this.pm.pitchMarks, this.wsFixedInSeconds, this.ssFixedInSeconds, this.numfrm, this.numfrmFixed, this.numPeriods, this.baseParams.isFixedRateVocalTractConversion);
                this.tscaleSingle = 1.0;
                for (int i = 0; i < this.modParams.tscalesVar.length; ++i) {
                    if (this.modParams.tscalesVar[i] == 1.0) continue;
                    this.tscaleSingle = -1.0;
                    break;
                }
            }
            this.outputFile = strOutputFile;
            this.labels = inputItem.labelFile != "" && FileUtils.exists((String)inputItem.labelFile) ? new Labels(inputItem.labelFile) : null;
            this.targetLabels = inputItem.targetLabelFile != "" && FileUtils.exists((String)inputItem.targetLabelFile) ? new Labels(inputItem.targetLabelFile) : null;
            if (inputItem.targetWavFile != "" && FileUtils.exists((String)inputItem.targetWavFile) && this.baseParams.isLsfsFromTargetFile) {
                try {
                    this.targetLsfs = LsfAnalyser.lsfAnalyzeWavFile(inputItem.targetWavFile, this.baseParams.lsfParams);
                }
                catch (UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.targetLsfs = null;
            }
        }
        if (bContinue) {
            this.tmpvsc = new double[1];
            this.bSilent = false;
            if (this.outputFile != null) {
                this.tempOutBinaryFile = this.outputFile + ".bin";
            }
            this.psFrm = !this.baseParams.isFixedRateVocalTractConversion ? new PsolaFrameProvider(this.input, this.pm, this.modParams.fs, this.modParams.numPeriods) : new PsolaFrameProvider(this.input, this.wsFixedInSeconds, this.ssFixedInSeconds, this.modParams.fs, this.numfrm);
            try {
                this.dout = new LEDataOutputStream(this.tempOutBinaryFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            this.windowIn = new DynamicWindow(3);
            this.windowOut = new DynamicWindow(3);
            this.frmSize = 0;
            this.newFrmSize = 0;
            this.newPeriod = 0;
            this.synthFrmInd = 0;
            this.localDurDiff = 0.0;
            this.repeatSkipCount = 0;
            this.localDurDiffSaved = 0.0;
            this.sumLocalDurDiffs = 0.0;
            this.nextAdd = 0.0;
            this.synthSt = this.pm.pitchMarks[0];
            this.synthTotal = 0;
            this.maxFrmSize = (int)((double)(this.numPeriods * this.fs) / 40.0);
            if (this.maxFrmSize % 2 != 0) {
                ++this.maxFrmSize;
            }
            this.maxNewFrmSize = (int)Math.floor((double)this.maxFrmSize / MIN_PSCALE + 0.5);
            if (this.maxNewFrmSize % 2 != 0) {
                ++this.maxNewFrmSize;
            }
            this.synthFrameInd = 0;
            this.bLastFrame = false;
            this.bBroke = false;
            this.outBuffLen = 500000;
            this.outBuff = MathUtils.zeros(this.outBuffLen);
            this.outBuffStart = 1;
            this.totalWrittenToFile = 0;
            this.ySynthBuff = MathUtils.zeros(this.maxNewFrmSize);
            this.wSynthBuff = MathUtils.zeros(this.maxNewFrmSize);
            this.ySynthInd = 1;
        }
    }

    public void fdpsolaOnline(VocalTractTransformationFunction vtMapper, VocalTractTransformationData vtData, PitchTransformationData ptData) throws IOException {
        int i;
        this.desiredFrameTime = 1.05;
        this.bShowSpectralPlots = false;
        this.fs = (int)this.inputAudio.getFormat().getSampleRate();
        PitchStatistics inputF0Statistics = new PitchStatistics(this.baseParams.prosodyParams.pitchStatisticsType, this.f0s);
        double[] targetF0s = null;
        if (!this.baseParams.isPitchFromTargetFile) {
            if (ptData instanceof PitchMapping) {
                targetF0s = this.pitchTransformer.transform(this.baseParams.prosodyParams, ((PitchMapping)ptData).f0StatisticsMapping, inputF0Statistics, this.f0s, this.modParams.pscalesVar);
            } else {
                this.baseParams.prosodyParams.pitchTransformationMethod = -1;
                targetF0s = this.pitchTransformer.transform(this.baseParams.prosodyParams, ((PitchMapping)ptData).f0StatisticsMapping, inputF0Statistics, this.f0s, this.modParams.pscalesVar);
            }
        } else {
            targetF0s = new double[this.numfrm];
        }
        this.preselectedIndices = null;
        this.allIndices = null;
        if (vtData instanceof WeightedCodebook && this.baseParams instanceof WeightedCodebookTransformerParams && !((WeightedCodebookTransformerParams)this.baseParams).isContextBasedPreselection) {
            this.allIndices = new int[((WeightedCodebook)vtData).entries.length];
            for (i = 0; i < this.allIndices.length; ++i) {
                this.allIndices[i] = i;
            }
        }
        this.inputFrameIndex = 0;
        for (i = 0; i < this.numfrm; ++i) {
            int inputFrameSize;
            int currentPeriod;
            double[] frmIn = this.psFrm.getNextFrame();
            if (this.bBroke) break;
            boolean isLastInputFrame = i == this.numfrm - 1;
            if (!this.baseParams.isFixedRateVocalTractConversion) {
                currentPeriod = this.pm.pitchMarks[i + 1] - this.pm.pitchMarks[i];
                inputFrameSize = this.pm.pitchMarks[i + this.modParams.numPeriods] - this.pm.pitchMarks[i] + 1;
            } else {
                currentPeriod = -1;
                inputFrameSize = frmIn.length;
            }
            double targetF0Value = 0.0;
            int index = (int)Math.floor((this.psFrm.getCurrentTime() - 0.5 * this.wsFixedInSeconds) / this.ssFixedInSeconds + 0.5);
            if (!this.baseParams.isPitchFromTargetFile) {
                index = MathUtils.CheckLimits(index, 0, targetF0s.length - 1);
                targetF0Value = targetF0s[index];
            }
            double currentF0Value = this.f0s[index];
            if (this.baseParams.isPitchFromTargetFile) {
                targetF0s[i] = targetF0Value = currentF0Value * this.modParams.pscalesVar[i];
            }
            boolean isVoiced = !this.baseParams.isFixedRateVocalTractConversion ? (double)this.pm.f0s[i] > 10.0 : currentF0Value > 10.0;
            double currentF0 = isVoiced ? (double)(this.fs / currentPeriod) : 0.0;
            this.currentLabelIndex = this.labels != null ? SignalProcUtils.time2LabelIndex(this.psFrm.getCurrentTime(), this.labels) : -1;
            this.processFrame(frmIn, isVoiced, currentF0, targetF0Value, this.modParams.tscalesVar[i], this.modParams.escalesVar[i], this.modParams.vscalesVar[i], isLastInputFrame, currentPeriod, inputFrameSize, vtMapper, vtData);
            if (!this.baseParams.isVocalTractTransformation || this.baseParams.smoothingState != 2 || this.baseParams.smoothingMethod == 0) continue;
            ++this.smoothedInd;
            if (this.smoothedInd <= this.smoothedVocalTract.length - 1) continue;
            this.smoothedInd = this.smoothedVocalTract.length - 1;
        }
        this.writeFinal();
        this.convertToWav(this.inputAudio.getFormat());
        this.inputAudio.close();
        if (this.baseParams.smoothingState == 1) {
            if (this.baseParams.isVocalTractTransformation) {
                System.out.println("Temporal smoothing started using " + String.valueOf(this.baseParams.smoothingNumNeighbours) + " neighbours...");
                this.smoothingFile.close();
                this.smoothingFile = new SmoothingFile(this.baseParams.smoothedVocalTractFile, 2);
                double[][] vts = this.smoothingFile.readAll();
                double[] tmp1 = new double[vts.length];
                for (i = 0; i < vts.length; ++i) {
                    tmp1[i] = vts[i][20];
                }
                vts = TemporalSmoother.smooth(vts, this.baseParams.smoothingNumNeighbours);
                double[] tmp2 = new double[vts.length];
                for (i = 0; i < vts.length; ++i) {
                    tmp2[i] = vts[i][20];
                }
                this.smoothingFile = new SmoothingFile(this.baseParams.smoothedVocalTractFile, 1, this.baseParams.smoothingMethod);
                this.smoothingFile.writeAll(vts);
                System.out.println("Temporal smoothing completed...");
            }
        } else if (this.baseParams.smoothingState == 2) {
            FileUtils.delete((String)this.baseParams.smoothedVocalTractFile);
        }
    }

    public double[] processFrame(double[] frmIn, boolean isVoiced, double currentF0, double targetF0, double tscale, double escale, double vscale, boolean isLastInputFrame, int currentPeriod, int inputFrameSize, VocalTractTransformationFunction mapper, VocalTractTransformationData data) throws IOException {
        double pscale = currentF0 > 10.0 ? targetF0 / currentF0 : 1.0;
        if (pscale < MIN_PSCALE) {
            pscale = MIN_PSCALE;
        }
        if (pscale > MAX_PSCALE) {
            pscale = MAX_PSCALE;
        }
        if (tscale < MIN_TSCALE) {
            tscale = MIN_TSCALE;
        }
        if (tscale > MAX_TSCALE) {
            tscale = MAX_TSCALE;
        }
        double[] output = null;
        Object outputTmp = null;
        VocalTractMatch match = null;
        this.windowIn = new DynamicWindow(this.baseParams.lsfParams.windowType);
        this.windowOut = new DynamicWindow(this.baseParams.lsfParams.windowType);
        this.repeatSkipCount = 0;
        this.frmSize = inputFrameSize;
        if (this.frmSize % 2 != 0) {
            ++this.frmSize;
        }
        if (this.frmSize < 4) {
            this.frmSize = 4;
        }
        if (isVoiced) {
            this.newFrmSize = (int)Math.floor((double)this.frmSize / pscale + 0.5);
            if (this.newFrmSize % 2 != 0) {
                ++this.newFrmSize;
            }
            if (this.newFrmSize < 4) {
                this.newFrmSize = 4;
            }
        } else {
            this.newFrmSize = this.frmSize;
        }
        this.newPeriod = (int)Math.floor((double)this.newFrmSize / (double)NUM_PITCH_SYNC_PERIODS + 0.5);
        this.localDurDiff = this.nextAdd + ((double)this.frmSize * tscale - (double)this.newFrmSize) / (double)NUM_PITCH_SYNC_PERIODS;
        this.nextAdd = 0.0;
        if (this.localDurDiff < -0.1 * (double)this.newPeriod) {
            --this.repeatSkipCount;
            if (!isLastInputFrame) {
                this.nextAdd = this.localDurDiff + (double)this.newPeriod;
                this.localDurDiff = 0.0;
            }
        } else if (this.localDurDiff > 0.1 * (double)this.newPeriod) {
            while (this.localDurDiff > 0.1 * (double)this.newPeriod) {
                ++this.repeatSkipCount;
                this.localDurDiff -= (double)this.newPeriod;
            }
            if (!isLastInputFrame) {
                this.nextAdd = this.localDurDiff;
                this.localDurDiff = 0.0;
            }
        }
        this.sumLocalDurDiffs += this.localDurDiff;
        if (isLastInputFrame) {
            this.localDurDiff = this.sumLocalDurDiffs;
            while (this.localDurDiff > 0.0) {
                ++this.repeatSkipCount;
                this.localDurDiff -= (double)this.newPeriod;
            }
        }
        if (isLastInputFrame) {
            ++this.repeatSkipCount;
            this.bLastFrame = true;
        }
        LpcAnalyser.LpCoeffs inputLPCoeffs = null;
        double[] inputLpcs = null;
        double[] inputLsfs = null;
        double[] targetLpcs = null;
        ComplexArray inputDft = null;
        ComplexArray inputExpTerm = null;
        ComplexArray outputExpTerm = null;
        ComplexArray inputResidual = null;
        ComplexArray outputResidual = null;
        ComplexArray outputDft = null;
        double[] inputVocalTractSpectrum = null;
        double[] interpolatedInputLpcs = null;
        double[] sourceVocalTractSpectrumEstimate = null;
        double[] targetVocalTractSpectrumEstimate = null;
        double[] interpolatedInputVocalTractSpectrum = null;
        double[] outputVocalTractSpectrum = null;
        double[] warpedOutputVocalTractSpectrum = null;
        double[] transformationFilter = null;
        Context currentContext = null;
        if (this.repeatSkipCount > -1) {
            int k;
            int j;
            this.frm = MathUtils.zeros(this.frmSize);
            System.arraycopy(frmIn, 0, this.frm, 0, Math.min(frmIn.length, this.frmSize));
            this.wgt = this.windowIn.values(this.frmSize);
            this.bWarp = vscale != 1.0;
            boolean isTransformUnvoiced = true;
            if (isVoiced && pscale != 1.0 || this.bWarp || isTransformUnvoiced) {
                double[] tmpSpec;
                ComplexArray tmpComp;
                this.frmEn = SignalProcUtils.getEnergy(this.frm);
                this.wgt = this.windowIn.values(this.frmSize);
                for (j = 0; j < this.frmSize; ++j) {
                    this.frm[j] = this.frm[j] * this.wgt[j];
                }
                this.frm = SignalProcUtils.applyPreemphasis(this.frm, this.baseParams.lsfParams.preCoef);
                inputLPCoeffs = LpcAnalyser.calcLPC(this.frm, this.baseParams.lsfParams.dimension);
                inputLpcs = inputLPCoeffs.getOneMinusA();
                inputLsfs = !this.baseParams.lsfParams.isBarkScaled ? LsfAnalyser.lpc2lsfInHz(inputLpcs, this.fs) : LsfAnalyser.lpc2lsfInBark(inputLpcs, this.fs);
                double sqrtInputGain = inputLPCoeffs.getGain();
                if (this.baseParams.isVocalTractTransformation) {
                    if (mapper instanceof WeightedCodebookMapper) {
                        if (this.baseParams instanceof WeightedCodebookTransformerParams && ((WeightedCodebookTransformerParams)this.baseParams).isContextBasedPreselection) {
                            currentContext = new Context(this.labels, this.currentLabelIndex, ((WeightedCodebookTransformerParams)this.baseParams).totalContextNeighbours);
                            this.preselectedIndices = ((WeightedCodebookMapper)mapper).preselect(currentContext, (WeightedCodebook)data, ((WeightedCodebookTransformerParams)this.baseParams).isVocalTractMatchUsingTargetModel, ((WeightedCodebookTransformerParams)this.baseParams).mapperParams.numBestMatches);
                        }
                        match = this.preselectedIndices != null ? ((WeightedCodebookMapper)mapper).transform(inputLsfs, (WeightedCodebook)data, this.baseParams.isVocalTractMatchUsingTargetModel, this.preselectedIndices) : ((WeightedCodebookMapper)mapper).transform(inputLsfs, (WeightedCodebook)data, this.baseParams.isVocalTractMatchUsingTargetModel, this.allIndices);
                    } else if (mapper instanceof JointGMMMapper) {
                        double[] gmmWeights = new double[((JointGMMSet)data).gmms.length];
                        Arrays.fill(gmmWeights, 0.0);
                        int currentGmmIndex = -1;
                        if (this.currentLabelIndex >= 0 && this.currentLabelIndex < this.labels.items.length) {
                            currentGmmIndex = ((JointGMMSet)data).cgParams.getClassIndex(this.labels.items[this.currentLabelIndex].phn);
                        }
                        if (currentGmmIndex > 0) {
                            gmmWeights[currentGmmIndex] = 1.0;
                        }
                        gmmWeights = MathUtils.normalizeToSumUpTo(gmmWeights, 1.0);
                        match = ((JointGMMMapper)mapper).transform(inputLsfs, (JointGMMSet)data, gmmWeights, this.baseParams.isVocalTractMatchUsingTargetModel);
                    } else if (mapper instanceof TargetLsfCopyMapper) {
                        match = ((TargetLsfCopyMapper)mapper).transform(this.psFrm.getCurrentTime(), this.labels, this.targetLabels, this.targetLsfs, this.baseParams.lsfParams.winsize, this.baseParams.lsfParams.skipsize);
                    }
                }
                inputDft = new ComplexArray(this.frmSize);
                int maxFreq = this.frmSize / 2 + 1;
                System.arraycopy(this.frm, 0, inputDft.real, 0, Math.min(this.frmSize, inputDft.real.length));
                if (inputDft.real.length > this.frmSize) {
                    Arrays.fill(inputDft.real, inputDft.real.length - this.frmSize, inputDft.real.length - 1, 0.0);
                }
                Arrays.fill(inputDft.imag, 0, inputDft.imag.length - 1, 0.0);
                inputDft = FFTMixedRadix.fftComplex(inputDft);
                if (this.bShowSpectralPlots && this.psFrm.getCurrentTime() >= this.desiredFrameTime) {
                    tmpComp = new ComplexArray(inputDft);
                    tmpSpec = MathUtils.dft2ampdb(tmpComp, 0, maxFreq);
                    DisplayUtils.plot(tmpSpec, "1.Input DFT");
                }
                inputExpTerm = LpcAnalyser.calcExpTerm(this.frmSize, this.baseParams.lsfParams.dimension);
                outputExpTerm = LpcAnalyser.calcExpTerm(this.newFrmSize, this.baseParams.lsfParams.dimension);
                inputVocalTractSpectrum = LpcAnalyser.calcSpecLinearFromOneMinusA(inputLPCoeffs.getOneMinusA(), (float)sqrtInputGain, this.frmSize, inputExpTerm);
                if (this.baseParams.isSourceVocalTractSpectrumFromModel && this.baseParams.isVocalTractTransformation) {
                    if (mapper instanceof WeightedCodebookMapper) {
                        interpolatedInputLpcs = !this.baseParams.isResynthesizeVocalTractFromSourceModel ? (!this.baseParams.lsfParams.isBarkScaled ? LsfAnalyser.lsfInHz2lpc(match.entry.sourceItem.lsfs, this.fs) : LsfAnalyser.lsfInBark2lpc(match.entry.sourceItem.lsfs, this.fs)) : (!this.baseParams.lsfParams.isBarkScaled ? LsfAnalyser.lsfInHz2lpc(match.entry.targetItem.lsfs, this.fs) : LsfAnalyser.lsfInBark2lpc(match.entry.targetItem.lsfs, this.fs));
                    } else if (mapper instanceof JointGMMMapper) {
                        interpolatedInputLpcs = !this.baseParams.isResynthesizeVocalTractFromSourceModel ? (!this.baseParams.lsfParams.isBarkScaled ? LsfAnalyser.lsfInHz2lpc(((JointGMMMatch)match).mappedSourceFeatures, this.fs) : LsfAnalyser.lsfInBark2lpc(((JointGMMMatch)match).mappedSourceFeatures, this.fs)) : (!this.baseParams.lsfParams.isBarkScaled ? LsfAnalyser.lsfInHz2lpc(((JointGMMMatch)match).outputFeatures, this.fs) : LsfAnalyser.lsfInBark2lpc(((JointGMMMatch)match).outputFeatures, this.fs));
                    } else if (mapper instanceof TargetLsfCopyMapper) {
                        interpolatedInputLpcs = ArrayUtils.copy(inputLpcs);
                    }
                    sourceVocalTractSpectrumEstimate = LpcAnalyser.calcSpecLinearFromOneMinusA(interpolatedInputLpcs, 1.0f, this.newFrmSize, outputExpTerm);
                }
                if (this.bShowSpectralPlots && this.psFrm.getCurrentTime() >= this.desiredFrameTime) {
                    tmpSpec = new double[maxFreq];
                    System.arraycopy(inputVocalTractSpectrum, 0, tmpSpec, 0, tmpSpec.length);
                    tmpSpec = MathUtils.amp2db(tmpSpec);
                    DisplayUtils.plot(tmpSpec, "2.Input Vocal Tract");
                    FileUtils.writeToTextFile((double[])inputVocalTractSpectrum, (String)"d:/hmmTest_inputVT.txt");
                }
                if (this.bShowSpectralPlots && this.psFrm.getCurrentTime() >= this.desiredFrameTime && this.baseParams.isSourceVocalTractSpectrumFromModel && this.baseParams.isVocalTractTransformation) {
                    tmpSpec = new double[maxFreq];
                    System.arraycopy(sourceVocalTractSpectrumEstimate, 0, tmpSpec, 0, tmpSpec.length);
                    tmpSpec = MathUtils.amp2db(tmpSpec);
                    DisplayUtils.plot(tmpSpec, "3.Source Vocal Tract Estimate");
                    FileUtils.writeToTextFile((double[])sourceVocalTractSpectrumEstimate, (String)"d:/hmmTest_estimateVT.txt");
                }
                inputResidual = new ComplexArray(this.frmSize);
                for (k = 0; k < maxFreq; ++k) {
                    inputResidual.real[k] = inputDft.real[k] / inputVocalTractSpectrum[k];
                    inputResidual.imag[k] = inputDft.imag[k] / inputVocalTractSpectrum[k];
                }
                if (this.bShowSpectralPlots && this.psFrm.getCurrentTime() >= this.desiredFrameTime) {
                    tmpComp = new ComplexArray(inputResidual);
                    tmpSpec = MathUtils.dft2ampdb(tmpComp, 0, maxFreq - 1);
                    DisplayUtils.plot(tmpSpec, "4.Input Residual");
                }
                int newMaxFreq = this.newFrmSize / 2 + 1;
                if (this.baseParams.isVocalTractTransformation) {
                    if (this.baseParams.smoothingMethod == 2) {
                        if (this.baseParams.smoothingState == 1) {
                            if (!this.baseParams.isResynthesizeVocalTractFromSourceModel) {
                                this.smoothingFile.writeSingle(match.entry.targetItem.lsfs);
                            } else {
                                this.smoothingFile.writeSingle(match.entry.sourceItem.lsfs);
                            }
                        } else if (this.baseParams.smoothingState == 2) {
                            if (!this.baseParams.isResynthesizeVocalTractFromSourceModel) {
                                match.entry.targetItem.setLsfs(this.smoothedVocalTract[this.smoothedInd]);
                            } else {
                                match.entry.sourceItem.setLsfs(this.smoothedVocalTract[this.smoothedInd]);
                            }
                        }
                    }
                    if (match instanceof WeightedCodebookLsfMatch) {
                        targetLpcs = !this.baseParams.isResynthesizeVocalTractFromSourceModel ? (!this.baseParams.lsfParams.isBarkScaled ? LsfAnalyser.lsfInHz2lpc(match.entry.targetItem.lsfs, this.fs) : LsfAnalyser.lsfInBark2lpc(match.entry.targetItem.lsfs, this.fs)) : (!this.baseParams.lsfParams.isBarkScaled ? LsfAnalyser.lsfInHz2lpc(match.entry.sourceItem.lsfs, this.fs) : LsfAnalyser.lsfInBark2lpc(match.entry.sourceItem.lsfs, this.fs));
                    } else if (match instanceof JointGMMMatch) {
                        targetLpcs = !this.baseParams.isResynthesizeVocalTractFromSourceModel ? (!this.baseParams.lsfParams.isBarkScaled ? LsfAnalyser.lsfInHz2lpc(((JointGMMMatch)match).outputFeatures, this.fs) : LsfAnalyser.lsfInBark2lpc(((JointGMMMatch)match).outputFeatures, this.fs)) : (!this.baseParams.lsfParams.isBarkScaled ? LsfAnalyser.lsfInHz2lpc(((JointGMMMatch)match).mappedSourceFeatures, this.fs) : LsfAnalyser.lsfInBark2lpc(((JointGMMMatch)match).mappedSourceFeatures, this.fs));
                    } else if (match instanceof LsfMatch) {
                        targetLpcs = !this.baseParams.lsfParams.isBarkScaled ? LsfAnalyser.lsfInHz2lpc(((LsfMatch)match).lsfs, this.fs) : LsfAnalyser.lsfInBark2lpc(((LsfMatch)match).lsfs, this.fs);
                    }
                    if (this.frmSize != this.newFrmSize) {
                        if (outputExpTerm == null || newMaxFreq * this.baseParams.lsfParams.dimension != outputExpTerm.real.length) {
                            outputExpTerm = LpcAnalyser.calcExpTerm(this.newFrmSize, this.baseParams.lsfParams.dimension);
                        }
                        targetVocalTractSpectrumEstimate = LpcAnalyser.calcSpecLinearFromOneMinusA(targetLpcs, 1.0f, this.newFrmSize, outputExpTerm);
                    } else {
                        targetVocalTractSpectrumEstimate = LpcAnalyser.calcSpecLinearFromOneMinusA(targetLpcs, 1.0f, this.newFrmSize, inputExpTerm);
                    }
                    k = 0;
                    while (k < newMaxFreq) {
                        int n = k++;
                        targetVocalTractSpectrumEstimate[n] = targetVocalTractSpectrumEstimate[n] * sqrtInputGain;
                    }
                }
                if (this.bShowSpectralPlots && this.psFrm.getCurrentTime() >= this.desiredFrameTime && this.baseParams.isVocalTractTransformation) {
                    tmpSpec = new double[newMaxFreq];
                    System.arraycopy(targetVocalTractSpectrumEstimate, 0, tmpSpec, 0, tmpSpec.length);
                    tmpSpec = MathUtils.amp2db(tmpSpec);
                    DisplayUtils.plot(tmpSpec, "5.Target Vocal Tract Estimate");
                }
                outputVocalTractSpectrum = new double[newMaxFreq];
                interpolatedInputVocalTractSpectrum = MathUtils.interpolate(inputVocalTractSpectrum, newMaxFreq);
                if (this.baseParams.isVocalTractTransformation) {
                    if (this.baseParams.isSourceVocalTractSpectrumFromModel) {
                        for (k = 0; k < newMaxFreq; ++k) {
                            outputVocalTractSpectrum[k] = targetVocalTractSpectrumEstimate[k] / sourceVocalTractSpectrumEstimate[k] * interpolatedInputVocalTractSpectrum[k];
                        }
                    } else {
                        for (k = 0; k < newMaxFreq; ++k) {
                            outputVocalTractSpectrum[k] = targetVocalTractSpectrumEstimate[k];
                        }
                    }
                } else {
                    for (k = 0; k < newMaxFreq; ++k) {
                        outputVocalTractSpectrum[k] = interpolatedInputVocalTractSpectrum[k];
                    }
                }
                if (this.baseParams.isVocalTractTransformation) {
                    transformationFilter = new double[newMaxFreq];
                    if (this.baseParams.isSourceVocalTractSpectrumFromModel) {
                        for (k = 0; k < newMaxFreq; ++k) {
                            transformationFilter[k] = targetVocalTractSpectrumEstimate[k] / sourceVocalTractSpectrumEstimate[k];
                        }
                    } else {
                        for (k = 0; k < newMaxFreq; ++k) {
                            transformationFilter[k] = targetVocalTractSpectrumEstimate[k] / interpolatedInputVocalTractSpectrum[k];
                        }
                    }
                    if (this.baseParams.smoothingMethod == 1) {
                        if (this.baseParams.smoothingState == 1) {
                            this.smoothingFile.writeSingle(transformationFilter);
                            if (this.bShowSpectralPlots && this.psFrm.getCurrentTime() >= this.desiredFrameTime) {
                                tmpSpec = new double[newMaxFreq];
                                System.arraycopy(transformationFilter, 0, tmpSpec, 0, tmpSpec.length);
                                tmpSpec = MathUtils.amp2db(tmpSpec);
                                DisplayUtils.plot(tmpSpec, "6.Transformation filter");
                            }
                        } else if (this.baseParams.smoothingState == 2) {
                            if (this.baseParams.isSourceVocalTractSpectrumFromModel) {
                                for (k = 0; k < newMaxFreq; ++k) {
                                    outputVocalTractSpectrum[k] = this.smoothedVocalTract[this.smoothedInd][k] * sourceVocalTractSpectrumEstimate[k];
                                }
                            } else {
                                for (k = 0; k < newMaxFreq; ++k) {
                                    outputVocalTractSpectrum[k] = this.smoothedVocalTract[this.smoothedInd][k] * interpolatedInputVocalTractSpectrum[k];
                                }
                            }
                            if (this.bShowSpectralPlots && this.psFrm.getCurrentTime() >= this.desiredFrameTime) {
                                tmpSpec = new double[newMaxFreq];
                                System.arraycopy(this.smoothedVocalTract[this.smoothedInd], 0, tmpSpec, 0, tmpSpec.length);
                                tmpSpec = MathUtils.amp2db(tmpSpec);
                                DisplayUtils.plot(tmpSpec, "6.Smoothed transformation filter");
                            }
                        } else if (this.bShowSpectralPlots && this.psFrm.getCurrentTime() >= this.desiredFrameTime) {
                            tmpSpec = new double[newMaxFreq];
                            System.arraycopy(transformationFilter, 0, tmpSpec, 0, tmpSpec.length);
                            tmpSpec = MathUtils.amp2db(tmpSpec);
                            DisplayUtils.plot(tmpSpec, "6.Transformation filter");
                        }
                    } else if (this.bShowSpectralPlots && this.psFrm.getCurrentTime() >= this.desiredFrameTime) {
                        tmpSpec = new double[newMaxFreq];
                        System.arraycopy(transformationFilter, 0, tmpSpec, 0, tmpSpec.length);
                        tmpSpec = MathUtils.amp2db(tmpSpec);
                        DisplayUtils.plot(tmpSpec, "6.Transformation filter");
                    }
                }
                if (this.bWarp) {
                    this.tmpvsc[0] = vscale;
                    this.newVScales = MathUtils.modifySize(this.tmpvsc, newMaxFreq);
                    for (k = 0; k < this.newVScales.length; ++k) {
                        if (!(this.newVScales[k] < 0.05)) continue;
                        this.newVScales[k] = 0.05;
                    }
                    warpedOutputVocalTractSpectrum = new double[newMaxFreq];
                    for (k = 0; k < newMaxFreq; ++k) {
                        int wInd = (int)Math.floor((double)(k + 1) / this.newVScales[k] + 0.5);
                        if (wInd < 1) {
                            wInd = 1;
                        }
                        if (wInd > newMaxFreq) {
                            wInd = newMaxFreq;
                        }
                        warpedOutputVocalTractSpectrum[k] = outputVocalTractSpectrum[wInd - 1];
                    }
                    System.arraycopy(warpedOutputVocalTractSpectrum, 0, outputVocalTractSpectrum, 0, newMaxFreq);
                }
                outputResidual = new ComplexArray(this.newFrmSize);
                outputResidual.real = MathUtils.zeros(this.newFrmSize);
                outputResidual.imag = MathUtils.zeros(this.newFrmSize);
                System.arraycopy(inputResidual.real, 0, outputResidual.real, 0, Math.min(maxFreq, this.newFrmSize));
                System.arraycopy(inputResidual.imag, 0, outputResidual.imag, 0, Math.min(maxFreq, this.newFrmSize));
                int kMax = 1;
                while (newMaxFreq > (kMax + 1) * (maxFreq - 2)) {
                    ++kMax;
                }
                for (k = 1; k <= kMax; ++k) {
                    int tmpMul;
                    int tmpAdd;
                    int tmpFix = (maxFreq - 2) * k;
                    if (k % 2 == 1) {
                        tmpAdd = maxFreq + 2;
                        tmpMul = 1;
                    } else {
                        tmpAdd = -1;
                        tmpMul = -1;
                    }
                    for (j = tmpFix + 3; j <= Math.min(newMaxFreq, maxFreq + tmpFix); ++j) {
                        outputResidual.real[j - 1] = inputResidual.real[tmpMul * (tmpFix - j) + tmpAdd - 1];
                        outputResidual.imag[j - 1] = inputResidual.imag[tmpMul * (tmpFix - j) + tmpAdd - 1];
                    }
                }
                outputResidual.real[newMaxFreq - 1] = Math.sqrt(outputResidual.real[newMaxFreq - 1] * outputResidual.real[newMaxFreq - 1] + outputResidual.imag[newMaxFreq - 1] * outputResidual.imag[newMaxFreq - 1]);
                outputResidual.imag[newMaxFreq - 1] = 0.0;
                if (this.bShowSpectralPlots && this.psFrm.getCurrentTime() >= this.desiredFrameTime) {
                    tmpComp = new ComplexArray(outputResidual);
                    tmpSpec = MathUtils.dft2ampdb(tmpComp, 0, newMaxFreq - 1);
                    DisplayUtils.plot(tmpSpec, "7.Output Residual");
                }
                outputDft = new ComplexArray(this.newFrmSize);
                if (this.baseParams.smoothingMethod == 3) {
                    if (this.baseParams.smoothingState == 1) {
                        this.smoothingFile.writeSingle(outputVocalTractSpectrum, newMaxFreq);
                    } else if (this.baseParams.smoothingState == 2) {
                        for (k = 0; k < newMaxFreq; ++k) {
                            outputVocalTractSpectrum[k] = this.smoothedVocalTract[this.smoothedInd][k];
                        }
                    }
                }
                if (this.bShowSpectralPlots && this.psFrm.getCurrentTime() >= this.desiredFrameTime) {
                    tmpSpec = new double[newMaxFreq];
                    System.arraycopy(outputVocalTractSpectrum, 0, tmpSpec, 0, tmpSpec.length);
                    tmpSpec = MathUtils.amp2db(tmpSpec);
                    DisplayUtils.plot(tmpSpec, "8.Output Vocal Tract");
                }
                for (k = 1; k <= newMaxFreq; ++k) {
                    outputDft.real[k - 1] = outputResidual.real[k - 1] * outputVocalTractSpectrum[k - 1];
                    outputDft.imag[k - 1] = outputResidual.imag[k - 1] * outputVocalTractSpectrum[k - 1];
                }
                for (k = newMaxFreq + 1; k <= this.newFrmSize; ++k) {
                    outputDft.real[k - 1] = outputDft.real[2 * newMaxFreq - 1 - k];
                    outputDft.imag[k - 1] = -outputDft.imag[2 * newMaxFreq - 1 - k];
                }
                if (this.bShowSpectralPlots && this.psFrm.getCurrentTime() >= this.desiredFrameTime) {
                    tmpComp = new ComplexArray(outputDft);
                    tmpSpec = MathUtils.dft2ampdb(tmpComp, 0, newMaxFreq);
                    DisplayUtils.plot(tmpSpec, "9.Output DFT");
                    this.bShowSpectralPlots = false;
                }
                outputDft = FFTMixedRadix.ifft(outputDft);
                this.frmy = new double[this.newFrmSize];
                System.arraycopy(outputDft.real, 0, this.frmy, 0, this.newFrmSize);
            } else {
                if (this.frmSize < this.newFrmSize) {
                    this.newFrmSize = this.frmSize;
                }
                this.frmy = new double[this.newFrmSize];
            }
            this.frmy = SignalProcUtils.removePreemphasis(this.frmy, this.baseParams.lsfParams.preCoef);
            this.frmyEn = SignalProcUtils.getEnergy(this.frmy);
            this.gain = this.frmEn / Math.sqrt(this.frmSize) / (this.frmyEn / Math.sqrt(this.newFrmSize)) * escale;
            if (!(isVoiced && pscale != 1.0 || this.bWarp || isTransformUnvoiced)) {
                for (k = 0; k < this.frmSize; ++k) {
                    this.frmy[k] = this.frm[k] * this.wgt[k];
                }
            }
            k = 0;
            while (k < this.newFrmSize) {
                int n = k++;
                this.frmy[n] = this.frmy[n] * this.gain;
            }
            for (j = 1; j <= this.repeatSkipCount + 1; ++j) {
                this.newSkipSize = !this.baseParams.isFixedRateVocalTractConversion ? (isVoiced ? (int)Math.floor((double)currentPeriod / pscale + 0.5) : (int)Math.floor((double)currentPeriod + 0.5)) : (int)Math.floor(this.ssFixedInSeconds * (double)this.fs + 0.5);
                this.bLastFrame = isLastInputFrame && j == this.repeatSkipCount + 1;
                ++this.synthFrameInd;
                this.wgty = this.windowOut.values(this.newFrmSize);
                if (this.synthFrameInd == 1) {
                    this.halfWin = (int)Math.floor((double)this.newFrmSize / 2.0 + 0.5);
                    this.synthTotal = this.synthSt + this.newFrmSize;
                    if (this.ySynthInd + this.newFrmSize - 1 <= this.maxNewFrmSize) {
                        for (k = this.ySynthInd; k <= this.ySynthInd + this.halfWin - 1; ++k) {
                            this.ySynthBuff[k - 1] = this.frmy[k - this.ySynthInd];
                            this.wSynthBuff[k - 1] = 1.0;
                        }
                        for (k = this.ySynthInd + this.halfWin; k <= this.ySynthInd + this.newFrmSize - 1; ++k) {
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                            int n2 = k - 1;
                            this.wSynthBuff[n2] = this.wSynthBuff[n2] + this.wgty[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                        }
                    } else {
                        for (k = this.ySynthInd; k <= this.maxNewFrmSize; ++k) {
                            if (k - this.ySynthInd < this.halfWin) {
                                this.ySynthBuff[k - 1] = this.frmy[k - this.ySynthInd];
                                this.wSynthBuff[k - 1] = 1.0;
                                continue;
                            }
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                            int n3 = k - 1;
                            this.wSynthBuff[n3] = this.wSynthBuff[n3] + this.wgty[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                        }
                        for (k = 1; k <= this.newFrmSize - 1 - this.maxNewFrmSize + this.ySynthInd; ++k) {
                            if (this.maxNewFrmSize - this.ySynthInd + k < this.halfWin) {
                                this.ySynthBuff[k - 1] = this.frmy[this.maxNewFrmSize - this.ySynthInd + k];
                                this.wSynthBuff[k - 1] = 1.0;
                                continue;
                            }
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[this.maxNewFrmSize - this.ySynthInd + k] * this.wgty[this.maxNewFrmSize - this.ySynthInd + k];
                            int n4 = k - 1;
                            this.wSynthBuff[n4] = this.wSynthBuff[n4] + this.wgty[this.maxNewFrmSize - this.ySynthInd + k] * this.wgty[this.maxNewFrmSize - this.ySynthInd + k];
                        }
                    }
                    if (!this.bSilent) {
                        System.out.println("Synthesized using frame " + String.valueOf(this.inputFrameIndex + 1));
                    }
                } else if (this.bLastFrame) {
                    this.halfWin = (int)Math.floor((double)this.newFrmSize / 2.0 + 0.5);
                    int remain = this.newFrmSize - this.halfWin;
                    this.synthTotal = this.synthSt + this.halfWin + remain - 1;
                    if (this.ySynthInd + this.newFrmSize - 1 <= this.maxNewFrmSize) {
                        for (k = this.ySynthInd; k <= this.ySynthInd + this.halfWin - 1; ++k) {
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                            int n5 = k - 1;
                            this.wSynthBuff[n5] = this.wSynthBuff[n5] + this.wgty[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                        }
                        for (k = this.ySynthInd + this.halfWin; k <= this.ySynthInd + this.newFrmSize - 1; ++k) {
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd];
                            this.wSynthBuff[k - 1] = 1.0;
                        }
                    } else {
                        for (k = this.ySynthInd; k <= this.maxNewFrmSize; ++k) {
                            if (k - this.ySynthInd < this.halfWin) {
                                int n = k - 1;
                                this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                                int n6 = k - 1;
                                this.wSynthBuff[n6] = this.wSynthBuff[n6] + this.wgty[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                                continue;
                            }
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd];
                            this.wSynthBuff[k - 1] = 1.0;
                        }
                        for (k = 1; k <= this.newFrmSize - 1 - this.maxNewFrmSize + this.ySynthInd; ++k) {
                            if (this.maxNewFrmSize - this.ySynthInd + k < this.halfWin) {
                                int n = k - 1;
                                this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[this.maxNewFrmSize - this.ySynthInd + k] * this.wgty[this.maxNewFrmSize - this.ySynthInd + k];
                                int n7 = k - 1;
                                this.wSynthBuff[n7] = this.wSynthBuff[n7] + this.wgty[this.maxNewFrmSize - this.ySynthInd + k] * this.wgty[this.maxNewFrmSize - this.ySynthInd + k];
                                continue;
                            }
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[this.maxNewFrmSize - this.ySynthInd + k];
                            this.wSynthBuff[k - 1] = 1.0;
                        }
                    }
                    if (!this.bSilent) {
                        System.out.println("Synthesized using frame " + String.valueOf(this.inputFrameIndex + 1));
                    }
                } else {
                    if (!isVoiced && this.repeatSkipCount % 2 == 1) {
                        this.frmy = SignalProcUtils.reverse(this.frmy);
                    }
                    this.synthTotal = this.synthSt + this.newFrmSize;
                    if (this.ySynthInd + this.newFrmSize - 1 <= this.maxNewFrmSize) {
                        for (k = this.ySynthInd; k <= this.ySynthInd + this.newFrmSize - 1; ++k) {
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                            int n8 = k - 1;
                            this.wSynthBuff[n8] = this.wSynthBuff[n8] + this.wgty[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                        }
                    } else {
                        for (k = this.ySynthInd; k <= this.maxNewFrmSize; ++k) {
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                            int n9 = k - 1;
                            this.wSynthBuff[n9] = this.wSynthBuff[n9] + this.wgty[k - this.ySynthInd] * this.wgty[k - this.ySynthInd];
                        }
                        for (k = 1; k <= this.newFrmSize - 1 - this.maxNewFrmSize + this.ySynthInd; ++k) {
                            int n = k - 1;
                            this.ySynthBuff[n] = this.ySynthBuff[n] + this.frmy[k + this.maxNewFrmSize - this.ySynthInd] * this.wgty[k + this.maxNewFrmSize - this.ySynthInd];
                            int n10 = k - 1;
                            this.wSynthBuff[n10] = this.wSynthBuff[n10] + this.wgty[k + this.maxNewFrmSize - this.ySynthInd] * this.wgty[k + this.maxNewFrmSize - this.ySynthInd];
                        }
                    }
                    if (!this.bSilent) {
                        if (j == 1) {
                            System.out.println("Synthesized using frame " + String.valueOf(this.inputFrameIndex + 1));
                        } else {
                            System.out.println("Repeated using frame " + String.valueOf(this.inputFrameIndex + 1));
                        }
                    }
                }
                for (k = 0; k <= this.newSkipSize - 1; ++k) {
                    int kInd = (k + this.ySynthInd) % this.maxNewFrmSize;
                    if (kInd == 0) {
                        kInd = this.maxNewFrmSize;
                    }
                    this.outBuff[this.outBuffStart - 1] = this.wSynthBuff[kInd - 1] > 0.0 ? this.ySynthBuff[kInd - 1] / this.wSynthBuff[kInd - 1] : this.ySynthBuff[kInd - 1];
                    this.ySynthBuff[kInd - 1] = 0.0;
                    this.wSynthBuff[kInd - 1] = 0.0;
                    ++this.outBuffStart;
                    if (this.outBuffStart <= this.outBuffLen) continue;
                    if (this.tscaleSingle != 1.0 || this.totalWrittenToFile + this.outBuffLen <= this.origLen) {
                        this.dout.writeDouble(this.outBuff, 0, this.outBuffLen);
                        this.totalWrittenToFile += this.outBuffLen;
                    } else {
                        this.dout.writeDouble(this.outBuff, 0, this.origLen - this.totalWrittenToFile);
                        this.totalWrittenToFile = this.origLen;
                    }
                    this.outBuffStart = 1;
                }
                this.synthSt += this.newSkipSize;
                this.ySynthInd = this.ySynthInd + this.newSkipSize <= this.maxNewFrmSize ? (this.ySynthInd += this.newSkipSize) : (this.ySynthInd += this.newSkipSize - this.maxNewFrmSize);
                if (!this.bLastFrame) continue;
                this.bBroke = true;
                break;
            }
        } else if (!this.bSilent) {
            System.out.println("Skipped frame " + String.valueOf(this.inputFrameIndex + 1));
        }
        ++this.inputFrameIndex;
        return output;
    }

    public double[] writeFinal() throws IOException {
        double[] output = null;
        Object outputTmp = null;
        if (this.tscaleSingle == 1.0) {
            this.synthTotal = this.origLen;
        }
        if (this.outBuffLen > this.synthTotal) {
            this.outBuffLen = this.synthTotal;
        }
        for (int k = this.synthSt; k <= this.synthTotal; ++k) {
            int kInd = (k - this.synthSt + this.ySynthInd) % this.maxNewFrmSize;
            if (kInd == 0) {
                kInd = this.maxNewFrmSize;
            }
            this.outBuff[this.outBuffStart - 1] = this.wSynthBuff[kInd - 1] > 0.0 ? this.ySynthBuff[kInd - 1] / this.wSynthBuff[kInd - 1] : this.ySynthBuff[kInd - 1];
            this.ySynthBuff[kInd - 1] = 0.0;
            this.wSynthBuff[kInd - 1] = 0.0;
            ++this.outBuffStart;
            if (this.outBuffStart <= this.outBuffLen) continue;
            if (this.tscaleSingle != 1.0 || this.totalWrittenToFile + this.outBuffLen <= this.origLen) {
                this.dout.writeDouble(this.outBuff, 0, this.outBuffLen);
                this.totalWrittenToFile += this.outBuffLen;
            } else {
                this.dout.writeDouble(this.outBuff, 0, this.origLen - this.totalWrittenToFile);
                this.totalWrittenToFile = this.origLen;
            }
            this.outBuffStart = 1;
        }
        if (this.outBuffStart > 1) {
            if (this.tscaleSingle != 1.0 || this.totalWrittenToFile + this.outBuffStart - 1 <= this.origLen) {
                this.dout.writeDouble(this.outBuff, 0, this.outBuffStart - 1);
                this.totalWrittenToFile += this.outBuffStart - 1;
            } else {
                this.dout.writeDouble(this.outBuff, 0, this.origLen - this.totalWrittenToFile);
                this.totalWrittenToFile = this.origLen;
            }
        }
        if (this.dout != null) {
            this.dout.close();
        }
        return output;
    }

    public void convertToWav(AudioFormat audioformat) throws IOException {
        if (this.tempOutBinaryFile != null) {
            double[] yOut = null;
            this.din = new LEDataInputStream(this.tempOutBinaryFile);
            yOut = this.din.readDouble(this.totalWrittenToFile);
            this.din.close();
            double tmpMax = MathUtils.getAbsMax(yOut);
            if (tmpMax > 1.0) {
                int n = 0;
                while (n < yOut.length) {
                    int n2 = n++;
                    yOut[n2] = yOut[n2] / tmpMax;
                }
            }
            this.outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(yOut), audioformat);
            AudioSystem.write((AudioInputStream)this.outputAudio, AudioFileFormat.Type.WAVE, new File(this.outputFile));
            FileUtils.delete((String)this.tempOutBinaryFile);
        }
    }
}

