/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.tags;

import edu.cmu.sphinx.tools.tags.ActionTagsUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.speech.recognition.RuleParse;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ActionTagsParser {
    protected Context context;
    protected Object undefined;
    protected ImporterTopLevel global;
    static BufferedReader inReader;

    public ActionTagsParser() {
        try {
            this.context = Context.enter();
            this.context.setErrorReporter((ErrorReporter)new LocalErrorReporter());
            this.context.setLanguageVersion(120);
            this.global = (ImporterTopLevel)this.context.initStandardObjects((ScriptableObject)new ImporterTopLevel(), false);
            this.undefined = Context.getUndefinedValue();
            String[] names = new String[]{"print", "debug"};
            this.global.defineFunctionProperties(names, ActionTagsParser.class, 2);
            this.context.evaluateString((Scriptable)this.global, ActionTagsUtilities.getClassDefinitions(), "GlobalDefinitions", 1, null);
        }
        catch (JavaScriptException jse) {
            jse.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void parseTags(RuleParse ruleParse) {
        if (ruleParse == null) {
            return;
        }
        try {
            this.context.evaluateString((Scriptable)this.global, ActionTagsUtilities.getScript(ruleParse), "parseTags", 1, null);
        }
        catch (JavaScriptException jse) {
            jse.printStackTrace();
        }
    }

    public Object evaluateString(String script) {
        Object retVal = null;
        try {
            retVal = this.context.evaluateString((Scriptable)this.global, script, "evaluateString", 1, null);
            if (retVal == this.undefined) {
                retVal = null;
            }
        }
        catch (JavaScriptException jse) {
            jse.printStackTrace();
        }
        if (retVal != null && retVal instanceof NativeJavaObject) {
            retVal = ((NativeJavaObject)retVal).unwrap();
        }
        return retVal;
    }

    public Object getGlobal(String name) {
        return this.evaluateString(name + ';');
    }

    public Object get(String name) {
        return this.evaluateString("$." + name + ';');
    }

    public static void print(String string) {
        System.out.println(string);
    }

    public static String debug(String string) {
        System.out.println("DEBUG: " + string);
        System.out.print("DEBUG> ");
        try {
            if (inReader == null) {
                inReader = new BufferedReader(new InputStreamReader(System.in));
            }
            return inReader.readLine();
        }
        catch (IOException e) {
            return "step";
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.printScriptable((Scriptable)this.global, builder, null);
        return builder.toString();
    }

    public String showValue() {
        StringBuilder builder = new StringBuilder();
        try {
            this.printScriptable((Scriptable)this.global.get("$", (Scriptable)this.global), builder, null);
        }
        catch (Exception e) {
            builder.append("$: unknown (").append(e).append(")\n");
            e.printStackTrace();
        }
        return builder.toString();
    }

    protected void printScriptable(Scriptable scriptable, StringBuilder builder, String prefix) {
        Object[] ids;
        if (scriptable == this.undefined) {
            builder.append(prefix).append(": undefined\n");
            return;
        }
        for (Object id : ids = scriptable.getIds()) {
            String idStr = prefix == null ? id.toString() : prefix + '.' + id;
            try {
                Object o = id instanceof String ? scriptable.get((String)id, scriptable) : scriptable.get(((Integer)id).intValue(), scriptable);
                if (o instanceof Function) continue;
                if (o instanceof Scriptable) {
                    this.printScriptable((Scriptable)o, builder, idStr);
                    continue;
                }
                builder.append(idStr).append(": ").append(o).append('\n');
            }
            catch (Exception e) {
                builder.append(idStr).append(": unknown (").append(e).append(")\n");
                e.printStackTrace();
            }
        }
    }

    class LocalErrorReporter
    implements ErrorReporter {
        LocalErrorReporter() {
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            System.err.println("ECMAScript warning in " + sourceName);
            System.err.println("    line #:  " + line);
            System.err.println("    source:  " + lineSource);
            System.err.println("    message: " + message + '\n');
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            System.err.println("ECMAScript error in " + sourceName);
            System.err.println("    line #:  " + line);
            System.err.println("    source:  " + lineSource);
            System.err.println("    message: " + message + '\n');
            throw new EvaluatorException(message);
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            return new EvaluatorException(message);
        }
    }
}

