/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tess4j;

import com.sun.jna.Pointer;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.imageio.IIOImage;
import net.sourceforge.tess4j.TessAPI1;
import net.sourceforge.tess4j.TesseractException;
import net.sourceforge.vietocr.ImageIOHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tesseract1
extends TessAPI1 {
    private static final Rectangle EMPTY_RECTANGLE = new Rectangle();
    private String language = "eng";
    private String datapath = "tessdata";
    private int psm = 3;
    private boolean hocr;
    private int pageNum;
    private int ocrEngineMode = 3;
    private Properties prop = new Properties();
    public static final String htmlBeginTag = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n<title></title>\n<meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\" />\n<meta name='ocr-system' content='tesseract'/>\n</head>\n<body>\n";
    public static final String htmlEndTag = "</body>\n</html>\n";

    public Tesseract1() {
        System.setProperty("jna.encoding", "UTF8");
    }

    public void setDatapath(String string) {
        this.datapath = string;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public void setOcrEngineMode(int n) {
        this.ocrEngineMode = n;
    }

    public void setPageSegMode(int n) {
        this.psm = n;
    }

    public void setHocr(boolean bl) {
        this.hocr = bl;
        this.prop.setProperty("tessedit_create_hocr", bl ? "1" : "0");
    }

    public void setTessVariable(String string, String string2) {
        this.prop.setProperty(string, string2);
    }

    public String doOCR(File file) throws TesseractException {
        return this.doOCR(file, null);
    }

    public String doOCR(File file, Rectangle rectangle) throws TesseractException {
        try {
            return this.doOCR(ImageIOHelper.getIIOImageList(file), rectangle);
        }
        catch (IOException iOException) {
            throw new TesseractException(iOException);
        }
    }

    public String doOCR(BufferedImage bufferedImage) throws TesseractException {
        return this.doOCR(bufferedImage, null);
    }

    public String doOCR(BufferedImage bufferedImage, Rectangle rectangle) throws TesseractException {
        IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
        ArrayList<IIOImage> arrayList = new ArrayList<IIOImage>();
        arrayList.add(iIOImage);
        return this.doOCR(arrayList, rectangle);
    }

    public String doOCR(List<IIOImage> list, Rectangle rectangle) throws TesseractException {
        StringBuilder stringBuilder = new StringBuilder();
        this.pageNum = 0;
        for (IIOImage iIOImage : list) {
            ++this.pageNum;
            try {
                ByteBuffer byteBuffer = ImageIOHelper.getImageByteBuffer(iIOImage);
                RenderedImage renderedImage = iIOImage.getRenderedImage();
                String string = this.doOCR(renderedImage.getWidth(), renderedImage.getHeight(), byteBuffer, rectangle, renderedImage.getColorModel().getPixelSize());
                stringBuilder.append(string);
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
        }
        if (this.hocr) {
            stringBuilder.insert(0, htmlBeginTag).append(htmlEndTag);
        }
        return stringBuilder.toString();
    }

    public String doOCR(int n, int n2, ByteBuffer byteBuffer, Rectangle rectangle, int n3) throws TesseractException {
        TessAPI1.TessBaseAPI tessBaseAPI = Tesseract1.TessBaseAPICreate();
        Tesseract1.TessBaseAPIInit2(tessBaseAPI, this.datapath, this.language, this.ocrEngineMode);
        Tesseract1.TessBaseAPISetPageSegMode(tessBaseAPI, this.psm);
        Enumeration<?> enumeration = this.prop.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Tesseract1.TessBaseAPISetVariable(tessBaseAPI, string, this.prop.getProperty(string));
        }
        int n4 = n3 / 8;
        int n5 = (int)Math.ceil((double)(n * n3) / 8.0);
        Tesseract1.TessBaseAPISetImage(tessBaseAPI, byteBuffer, n, n2, n4, n5);
        if (rectangle != null && !rectangle.equals(EMPTY_RECTANGLE)) {
            Tesseract1.TessBaseAPISetRectangle(tessBaseAPI, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        Pointer pointer = this.hocr ? Tesseract1.TessBaseAPIGetHOCRText(tessBaseAPI, this.pageNum - 1) : Tesseract1.TessBaseAPIGetUTF8Text(tessBaseAPI);
        String string = pointer.getString(0L);
        Tesseract1.TessDeleteText(pointer);
        Tesseract1.TessBaseAPIDelete(tessBaseAPI);
        return string;
    }
}

