/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.live;

import edu.cmu.sphinx.frontend.util.ConcatFileDataSource;
import edu.cmu.sphinx.recognizer.Recognizer;
import edu.cmu.sphinx.result.Result;
import edu.cmu.sphinx.util.GapInsertionDetector;
import edu.cmu.sphinx.util.NISTAlign;
import edu.cmu.sphinx.util.ReferenceSource;
import edu.cmu.sphinx.util.Timer;
import edu.cmu.sphinx.util.TimerPool;
import edu.cmu.sphinx.util.props.Configurable;
import edu.cmu.sphinx.util.props.ConfigurationManager;
import edu.cmu.sphinx.util.props.PropertyException;
import edu.cmu.sphinx.util.props.PropertySheet;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4String;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

public class LiveModeRecognizer
implements Configurable {
    @S4Component(type=Recognizer.class)
    public static final String PROP_RECOGNIZER = "recognizer";
    @S4Component(type=ConcatFileDataSource.class)
    public static final String PROP_INPUT_SOURCE = "inputSource";
    @S4Boolean(defaultValue=false)
    public static final String PROP_SHOW_GAP_INSERTIONS = "showGapInsertions";
    @S4String(defaultValue="hypothesis.txt")
    public static final String PROP_HYPOTHESIS_TRANSCRIPT = "hypothesisTranscript";
    @S4Integer(defaultValue=-1)
    public static final String PROP_ALIGN_INTERVAL = "alignInterval";
    private Recognizer recognizer;
    private ConcatFileDataSource dataSource;
    private String hypothesisFile;
    private boolean showGapInsertions;
    private int alignInterval;
    private int numUtterances;
    private FileWriter hypothesisTranscript;
    private ReferenceSource referenceSource;
    private final NISTAlign aligner = new NISTAlign(true, true);

    public LiveModeRecognizer(Recognizer recognizer, ConcatFileDataSource dataSource, int skip, boolean showGapInsertions, String hypothesisFile, int alignInterval) {
        this.recognizer = recognizer;
        this.dataSource = dataSource;
        this.showGapInsertions = showGapInsertions;
        this.hypothesisFile = hypothesisFile;
        this.alignInterval = alignInterval;
        this.referenceSource = dataSource;
    }

    public LiveModeRecognizer() {
    }

    public void newProperties(PropertySheet ps) throws PropertyException {
        this.recognizer = (Recognizer)ps.getComponent(PROP_RECOGNIZER);
        this.dataSource = (ConcatFileDataSource)ps.getComponent(PROP_INPUT_SOURCE);
        this.showGapInsertions = ps.getBoolean(PROP_SHOW_GAP_INSERTIONS);
        this.hypothesisFile = ps.getString(PROP_HYPOTHESIS_TRANSCRIPT);
        this.alignInterval = ps.getInt(PROP_ALIGN_INTERVAL);
        this.referenceSource = this.dataSource;
    }

    public void decode() throws IOException {
        Result result;
        LinkedList<String> resultList = new LinkedList<String>();
        int startReference = 0;
        this.hypothesisTranscript = new FileWriter(this.hypothesisFile);
        this.recognizer.allocate();
        while ((result = this.recognizer.recognize()) != null) {
            ++this.numUtterances;
            String resultText = result.getBestResultNoFiller();
            System.out.println("\nHYP: " + resultText);
            System.out.println("   Sentences: " + this.numUtterances);
            resultList.add(resultText);
            this.hypothesisTranscript.write(result.getTimedBestResult(false, true) + '\n');
            this.hypothesisTranscript.flush();
            if (this.alignInterval <= 0 || this.numUtterances % this.alignInterval != 0) continue;
            List references = this.referenceSource.getReferences();
            List<String> section = references.subList(startReference, references.size());
            this.alignResults(resultList, section);
            resultList = new LinkedList();
            startReference = references.size();
        }
        this.hypothesisTranscript.close();
        List references = this.referenceSource.getReferences();
        List<String> section = references.subList(startReference, references.size());
        if (!resultList.isEmpty() || !section.isEmpty()) {
            this.alignResults(resultList, section);
        }
        System.out.println("# ------------- Summary Statistics -------------");
        this.aligner.printTotalSummary();
        this.recognizer.deallocate();
        this.showLiveSummary();
        System.out.println();
    }

    private void showLiveSummary() throws IOException {
        int actualUtterances = this.referenceSource.getReferences().size();
        int gapInsertions = this.detectGapInsertionErrors();
        System.out.println("   Utterances:  Actual: " + actualUtterances + "  Found: " + this.numUtterances);
        System.out.println("   Gap Insertions: " + gapInsertions);
    }

    private int detectGapInsertionErrors() throws IOException {
        Timer gapTimer = TimerPool.getTimer((Object)this, (String)"GapInsertionDetector");
        gapTimer.start();
        GapInsertionDetector gid = new GapInsertionDetector(this.dataSource.getTranscriptFile(), this.hypothesisFile, this.showGapInsertions);
        int gapInsertions = gid.detect();
        gapTimer.stop();
        return gapInsertions;
    }

    private void alignResults(List<String> hypothesisList, List<String> referenceList) {
        System.out.println();
        System.out.println("Aligning results...");
        System.out.println("   Utterances: Found: " + hypothesisList.size() + "   Actual: " + referenceList.size());
        String hypothesis = this.listToString(hypothesisList);
        String reference = this.listToString(referenceList);
        this.saveAlignedText(hypothesis, reference);
        this.getAlignTimer().start();
        this.aligner.align(reference, hypothesis);
        this.getAlignTimer().stop();
        System.out.println(" ...done aligning");
        System.out.println();
    }

    private void saveAlignedText(String hypothesis, String reference) {
        try {
            FileWriter writer = new FileWriter("align.txt");
            writer.write(hypothesis);
            writer.write("\n");
            writer.write(reference);
            writer.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private String listToString(List<String> resultList) {
        StringBuilder sb = new StringBuilder();
        for (String result : resultList) {
            sb.append(result).append(' ');
        }
        return sb.toString();
    }

    private Timer getAlignTimer() {
        return TimerPool.getTimer((Object)this, (String)"Align");
    }

    public void close() throws IOException {
        this.hypothesisTranscript.close();
    }

    public static void main(String[] argv) {
        LiveModeRecognizer lmr;
        if (argv.length != 1) {
            System.out.println("Usage: LiveModeRecognizer config-file.xml ");
            System.exit(1);
        }
        String cmFile = argv[0];
        try {
            URL url = new File(cmFile).toURI().toURL();
            ConfigurationManager cm = new ConfigurationManager(url);
            lmr = (LiveModeRecognizer)cm.lookup("live");
        }
        catch (IOException ioe) {
            System.err.println("I/O error during initialization: \n   " + ioe);
            return;
        }
        catch (PropertyException e) {
            System.err.println("Error during initialization: \n  " + (Object)((Object)e));
            e.printStackTrace();
            return;
        }
        if (lmr == null) {
            System.err.println("Can't find liveModeRecognizer in " + cmFile);
            return;
        }
        try {
            lmr.decode();
        }
        catch (IOException ioe) {
            System.err.println("I/O error during decoding: " + ioe.getMessage());
        }
    }
}

