/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.gui.util;

import edu.cmu.sphinx.tools.gui.ConfigProperties;
import edu.cmu.sphinx.tools.gui.GUIFileActionListener;
import edu.cmu.sphinx.tools.gui.util.ClassFinder;
import edu.cmu.sphinx.tools.gui.util.ConfigurableComponent;
import edu.cmu.sphinx.tools.gui.util.ConfigurableProperty;
import edu.cmu.sphinx.tools.gui.util.ConfigurableUtilException;
import edu.cmu.sphinx.tools.gui.util.JavadocExtractor;
import edu.cmu.sphinx.util.props.PropertyType;
import edu.cmu.sphinx.util.props.RawPropertyData;
import edu.cmu.sphinx.util.props.S4Boolean;
import edu.cmu.sphinx.util.props.S4Component;
import edu.cmu.sphinx.util.props.S4ComponentList;
import edu.cmu.sphinx.util.props.S4Double;
import edu.cmu.sphinx.util.props.S4Integer;
import edu.cmu.sphinx.util.props.S4Property;
import edu.cmu.sphinx.util.props.S4String;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ModelBuilder
implements GUIFileActionListener {
    private static final String CONFIG_PATH = "/edu/cmu/sphinx/tools/gui/util.conf";
    private static final String FOLDER_PROP = "edu/cmu/sphinx";
    private static final String PACKAGE_PROP = "edu.cmu.sphinx";
    private static final String SOURCE_PROP = "source_path";
    private static final String CLASSES_PROP = "classes_path";
    private final Map<Object, ConfigurableComponent> _classes = new HashMap<Object, ConfigurableComponent>();
    private final Map<String, Set<ConfigurableComponent>> _groups = new HashMap<String, Set<ConfigurableComponent>>();
    private final String _folder_path = "edu/cmu/sphinx";
    private final String _package_path = "edu.cmu.sphinx";
    private static String _source_path;
    private static String _classes_path;

    private ModelBuilder() {
        _source_path = null;
        _classes_path = null;
    }

    public static ModelBuilder getInstance() {
        return ModelBuilderHolder.instance;
    }

    public Map<Object, ConfigurableComponent> getClasses() {
        return this._classes.isEmpty() ? null : this._classes;
    }

    public Map<String, Set<ConfigurableComponent>> getGroups() {
        return this._groups.isEmpty() ? null : this._groups;
    }

    public boolean checkDuplicateConfigurationSet(String name) {
        for (ConfigurableComponent cc : this._classes.values()) {
            if (!cc.containsConfigurationSet(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearAll() {
        for (ConfigurableComponent cc : this._classes.values()) {
            cc.deleteAllConfigurationProp();
        }
    }

    @Override
    public void update(ConfigProperties cp) {
        this.clearAll();
        this.loadCurrentValues(cp);
    }

    @Override
    public void saveData(ConfigProperties cp) {
        for (ConfigurableComponent cc : this._classes.values()) {
            cp.addRPDProperties(cc.getConfigurationPropMap());
        }
    }

    @Override
    public void modelRefresh() throws ConfigurableUtilException {
        this.refresh();
    }

    public String getSourceCode(String classname) {
        StringBuilder text = new StringBuilder();
        if (_source_path == null) {
            return "== Source code not available ==";
        }
        try {
            String thisline;
            String completename = classname.trim().replace('.', '/');
            completename = !_source_path.trim().endsWith("/") ? _source_path.trim().concat('/' + completename) : _source_path.trim().concat(completename);
            if (!completename.endsWith(".java")) {
                completename = completename.concat(".java");
            }
            BufferedReader br = new BufferedReader(new FileReader(completename));
            while ((thisline = br.readLine()) != null) {
                text.append(thisline).append('\n');
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        return text.toString();
    }

    public Map<String, String> getclasslist(String classtype) {
        try {
            Class<?> searchclass = Class.forName(classtype);
            HashMap<String, String> myreturn = new HashMap<String, String>();
            if (this._classes != null && classtype != null && !classtype.trim().isEmpty()) {
                for (ConfigurableComponent cc : this._classes.values()) {
                    Class<?> c = cc.getComponentClass();
                    Map<String, RawPropertyData> configset = cc.getConfigurationPropMap();
                    if (!searchclass.isAssignableFrom(c) || configset == null || configset.isEmpty()) continue;
                    for (String configname : configset.keySet()) {
                        myreturn.put(configname, c.getName());
                    }
                }
            }
            return myreturn;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private void loadCurrentValues(ConfigProperties cp) {
        Map<String, Map<String, Object>> rpdMap = cp.getOtherProp();
        for (Map.Entry<String, Map<String, Object>> entry : rpdMap.entrySet()) {
            String classname = entry.getKey();
            for (Object object : entry.getValue().values()) {
                RawPropertyData rpd = (RawPropertyData)object;
                if (!this._classes.containsKey(classname)) continue;
                ConfigurableComponent cc = this._classes.get(classname);
                Map propertyMap = rpd.getProperties();
                this.checkProperty(propertyMap, cc);
                this.addIncompleteProps(propertyMap, cc);
                cc.addConfigurationProp(rpd);
            }
        }
    }

    private void addIncompleteProps(Map<String, Object> propertyMap, ConfigurableComponent checker) {
        Map<String, ConfigurableProperty> completePropMap = checker.getPropertyMap();
        for (Map.Entry<String, ConfigurableProperty> propentry : completePropMap.entrySet()) {
            String propname = propentry.getKey();
            if (propertyMap.containsKey(propname)) continue;
            ConfigurableProperty prop = propentry.getValue();
            String defaultVal = prop.getDefault();
            if (defaultVal != null && !defaultVal.trim().isEmpty()) {
                propertyMap.put(propname, defaultVal);
                continue;
            }
            propertyMap.put(propname, null);
        }
    }

    private void checkProperty(Map<String, Object> propertyMap, ConfigurableComponent checker) {
        for (Map.Entry<String, Object> propentry : propertyMap.entrySet()) {
            String propname = propentry.getKey();
            if (checker.containsProperty(propname)) continue;
            propertyMap.remove(propname);
        }
    }

    public Iterator<ConfigurableComponent> getClassGroup(String groupname) {
        if (groupname != null && this._groups.containsKey(groupname.toLowerCase())) {
            return this._groups.get(groupname).iterator();
        }
        return null;
    }

    public void printModel() {
        for (Map.Entry<String, Set<ConfigurableComponent>> entry : this._groups.entrySet()) {
            System.out.println("Group : " + entry.getKey());
            for (ConfigurableComponent groupmember : entry.getValue()) {
                System.out.println('-' + groupmember.getName());
            }
        }
        for (ConfigurableComponent cc : this._classes.values()) {
            System.out.print(cc);
        }
        System.out.println();
        System.out.flush();
    }

    public void refresh() throws ConfigurableUtilException {
        this._classes.clear();
        this._groups.clear();
        this.clear_config();
        try {
            this.read_config_prop();
        }
        catch (ConfigurableUtilException e) {
            System.err.println("Error:Configuration file not loaded successfully\nError:Features that require access to source code will not be available");
        }
        this.read_classpath();
        this.scan(FOLDER_PROP, PACKAGE_PROP);
    }

    private void clear_config() {
        _classes_path = null;
        _source_path = null;
    }

    private void read_classpath() {
        Properties props = System.getProperties();
        if (_classes_path == null) {
            _classes_path = props.getProperty("java.class.path");
        }
    }

    private void read_config_prop() throws ConfigurableUtilException {
        try {
            InputStream in = this.getClass().getResourceAsStream(CONFIG_PATH);
            Properties configuration = new Properties();
            configuration.load(in);
            in.close();
            _source_path = (String)configuration.get(SOURCE_PROP);
            System.out.println("source path: " + _source_path);
            _classes_path = (String)configuration.get(CLASSES_PROP);
        }
        catch (FileNotFoundException fe) {
            throw new ConfigurableUtilException("Configuration file /edu/cmu/sphinx/tools/gui/util.conf not found", 3);
        }
        catch (IOException ie) {
            throw new ConfigurableUtilException("Configuration File I/O Error", 3);
        }
        catch (NullPointerException e) {
            throw new ConfigurableUtilException("Configuration File Load Error", 3);
        }
    }

    private void scan(String startDir, String startPackage) throws ConfigurableUtilException {
        try {
            List<String> myFolders = ClassFinder.findFolder(startDir);
            for (String tempName : myFolders) {
                HashSet<ConfigurableComponent> thisgroup = new HashSet<ConfigurableComponent>();
                HashSet myClasses = new HashSet();
                ClassFinder.findClasses(startDir + '/' + tempName, startPackage + '.' + tempName, myClasses);
                for (Class clazz : myClasses) {
                    try {
                        ConfigurableComponent tempcc = this.createcomponent(clazz, startPackage + '.' + tempName);
                        this._classes.put(tempcc.getName(), tempcc);
                        thisgroup.add(tempcc);
                    }
                    catch (IllegalAccessException e) {
                        throw new ConfigurableUtilException("IllegalAccessException while creating configurable component", 2);
                    }
                }
                this._groups.put(startPackage + '.' + tempName, thisgroup);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurableUtilException("class not found " + e.getMessage(), 2);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurableUtilException("file not found " + e.getMessage(), 2);
        }
    }

    private ConfigurableComponent createcomponent(Class<?> c, String group) throws ConfigurableUtilException, IllegalAccessException {
        Field[] publicFields;
        ConfigurableComponent cc = new ConfigurableComponent(group, c, c.getName(), "");
        System.out.println("***** create ConfigurableComponent " + c.getName() + " for " + group);
        for (Field field : publicFields = c.getFields()) {
            int m = field.getModifiers();
            String fieldname = field.getName();
            if (!Modifier.isPublic(m) || !Modifier.isStatic(m) || !Modifier.isFinal(m) || !fieldname.startsWith("PROP_")) continue;
            ConfigurableProperty cp = this.createProperty(c, field);
            cc.addProperty(cp);
        }
        return cc;
    }

    private ConfigurableProperty createProperty(Class<?> c, Field field) throws ConfigurableUtilException {
        ConfigurableProperty cp;
        try {
            cp = CreatePropertyHelper.createProperty(field, c);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurableUtilException("IllegalAccessException while creating configurable property", 2);
        }
        return cp;
    }

    private static class CreatePropertyHelper {
        private static Class<?> _class;
        private static String _fieldname;
        private static Field _field;
        private static PropertyType _type;
        private static String _defval;
        private static String _classtype;

        private CreatePropertyHelper() {
        }

        private static void processAnnotation() throws IllegalAccessException {
            Annotation[] annotations;
            for (Annotation annotation : annotations = _field.getAnnotations()) {
                Annotation[] superAnnotations;
                for (Annotation superAnnotation : superAnnotations = annotation.annotationType().getAnnotations()) {
                    if (!(superAnnotation instanceof S4Property)) continue;
                    System.out.println("*** s4 property member");
                    System.out.println(_field.getName() + " : *** " + annotation.annotationType().getName());
                    if (annotation instanceof S4Double) {
                        _type = PropertyType.DOUBLE;
                        _defval = Double.toString(((S4Double)annotation).defaultValue());
                        continue;
                    }
                    if (annotation instanceof S4Integer) {
                        _type = PropertyType.INT;
                        _defval = Integer.toString(((S4Integer)annotation).defaultValue());
                        continue;
                    }
                    if (annotation instanceof S4Component) {
                        _type = PropertyType.COMPONENT;
                        _classtype = ((S4Component)annotation).type().getName();
                        continue;
                    }
                    if (annotation instanceof S4String) {
                        _type = PropertyType.STRING;
                        _defval = ((S4String)annotation).defaultValue();
                        continue;
                    }
                    if (annotation instanceof S4Boolean) {
                        _type = PropertyType.BOOLEAN;
                        _defval = String.valueOf(((S4Boolean)annotation).defaultValue());
                        continue;
                    }
                    if (!(annotation instanceof S4ComponentList)) continue;
                    _type = PropertyType.COMPONENT_LIST;
                    _classtype = ((S4ComponentList)annotation).type().getName();
                }
            }
        }

        private static ConfigurableProperty createProperty(Field f, Class<?> c) throws IllegalAccessException {
            _class = c;
            _field = f;
            _fieldname = f.getName();
            _type = null;
            _defval = null;
            _classtype = null;
            String propname = (String)_field.get(null);
            String field_comment = JavadocExtractor.getJavadocComment(_class.getName(), _classes_path, _source_path, _fieldname);
            if (field_comment == null) {
                field_comment = "";
            }
            System.out.println(" Comment *** : " + field_comment);
            CreatePropertyHelper.processAnnotation();
            if (_defval == null) {
                _defval = "";
            }
            ConfigurableProperty cp = _type == PropertyType.COMPONENT || _type == PropertyType.COMPONENT_LIST ? new ConfigurableProperty(propname, _defval, _type, field_comment, _fieldname, _classtype) : new ConfigurableProperty(propname, _defval, _type, field_comment, _fieldname);
            return cp;
        }
    }

    private static class ModelBuilderHolder {
        private static final ModelBuilder instance = new ModelBuilder();

        private ModelBuilderHolder() {
        }
    }
}

