/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.gui.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassFinder {
    private static final String COMMON_SPHINX_PACKAGE = "edu";
    private static final Logger logger = Logger.getLogger("ClassFinder");

    public static BufferedReader findFile(String filename) throws ClassNotFoundException, FileNotFoundException {
        File file = ClassFinder.getStartingDir(filename);
        BufferedReader br = new BufferedReader(new FileReader(file));
        return br;
    }

    public static List<String> findFolder(String startDir) throws ClassNotFoundException, FileNotFoundException {
        File[] myFilesDirs;
        ArrayList<String> folderList = new ArrayList<String>();
        File tempDir = ClassFinder.getStartingDir(startDir);
        ClassFinder.validateDirectory(tempDir);
        for (File file : myFilesDirs = tempDir.listFiles()) {
            if (!file.isDirectory()) continue;
            folderList.add(file.getName());
        }
        return folderList;
    }

    public static void findClasses(String startDir, String startPackage, Set<Class<?>> classList) throws ClassNotFoundException, FileNotFoundException {
        File tempDir = ClassFinder.getStartingDir(startDir);
        ClassFinder.validateDirectory(tempDir);
        File[] myFilesDirs = tempDir.listFiles();
        String tempFile = null;
        for (File file : myFilesDirs) {
            tempFile = file.getName();
            if (file.isDirectory()) {
                ClassFinder.findClasses(startDir + '/' + tempFile, startPackage + '.' + tempFile, classList);
                continue;
            }
            if (!tempFile.endsWith(".class")) continue;
            logger.log(Level.FINE, "Checking class" + tempFile);
            ClassFinder.validateFile(file);
            try {
                String classname = startPackage + '.' + tempFile.substring(0, tempFile.length() - 6);
                Class<?> addclass = Class.forName(classname);
                if (!ClassFinder.filterClass(addclass) || addclass.isInterface() || Modifier.isAbstract(addclass.getModifiers())) continue;
                classList.add(addclass);
                logger.log(Level.FINE, "Adding class" + tempFile);
            }
            catch (NoClassDefFoundError e) {
                System.err.flush();
                System.err.println("error loading " + tempFile + " in " + startPackage);
                System.err.flush();
            }
        }
    }

    private static boolean filterClass(Class<?> c) {
        Class<?>[] theInterfaces;
        for (Class<?> cls : theInterfaces = c.getInterfaces()) {
            String interfaceName = cls.getName();
            logger.log(Level.FINE, "The class " + c.getName() + " has interface " + interfaceName);
            if (interfaceName.equalsIgnoreCase("edu.cmu.sphinx.util.props.Configurable")) {
                return true;
            }
            if (!interfaceName.startsWith(COMMON_SPHINX_PACKAGE) || !ClassFinder.filterClass(cls)) continue;
            return true;
        }
        Class<?> superclass = c.getSuperclass();
        return superclass != null && superclass.getName().startsWith(COMMON_SPHINX_PACKAGE) && ClassFinder.filterClass(superclass);
    }

    private static File getStartingDir(String name) throws ClassNotFoundException {
        File file = null;
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource(name.replace('.', '/'));
            file = new File(url.getFile());
        }
        catch (NullPointerException x) {
            throw new ClassNotFoundException(name + " cannot be found; " + "it does not appear to be a valid file/directory");
        }
        if (file.exists()) {
            return file;
        }
        throw new ClassNotFoundException(name + " does not appear to be a valid file/dir");
    }

    private static void validateDirectory(File aDirectory) throws FileNotFoundException {
        if (aDirectory == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!aDirectory.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + aDirectory);
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + aDirectory);
        }
        if (!aDirectory.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + aDirectory);
        }
    }

    private static void validateFile(File aFile) throws FileNotFoundException {
        if (aFile == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!aFile.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + aFile);
        }
        if (!aFile.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + aFile);
        }
    }
}

