/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.gui;

import edu.cmu.sphinx.tools.gui.ConfigProperties;
import edu.cmu.sphinx.tools.gui.GUIFileActionListener;
import edu.cmu.sphinx.tools.gui.GUIMediator;
import edu.cmu.sphinx.tools.gui.GUIOperationException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;

class PanelGlobal
extends JPanel
implements GUIFileActionListener {
    private final String _title;
    private final GUIMediator _gm;
    private static final int MODE_OK = 10;
    private static final int MODE_SKIP = 20;
    private static final int MODE_ERROR = 30;
    private JButton ButtonAdd;
    private JButton ButtonDelete;
    private JLabel LabelTitle;
    private JTable TableParameter;
    private JTextField TextFieldPropName;
    private JTextField TextFieldPropVal;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;

    PanelGlobal(String title, GUIMediator gm) {
        this._title = title;
        this.initComponents();
        this._gm = gm;
        this._gm.registerPanel(this);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.TextFieldPropVal = new JTextField();
        this.TextFieldPropName = new JTextField();
        this.LabelTitle = new JLabel();
        this.jLabel4 = new JLabel();
        this.jPanel2 = new JPanel();
        this.ButtonAdd = new JButton();
        this.ButtonDelete = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.TableParameter = new JTable();
        this.setLayout(new BorderLayout(10, 20));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setFocusable(false);
        this.jLabel2.setText("Property Value");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel1.setText("Property Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.TextFieldPropVal.setMinimumSize(new Dimension(100, 19));
        this.TextFieldPropVal.setPreferredSize(new Dimension(100, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.TextFieldPropVal, gridBagConstraints);
        this.TextFieldPropName.setMinimumSize(new Dimension(100, 19));
        this.TextFieldPropName.setPreferredSize(new Dimension(100, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.TextFieldPropName, gridBagConstraints);
        this.LabelTitle.setBackground(new Color(153, 153, 153));
        this.LabelTitle.setText(this._title);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jPanel1.add((Component)this.LabelTitle, gridBagConstraints);
        this.jLabel4.setText("                                             ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 2;
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.add((Component)this.jPanel1, "North");
        this.jPanel2.setFocusable(false);
        this.ButtonAdd.setText("Add");
        this.ButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelGlobal.this.ButtonAddActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.ButtonAdd);
        this.ButtonDelete.setText("Delete");
        this.ButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelGlobal.this.ButtonDeleteActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.ButtonDelete);
        this.add((Component)this.jPanel2, "South");
        this.TableParameter.setModel(new DefaultTableModel(new Object[0][], new String[]{"Property Name", "Property Value"}){
            final Class<?>[] types;
            final boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.TableParameter);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void ButtonDeleteActionPerformed(ActionEvent evt) {
        ListSelectionModel mySelectionModel = this.TableParameter.getSelectionModel();
        DefaultTableModel myModel = (DefaultTableModel)this.TableParameter.getModel();
        int myIndex = mySelectionModel.getMinSelectionIndex();
        if (myIndex == -1 || myIndex == myModel.getRowCount()) {
            this.displayError("The are nothing to be deleted");
        } else if (myModel.getRowCount() == 0) {
            this.displayError("There are no data in the table");
        } else if (myModel != null) {
            this.removeTableData(myIndex, myModel);
        }
    }

    private void ButtonAddActionPerformed(ActionEvent evt) {
        String propName = this.TextFieldPropName.getText();
        String propVal = this.TextFieldPropVal.getText();
        if (propName == null || propName.trim().isEmpty() || propVal == null || propVal.trim().isEmpty()) {
            this.displayError("Please complete the property name and value first");
        } else {
            this.addTableData(propName, propVal);
        }
    }

    private void removeTableData(int index, DefaultTableModel model) {
        model.removeRow(index);
        this.TableParameter.revalidate();
    }

    private void addTableData(String propName, String propVal) {
        DefaultTableModel model = (DefaultTableModel)this.TableParameter.getModel();
        Vector<String> myData = new Vector<String>(2);
        myData.add(propName);
        myData.add(propVal);
        model.insertRow(model.getRowCount(), myData);
        this.TableParameter.revalidate();
    }

    @Override
    public void clearAll() {
        DefaultTableModel model = (DefaultTableModel)this.TableParameter.getModel();
        int numRows = model.getRowCount();
        for (int i = numRows - 1; i >= 0; --i) {
            this.removeTableData(i, model);
        }
    }

    @Override
    public void update(ConfigProperties cp) {
        Map<String, String> myglobal = cp.getGlobal();
        this.clearAll();
        for (Map.Entry<String, String> entry : myglobal.entrySet()) {
            this.addTableData(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void saveData(ConfigProperties cp) throws GUIOperationException {
        Map<String, String> globalMap = cp.getGlobal() == null ? new HashMap<String, String>() : cp.getGlobal();
        this.iterateTable(globalMap);
        cp.setGlobal(globalMap);
    }

    @Override
    public void modelRefresh() {
    }

    private void iterateTable(Map<String, String> globalMap) throws GUIOperationException {
        DefaultTableModel model = (DefaultTableModel)this.TableParameter.getModel();
        int numRows = model.getRowCount();
        block4: for (int i = 0; i < numRows; ++i) {
            String propName = ((String)this.TableParameter.getValueAt(i, 0)).trim();
            String propVal = ((String)this.TableParameter.getValueAt(i, 1)).trim();
            System.out.print("validating " + propName + " and " + propVal);
            int retval = this.validateProp(propName, propVal);
            switch (retval) {
                case 10: {
                    globalMap.put(propName, propVal);
                    continue block4;
                }
                case 30: {
                    this.displayError("File Save error : Global property row " + (i + 1) + " is invalid ");
                    throw new GUIOperationException(1, "Data from Global property table is invalid");
                }
            }
        }
    }

    private int validateProp(String propName, String propVal) {
        if (propName == null || propName.trim().isEmpty()) {
            if (propVal == null || propVal.trim().isEmpty()) {
                return 20;
            }
            return 30;
        }
        if (propName.trim().indexOf(32) == -1) {
            if (propVal != null && propVal.trim().indexOf(32) == -1) {
                return 10;
            }
            return 30;
        }
        return 30;
    }

    private void displayError(String message) {
        JOptionPane.showMessageDialog(this, message, "Global Property", 0);
    }
}

