/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sphinx.tools.audio;

import edu.cmu.sphinx.tools.audio.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AudioData {
    protected AudioFormat format;
    protected short[] shorts;
    protected final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    protected int selectionStart = -1;
    protected int selectionEnd = -1;

    public AudioData() {
        this.format = new AudioFormat(16000.0f, 16, 1, true, true);
        this.shorts = new short[0];
    }

    public AudioData(short[] data, float sampleRate) {
        this.shorts = data;
        this.format = new AudioFormat(sampleRate, 16, 1, true, true);
    }

    public AudioData(AudioInputStream ais) throws IOException {
        this.shorts = Utils.toSignedPCM(ais);
        this.format = new AudioFormat(ais.getFormat().getSampleRate(), 16, 1, true, true);
    }

    public short[] getAudioData() {
        return this.shorts;
    }

    public void setAudioData(short[] data) {
        this.shorts = data;
        this.fireStateChanged();
    }

    public AudioFormat getAudioFormat() {
        return this.format;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }
}

