/*
 * Decompiled with CFR 0.152.
 */
package com.oculusvr.capi;

import com.oculusvr.capi.EyeRenderDesc;
import com.oculusvr.capi.FovPort;
import com.oculusvr.capi.FrameTiming;
import com.oculusvr.capi.Hmd;
import com.oculusvr.capi.HmdDesc;
import com.oculusvr.capi.OvrMatrix4f;
import com.oculusvr.capi.OvrSizei;
import com.oculusvr.capi.TrackingState;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.nio.FloatBuffer;

public interface OvrLibrary
extends Library {
    public static final String OVR_KEY_USER = "User";
    public static final String OVR_KEY_NAME = "Name";
    public static final String OVR_KEY_GENDER = "Gender";
    public static final String OVR_KEY_PLAYER_HEIGHT = "PlayerHeight";
    public static final String OVR_KEY_EYE_HEIGHT = "EyeHeight";
    public static final String OVR_KEY_IPD = "IPD";
    public static final String OVR_KEY_NECK_TO_EYE_DISTANCE = "NeckEyeDistance";
    public static final String OVR_KEY_EYE_RELIEF_DIAL = "EyeReliefDial";
    public static final String OVR_KEY_EYE_TO_NOSE_DISTANCE = "EyeToNoseDist";
    public static final String OVR_KEY_MAX_EYE_TO_PLATE_DISTANCE = "MaxEyeToPlateDist";
    public static final String OVR_KEY_EYE_CUP = "EyeCup";
    public static final String OVR_KEY_CUSTOM_EYE_RENDER = "CustomEyeRender";
    public static final String OVR_KEY_CAMERA_POSITION_1 = "CenteredFromWorld";
    public static final String OVR_KEY_CAMERA_POSITION_2 = "CenteredFromWorld2";
    public static final String OVR_KEY_CAMERA_POSITION = "CenteredFromWorld2";
    public static final String OVR_DEFAULT_GENDER = "Unknown";
    public static final float OVR_DEFAULT_NECK_TO_EYE_VERTICAL = 0.075f;
    public static final float OVR_DEFAULT_PLAYER_HEIGHT = 1.778f;
    public static final float OVR_DEFAULT_IPD = 0.064f;
    public static final float OVR_DEFAULT_NECK_TO_EYE_HORIZONTAL = 0.0805f;
    public static final float OVR_DEFAULT_EYE_HEIGHT = 1.675f;
    public static final int OVR_DEFAULT_EYE_RELIEF_DIAL = 3;
    public static final String OVR_PERF_HUD_MODE = "PerfHudMode";
    public static final String OVR_DEBUG_HUD_STEREO_MODE = "DebugHudStereoMode";
    public static final String OVR_DEBUG_HUD_STEREO_GUIDE_SIZE = "DebugHudStereoGuideSize2f";
    public static final String OVR_DEBUG_HUD_STEREO_GUIDE_POSITION = "DebugHudStereoGuidePosition3f";
    public static final String OVR_DEBUG_HUD_STEREO_GUIDE_YAWPITCHROLL = "DebugHudStereoGuideYawPitchRoll3f";
    public static final String OVR_DEBUG_HUD_STEREO_GUIDE_COLOR = "DebugHudStereoGuideColor4f";
    public static final int PRODUCT_VERSION = 0;
    public static final int MAJOR_VERSION = 7;
    public static final String BIT_DEPTH = System.getProperty("sun.arch.data.model");
    public static final String LIBRARY_NAME = String.format("LibOVRRT%s_%d_%d.dll", BIT_DEPTH, 0, 7);
    public static final NativeLibrary JNA_NATIVE_LIB = NativeLibrary.getInstance((String)LIBRARY_NAME);
    public static final OvrLibrary INSTANCE = (OvrLibrary)Native.loadLibrary((String)LIBRARY_NAME, OvrLibrary.class);

    public int ovr_Initialize(Pointer var1);

    public void ovr_Shutdown();

    public HmdDesc ovr_GetHmdDesc(Hmd var1);

    public int ovr_Create(PointerByReference var1, PointerByReference var2);

    public void ovr_Destroy(Hmd var1);

    public Pointer ovr_GetVersionString();

    public int ovr_GetEnabledCaps(Hmd var1);

    public void ovr_SetEnabledCaps(Hmd var1, int var2);

    public int ovr_ConfigureTracking(Hmd var1, int var2, int var3);

    public void ovr_RecenterPose(Hmd var1);

    public TrackingState ovr_GetTrackingState(Hmd var1, double var2);

    public OvrSizei ovr_GetFovTextureSize(Hmd var1, int var2, FovPort var3, float var4);

    public EyeRenderDesc ovr_GetRenderDesc(Hmd var1, int var2, FovPort var3);

    public FrameTiming ovr_GetFrameTiming(Hmd var1, int var2);

    public double ovr_GetTimeInSeconds();

    public byte ovr_GetBool(Hmd var1, String var2, byte var3);

    public byte ovr_SetBool(Hmd var1, String var2, byte var3);

    public int ovr_GetInt(Hmd var1, String var2, int var3);

    public byte ovr_SetInt(Hmd var1, String var2, int var3);

    public float ovr_GetFloat(Hmd var1, String var2, float var3);

    public byte ovr_SetFloat(Hmd var1, String var2, float var3);

    public int ovr_GetFloatArray(Hmd var1, String var2, FloatBuffer var3, int var4);

    public byte ovr_SetFloatArray(Hmd var1, String var2, FloatBuffer var3, int var4);

    public String ovr_GetString(Hmd var1, String var2, String var3);

    public byte ovr_SetString(Hmd var1, String var2, String var3);

    public OvrMatrix4f ovrMatrix4f_Projection(FovPort var1, float var2, float var3, byte var4);

    public int ovr_CreateSwapTextureSetGL(Hmd var1, int var2, int var3, int var4, PointerByReference var5);

    public void ovr_DestroySwapTextureSet(Hmd var1, Pointer var2);

    public int ovr_CreateMirrorTextureGL(Hmd var1, int var2, int var3, int var4, PointerByReference var5);

    public void ovr_DestroyMirrorTexture(Hmd var1, Pointer var2);

    public int ovr_SubmitFrame(Hmd var1, int var2, Pointer var3, PointerByReference var4, int var5);

    public static interface ovrProjectionModifier {
        public static final int ovrProjection_None = 0;
        public static final int ovrProjection_RightHanded = 1;
        public static final int ovrProjection_FarLessThanNear = 2;
        public static final int ovrProjection_FarClipAtInfinity = 4;
        public static final int ovrProjection_ClipRangeOpenGL = 8;
    }

    public static interface ovrLayerFlags {
        public static final int ovrLayerFlag_HighQuality = 1;
        public static final int ovrLayerFlag_TextureOriginAtBottomLeft = 2;
    }

    public static interface ovrLayerType {
        public static final int ovrLayerType_Disabled = 0;
        public static final int ovrLayerType_EyeFov = 1;
        public static final int ovrLayerType_EyeFovDepth = 2;
        public static final int ovrLayerType_QuadInWorld = 3;
        public static final int ovrLayerType_QuadHeadLocked = 4;
        public static final int ovrLayerType_Direct = 6;
    }

    public static interface ovrRenderAPIType {
        public static final int ovrRenderAPI_None = 0;
        public static final int ovrRenderAPI_OpenGL = 1;
        public static final int ovrRenderAPI_Android_GLES = 2;
        public static final int ovrRenderAPI_D3D11 = 5;
    }

    public static interface ovrStatusBits {
        public static final int ovrStatus_OrientationTracked = 1;
        public static final int ovrStatus_PositionTracked = 2;
        public static final int ovrStatus_CameraPoseTracked = 4;
        public static final int ovrStatus_PositionConnected = 32;
        public static final int ovrStatus_HmdConnected = 128;
    }

    public static interface ovrEyeType {
        public static final int ovrEye_Left = 0;
        public static final int ovrEye_Right = 1;
        public static final int ovrEye_Count = 2;
    }

    public static interface ovrDistortionCaps {
        public static final int ovrDistortionCap_Chromatic = 1;
        public static final int ovrDistortionCap_TimeWarp = 2;
        public static final int ovrDistortionCap_Vignette = 8;
        public static final int ovrDistortionCap_NoRestore = 16;
        public static final int ovrDistortionCap_FlipInput = 32;
        public static final int ovrDistortionCap_SRGB = 64;
        public static final int ovrDistortionCap_Overdrive = 128;
        public static final int ovrDistortionCap_HqDistortion = 256;
        public static final int ovrDistortionCap_LinuxDevFullscreen = 512;
        public static final int ovrDistortionCap_ComputeShader = 1024;
        public static final int ovrDistortionCap_ProfileNoTimewarpSpinWaits = 65536;
    }

    public static interface ovrTrackingCaps {
        public static final int ovrTrackingCap_Orientation = 16;
        public static final int ovrTrackingCap_MagYawCorrection = 32;
        public static final int ovrTrackingCap_Position = 64;
        public static final int ovrTrackingCap_Idle = 256;
    }

    public static interface ovrHmdCaps {
        public static final int ovrHmdCap_DebugDevice = 1;
        public static final int ovrHmdCap_Writable_Mask = 0;
        public static final int ovrHmdCap_Service_Mask = 0;
    }

    public static interface ovrHmdType {
        public static final int ovrHmd_None = 0;
        public static final int ovrHmd_DK1 = 3;
        public static final int ovrHmd_DKHD = 4;
        public static final int ovrHmd_DK2 = 6;
        public static final int ovrHmd_CB = 8;
        public static final int ovrHmd_Other = 9;
        public static final int ovrHmd_E3_2015 = 10;
        public static final int ovrHmd_ES06 = 11;
    }

    public static interface ovrErrorType {
        public static final int ovrError_MemoryAllocationFailure = -1000;
        public static final int ovrError_SocketCreationFailure = -1001;
        public static final int ovrError_InvalidHmd = -1002;
        public static final int ovrError_Timeout = -1003;
        public static final int ovrError_NotInitialized = -1004;
        public static final int ovrError_InvalidParameter = -1005;
        public static final int ovrError_ServiceError = -1006;
        public static final int ovrError_NoHmd = -1007;
        public static final int ovrError_AudioReservedBegin = -2000;
        public static final int ovrError_AudioReservedEnd = -2999;
        public static final int ovrError_Initialize = -3000;
        public static final int ovrError_LibLoad = -3001;
        public static final int ovrError_LibVersion = -3002;
        public static final int ovrError_ServiceConnection = -3003;
        public static final int ovrError_ServiceVersion = -3004;
        public static final int ovrError_IncompatibleOS = -3005;
        public static final int ovrError_DisplayInit = -3006;
        public static final int ovrError_ServerStart = -3007;
        public static final int ovrError_Reinitialization = -3008;
        public static final int ovrError_MismatchedAdapters = -3009;
        public static final int ovrError_LeakingResources = -3010;
        public static final int ovrError_ClientVersion = -3011;
        public static final int ovrError_InvalidBundleAdjustment = -4000;
        public static final int ovrError_USBBandwidth = -4001;
        public static final int ovrError_USBEnumeratedSpeed = -4002;
        public static final int ovrError_ImageSensorCommError = -4003;
        public static final int ovrError_GeneralTrackerFailure = -4004;
        public static final int ovrError_ExcessiveFrameTruncation = -4005;
        public static final int ovrError_ExcessiveFrameSkipping = -4006;
        public static final int ovrError_SyncDisconnected = -4007;
        public static final int ovrError_TrackerMemoryReadFailure = -4008;
        public static final int ovrError_TrackerMemoryWriteFailure = -4009;
        public static final int ovrError_TrackerFrameTimeout = -4010;
        public static final int ovrError_TrackerTruncatedFrame = -4011;
        public static final int ovrError_HMDFirmwareMismatch = -4100;
        public static final int ovrError_TrackerFirmwareMismatch = -4101;
        public static final int ovrError_BootloaderDeviceDetected = -4102;
        public static final int ovrError_TrackerCalibrationError = -4103;
        public static final int ovrError_Incomplete = -5000;
        public static final int ovrError_Abandoned = -5001;
        public static final int ovrError_DisplayLost = -6000;
    }

    public static interface ovrSuccessType {
        public static final int ovrSuccess = 0;
        public static final int ovrSuccess_NotVisible = 1000;
        public static final int ovrSuccess_HMDFirmwareMismatch = 4100;
        public static final int ovrSuccess_TrackerFirmwareMismatch = 4101;
    }
}

