/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.gl.shaders;

import org.lwjgl.opengl.GL20;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shader {
    private static final Logger LOG = LoggerFactory.getLogger(Shader.class);
    private final String source;
    private final int type;
    int shader = -1;

    public Shader(int type, String source) {
        this.source = source;
        this.type = type;
    }

    public void attach(int program) {
        GL20.glAttachShader((int)program, (int)this.shader);
    }

    public void compile() {
        try {
            int newShader = Shader.compile(this.source, this.type);
            if (-1 != this.shader) {
                GL20.glDeleteShader((int)this.shader);
            }
            this.shader = newShader;
        }
        catch (Exception e) {
            if (this.shader != -1) {
                GL20.glDeleteShader((int)this.shader);
                this.shader = -1;
            }
            throw e;
        }
    }

    public String getLog() {
        return Shader.getLog(this.shader);
    }

    public static String getLog(int shader) {
        return GL20.glGetShaderInfoLog((int)shader, (int)8192);
    }

    public static int compile(String source, int type) {
        int newShader = GL20.glCreateShader((int)type);
        GL20.glShaderSource((int)newShader, (CharSequence)source);
        GL20.glCompileShader((int)newShader);
        int compileResult = GL20.glGetShaderi((int)newShader, (int)35713);
        if (1 != compileResult) {
            String log = Shader.getLog(newShader);
            LOG.warn("shader compile failed :" + log);
            GL20.glDeleteShader((int)newShader);
            throw new IllegalStateException("Shader compile error" + log);
        }
        return newShader;
    }
}

