/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.gl.shaders;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opengl.GL20;
import org.saintandreas.gl.BufferUtils;
import org.saintandreas.gl.OpenGL;
import org.saintandreas.gl.shaders.Shader;
import org.saintandreas.math.Matrix4f;
import org.saintandreas.math.Vector3f;
import org.saintandreas.math.Vector4f;
import org.saintandreas.resources.Resource;
import org.saintandreas.resources.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Program {
    private static final Logger LOG = LoggerFactory.getLogger(Program.class);
    private final int VERTEX_SHADER = 0;
    private final int GEOMETRY_SHADER = 1;
    private final int FRAGMENT_SHADER = 2;
    public final Map<String, Integer> uniforms = new HashMap<String, Integer>();
    public final Map<String, Integer> attributes = new HashMap<String, Integer>();
    private static Program CURRENT_PROGRAM = null;
    private Shader[] shaders = new Shader[3];
    public int program = -1;

    public Program(Resource vs, Resource fs) {
        this(ResourceManager.getProvider().getAsString(vs), ResourceManager.getProvider().getAsString(fs));
    }

    public Program(String vssf, String fssf) {
        this(new Shader(35633, vssf), null, new Shader(35632, fssf));
    }

    public Program(Shader vs, Shader fs) {
        this(vs, null, fs);
    }

    public Program(Shader vs, Shader gs, Shader fs) {
        this.shaders[0] = vs;
        this.shaders[1] = gs;
        this.shaders[2] = fs;
    }

    public void destroy() {
        if (this.program != -1) {
            GL20.glDeleteProgram((int)this.program);
            this.program = -1;
        }
    }

    public void link() {
        int location;
        String name;
        int i;
        for (Shader s : this.shaders) {
            if (null == s || s.shader != -1) continue;
            s.compile();
        }
        int newProgram = Program.linkProgram(this.shaders);
        if (this.program != -1) {
            GL20.glDeleteProgram((int)this.program);
            this.program = -1;
        }
        this.uniforms.clear();
        this.attributes.clear();
        this.program = newProgram;
        if (this.program == -1) {
            throw new IllegalStateException("Link failure");
        }
        int count = GL20.glGetProgrami((int)this.program, (int)35718);
        for (i = 0; i < count; ++i) {
            name = GL20.glGetActiveUniform((int)this.program, (int)i, (int)256);
            location = GL20.glGetUniformLocation((int)this.program, (CharSequence)name);
            this.uniforms.put(name, location);
        }
        count = GL20.glGetProgrami((int)this.program, (int)35721);
        for (i = 0; i < count; ++i) {
            name = GL20.glGetActiveAttrib((int)this.program, (int)i, (int)256);
            location = GL20.glGetAttribLocation((int)this.program, (CharSequence)name);
            this.attributes.put(name, location);
        }
    }

    public String getLog() {
        return Program.getLog(this.program);
    }

    public void use() {
        if (this.program == -1) {
            throw new IllegalStateException("Program is not linked");
        }
        CURRENT_PROGRAM = this;
        GL20.glUseProgram((int)this.program);
        OpenGL.checkError();
    }

    public static void clear() {
        GL20.glUseProgram((int)0);
        CURRENT_PROGRAM = null;
    }

    protected int getUniformLocation(String string) {
        if (!this.uniforms.containsKey(string)) {
            return -1;
        }
        return this.uniforms.get(string);
    }

    private void checkCurrent() {
        if (this != CURRENT_PROGRAM) {
            throw new IllegalStateException("Attempting to set uniform on unbound program");
        }
    }

    public void setUniform(String string, int value) {
        this.checkCurrent();
        int location = this.getUniformLocation(string);
        GL20.glUniform1i((int)location, (int)value);
    }

    public void setUniform(String string, float value) {
        this.checkCurrent();
        int location = this.getUniformLocation(string);
        GL20.glUniform1f((int)location, (float)value);
    }

    public void setUniform(String string, Vector4f value) {
        this.checkCurrent();
        int location = this.getUniformLocation(string);
        GL20.glUniform4f((int)location, (float)value.x, (float)value.y, (float)value.z, (float)value.w);
    }

    public void setUniform(String string, Vector3f value) {
        this.checkCurrent();
        int location = this.getUniformLocation(string);
        GL20.glUniform3f((int)location, (float)value.x, (float)value.y, (float)value.z);
    }

    public void setUniformMatrix4(String name, FloatBuffer fb) {
        this.checkCurrent();
        int location = this.getUniformLocation(name);
        GL20.glUniformMatrix4((int)location, (boolean)false, (FloatBuffer)fb);
    }

    public void setUniformMatrix4(String name, float[] v) {
        FloatBuffer fb = ByteBuffer.allocateDirect(v.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        fb.put(v);
        fb.position(0);
        this.setUniformMatrix4(name, fb);
    }

    public void setUniform(String name, Matrix4f m) {
        FloatBuffer fb = BufferUtils.getFloatBuffer(16);
        m.fillFloatBuffer(fb, true);
        fb.position(0);
        this.setUniformMatrix4(name, fb);
    }

    public static String getLog(int program) {
        return GL20.glGetProgramInfoLog((int)program, (int)8192);
    }

    public static int linkProgram(Shader ... shaders) {
        int newProgram = GL20.glCreateProgram();
        for (Shader s : shaders) {
            if (null == s) continue;
            s.attach(newProgram);
        }
        GL20.glLinkProgram((int)newProgram);
        int linkResult = GL20.glGetProgrami((int)newProgram, (int)35714);
        if (1 != linkResult) {
            String log = Program.getLog(newProgram);
            LOG.warn("Link failed: " + log);
            GL20.glDeleteProgram((int)newProgram);
            throw new RuntimeException(log);
        }
        return newProgram;
    }

    static enum ShaderType {
        VERTEX,
        GEOMETRY,
        FRAGMENT;

    }
}

