/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.gl.buffers;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengl.GL15;

public class BaseBuffer {
    int buffer = -1;
    final int target;

    public BaseBuffer(int buffer, int target) {
        this.target = target;
        this.buffer = buffer;
    }

    public BaseBuffer(int target) {
        this.target = target;
        this.buffer = GL15.glGenBuffers();
    }

    public void bind() {
        GL15.glBindBuffer((int)this.target, (int)this.buffer);
    }

    public static void unbind(int target) {
        GL15.glBindBuffer((int)target, (int)0);
    }

    public void setData(ByteBuffer data) {
        this.setData(data, 35044);
    }

    public void setData(FloatBuffer data) {
        this.setData(data, 35044);
    }

    public void setData(IntBuffer data) {
        this.setData(data, 35044);
    }

    public void setData(ShortBuffer data) {
        this.setData(data, 35044);
    }

    public void setData(ByteBuffer data, int usage) {
        GL15.glBufferData((int)this.target, (ByteBuffer)data, (int)usage);
    }

    public void setData(FloatBuffer data, int usage) {
        GL15.glBufferData((int)this.target, (FloatBuffer)data, (int)usage);
    }

    public void setData(IntBuffer data, int usage) {
        GL15.glBufferData((int)this.target, (IntBuffer)data, (int)usage);
    }

    public void setData(ShortBuffer data, int usage) {
        GL15.glBufferData((int)this.target, (ShortBuffer)data, (int)usage);
    }

    public void destroy() {
        GL15.glDeleteBuffers((int)this.buffer);
        this.buffer = -1;
    }
}

