/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.gl.app;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.PixelFormat;

public abstract class LwjglApp
implements Runnable {
    private GLContext glContext = new GLContext();
    protected int width;
    protected int height;
    protected float aspect = 1.0f;
    protected ContextAttribs contextAttributes = new ContextAttribs();
    protected PixelFormat pixelFormat = new PixelFormat();

    protected abstract void setupDisplay();

    protected abstract void drawFrame();

    protected void setupContext() {
    }

    protected void setupDisplay(Rectangle r) {
        this.setupDisplay(r.x, r.y, r.width, r.height);
    }

    protected void setupDisplay(int left, int top, int width, int height) {
        try {
            Display.setDisplayMode((DisplayMode)new DisplayMode(width, height));
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
        Display.setLocation((int)left, (int)top);
        Display.setVSyncEnabled((boolean)true);
        this.onResize(width, height);
    }

    protected void initGl() {
    }

    @Override
    public void run() {
        try {
            this.setupContext();
            this.setupDisplay();
            Display.create((PixelFormat)this.pixelFormat, (ContextAttribs)this.contextAttributes);
            int err = GL11.glGetError();
            GLContext.useContext((Object)this.glContext, (boolean)false);
            Mouse.create();
            Keyboard.create();
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
        this.initGl();
        while (!Display.isCloseRequested()) {
            if (Display.wasResized()) {
                this.onResize(Display.getWidth(), Display.getHeight());
            }
            this.update();
            this.drawFrame();
            this.finishFrame();
        }
        this.onDestroy();
        Display.destroy();
    }

    protected void finishFrame() {
        Display.update();
    }

    protected void onKeyboardEvent() {
        int key = Keyboard.getEventKey();
        switch (key) {
            case 1: {
                System.exit(0);
            }
        }
    }

    protected void onMouseEvent() {
    }

    protected void update() {
        while (Keyboard.next()) {
            this.onKeyboardEvent();
        }
        while (Mouse.next()) {
            this.onMouseEvent();
        }
    }

    protected void onResize(int width, int height) {
        this.width = width;
        this.height = height;
        this.aspect = (float)width / (float)height;
    }

    protected void onDestroy() {
    }

    public static Rectangle findNonPrimaryRect() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            if (gd == ge.getDefaultScreenDevice()) continue;
            return gd.getDefaultConfiguration().getBounds();
        }
        return null;
    }
}

