/*
 * Decompiled with CFR 0.152.
 */
package org.saintandreas.gl;

import org.saintandreas.gl.Transformable;
import org.saintandreas.math.Matrix3f;
import org.saintandreas.math.Matrix4f;
import org.saintandreas.math.Quaternion;
import org.saintandreas.math.Vector2f;
import org.saintandreas.math.Vector3f;

public abstract class AbstractTransformable<T extends AbstractTransformable<T>>
implements Transformable<T> {
    Matrix4f transform = new Matrix4f();

    @Override
    public Matrix4f getTransform() {
        return this.transform;
    }

    public T set(Matrix4f m) {
        this.transform = m;
        return (T)this;
    }

    @Override
    public T identity() {
        return this.set(new Matrix4f());
    }

    @Override
    public T transpose() {
        return this.set(this.getTransform().transpose());
    }

    @Override
    public T translate(float x) {
        return (T)this.translate(new Vector3f(x, 0.0f, 0.0f));
    }

    @Override
    public T translate(Vector2f vec) {
        return this.set(this.getTransform().translate(vec));
    }

    @Override
    public T translate(Vector3f vec) {
        return this.set(this.getTransform().translate(vec));
    }

    @Override
    public T rotate(float angle, Vector3f axis) {
        return this.set(this.getTransform().rotate(angle, axis));
    }

    @Override
    public T rotate(Quaternion q) {
        return this.set(this.getTransform().rotate(q));
    }

    @Override
    public T rotate(Matrix3f m) {
        return this.set(this.getTransform().rotate(m));
    }

    @Override
    public T scale(Vector3f vec) {
        return this.set(this.getTransform().scale(vec));
    }

    @Override
    public T scale(float f) {
        return this.set(this.getTransform().scale(f));
    }

    @Override
    public T multiply(Matrix4f m) {
        return this.set(this.getTransform().mult(m));
    }

    @Override
    public T preMultiply(Matrix4f m) {
        return this.set(m.mult(this.getTransform()));
    }

    @Override
    public T preTranslate(float x) {
        return (T)this.preTranslate(new Vector2f(x, 0.0f));
    }

    @Override
    public T preTranslate(Vector2f v) {
        return (T)this.preMultiply(new Matrix4f().translate(v));
    }

    @Override
    public T preTranslate(Vector3f v) {
        return (T)this.preMultiply(new Matrix4f().translate(v));
    }

    @Override
    public T preRotate(float angle, Vector3f axis) {
        return (T)this.preMultiply(new Matrix4f().rotate(angle, axis));
    }

    @Override
    public T preRotate(Quaternion q) {
        return (T)this.preMultiply(new Matrix4f().rotate(q));
    }

    @Override
    public T preRotate(Matrix3f m) {
        return (T)this.preMultiply(new Matrix4f().rotate(m));
    }

    @Override
    public T lookat(Vector3f eye, Vector3f center, Vector3f up) {
        return this.set(Matrix4f.lookat((Vector3f)eye, (Vector3f)center, (Vector3f)up));
    }

    @Override
    public T orthographic(float left, float right, float bottom, float top, float near, float far) {
        return this.set(Matrix4f.orthographic((float)left, (float)right, (float)bottom, (float)top, (float)near, (float)far));
    }

    @Override
    public T perspective(float fovy, float aspect, float zNear, float zFar) {
        return this.set(Matrix4f.perspective((float)fovy, (float)aspect, (float)zNear, (float)zFar));
    }

    public Vector3f getTranslation() {
        return this.getTransform().toTranslationVector();
    }

    public Quaternion getRotation() {
        return this.getTransform().toRotationQuat();
    }

    public T untranslate() {
        return (T)this.translate((Vector3f)this.getTranslation().scale(-1.0f));
    }

    public T unrotate() {
        return this.set(new Matrix4f().translate(this.getTranslation()));
    }
}

