/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.alpha.net.apache;

import com.wolfram.alpha.net.HttpProvider;
import com.wolfram.alpha.net.ProxySettings;
import com.wolfram.alpha.net.apache.ApacheHttpTransaction;
import com.wolfram.alpha.net.impl.HttpTransaction;
import java.net.URL;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class ApacheHttpProvider
implements HttpProvider {
    private static HttpClient httpClient;
    private static HttpParams params;
    private int socketTimeoutMillis = 20000;
    private static final String DEFAULT_USER_AGENT = "Wolfram|Alpha Java Binding 1.1";
    private static final int CONNECTION_TIMEOUT_MILLIS = 8000;
    private static final int SOCKET_TIMEOUT_MILLIS = 20000;
    private static final int MAX_CONNECTIONS_PER_ROUTE = 8;
    private static final int MAX_RETRY_COUNT = 1;
    private static ProxySettings proxySettings;

    public void setUserAgent(String agent) {
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)agent);
    }

    public HttpTransaction createHttpTransaction(URL url, ProxySettings proxySettings) {
        return new ApacheHttpTransaction(httpClient, url, proxySettings, 1, this.socketTimeoutMillis);
    }

    public HttpClient getHttpClient() {
        return httpClient;
    }

    public void setProxyInfo(int useProxy, String httpProxyHost, int httpProxyPort, String socksProxyHost, int socksProxyPort) {
        proxySettings.setProxyInfo(useProxy, httpProxyHost, httpProxyPort);
    }

    public void setProxyCredentials(String username, String password) {
        proxySettings.setProxyUsername(username);
        proxySettings.setProxyPassword(password);
    }

    public String[] getProxyHostAndPort(String url) {
        return proxySettings.getProxyHostAndPort(url);
    }

    static {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        params = new BasicHttpParams();
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRoute(){

            public int getMaxForRoute(HttpRoute route) {
                return 8;
            }
        });
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)DEFAULT_USER_AGENT);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)8000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)20000);
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager(params, schemeRegistry);
        httpClient = new DefaultHttpClient((ClientConnectionManager)cm, params);
    }
}

