/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.alpha.net;

import com.wolfram.alpha.WAException;
import com.wolfram.alpha.net.HttpProvider;
import com.wolfram.alpha.net.ProxySettings;
import com.wolfram.alpha.net.WAHttpException;
import com.wolfram.alpha.net.impl.HttpTransaction;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Logger;

public class URLFetcher {
    HttpProvider http;
    private URL url;
    private String outFile;
    private ProxySettings proxySettings;
    private volatile HttpTransaction trans;
    private volatile boolean wasCancelled = false;
    private volatile boolean isFinished = false;
    private volatile File downloadedFile = null;
    private volatile byte[] bytes = null;
    private volatile int totalBytes = -1;
    private volatile int totalBytesDownloaded = -1;
    private volatile String charSet = null;
    private volatile Exception exception = null;
    private static Logger logger = Logger.getLogger("com.wolfram.alpha.net.URLFetcher");
    private static final int MAX_BUFFER_SIZE = 1000000;

    public URLFetcher(URL url, String outFile, HttpProvider http, ProxySettings proxySettings) {
        this.url = url;
        this.outFile = outFile;
        this.http = http;
        this.proxySettings = proxySettings;
    }

    public void cancel() {
        this.wasCancelled = true;
        if (this.trans != null) {
            this.trans.setNoRetry();
        }
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public String getFilename() {
        return this.outFile;
    }

    public File getFile() {
        return this.wasCancelled ? null : this.downloadedFile;
    }

    public byte[] getBytes() {
        return this.wasCancelled ? null : this.bytes;
    }

    public int getTotalBytes() {
        return this.totalBytes;
    }

    public int getTotalBytesDownloaded() {
        return this.totalBytesDownloaded;
    }

    public double getProgress() {
        if (this.isFinished()) {
            return 1.0;
        }
        int totalBytes = this.getTotalBytes();
        if (totalBytes == -1) {
            return -1.0;
        }
        return (double)this.getTotalBytesDownloaded() / (double)totalBytes;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public Exception getException() {
        return this.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void fetch() {
        block54: {
            if (!this.wasCancelled) break block54;
            this.isFinished = true;
            return;
        }
        try {
            long start;
            block59: {
                Exception e22222;
                boolean useFile;
                OutputStream outStream;
                InputStream responseStream;
                block55: {
                    int numRead;
                    long maxBytesToDownload;
                    start = System.currentTimeMillis();
                    logger.info("Downloading url " + this.url);
                    responseStream = null;
                    outStream = null;
                    useFile = this.outFile != null;
                    this.trans = this.http.createHttpTransaction(this.url, this.proxySettings);
                    this.trans.execute();
                    long contentLength = this.trans.getContentLength();
                    this.charSet = this.trans.getCharSet();
                    responseStream = this.trans.getResponseStream();
                    if (useFile) {
                        if (this.outFile.length() > 0) {
                            this.downloadedFile = new File(this.outFile);
                        } else {
                            this.downloadedFile = File.createTempFile("WolframAlphaAPI", ".tmp", null);
                            this.outFile = this.downloadedFile.getAbsolutePath();
                        }
                        outStream = new FileOutputStream(this.downloadedFile);
                    } else {
                        if (contentLength == -1L || contentLength > 1000000L) {
                            throw new WAException("Content from URL " + this.url + " is unknown or too large to be buffered in memory. Read into a file instead.");
                        }
                        outStream = new ByteArrayOutputStream((int)contentLength);
                    }
                    byte[] buf = new byte[8192];
                    this.totalBytesDownloaded = 0;
                    long l = maxBytesToDownload = useFile ? Long.MAX_VALUE : contentLength;
                    while ((numRead = responseStream.read(buf)) != -1 && !this.wasCancelled) {
                        this.totalBytesDownloaded += numRead;
                        if ((long)this.totalBytesDownloaded > maxBytesToDownload) continue;
                        outStream.write(buf, 0, numRead);
                    }
                    Object var13_12 = null;
                    if (responseStream == null) break block55;
                    try {
                        responseStream.close();
                    }
                    catch (Exception e22222) {
                        // empty catch block
                    }
                }
                if (this.trans != null) {
                    this.trans.release();
                }
                if (outStream != null) {
                    if (!this.wasCancelled && !useFile) {
                        this.bytes = ((ByteArrayOutputStream)outStream).toByteArray();
                    }
                    try {
                        outStream.close();
                    }
                    catch (Exception e22222) {
                        // empty catch block
                    }
                }
                if (this.wasCancelled && this.downloadedFile != null) {
                    this.downloadedFile.delete();
                    this.downloadedFile = null;
                }
                break block59;
                {
                    catch (WAHttpException e3) {
                        Exception e22222;
                        this.exception = e3;
                        Object var13_13 = null;
                        if (responseStream != null) {
                            try {
                                responseStream.close();
                            }
                            catch (Exception e22222) {
                                // empty catch block
                            }
                        }
                        if (this.trans != null) {
                            this.trans.release();
                        }
                        if (outStream != null) {
                            if (!this.wasCancelled && !useFile) {
                                this.bytes = ((ByteArrayOutputStream)outStream).toByteArray();
                            }
                            try {
                                outStream.close();
                            }
                            catch (Exception e22222) {
                                // empty catch block
                            }
                        }
                        if (this.wasCancelled && this.downloadedFile != null) {
                            this.downloadedFile.delete();
                            this.downloadedFile = null;
                        }
                        break block59;
                    }
                    catch (IOException e4) {
                        Exception e22222;
                        this.exception = e4;
                        Object var13_14 = null;
                        if (responseStream != null) {
                            try {
                                responseStream.close();
                            }
                            catch (Exception e22222) {
                                // empty catch block
                            }
                        }
                        if (this.trans != null) {
                            this.trans.release();
                        }
                        if (outStream != null) {
                            if (!this.wasCancelled && !useFile) {
                                this.bytes = ((ByteArrayOutputStream)outStream).toByteArray();
                            }
                            try {
                                outStream.close();
                            }
                            catch (Exception e22222) {
                                // empty catch block
                            }
                        }
                        if (this.wasCancelled && this.downloadedFile != null) {
                            this.downloadedFile.delete();
                            this.downloadedFile = null;
                        }
                        break block59;
                    }
                    catch (Exception e5) {
                        Exception e22222;
                        this.exception = e5;
                        Object var13_15 = null;
                        if (responseStream != null) {
                            try {
                                responseStream.close();
                            }
                            catch (Exception e22222) {
                                // empty catch block
                            }
                        }
                        if (this.trans != null) {
                            this.trans.release();
                        }
                        if (outStream != null) {
                            if (!this.wasCancelled && !useFile) {
                                this.bytes = ((ByteArrayOutputStream)outStream).toByteArray();
                            }
                            try {
                                outStream.close();
                            }
                            catch (Exception e22222) {
                                // empty catch block
                            }
                        }
                        if (this.wasCancelled && this.downloadedFile != null) {
                            this.downloadedFile.delete();
                            this.downloadedFile = null;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Exception e22222;
                    Object var13_16 = null;
                    if (responseStream != null) {
                        try {
                            responseStream.close();
                        }
                        catch (Exception e22222) {
                            // empty catch block
                        }
                    }
                    if (this.trans != null) {
                        this.trans.release();
                    }
                    if (outStream != null) {
                        if (!this.wasCancelled && !useFile) {
                            this.bytes = ((ByteArrayOutputStream)outStream).toByteArray();
                        }
                        try {
                            outStream.close();
                        }
                        catch (Exception e22222) {
                            // empty catch block
                        }
                    }
                    if (this.wasCancelled && this.downloadedFile != null) {
                        this.downloadedFile.delete();
                        this.downloadedFile = null;
                    }
                    throw throwable;
                }
            }
            if (this.exception != null) {
                logger.warning("Exception downloading URL " + this.url + ". " + this.exception);
            }
            if (this.wasCancelled) {
                logger.info("Download of URL " + this.url + " was cancelled by user. Elapsed millis: " + (System.currentTimeMillis() - start));
            } else {
                logger.info("Finished downloading URL " + this.url + ". Elapsed millis: " + (System.currentTimeMillis() - start));
            }
            Object var16_23 = null;
            this.isFinished = true;
        }
        catch (Throwable throwable) {
            Object var16_24 = null;
            this.isFinished = true;
            throw throwable;
        }
    }
}

