/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.alpha.impl;

import com.wolfram.alpha.WAException;
import com.wolfram.alpha.WASubpod;
import com.wolfram.alpha.impl.WAImageImpl;
import com.wolfram.alpha.impl.WAPlainTextImpl;
import com.wolfram.alpha.net.HttpProvider;
import com.wolfram.alpha.visitor.Visitable;
import com.wolfram.alpha.visitor.Visitor;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WASubpodImpl
implements WASubpod,
Visitable,
Serializable {
    private String title;
    private volatile boolean imageAcquired = false;
    private Object userData;
    private transient HttpProvider http;
    private Visitable[] contentElements = EMPTY_VISITABLE_ARRAY;
    static final WASubpodImpl[] EMPTY_ARRAY = new WASubpodImpl[0];
    private static final long serialVersionUID = 7545052461156130238L;

    WASubpodImpl(Element thisElement, HttpProvider http, File tempDir) throws WAException {
        this.http = http;
        this.title = thisElement.getAttribute("title");
        NodeList subElements = thisElement.getChildNodes();
        int numSubElements = subElements.getLength();
        ArrayList<Visitable> contentList = new ArrayList<Visitable>(numSubElements);
        for (int i = 0; i < numSubElements; ++i) {
            Node child = subElements.item(i);
            String name = child.getNodeName();
            if ("plaintext".equals(name)) {
                contentList.add(new WAPlainTextImpl((Element)child));
                continue;
            }
            if (!"img".equals(name)) continue;
            contentList.add(new WAImageImpl((Element)child, http, tempDir));
        }
        this.contentElements = contentList.toArray(new Visitable[contentList.size()]);
    }

    public String getTitle() {
        return this.title;
    }

    public Visitable[] getContents() {
        return this.contentElements;
    }

    public synchronized void setUserData(Object obj) {
        this.userData = obj;
    }

    public synchronized Object getUserData() {
        return this.userData;
    }

    public synchronized int hashCode() {
        int result = 17;
        result = 37 * result + this.title.hashCode();
        for (Visitable obj : this.contentElements) {
            if (!(obj instanceof WAImageImpl)) continue;
            result = 37 * result + obj.hashCode();
            break;
        }
        if (this.userData != null) {
            result = 37 * result + this.userData.hashCode();
        }
        return result;
    }

    public void acquireImage() {
        if (!this.imageAcquired && this.http != null) {
            for (Visitable elem : this.contentElements) {
                if (!(elem instanceof WAImageImpl)) continue;
                WAImageImpl image = (WAImageImpl)elem;
                image.acquireImage();
                break;
            }
            this.imageAcquired = true;
        }
    }

    public void accept(Visitor v) {
        v.visit(this);
    }
}

