/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.alpha.impl;

import com.wolfram.alpha.WAAssumption;
import com.wolfram.alpha.WAException;
import com.wolfram.alpha.visitor.Visitable;
import com.wolfram.alpha.visitor.Visitor;
import java.io.Serializable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WAAssumptionImpl
implements WAAssumption,
Visitable,
Serializable {
    private String type;
    private int count;
    private String word;
    private String description;
    private int current = -1;
    private String[] names;
    private String[] inputs;
    private String[] descriptions;
    private String[] words;
    private boolean[] valids;
    static final WAAssumptionImpl[] EMPTY_ARRAY = new WAAssumptionImpl[0];
    private static final long serialVersionUID = -7699189119552569080L;

    WAAssumptionImpl(Element thisElement) throws WAException {
        this.type = thisElement.getAttribute("type");
        this.word = thisElement.getAttribute("word");
        if (this.word.equals("")) {
            this.word = null;
        }
        this.description = thisElement.getAttribute("desc");
        if (this.description.equals("")) {
            this.description = null;
        }
        try {
            this.count = Integer.parseInt(thisElement.getAttribute("count"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.current = Integer.parseInt(thisElement.getAttribute("current"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        NodeList valueElements = thisElement.getElementsByTagName("value");
        int numValueElements = valueElements.getLength();
        this.names = new String[numValueElements];
        this.inputs = new String[numValueElements];
        this.descriptions = new String[numValueElements];
        this.words = new String[numValueElements];
        this.valids = new boolean[numValueElements];
        for (int i = 0; i < numValueElements; ++i) {
            Element value = (Element)valueElements.item(i);
            this.names[i] = value.getAttribute("name");
            this.inputs[i] = value.getAttribute("input");
            this.descriptions[i] = value.getAttribute("desc");
            this.words[i] = value.getAttribute("word");
            this.valids[i] = !value.getAttribute("valid").equals("false");
        }
    }

    public String getType() {
        return this.type;
    }

    public int getCount() {
        return this.count;
    }

    public String getWord() {
        return this.word;
    }

    public String getDescription() {
        return this.description;
    }

    public int getCurrent() {
        return this.current;
    }

    public String[] getNames() {
        return this.names;
    }

    public String[] getDescriptions() {
        return this.descriptions;
    }

    public String[] getInputs() {
        return this.inputs;
    }

    public String[] getWords() {
        return this.words;
    }

    public boolean[] getValidities() {
        return this.valids;
    }

    public void accept(Visitor v) {
        v.visit(this);
    }
}

